/*############################################################################*/
/*#                                                                          #*/
/*#  MIT HRTF C Library                                                      #*/
/*#  Filter table for normal set at 48000Hz                                  #*/
/*#  Copyright © 2007 Aristotel Digenis                                      #*/
/*#                                                                          #*/
/*#  Filename:  mit_hrtf_normal_48000.h                                      #*/
/*#  Version:   0.1                                                          #*/
/*#  Date:      04/05/2007                                                   #*/
/*#  Author(s): Aristotel Digenis                                            #*/
/*#  Credit:    Bill Gardner and Keith Martin                                #*/
/*#  Licence:   MIT                                                          #*/
/*#                                                                          #*/
/*############################################################################*/


#include "../mit_hrtf_filter.h"

const mit_hrtf_filter_set_48 normal_48 = 
{
    {    // elev-10 
        {    // H-10e000a.wav
            {8,-12,23,-24,15,-10,-20,53,-104,129,-145,141,18,4124,7752,-5657,-8386,3133,-3011,-1673,10676,7837,2015,8551,15970,1498,-12231,-935,2147,-11363,-10395,1013,-1923,-8565,-3044,2578,1541,-411,1181,4390,3455,1615,3127,3049,-415,-1232,468,-455,-3044,-3740,-2617,-2875,-3747,-2440,-1277,-1406,-192,1550,1678,1554,1896,1938,1586,1083,591,306,78,-622,-1031,-922,-1161,-1507,-1351,-1015,-968,-817,-378,-4,61,247,665,770,671,558,478,348,19,-318,-395,-390,-624,-692,-466,-442,-556,-446,-217,-68,-14,96,262,196,112,221,277,182,29,-41,-146,-344,-432,-440,-421,-377,-320,-196,-72,-15,35,93,76,22,14,14,-9,-34,-55,-121,-169,-172,-162,-133,-97,-56,-71,-37,4,4,55,21},
            {8,-12,23,-24,15,-10,-20,53,-104,129,-145,141,18,4124,7752,-5657,-8386,3133,-3011,-1673,10676,7837,2015,8551,15970,1498,-12231,-935,2147,-11363,-10395,1013,-1923,-8565,-3044,2578,1541,-411,1181,4390,3455,1615,3127,3049,-415,-1232,468,-455,-3044,-3740,-2617,-2875,-3747,-2440,-1277,-1406,-192,1550,1678,1554,1896,1938,1586,1083,591,306,78,-622,-1031,-922,-1161,-1507,-1351,-1015,-968,-817,-378,-4,61,247,665,770,671,558,478,348,19,-318,-395,-390,-624,-692,-466,-442,-556,-446,-217,-68,-14,96,262,196,112,221,277,182,29,-41,-146,-344,-432,-440,-421,-377,-320,-196,-72,-15,35,93,76,22,14,14,-9,-34,-55,-121,-169,-172,-162,-133,-97,-56,-71,-37,4,4,55,21}
        },
        {    // H-10e005a.wav
            {-2,7,-10,17,-18,12,-8,-16,45,-84,104,-115,116,38,3575,6844,-4472,-7199,2520,-2666,-1759,9068,7217,2290,7323,14079,2830,-9846,-1481,1926,-9287,-9522,68,-1682,-7406,-3298,1590,1263,-317,831,3705,3150,1669,3060,2851,-279,-960,309,-538,-2590,-3099,-2136,-2513,-3311,-2036,-919,-1294,-711,889,1357,1223,1341,1461,1466,1154,675,398,112,-528,-823,-755,-1075,-1436,-1257,-944,-893,-720,-323,15,56,178,540,650,535,424,419,337,40,-282,-358,-302,-511,-628,-460,-405,-456,-392,-242,-143,-110,15,195,164,101,204,263,179,52,-18,-129,-293,-351,-340,-329,-313,-281,-213,-116,-51,-12,33,14,-34,-56,-40,-22,-36,-40,-65,-92,-104,-107,-94,-74,-70,-81,-65,-30,8,6},
            {-9,23,-23,8,3,-43,80,-132,147,-145,124,-36,3678,9233,-4659,-10889,2796,-2138,-2515,11358,8941,1945,8468,17646,2869,-14279,-2206,3280,-11665,-11937,975,-1177,-9333,-3960,2988,2130,-517,821,4786,3902,1247,3159,3941,-54,-1576,533,-107,-3063,-4203,-3131,-3307,-4421,-3011,-1292,-1310,-319,1685,2098,1882,2244,2351,1908,1204,559,221,-12,-732,-1139,-950,-1179,-1568,-1386,-1008,-1027,-945,-486,-36,76,233,688,822,694,606,563,416,63,-295,-400,-374,-643,-765,-527,-501,-578,-446,-202,-55,-46,98,336,279,149,222,292,197,7,-54,-146,-362,-474,-515,-497,-446,-354,-194,-53,18,42,110,126,68,48,48,20,-4,-30,-107,-199,-238,-225,-203,-128,-63,-50,-16,36,28,41,109,33}
        },
        {    // H-10e010a.wav
            {-3,-1,4,-8,14,-16,13,-9,-9,29,-65,80,-91,103,60,3303,5877,-3825,-5963,1853,-2324,-1221,7575,6458,2637,6507,12406,3283,-7892,-1649,1415,-7646,-8400,-656,-1729,-6405,-3273,927,1044,-235,714,3199,2864,1660,2836,2745,-133,-1023,65,-526,-2175,-2624,-1891,-2137,-2769,-1729,-680,-1036,-855,351,925,953,1097,1266,1267,938,488,300,81,-469,-722,-685,-926,-1243,-1109,-805,-746,-602,-274,48,128,186,429,504,418,335,307,236,18,-257,-346,-323,-486,-556,-428,-396,-418,-333,-191,-126,-132,-21,170,176,121,178,218,149,25,-46,-152,-270,-288,-283,-274,-276,-257,-192,-132,-89,-56,-21,-33,-74,-73,-44,-33,-22,-9,-17,-54,-86,-66,-71,-71,-76,-112,-83,-45,-10},
            {17,-15,-4,21,-66,107,-149,142,-110,71,-15,3041,10431,-2810,-13291,1546,-1216,-3148,12272,9902,1630,8779,19063,4162,-15754,-3558,3828,-11947,-12772,899,-910,-9854,-4553,3002,2374,-186,631,4610,3883,1323,3766,4442,144,-1554,629,52,-3182,-4488,-3643,-4027,-5126,-3198,-975,-1326,-593,1764,2504,2321,2444,2453,2191,1494,711,193,-167,-919,-1336,-1034,-1199,-1611,-1433,-1066,-1078,-956,-464,17,152,249,675,857,765,635,527,422,79,-305,-383,-361,-643,-833,-622,-514,-558,-403,-187,-64,-20,82,330,342,213,288,330,202,0,-111,-182,-382,-502,-539,-565,-505,-394,-222,-57,32,75,151,175,106,80,70,37,8,-7,-85,-187,-231,-248,-247,-182,-97,-69,10,79,79,61,87,124,29}
        },
        {    // H-10e015a.wav
            {-3,-3,-1,3,-7,11,-13,8,-7,-8,21,-50,58,-67,75,62,2856,5142,-2889,-5220,1254,-1614,-1130,6023,5971,2803,5501,10978,4044,-6204,-1931,1326,-5951,-7564,-1341,-1636,-5574,-3403,270,900,-167,401,2745,2797,1704,2389,2356,203,-790,-99,-383,-1741,-2299,-1682,-1692,-2301,-1688,-755,-903,-781,65,520,776,1005,965,801,609,385,221,36,-361,-568,-528,-728,-1002,-929,-718,-624,-512,-276,33,141,190,342,378,333,241,170,110,-38,-246,-338,-317,-440,-510,-392,-346,-379,-318,-176,-84,-62,-7,105,126,110,166,180,89,-22,-75,-142,-238,-280,-272,-261,-250,-231,-195,-139,-101,-80,-63,-60,-67,-72,-51,-30,-23,-3,-15,-52,-62,-61,-49,-62,-84,-126,-142,-31},
            {4,-27,42,-85,114,-139,96,-41,-27,69,2133,11034,415,-15225,-1174,180,-4086,12439,11994,1234,8295,20625,6289,-16965,-5589,4641,-11869,-14087,810,-78,-10458,-5545,3473,2427,-347,765,3924,3640,2030,4195,4789,582,-1619,603,396,-3045,-4931,-4534,-4654,-5206,-3086,-974,-1555,-813,2033,2923,2398,2477,2556,2358,1710,894,234,-209,-932,-1501,-1212,-1291,-1714,-1548,-1128,-1092,-978,-358,141,175,255,765,978,778,622,508,380,43,-343,-446,-403,-653,-851,-605,-501,-585,-424,-151,-12,-5,76,330,368,228,319,374,217,-15,-160,-226,-415,-517,-532,-581,-536,-426,-258,-99,-31,37,168,227,147,96,111,63,0,-12,-85,-182,-225,-244,-240,-205,-136,-101,-31,106,137,130,118,76,72,20}
        },
        {    // H-10e020a.wav
            {0,-3,-4,-2,2,-5,9,-10,4,-2,-10,17,-39,44,-45,49,56,2348,4551,-1930,-4670,828,-913,-1277,4643,5560,2812,4514,9713,4827,-4663,-2102,1409,-4405,-6833,-1953,-1496,-4855,-3647,-239,796,-235,178,2489,2728,1454,1871,2208,538,-497,-35,-173,-1377,-2041,-1419,-1397,-2139,-1768,-861,-784,-645,86,400,434,541,583,586,420,228,186,114,-177,-395,-400,-560,-839,-805,-576,-509,-467,-257,37,113,123,274,310,234,140,77,19,-132,-296,-307,-243,-346,-455,-381,-303,-303,-262,-156,-59,-31,4,95,102,72,127,148,72,-53,-135,-169,-226,-262,-274,-259,-231,-198,-138,-90,-88,-105,-74,-48,-47,-64,-59,-36,-28,-14,-42,-51,-43,-17,-28,-56,-93,-164,-45},
            {-40,59,-99,102,-98,22,50,-134,179,1151,10602,4693,-15399,-5689,1348,-4230,10809,14227,2367,7149,21002,9676,-16622,-8959,4843,-10141,-15477,-963,1123,-9562,-7250,3073,3603,-564,-657,3659,4620,2178,3804,5350,1505,-1827,184,999,-2688,-5720,-5488,-4597,-4646,-3243,-1612,-1653,-511,2153,2957,2337,2461,2656,2461,1868,974,217,-179,-774,-1493,-1415,-1359,-1789,-1778,-1290,-1072,-852,-314,87,261,438,832,1008,823,626,486,365,29,-428,-548,-417,-628,-886,-655,-461,-524,-447,-208,-18,49,133,346,407,237,244,363,253,-9,-182,-260,-441,-555,-529,-530,-520,-451,-297,-145,-60,-11,105,208,152,103,130,113,41,-12,-92,-175,-208,-222,-252,-239,-155,-132,-49,97,172,174,161,117,42,53,19}
        },
        {    // H-10e025a.wav
            {-4,1,-3,-5,-1,0,-6,6,-8,3,2,-12,15,-31,32,-33,29,42,1836,4017,-1018,-4141,480,-344,-1464,3447,5123,2734,3606,8545,5526,-3193,-2124,1497,-3036,-6195,-2451,-1318,-4355,-3834,-593,647,-191,54,2046,2416,1327,1663,2089,736,-226,216,107,-1097,-1818,-1410,-1377,-2033,-1748,-806,-631,-506,-41,61,104,249,377,414,324,210,163,218,2,-318,-397,-495,-628,-606,-477,-419,-405,-265,-22,64,60,160,234,191,53,-40,-73,-152,-270,-295,-215,-284,-393,-325,-247,-246,-204,-111,-55,-43,-11,85,95,39,63,89,36,-99,-186,-204,-231,-242,-239,-228,-191,-144,-97,-66,-80,-80,-71,-60,-57,-61,-53,-60,-59,-62,-41,-23,-7,-13,-28,-64,-131,-38},
            {48,-85,76,-39,-50,128,-204,262,365,9100,8869,-12949,-10917,832,-3110,8510,15153,4279,6871,20608,12514,-14352,-11921,3308,-7893,-15149,-3539,448,-7834,-7478,1856,3806,-349,-1598,3273,5364,2414,3652,5265,2080,-1272,-200,1042,-2550,-6348,-5856,-3885,-4075,-3875,-2222,-1478,-123,2132,2632,2228,2486,2652,2573,1927,943,285,-99,-657,-1413,-1475,-1424,-1802,-1901,-1444,-1070,-909,-347,184,388,559,898,1029,783,641,510,337,13,-426,-520,-438,-639,-897,-696,-448,-500,-423,-221,-67,61,172,390,466,245,204,323,251,21,-173,-241,-431,-593,-548,-514,-486,-445,-312,-130,-40,-29,35,149,125,78,108,109,59,42,-13,-136,-170,-193,-251,-268,-210,-133,-53,75,166,209,214,178,90,33,52,16}
        },
        {    // H-10e030a.wav
            {-1,-2,-1,-1,-3,-2,2,-2,5,-4,4,4,-12,16,-23,22,-17,18,29,1349,3493,-157,-3559,138,83,-1580,2398,4625,2613,2849,7401,6062,-1673,-2029,1494,-1873,-5559,-2768,-1263,-3966,-3801,-794,493,-300,-229,1679,2294,1296,1449,1964,987,173,473,217,-1014,-1809,-1481,-1298,-1763,-1542,-745,-688,-789,-277,42,10,69,229,357,317,204,193,199,2,-246,-313,-359,-486,-472,-364,-381,-405,-300,-85,13,14,94,139,95,-10,-74,-82,-132,-247,-299,-234,-253,-296,-234,-181,-173,-161,-101,-58,-78,-51,37,69,24,10,26,-44,-141,-176,-191,-203,-198,-184,-177,-165,-115,-63,-55,-66,-86,-76,-58,-54,-63,-80,-83,-80,-40,-11,-3,-15,-17,-47,-110,-31},
            {-43,14,26,-117,176,-242,286,-127,6709,11979,-7848,-15183,-2111,-1697,6497,14893,6155,6839,20200,15401,-11098,-14114,1010,-6075,-13879,-5470,-1111,-7166,-7394,1615,3009,-1168,-552,3388,4475,2775,4099,4926,2182,-614,-272,503,-2937,-6303,-5126,-3276,-4302,-4318,-2111,-1268,-302,1932,2537,2041,2333,2643,2564,1820,955,480,-50,-643,-1268,-1427,-1507,-1824,-1873,-1490,-1095,-986,-472,227,510,660,908,963,763,616,479,341,79,-329,-526,-496,-615,-829,-687,-489,-521,-432,-235,-84,42,176,357,423,269,204,292,250,55,-127,-212,-397,-578,-586,-582,-533,-445,-291,-112,-17,0,18,91,66,11,38,52,40,62,48,-44,-117,-172,-234,-274,-232,-169,-93,41,130,182,240,235,149,53,28,41,11}
        },
        {    // H-10e035a.wav
            {-1,-1,-2,-2,-1,-4,-4,2,-3,2,-2,-1,4,-12,12,-16,11,-8,7,15,915,2942,591,-2884,-221,346,-1553,1482,4005,2503,2284,6232,6397,-150,-1805,1331,-958,-4756,-2988,-1425,-3407,-3450,-1222,-25,-286,-166,1356,2023,1293,1349,1960,1409,440,249,-22,-920,-1605,-1397,-1090,-1448,-1541,-1089,-898,-726,-313,-59,13,46,155,292,307,194,109,163,42,-171,-197,-257,-402,-447,-359,-343,-419,-331,-107,-11,-31,5,44,14,-45,-62,-67,-134,-242,-283,-199,-192,-250,-180,-101,-131,-169,-139,-104,-98,-86,-17,16,-33,-35,-26,-69,-137,-155,-132,-149,-160,-148,-150,-143,-117,-85,-63,-77,-80,-74,-62,-64,-92,-85,-69,-53,-29,-5,-10,-24,-56,-102,-28},
            {-45,94,-170,191,-208,204,-207,3853,13167,-822,-16888,-6927,-1243,4963,13929,7612,6944,19485,18006,-6465,-15029,-1950,-4951,-11878,-6523,-3217,-6635,-7390,-229,2065,-508,616,2842,3943,3333,4098,4543,2519,336,-922,-873,-2796,-5341,-4440,-3124,-4352,-4518,-2025,-820,-530,1238,2426,2167,2169,2394,2360,1809,1004,567,64,-563,-1137,-1400,-1543,-1845,-1821,-1362,-1062,-1103,-562,280,530,592,867,969,700,564,515,372,149,-253,-500,-523,-597,-729,-656,-459,-478,-469,-281,-124,10,159,293,357,257,180,273,264,125,-31,-164,-336,-552,-598,-604,-602,-490,-306,-105,12,22,15,79,72,-6,-40,-38,-13,63,119,19,-89,-139,-188,-235,-238,-179,-118,-20,86,157,223,253,199,116,54,30,32,7}
        },
        {    // H-10e040a.wav
            {0,-1,-1,-2,-1,-2,-4,-2,1,-2,3,0,-2,5,-8,11,-14,7,6,-5,15,567,2356,1185,-2097,-569,436,-1354,709,3259,2423,1963,5080,6401,1348,-1385,942,-210,-3753,-3157,-1528,-2803,-3418,-1746,-185,-34,-171,915,1825,1499,1459,1926,1405,219,-124,-55,-558,-1206,-1262,-1152,-1522,-1657,-1131,-788,-705,-390,-86,55,84,96,206,251,186,117,129,78,-85,-159,-217,-371,-466,-394,-333,-352,-296,-144,-64,-90,-73,-15,-14,-65,-71,-40,-73,-177,-234,-189,-183,-210,-163,-115,-131,-171,-158,-122,-122,-112,-75,-53,-67,-61,-37,-56,-84,-90,-84,-104,-127,-135,-158,-158,-127,-98,-88,-77,-77,-75,-57,-65,-75,-67,-42,-31,-19,-18,-29,-67,-103,-26},
            {92,-149,128,-70,-11,64,1272,11757,6788,-14851,-12585,-2284,3574,12495,8669,6616,18822,20480,-1638,-14593,-4098,-4507,-10600,-6150,-4678,-6966,-7366,-2832,504,101,1726,3079,3438,3333,4396,4744,2513,839,-1114,-2270,-2962,-4089,-3640,-3308,-4352,-4206,-1962,-784,-718,832,2137,2025,2174,2254,2064,1687,1071,677,89,-417,-950,-1432,-1607,-1760,-1644,-1333,-1045,-1028,-648,190,506,487,730,919,739,591,495,371,207,-149,-459,-538,-550,-638,-596,-421,-417,-447,-323,-202,-51,110,214,307,245,156,215,250,193,49,-83,-250,-502,-580,-612,-633,-517,-355,-145,-15,11,3,48,110,38,-50,-77,-83,6,116,63,-45,-119,-179,-204,-203,-183,-140,-54,29,105,187,243,226,151,102,48,23,33,10}
        },
        {    // H-10e045a.wav
            {1,0,0,-1,-2,-1,-2,-4,-2,0,-2,2,1,-3,2,-5,3,-11,8,5,-7,20,299,1768,1560,-1222,-835,336,-995,69,2407,2401,1844,3961,6054,2707,-786,472,454,-2532,-3260,-2049,-2417,-3009,-1925,-332,100,-182,655,1870,1757,1198,1329,1084,192,-29,143,-263,-1097,-1489,-1313,-1361,-1462,-1120,-760,-628,-412,-104,63,58,52,138,221,212,127,112,76,-80,-172,-232,-353,-458,-424,-307,-274,-289,-215,-117,-116,-113,-59,-5,-17,-58,-25,-37,-130,-216,-220,-186,-218,-189,-123,-139,-155,-149,-147,-145,-152,-115,-78,-85,-64,-35,-7,-15,-49,-70,-101,-113,-141,-175,-177,-154,-118,-99,-86,-68,-56,-36,-33,-53,-51,-43,-18,-25,-52,-80,-110,-28},
            {-17,-60,141,-237,320,-194,7702,12784,-7914,-17712,-5543,2373,10400,9606,5696,17145,23231,4408,-13688,-6452,-3033,-9722,-6119,-4724,-7198,-8006,-5735,-465,-28,761,3632,4309,3359,3686,5604,3579,326,-1488,-2625,-2638,-3729,-3759,-2771,-3875,-4240,-2076,-684,-910,273,1934,1936,1993,2114,1909,1695,1087,718,243,-458,-883,-1221,-1549,-1745,-1588,-1276,-972,-918,-726,5,399,400,639,889,768,548,494,402,246,-67,-434,-475,-502,-592,-510,-385,-357,-433,-346,-200,-131,16,142,248,266,149,157,224,176,83,-24,-151,-372,-546,-592,-617,-539,-374,-216,-98,-32,-27,34,112,57,-1,-41,-80,-35,54,56,-25,-88,-154,-214,-192,-155,-137,-80,-22,46,137,220,241,193,142,86,28,19,33,9}
        },
        {    // H-10e050a.wav
            {1,1,0,-1,-1,-1,-2,-2,-3,-4,-1,-1,2,1,-8,3,-2,-6,-1,6,4,-3,17,133,1209,1699,-326,-956,90,-606,-374,1580,2332,1864,2981,5382,3783,61,283,951,-1797,-3558,-2283,-1722,-2458,-2032,-552,207,121,668,1547,1263,625,952,1179,547,64,-49,-434,-1122,-1412,-1188,-1173,-1309,-1034,-648,-590,-439,-116,-9,-3,65,151,191,183,124,72,21,-87,-187,-270,-351,-420,-400,-315,-282,-285,-222,-121,-107,-105,-41,6,-21,-58,-55,-56,-110,-217,-235,-201,-205,-186,-160,-138,-147,-162,-143,-148,-161,-134,-82,-60,-63,-18,18,1,-35,-67,-89,-131,-173,-193,-185,-161,-133,-96,-61,-38,-20,-25,-44,-54,-62,-31,-33,-54,-75,-110,-28},
            {-138,185,-204,164,-195,2779,13837,3301,-18709,-12217,1023,8064,10206,4996,13526,25132,11871,-10513,-9791,-2225,-7486,-6610,-4124,-7136,-8698,-7854,-2119,-336,-673,2904,4449,3903,3982,5852,4550,769,-1491,-3096,-2416,-2893,-4143,-3195,-3104,-3541,-2612,-1183,-834,-133,1518,1876,1773,1952,1796,1715,1241,756,414,-424,-945,-1085,-1317,-1629,-1647,-1311,-978,-799,-786,-253,337,361,532,812,769,538,459,428,269,3,-322,-423,-453,-575,-514,-355,-318,-390,-377,-241,-159,-59,94,201,250,172,107,181,167,67,-26,-118,-251,-452,-543,-562,-546,-426,-286,-164,-101,-86,-19,85,98,30,-28,-50,-44,32,65,-45,-113,-155,-214,-208,-167,-117,-86,-53,-14,64,178,241,219,163,111,57,24,21,19,3}
        },
        {    // H-10e055a.wav
            {1,1,1,1,0,-1,-2,-2,-2,-2,-1,-1,0,3,-2,-4,5,-4,-3,5,5,6,1,23,31,733,1617,475,-841,-285,-268,-534,798,2152,1926,2246,4538,4588,1325,-62,512,-1028,-2999,-2251,-1292,-1919,-1926,-559,455,209,49,644,894,745,997,1148,512,-214,-405,-443,-795,-1201,-1157,-955,-1010,-965,-648,-486,-439,-245,-49,40,68,103,157,141,59,22,0,-103,-246,-308,-316,-378,-395,-313,-240,-218,-187,-98,-67,-107,-85,-34,-46,-78,-83,-86,-119,-177,-203,-201,-213,-213,-172,-122,-130,-147,-132,-135,-142,-119,-74,-59,-64,-22,23,2,-46,-89,-114,-136,-178,-186,-171,-135,-92,-67,-39,-33,-49,-61,-53,-47,-37,-36,-31,-50,-88,-24},
            {-48,124,-219,290,-102,8801,13422,-10533,-20571,-3376,6661,9729,5748,8265,23904,20082,-3956,-12408,-3565,-4308,-6626,-3491,-6772,-9187,-8538,-4923,-762,-1294,620,3989,4066,3657,6025,6087,1699,-907,-2684,-2829,-2194,-3783,-3726,-2883,-3105,-2740,-1677,-1153,-668,1029,1866,1609,1721,1711,1738,1429,821,604,33,-825,-1241,-1262,-1370,-1525,-1391,-1141,-875,-818,-452,314,421,339,651,800,621,400,368,364,151,-211,-397,-367,-495,-580,-413,-301,-327,-355,-263,-181,-138,44,218,268,193,70,98,149,89,0,-100,-212,-378,-484,-488,-491,-439,-330,-229,-172,-131,-75,21,103,68,16,-11,-44,1,74,24,-98,-183,-233,-239,-195,-130,-73,-42,-26,15,104,203,237,198,135,69,32,34,34,14,1}
        },
        {    // H-10e060a.wav
            {1,1,2,2,2,0,1,0,-1,1,1,1,0,2,4,-1,-2,3,0,1,7,4,10,12,6,-8,397,1364,1070,-534,-645,-73,-463,181,1778,1999,2025,3924,4656,1816,-224,522,-86,-2249,-2289,-1031,-1033,-1413,-824,-101,-287,-395,420,1010,805,620,640,249,-301,-370,-298,-592,-996,-971,-765,-824,-813,-615,-500,-409,-239,-61,1,13,57,52,54,36,-27,-68,-166,-268,-286,-282,-297,-311,-256,-183,-176,-154,-107,-104,-138,-138,-84,-67,-86,-101,-103,-100,-153,-211,-215,-206,-193,-150,-106,-107,-129,-120,-100,-113,-129,-98,-50,-54,-46,-21,-36,-79,-115,-106,-112,-138,-142,-126,-93,-75,-75,-92,-95,-71,-43,-30,-24,-30,-16,-16,-52,-16},
            {97,-102,68,-72,2045,14306,5919,-21524,-14810,4955,9041,7214,4494,17496,26384,6608,-11895,-7529,-1872,-4770,-3487,-5533,-9817,-8438,-7174,-2718,-627,-1781,2148,4345,3115,4607,6868,3923,29,-1382,-2822,-2239,-2656,-3992,-3024,-2781,-2904,-2090,-1535,-1267,102,1595,1641,1555,1604,1598,1559,1070,764,521,-364,-1120,-1250,-1374,-1466,-1327,-1232,-1061,-886,-680,58,539,313,416,739,692,450,321,384,327,8,-330,-385,-405,-576,-509,-349,-306,-315,-294,-187,-128,-42,153,293,274,146,33,64,81,5,-31,-132,-305,-473,-513,-438,-409,-338,-234,-206,-198,-157,-47,101,99,22,1,-15,15,56,46,-48,-147,-216,-278,-248,-174,-91,-28,-23,4,72,149,201,195,149,104,58,39,44,31,23,6}
        },
        {    // H-10e065a.wav
            {1,2,2,2,1,2,1,0,1,1,1,1,0,1,3,2,-1,1,1,4,2,1,13,12,1,-3,-7,193,1030,1362,-88,-853,-84,-249,-204,1370,2371,2085,2512,3781,2841,599,408,314,-1371,-1789,-517,-451,-1585,-1703,-752,-109,-49,154,493,371,117,234,275,-49,-323,-306,-349,-687,-816,-618,-605,-733,-626,-373,-310,-306,-170,-84,-67,-59,-61,-23,-30,-100,-135,-173,-208,-206,-186,-182,-240,-241,-174,-156,-169,-175,-148,-145,-158,-118,-90,-106,-116,-110,-124,-165,-197,-184,-152,-146,-133,-100,-87,-88,-107,-116,-118,-131,-102,-85,-92,-91,-88,-57,-67,-95,-74,-62,-76,-108,-121,-110,-126,-130,-111,-79,-41,-36,-15,-2,-1,12,-10,-7},
            {171,-264,321,-365,6018,16473,-5515,-26063,-5208,10048,7997,4248,8736,25433,19517,-5605,-11657,-3067,-1516,-2594,-3749,-9579,-9545,-7472,-5831,-828,-1680,-1303,3532,3720,2876,5362,5827,1745,-383,-1531,-2225,-1496,-3352,-3609,-2447,-2891,-2492,-1828,-1815,-1106,778,1594,1423,1409,1316,1637,1527,872,733,331,-643,-1067,-1251,-1526,-1441,-1242,-1129,-938,-800,-505,284,522,296,508,683,592,381,327,427,267,-164,-377,-347,-535,-614,-414,-298,-299,-315,-220,-123,-99,50,260,335,243,92,34,37,-17,-44,-58,-177,-378,-524,-500,-428,-346,-240,-190,-213,-210,-114,8,120,79,-15,-24,-6,67,89,0,-125,-209,-246,-242,-217,-157,-44,-10,-24,14,108,180,179,143,98,78,66,71,66,30,21,7}
        },
        {    // H-10e070a.wav
            {1,1,1,1,1,1,1,0,0,1,-1,1,1,-1,0,3,1,-3,3,1,1,1,8,12,-1,3,8,-3,69,737,1396,303,-845,-192,16,7,1183,1791,1467,1916,3524,3590,1304,295,738,-5,-1047,-926,-960,-1831,-1748,-475,79,-436,-670,-194,86,-15,151,323,59,-201,-167,-158,-403,-602,-556,-497,-519,-485,-371,-355,-378,-301,-217,-186,-196,-172,-107,-78,-120,-141,-94,-80,-95,-117,-162,-214,-226,-196,-190,-201,-185,-148,-161,-190,-167,-132,-118,-133,-144,-137,-137,-135,-119,-105,-113,-120,-90,-66,-93,-127,-138,-145,-155,-158,-133,-111,-113,-87,-48,-43,-58,-52,-45,-78,-121,-143,-150,-135,-102,-73,-58,-56,-24,16,32,33,10,-1},
            {148,-287,383,-137,10444,14698,-16400,-24443,3726,11572,5437,3429,15729,27720,8662,-11972,-8013,-232,-137,-1564,-6680,-11119,-8603,-7143,-3567,-609,-2887,218,4055,2730,3012,5658,4068,248,-541,-1329,-1068,-1454,-3345,-2691,-2589,-2891,-1991,-1896,-2106,-773,1052,1325,1120,1005,1305,1867,1349,758,778,135,-753,-942,-1221,-1605,-1397,-1062,-988,-911,-858,-308,422,328,273,560,662,528,343,419,450,126,-300,-369,-374,-595,-561,-373,-296,-284,-270,-157,-110,-82,146,352,347,203,34,-4,8,-36,-47,-94,-252,-449,-533,-467,-403,-317,-204,-189,-226,-164,-38,67,103,27,-37,-43,9,67,53,-43,-159,-221,-252,-217,-171,-101,-9,-21,-58,-15,93,176,181,119,69,60,72,107,99,54,16,1}
        },
        {    // H-10e075a.wav
            {0,0,0,0,0,0,1,1,1,0,0,0,0,-1,0,1,1,0,-1,2,-2,4,4,3,3,2,18,-3,-4,42,519,1202,537,-568,33,557,-238,-20,1413,1990,1912,2865,3599,2241,1055,1226,376,-1341,-1633,-969,-985,-1227,-989,-813,-1044,-1046,-465,-27,-44,60,340,302,31,-58,-20,-190,-441,-426,-309,-366,-498,-458,-402,-470,-451,-377,-314,-275,-239,-145,-86,-80,-55,3,15,-56,-108,-144,-211,-235,-205,-172,-175,-204,-198,-206,-216,-192,-170,-149,-134,-118,-103,-79,-68,-87,-84,-77,-94,-106,-95,-110,-169,-197,-189,-179,-168,-140,-96,-84,-78,-44,-44,-68,-64,-55,-79,-127,-142,-117,-83,-61,-60,-66,-45,13,60,49,8,-2},
            {63,-192,279,576,14009,10654,-24059,-19830,9816,11106,3069,4657,22013,25188,-1110,-13568,-3998,2139,978,-2335,-8780,-11520,-8231,-5764,-2292,-1855,-2763,1673,3540,1852,3394,5513,2493,-644,-728,-853,-251,-1511,-2801,-1916,-2515,-2805,-1968,-1951,-1982,-613,824,920,720,755,1430,1859,1137,816,843,-6,-761,-855,-1147,-1483,-1244,-945,-915,-967,-912,-178,377,151,235,592,636,435,348,502,434,-34,-362,-324,-412,-609,-497,-327,-308,-304,-232,-110,-112,-43,223,372,313,140,-21,-48,-14,1,-23,-147,-342,-513,-534,-443,-378,-298,-211,-214,-226,-121,8,112,104,-20,-80,-76,-24,26,20,-57,-157,-213,-233,-195,-140,-55,-5,-79,-131,-60,62,160,164,106,62,46,95,136,110,66,16,-1}
        },
        {    // H-10e080a.wav
            {-1,-1,-1,0,0,0,0,1,1,1,1,-1,0,-1,1,0,0,0,-1,-1,4,2,1,-2,1,13,4,9,8,3,22,381,943,838,374,-11,-482,-456,386,1510,2013,1827,2438,3835,3518,1456,193,-296,-931,-876,-441,-885,-1791,-1971,-1398,-1076,-1057,-700,-237,31,225,441,453,216,54,22,-5,-174,-326,-317,-366,-498,-531,-499,-565,-590,-483,-371,-303,-261,-162,-52,-8,26,41,20,-29,-111,-149,-167,-194,-186,-192,-208,-236,-260,-238,-234,-212,-162,-134,-101,-79,-58,-42,-56,-59,-57,-76,-107,-145,-149,-160,-206,-208,-187,-169,-154,-126,-79,-84,-99,-76,-64,-57,-50,-59,-75,-85,-73,-58,-59,-56,-58,-44,-16,29,39,-15,-10},
            {-29,-72,132,1370,16231,6605,-28329,-15237,13139,10172,1556,6545,26108,20805,-8055,-12842,-192,4166,876,-3163,-9672,-12303,-7378,-4111,-2509,-2987,-2240,2783,2890,799,3744,5425,1360,-1264,-582,-469,-261,-1266,-1946,-1553,-2237,-2279,-2048,-2312,-1734,-274,385,228,430,737,1336,1639,1105,907,800,-26,-646,-743,-1022,-1228,-1031,-899,-905,-983,-875,-177,194,25,248,600,555,343,349,552,410,-91,-324,-291,-425,-591,-429,-274,-320,-322,-205,-79,-92,26,277,340,236,80,-32,-46,-8,26,6,-156,-384,-545,-540,-433,-347,-250,-204,-246,-230,-83,58,153,117,-54,-136,-107,-39,17,8,-64,-128,-173,-170,-148,-135,-60,-46,-123,-149,-69,59,135,144,111,75,73,126,167,139,89,34,1}
        },
        {    // H-10e085a.wav
            {0,0,0,0,0,0,1,1,1,1,1,1,0,1,0,0,1,2,-2,0,5,3,-1,-3,10,9,5,3,24,-2,-24,79,456,1246,1065,-314,-642,16,328,548,1146,1944,2479,3022,3576,2776,619,-415,316,519,-420,-1232,-1746,-2147,-2081,-1528,-1134,-1122,-792,-133,240,341,463,518,323,158,162,115,-112,-345,-361,-362,-500,-613,-627,-613,-591,-513,-398,-323,-260,-141,-15,54,26,22,63,4,-70,-115,-144,-169,-215,-217,-238,-295,-282,-228,-187,-173,-153,-100,-63,-44,-43,-47,-38,-60,-87,-93,-128,-172,-185,-182,-185,-188,-175,-167,-165,-138,-94,-80,-98,-83,-51,-34,-26,-16,-13,-17,-23,-42,-45,-54,-48,-44,-36,-19,-43,-15},
            {-77,-9,61,1748,17179,4366,-30128,-12540,14587,9574,941,7796,27849,17177,-12247,-11584,3202,5684,205,-3507,-9969,-13050,-6461,-2944,-3087,-3889,-1970,3476,2371,67,3646,5120,1046,-1537,-486,-150,-423,-1216,-1320,-939,-2005,-1990,-1663,-2390,-1948,-205,385,-307,-187,670,1315,1345,974,973,830,-56,-535,-464,-830,-1057,-853,-793,-866,-1021,-827,-186,6,-142,200,603,461,235,325,560,419,-66,-274,-244,-397,-568,-372,-239,-317,-311,-187,-51,-93,43,300,301,172,35,-41,-42,-13,40,39,-145,-374,-551,-550,-413,-340,-232,-197,-261,-221,-69,83,151,60,-83,-137,-103,-25,13,2,-60,-101,-112,-137,-146,-159,-104,-75,-152,-147,-45,48,115,125,106,87,81,154,201,167,120,46,1}
        },
        {    // H-10e090a.wav
            {0,0,0,0,1,1,1,1,1,1,1,1,0,1,2,0,1,2,-3,0,8,3,-5,3,9,15,-7,11,13,-17,11,96,693,917,101,-106,264,368,399,326,589,1533,2837,3203,2194,1537,1373,832,758,1141,492,-1134,-2058,-1966,-1876,-1914,-1678,-1262,-898,-507,-64,254,386,446,496,421,292,173,21,-145,-313,-371,-410,-560,-660,-616,-564,-563,-520,-441,-330,-232,-137,-34,17,76,93,66,23,-68,-107,-134,-197,-241,-273,-258,-239,-244,-200,-175,-159,-113,-88,-59,-61,-73,-72,-77,-69,-98,-118,-125,-176,-189,-168,-181,-201,-218,-195,-148,-123,-85,-82,-91,-51,-10,17,32,33,25,1,-26,-46,-73,-81,-88,-87,-84,-85,-20},
            {-54,-60,134,1420,17008,4906,-30287,-12625,14969,9515,935,7866,27712,15792,-14243,-11059,5945,7108,-379,-3668,-9793,-13517,-6091,-2252,-3425,-4551,-2250,3700,2228,-476,3330,4795,830,-1449,-146,-133,-504,-995,-1239,-568,-1472,-1784,-1484,-2063,-1844,-550,169,-359,-523,175,1057,1302,823,817,859,36,-444,-256,-546,-858,-749,-689,-770,-987,-839,-215,-74,-347,14,550,425,155,251,548,431,-36,-211,-171,-342,-553,-339,-198,-298,-301,-182,-42,-117,10,282,277,141,-6,-72,-69,-26,53,60,-121,-344,-512,-535,-414,-338,-250,-203,-244,-218,-101,23,106,37,-104,-122,-77,-4,36,14,-43,-105,-131,-151,-170,-166,-121,-111,-165,-148,-19,65,86,106,93,81,82,157,226,187,141,67,4}
        },
        {    // H-10e095a.wav
            {1,0,2,1,1,1,1,1,1,2,2,2,1,2,2,2,2,1,1,1,6,2,-4,1,19,9,5,6,-17,2,48,541,893,56,-618,-22,870,962,484,395,832,1815,2548,2314,1828,793,76,1073,1910,1472,643,-355,-1423,-1970,-1761,-1593,-1754,-1607,-1060,-582,-367,-125,180,345,436,473,390,283,111,-84,-174,-280,-392,-464,-523,-566,-571,-528,-516,-519,-464,-371,-254,-128,-10,89,90,58,55,14,-30,-120,-194,-198,-208,-204,-210,-224,-213,-189,-154,-127,-117,-115,-118,-110,-99,-81,-61,-82,-106,-106,-122,-162,-200,-220,-223,-221,-190,-144,-129,-117,-86,-46,-20,10,44,66,66,41,8,-37,-69,-97,-107,-124,-127,-113,-113,-27},
            {43,-220,360,497,15464,8255,-28429,-15837,14335,10224,1219,6825,25880,16905,-13935,-11976,7519,9037,-298,-3920,-9283,-13610,-6325,-2060,-3461,-4706,-3207,3225,2726,-862,2584,4679,969,-1578,115,291,-549,-842,-1153,-473,-1249,-1503,-1057,-1964,-1771,-415,-46,-718,-618,21,541,995,812,734,772,68,-327,-88,-332,-619,-555,-599,-728,-881,-784,-292,-125,-468,-204,422,383,125,169,500,467,-19,-165,-78,-253,-509,-323,-132,-258,-289,-189,-75,-115,-14,233,239,111,-15,-86,-101,-48,52,91,-55,-299,-475,-488,-382,-328,-258,-225,-283,-269,-143,-4,72,24,-108,-118,-28,46,83,46,-50,-142,-190,-184,-163,-167,-122,-99,-161,-154,-23,91,93,79,85,76,83,151,227,210,143,72,9}
        },
        {    // H-10e100a.wav
            {1,0,0,0,1,1,1,1,1,0,1,0,0,2,0,2,2,1,1,2,-1,3,-4,2,14,3,24,-15,-26,12,434,1046,250,-890,-352,515,690,903,943,881,1671,2280,1798,1190,1052,914,-184,-447,1274,2027,1119,162,-565,-1210,-1547,-1419,-1360,-1430,-1257,-893,-521,-410,-250,146,294,286,330,317,212,10,-164,-216,-223,-314,-414,-463,-500,-472,-474,-547,-568,-501,-348,-185,-92,-30,26,64,56,31,-7,-85,-107,-100,-127,-163,-206,-203,-179,-196,-198,-173,-169,-176,-172,-141,-113,-102,-76,-64,-72,-106,-142,-158,-205,-240,-214,-198,-185,-161,-125,-83,-84,-47,12,33,56,69,61,17,-32,-59,-92,-129,-136,-142,-143,-144,-130,-27},
            {196,-428,611,-462,12088,13080,-23048,-21443,11633,11944,1597,4988,22487,19553,-10755,-14106,7158,11558,966,-4191,-8729,-13230,-7070,-2281,-3336,-4439,-4350,1660,3571,-608,1318,4311,1553,-1342,-124,614,-16,-621,-1339,-344,-894,-1710,-798,-1448,-1902,-539,232,-763,-1101,-174,476,672,476,645,864,92,-423,9,-64,-470,-399,-408,-628,-828,-774,-312,-105,-502,-397,253,329,79,94,405,479,39,-171,-31,-138,-427,-305,-66,-182,-272,-199,-92,-123,-74,171,210,74,-52,-95,-106,-61,51,115,21,-237,-425,-431,-323,-275,-291,-313,-362,-323,-153,-4,39,11,-83,-84,10,73,100,39,-57,-149,-212,-215,-178,-148,-109,-76,-131,-162,-48,86,125,98,67,70,83,145,222,207,138,59,7}
        },
        {    // H-10e105a.wav
            {1,1,0,2,1,1,1,1,0,-1,2,-1,0,2,1,1,2,-2,4,0,1,1,-6,12,-2,20,4,-7,-22,279,1147,624,-955,-770,335,753,682,597,1161,2174,2542,1860,939,548,602,493,-249,-880,-310,915,1480,1064,287,-341,-825,-1039,-1002,-1017,-1076,-1071,-941,-692,-425,-212,-52,62,136,205,183,72,-49,-146,-115,-115,-257,-336,-349,-406,-495,-545,-532,-496,-423,-324,-242,-157,-59,23,31,-9,1,38,27,-30,-84,-113,-146,-176,-179,-189,-231,-269,-244,-188,-177,-174,-143,-112,-86,-64,-72,-130,-191,-187,-156,-167,-192,-202,-183,-135,-86,-50,-42,-44,-13,43,66,50,6,-37,-66,-87,-95,-139,-157,-157,-148,-124,-112,-26},
            {307,-505,624,-735,7211,16839,-13157,-27317,4963,14599,2797,2502,17995,22427,-4604,-16419,4015,14173,3913,-3952,-8438,-12773,-8037,-2799,-3259,-4045,-4962,-716,3909,713,15,3366,2181,-778,-239,583,241,-68,-1193,-592,-431,-1657,-1144,-1068,-1545,-752,195,-399,-1131,-683,126,732,392,146,709,395,-428,-190,101,-208,-268,-231,-445,-718,-801,-422,-38,-362,-575,-16,282,64,24,265,470,167,-176,-40,-20,-290,-307,-50,-84,-234,-230,-136,-116,-149,76,199,73,-72,-122,-86,-35,48,114,79,-136,-345,-394,-303,-282,-347,-363,-386,-352,-217,-29,65,58,-28,-86,-7,46,64,50,-31,-131,-215,-221,-163,-145,-114,-52,-82,-144,-89,66,142,124,80,55,76,128,200,210,129,43,6}
        },
        {    // H-10e110a.wav
            {1,2,1,1,3,2,1,2,-1,2,0,1,3,0,0,4,-1,3,6,-2,7,-4,5,0,14,13,-2,-8,179,1133,1018,-862,-1138,163,694,669,665,993,2012,2986,2450,922,280,482,362,-239,-720,-910,-923,-404,625,1351,1295,685,40,-358,-514,-599,-797,-1022,-1168,-1010,-624,-501,-473,-253,-74,-42,0,69,90,43,-20,-26,-37,-121,-248,-357,-424,-458,-449,-461,-487,-471,-397,-262,-154,-87,-17,43,67,72,75,52,11,-48,-106,-135,-168,-233,-272,-276,-277,-237,-184,-158,-157,-140,-93,-98,-138,-159,-165,-151,-132,-124,-138,-163,-141,-87,-46,-25,-23,-18,-14,5,13,-10,-40,-81,-95,-94,-103,-134,-155,-148,-112,-82,-74,-17},
            {224,-252,180,-128,2255,16138,300,-28001,-6607,15407,6219,35,11929,23573,4210,-16232,-1839,14948,8246,-2397,-7857,-12552,-9163,-3252,-3319,-4056,-4852,-2940,2670,2447,-240,1824,2406,-61,-131,704,279,113,-715,-594,-173,-1410,-1472,-1094,-1333,-752,98,-268,-915,-715,-340,393,612,43,238,434,-175,-330,-14,-88,-164,-83,-271,-559,-741,-542,-59,-125,-534,-322,142,87,-31,112,365,276,-133,-113,54,-127,-290,-66,11,-179,-250,-199,-112,-188,-80,131,102,-28,-129,-107,-39,45,136,141,-37,-252,-404,-400,-305,-320,-341,-397,-418,-284,-55,119,125,-1,-134,-101,19,58,35,-14,-93,-165,-208,-176,-143,-132,-50,-34,-116,-115,23,137,147,96,43,38,94,181,206,133,34,2}
        },
        {    // H-10e115a.wav
            {0,1,1,2,2,0,2,0,0,1,1,1,2,-1,2,3,-1,5,0,5,0,6,-1,4,16,2,11,70,1082,1476,-691,-1607,-11,795,606,538,1021,2284,3292,2542,947,366,328,184,-188,-859,-1129,-1066,-1056,-793,-183,727,1495,1544,1079,566,104,-278,-546,-901,-1099,-1037,-1021,-887,-722,-608,-426,-292,-195,-47,146,201,138,95,51,15,-78,-215,-297,-365,-424,-465,-535,-557,-495,-405,-255,-99,-30,3,55,87,105,114,62,-6,-52,-112,-191,-254,-274,-285,-293,-268,-214,-168,-163,-177,-177,-166,-152,-138,-140,-135,-115,-101,-82,-85,-76,-49,-46,-27,-17,-23,-36,-63,-83,-99,-100,-98,-113,-118,-121,-127,-108,-94,-75,-62,-61,-14},
            {-48,200,-379,523,-446,10235,11867,-19026,-19437,9908,11606,28,4481,20927,14042,-11389,-8700,12104,12998,785,-6301,-11859,-11121,-3865,-2897,-4657,-4663,-4101,237,3108,851,611,1912,552,-7,938,552,80,-428,-588,191,-843,-1798,-1222,-1222,-1003,-25,18,-811,-741,-383,1,483,176,67,278,-77,-365,-82,-68,-280,-64,-63,-356,-596,-590,-152,9,-361,-453,-64,60,-67,-12,208,287,-41,-168,55,26,-212,-130,30,-120,-233,-237,-175,-204,-198,22,114,42,-89,-144,-76,50,167,181,21,-254,-440,-438,-308,-281,-353,-408,-425,-296,-75,80,83,-23,-134,-135,-31,24,5,-9,-30,-105,-199,-218,-157,-115,-68,-13,-74,-134,-37,96,147,95,26,6,48,148,206,151,26,-8}
        },
        {    // H-10e120a.wav
            {1,1,1,1,1,1,0,1,-1,-1,1,-1,1,0,3,1,4,-2,6,0,5,5,-6,23,-11,33,18,930,1898,-269,-2094,-417,946,709,439,895,2459,3885,3046,919,30,117,253,-236,-1231,-1345,-1111,-1218,-1038,-722,-289,320,931,1587,1879,1525,810,112,-451,-700,-727,-1031,-1319,-1224,-992,-869,-769,-567,-358,-121,112,265,234,163,217,167,51,-68,-183,-255,-390,-513,-571,-597,-540,-403,-254,-170,-139,-56,61,117,123,102,80,33,-43,-88,-135,-224,-289,-298,-288,-262,-245,-228,-222,-237,-208,-159,-126,-127,-136,-102,-68,-46,-28,-22,-25,-31,-26,-23,-42,-69,-100,-124,-143,-160,-151,-132,-134,-128,-88,-59,-54,-55,-40,-26,-32,-9},
            {-191,301,-329,256,-272,2963,14622,-2274,-24382,-3697,14160,4772,-1331,12760,20944,-668,-12862,4732,15980,5914,-4294,-9441,-12578,-6560,-1817,-4625,-5350,-4372,-2027,2070,2016,550,1340,858,-115,871,1301,216,-395,-621,110,109,-1511,-1657,-1156,-1154,-494,169,-421,-850,-442,-120,304,250,0,212,92,-408,-312,26,-270,-328,-36,-102,-347,-528,-291,62,-151,-460,-225,45,-71,-134,28,236,113,-155,-15,136,-64,-209,-46,-40,-190,-250,-253,-210,-221,-77,88,82,-6,-88,-71,19,140,136,6,-191,-358,-418,-354,-290,-337,-350,-333,-291,-188,-54,18,6,-58,-130,-89,-9,22,17,-12,-74,-160,-208,-168,-95,-60,-14,-21,-109,-97,36,121,100,42,10,33,104,186,179,68,1}
        },
        {    // H-10e125a.wav
            {3,2,2,2,1,0,0,1,-1,2,0,1,1,3,1,4,-1,6,5,-2,13,-10,25,-11,36,-2,754,2236,320,-2516,-997,1074,869,382,813,2645,4415,3533,1100,-31,-72,-25,-409,-1306,-1734,-1577,-1270,-984,-875,-523,50,301,537,1249,1955,1905,1336,573,-118,-377,-619,-985,-1309,-1433,-1268,-1088,-986,-849,-457,-79,-10,105,317,395,332,199,118,74,-80,-209,-344,-535,-563,-498,-439,-418,-398,-283,-140,-26,15,56,122,105,50,15,-11,-23,-81,-187,-264,-306,-302,-276,-292,-308,-280,-217,-176,-165,-134,-98,-66,-48,-34,-9,13,23,15,-7,-30,-56,-96,-129,-165,-188,-179,-181,-187,-164,-120,-76,-38,-17,-12,-10,-3,-1,-15,-5},
            {-8,-63,187,-331,449,-414,8177,11225,-14328,-18101,7118,11495,-707,1952,18967,13023,-9152,-4942,13592,12557,-1071,-7274,-10536,-10187,-3349,-2763,-5856,-5129,-3426,51,2204,1008,1112,1391,0,-21,1636,1258,-320,-759,-298,532,-449,-1695,-1412,-1209,-899,-163,-111,-693,-558,-171,103,365,101,56,253,-165,-570,-195,-32,-375,-305,-79,-118,-319,-368,-45,78,-296,-396,-36,28,-166,-164,101,253,-7,-106,122,104,-203,-213,-27,-115,-243,-265,-207,-200,-161,37,136,89,-3,-41,-54,-25,63,85,-29,-253,-423,-419,-288,-227,-266,-315,-351,-315,-152,19,43,-25,-112,-101,7,47,18,-26,-62,-103,-147,-133,-89,-68,-23,14,-62,-137,-43,94,119,74,50,52,72,140,194,140,23}
        },
        {    // H-10e130a.wav
            {1,2,1,0,1,-1,-1,-1,1,-2,1,-2,3,0,2,0,2,5,-8,15,-18,26,-9,27,4,565,2471,1043,-2809,-1788,1109,1140,365,719,2857,5070,4017,1117,-44,-111,-181,-493,-1628,-2285,-1824,-1453,-1331,-974,-428,56,244,373,768,1174,1345,1554,1449,857,488,-19,-714,-1003,-1143,-1347,-1457,-1372,-1149,-812,-546,-293,-17,149,368,406,280,240,211,119,-70,-221,-299,-342,-386,-465,-494,-492,-441,-269,-142,-103,-31,31,51,27,25,69,59,-1,-84,-164,-251,-318,-323,-340,-345,-312,-271,-219,-186,-156,-108,-59,-15,-5,-12,10,39,40,25,-3,-62,-134,-183,-213,-221,-215,-217,-205,-173,-125,-75,-46,-31,-14,17,30,12,-10,-14,-3},
            {108,-164,177,-116,9,58,1112,11389,3609,-19043,-8695,11509,6372,-3295,7617,19794,4152,-9590,4280,16209,5921,-6002,-7855,-9663,-7511,-2676,-4331,-5982,-4539,-2190,1163,1631,751,1640,1189,-422,389,1955,870,-679,-815,107,412,-938,-1509,-1252,-1241,-763,-134,-429,-721,-218,55,255,347,96,147,141,-403,-560,-122,-134,-389,-272,-125,-198,-328,-224,93,25,-359,-296,1,-37,-173,-68,193,174,-63,-1,126,-101,-342,-169,-50,-210,-266,-217,-158,-157,-33,153,131,20,-87,-153,-102,60,136,27,-193,-353,-382,-299,-205,-279,-385,-395,-317,-197,-74,2,-10,-47,-71,-30,26,14,-23,-45,-70,-105,-109,-83,-80,-84,-30,-45,-135,-113,35,130,98,71,62,66,99,148,149,32}
        },
        {    // H-10e135a.wav
            {3,3,0,2,-3,2,-1,1,-1,0,-1,3,1,2,1,-1,14,-14,18,-16,17,3,14,28,395,2601,1836,-2916,-2704,990,1459,403,670,3145,5753,4494,1157,-63,-208,-380,-513,-1735,-2741,-2333,-1781,-1409,-1116,-790,95,557,352,739,1271,1020,777,947,1023,1052,719,82,-462,-937,-1089,-1174,-1421,-1526,-1215,-742,-526,-321,-10,207,262,251,303,309,150,16,5,-70,-179,-255,-347,-421,-467,-473,-391,-265,-204,-156,-80,-48,-44,8,98,132,71,-22,-90,-187,-294,-320,-322,-337,-337,-298,-249,-215,-162,-115,-79,-50,3,45,34,35,46,44,8,-59,-133,-207,-257,-273,-249,-212,-188,-162,-126,-86,-47,-25,-17,-11,10,30,28,11,-14,-6},
            {-49,90,-151,200,-249,249,-304,3461,11442,-3466,-18104,-910,11381,1227,-2682,12410,16864,-1381,-5596,10984,13918,-879,-7734,-6867,-8401,-5942,-3212,-5259,-5764,-3818,-1006,1458,1081,858,2005,923,-424,924,1734,392,-742,-585,257,-37,-1131,-1240,-1187,-1352,-755,-217,-636,-597,15,261,420,314,135,209,-27,-483,-419,-120,-263,-393,-217,-158,-304,-407,-155,148,-48,-370,-232,17,-34,-77,82,226,52,-151,-16,36,-250,-379,-168,-142,-249,-206,-100,-69,-101,29,101,-26,-113,-104,-65,-7,49,34,-73,-217,-312,-362,-325,-304,-362,-367,-341,-286,-178,-48,19,-5,-52,-57,-7,32,5,-32,-51,-82,-100,-100,-95,-120,-121,-87,-98,-120,-39,99,128,105,72,62,68,88,117,28}
        },
        {    // H-10e140a.wav
            {5,0,1,-1,1,-3,2,1,0,-2,4,2,-1,6,-8,18,-13,14,-11,7,13,-4,57,265,2644,2620,-2849,-3665,712,1777,465,647,3546,6526,4905,1099,7,-181,-709,-718,-1798,-3055,-2695,-2036,-1718,-1381,-870,75,489,369,916,1459,1165,778,604,374,577,771,416,82,-216,-615,-976,-1261,-1402,-1215,-954,-751,-462,-280,-54,147,172,194,211,198,170,136,-16,-143,-138,-178,-248,-360,-444,-361,-292,-322,-295,-212,-138,-90,-47,45,120,107,28,-51,-139,-251,-284,-289,-317,-317,-295,-239,-203,-195,-153,-103,-57,-10,15,45,72,66,51,-3,-82,-162,-232,-265,-274,-244,-210,-181,-154,-128,-85,-43,-22,-27,-31,-18,11,27,19,-4,-22,-6},
            {-44,18,6,-66,132,-221,276,-254,5424,9574,-7931,-14602,3934,8659,-2296,-112,14861,13081,-3255,-395,14063,8922,-5502,-6955,-5680,-7703,-5196,-3721,-5839,-5493,-2982,-76,1444,571,1152,2198,651,64,1342,1210,-50,-604,-219,198,-496,-1253,-1053,-1201,-1450,-705,-377,-781,-358,261,350,475,430,272,206,-91,-393,-275,-195,-418,-372,-175,-193,-362,-453,-163,42,-170,-288,-47,104,9,28,159,157,-86,-191,-14,-62,-368,-376,-139,-139,-189,-104,-29,-90,-152,-10,72,0,-63,-96,-88,-11,74,40,-134,-297,-359,-345,-283,-312,-396,-389,-322,-216,-100,-7,30,-8,-31,-15,43,60,-7,-41,-57,-84,-116,-127,-114,-139,-141,-89,-86,-84,42,157,160,88,57,61,65,98,27}
        },
        {    // H-10e145a.wav
            {0,2,-3,-1,-3,0,-1,-2,-5,-1,4,-5,4,-12,14,-14,9,-8,-3,20,-26,78,177,2653,3344,-2676,-4617,329,2088,522,621,4087,7420,5202,928,130,-68,-1008,-1011,-2013,-3454,-2980,-2116,-1915,-1632,-1135,-45,702,378,705,1642,1491,837,655,408,228,152,-3,55,-11,-202,-459,-888,-1183,-1011,-710,-749,-712,-459,-175,-5,-34,16,208,265,137,60,-8,-89,-84,-102,-183,-251,-268,-270,-291,-358,-363,-245,-169,-159,-121,-30,63,45,-40,-49,-78,-195,-257,-260,-271,-283,-252,-212,-222,-216,-165,-92,-58,-49,-3,32,56,63,26,-34,-120,-207,-260,-272,-251,-212,-171,-152,-153,-141,-102,-53,-28,-39,-46,-43,-29,9,9,-21,-39,-43,-10},
            {43,-69,53,-35,-8,61,-145,199,74,6527,7270,-9904,-10631,5906,5048,-3647,2729,15249,10107,-2591,4094,13815,3572,-7391,-5164,-4965,-7529,-4799,-4093,-6254,-4955,-2202,440,1293,173,1427,2253,652,639,1524,730,-387,-331,46,-13,-885,-1411,-956,-1260,-1523,-723,-530,-735,-158,366,452,537,500,469,373,-81,-354,-235,-319,-478,-332,-221,-307,-424,-404,-210,-150,-247,-133,139,137,0,54,146,100,-118,-208,-103,-183,-347,-249,-104,-156,-192,-133,-76,-110,-80,72,58,-63,-109,-75,-33,-11,-4,-75,-183,-258,-317,-344,-331,-368,-400,-351,-259,-155,-74,8,45,21,2,18,59,32,-35,-57,-81,-123,-138,-127,-124,-156,-147,-90,-72,-16,105,163,109,62,65,69,67,16}
        },
        {    // H-10e150a.wav
            {1,-4,-1,-3,-2,-1,-3,-4,-2,4,-5,6,-14,13,-13,5,-5,-10,32,-44,89,130,2643,3990,-2399,-5523,-174,2398,619,558,4696,8459,5426,604,316,165,-1307,-1335,-2217,-3923,-3412,-2168,-1971,-1828,-1296,-100,730,325,734,1775,1519,889,775,512,281,86,-323,-415,-396,-472,-368,-412,-703,-678,-510,-531,-499,-486,-333,-122,-119,-8,189,128,-45,0,26,-86,-134,-147,-119,-139,-252,-247,-190,-260,-289,-210,-158,-159,-163,-86,-22,-63,-105,-100,-123,-210,-217,-183,-214,-221,-212,-204,-226,-227,-129,-59,-49,-20,7,9,9,0,-20,-92,-180,-220,-253,-266,-241,-182,-130,-111,-110,-116,-108,-73,-34,-47,-70,-67,-50,-23,-2,-24,-62,-77,-65,-13},
            {-22,44,-70,58,-53,19,14,-88,125,423,6896,5322,-10094,-7295,5618,1918,-3232,4784,14374,8457,-462,6920,11272,-628,-7059,-3447,-4848,-7356,-4874,-4440,-5995,-4440,-1540,663,753,37,1826,2329,690,983,1646,530,-477,-175,118,-335,-1192,-1396,-1003,-1438,-1579,-747,-604,-666,25,506,549,591,639,685,480,-26,-304,-240,-374,-512,-338,-305,-434,-521,-405,-121,-107,-284,-204,76,141,97,101,74,12,-130,-137,-89,-235,-328,-195,-111,-196,-177,-76,-53,-104,-78,17,-7,-58,-52,-74,-96,-46,-33,-105,-194,-254,-308,-367,-352,-343,-347,-290,-220,-131,-38,32,68,45,16,24,36,-2,-56,-66,-88,-120,-136,-144,-140,-153,-131,-70,-41,22,116,131,100,74,67,57,11}
        },
        {    // H-10e155a.wav
            {-2,0,-2,0,2,-2,-3,0,5,-3,9,-13,15,-12,5,0,-17,44,-48,90,122,2674,4507,-2109,-6295,-758,2654,774,534,5362,9567,5627,132,472,530,-1562,-1714,-2437,-4354,-3894,-2306,-2009,-2015,-1435,-48,919,345,573,1842,1740,902,673,562,346,93,-232,-518,-814,-817,-593,-656,-788,-395,42,-131,-338,-304,-178,-15,47,2,-48,-50,-102,-59,-48,-208,-218,-139,-140,-210,-286,-215,-99,-135,-183,-88,-22,-110,-190,-140,-57,-79,-189,-208,-181,-236,-235,-160,-156,-185,-185,-175,-199,-207,-105,9,38,31,16,-1,-29,-79,-123,-151,-174,-218,-268,-256,-213,-166,-117,-88,-69,-67,-56,-44,-47,-59,-69,-71,-76,-54,-21,-26,-68,-95,-94,-71,-14},
            {8,-19,37,-61,60,-64,38,-11,-49,84,656,6781,4059,-9144,-5194,3970,55,-1910,5578,12961,8303,2217,7631,7665,-2793,-5483,-2487,-5104,-7046,-5128,-4978,-5128,-3524,-1591,508,435,110,2210,2284,832,1129,1575,751,-248,-382,-139,-426,-1363,-1434,-1122,-1691,-1554,-801,-713,-471,249,618,660,695,772,821,465,-47,-150,-141,-428,-574,-424,-399,-462,-496,-369,-141,-170,-292,-209,-53,12,114,179,93,-40,-144,-65,-42,-250,-323,-141,-49,-122,-147,-126,-129,-167,-98,1,-38,-67,-50,-49,-101,-112,-88,-130,-187,-247,-290,-305,-317,-327,-318,-266,-182,-96,-15,40,42,42,29,21,20,-30,-59,-75,-102,-117,-143,-140,-143,-158,-114,-51,-11,39,94,113,87,72,60,12}
        },
        {    // H-10e160a.wav
            {-3,-4,-1,-1,-2,-4,-2,4,-5,8,-13,12,-13,2,0,-21,40,-44,82,132,2782,4862,-1903,-6851,-1377,2773,978,580,6111,10636,5758,-318,526,870,-1698,-2098,-2704,-4791,-4365,-2457,-2064,-2236,-1626,20,1109,489,653,1852,1722,923,739,565,259,-58,-411,-400,-534,-942,-982,-1037,-1139,-614,37,167,54,-36,231,525,223,-129,-80,-11,-155,-261,-267,-304,-296,-277,-282,-302,-332,-206,-58,-102,-69,82,89,-38,-145,-97,-42,-152,-252,-242,-235,-287,-267,-187,-212,-231,-170,-155,-188,-168,-40,79,74,62,66,-13,-107,-167,-172,-165,-209,-242,-261,-263,-218,-156,-111,-102,-95,-57,-26,-3,-4,-46,-81,-94,-86,-70,-52,-53,-90,-127,-130,-107,-69,-12},
            {3,3,-14,32,-57,59,-70,49,-27,-22,57,753,6381,3469,-7658,-4353,1918,-500,-526,5224,11639,9387,4490,6416,4360,-2955,-3817,-2346,-5214,-6806,-5415,-5102,-4435,-2604,-1663,-212,468,540,2119,2181,1162,1234,1351,971,264,-538,-753,-534,-1119,-1569,-1470,-1814,-1599,-866,-619,-210,385,603,761,874,866,791,488,32,-167,-122,-342,-545,-520,-465,-353,-404,-440,-340,-360,-353,-168,-16,-22,0,68,118,52,-101,-85,-20,-76,-130,-97,-135,-220,-190,-144,-153,-201,-162,-65,-44,-41,-48,-107,-158,-135,-93,-89,-155,-220,-252,-273,-287,-334,-307,-221,-149,-80,-39,-3,37,56,40,13,-14,-52,-78,-86,-107,-122,-138,-145,-145,-151,-95,-37,-13,24,67,80,83,77,16}
        },
        {    // H-10e165a.wav
            {-5,0,1,-3,-5,-2,2,-6,7,-13,12,-14,2,-3,-21,33,-37,73,163,2974,5068,-1844,-7147,-1901,2667,1182,779,6896,11626,5792,-666,613,1028,-1784,-2380,-3002,-5177,-4841,-2663,-2084,-2409,-1863,1,1283,639,798,1997,1795,915,692,622,72,-394,-268,-267,-707,-1031,-985,-1065,-1349,-935,-275,-183,47,580,842,684,420,293,215,21,-287,-390,-395,-515,-519,-444,-407,-390,-386,-275,-99,-31,24,147,162,40,-41,-21,0,-104,-244,-267,-265,-320,-310,-253,-284,-319,-245,-141,-96,-80,-21,59,93,96,57,-48,-133,-154,-153,-184,-241,-265,-271,-255,-215,-172,-127,-109,-104,-80,-42,0,15,-8,-47,-63,-72,-87,-86,-92,-101,-131,-159,-162,-123,-30,4},
            {-4,5,0,-11,29,-51,54,-68,55,-38,-3,40,745,5842,3423,-6106,-4490,138,-130,381,4226,10881,11005,5697,4209,2248,-2009,-2753,-2543,-5128,-6633,-5655,-4782,-3706,-2554,-1636,-228,175,815,2188,1989,1353,1387,1416,931,275,-341,-798,-965,-1245,-1361,-1669,-2040,-1589,-838,-389,-23,384,607,751,970,1044,796,374,63,-43,-171,-383,-401,-327,-355,-442,-559,-588,-511,-444,-399,-248,-56,43,82,23,-1,57,91,136,83,-66,-155,-160,-175,-216,-218,-202,-198,-215,-188,-113,-63,-61,-89,-132,-129,-78,-65,-70,-118,-182,-226,-280,-293,-290,-260,-190,-146,-101,-52,3,60,57,25,2,-36,-70,-88,-91,-86,-119,-142,-134,-136,-121,-95,-45,-20,7,62,92,96,23}
        },
        {    // H-10e170a.wav
            {-2,0,-1,-6,-1,0,-2,4,-12,13,-18,5,-10,-10,20,-31,67,218,3256,5113,-1994,-7190,-2200,2371,1253,1166,7755,12421,5767,-893,759,1080,-1959,-2600,-3287,-5533,-5234,-2911,-2153,-2564,-2037,5,1335,677,953,2223,1931,1100,659,203,55,-153,-401,-454,-835,-1208,-1090,-1037,-1262,-1087,-622,-211,206,372,638,1038,983,677,445,215,-76,-375,-600,-713,-706,-630,-563,-539,-518,-339,-82,-18,9,163,232,125,-9,14,127,37,-165,-230,-276,-361,-370,-310,-326,-380,-284,-145,-103,-69,20,104,82,8,-14,-52,-87,-96,-136,-178,-227,-258,-266,-267,-229,-182,-152,-125,-113,-85,-44,-19,3,-15,-27,-22,-39,-69,-100,-106,-122,-143,-167,-177,-157,-75,33,17},
            {5,-5,8,0,-8,24,-42,45,-61,53,-40,10,29,675,5258,3721,-4760,-5170,-1052,586,702,3254,10595,12333,5965,2053,1280,-842,-2259,-2792,-4893,-6443,-5777,-4384,-3024,-2546,-2113,-174,819,725,1679,2166,1599,1431,1415,880,174,-462,-613,-811,-1565,-1694,-1472,-1760,-1690,-893,-240,104,327,514,896,1076,916,702,438,134,-8,-38,-204,-318,-348,-417,-522,-712,-757,-607,-518,-463,-273,-43,94,135,111,136,177,154,125,71,-68,-233,-251,-172,-161,-238,-302,-270,-226,-179,-117,-88,-92,-81,-62,-69,-64,-59,-63,-104,-163,-207,-254,-287,-288,-238,-175,-129,-103,-64,-6,43,55,18,-22,-65,-79,-74,-79,-86,-108,-129,-141,-137,-120,-85,-60,-33,13,81,115,27}
        },
        {    // H-10e175a.wav
            {-1,0,-6,0,-1,-1,3,-11,13,-22,11,-22,2,7,-20,55,306,3633,4987,-2349,-7017,-2255,1981,1133,1651,8702,12969,5755,-864,835,1027,-2066,-2875,-3626,-5782,-5548,-3209,-2241,-2655,-2223,-12,1428,718,956,2397,2262,998,510,594,144,-525,-565,-474,-934,-1385,-1252,-1227,-1486,-1013,-209,-52,-80,232,696,1003,999,862,775,496,60,-240,-481,-711,-810,-774,-749,-737,-636,-430,-195,-92,1,183,230,149,92,117,177,111,-36,-146,-268,-386,-398,-326,-306,-345,-300,-211,-166,-92,3,58,48,14,-3,-53,-107,-99,-92,-134,-191,-230,-254,-274,-247,-195,-161,-139,-125,-88,-52,-16,13,-7,-34,-34,-35,-47,-73,-110,-121,-140,-160,-175,-163,-101,-13,54,17},
            {-8,6,-5,5,-1,-8,21,-34,32,-48,37,-31,10,25,568,4675,4176,-3726,-5962,-1687,1201,765,2601,10281,13015,5814,476,981,97,-2105,-2942,-4527,-6261,-5762,-3908,-2643,-2620,-2266,-297,1137,1140,1298,1819,1956,1608,1188,751,145,-564,-733,-643,-1215,-1799,-1751,-1500,-1330,-943,-405,32,378,597,783,929,881,654,491,374,222,92,-160,-431,-559,-594,-643,-768,-811,-685,-527,-397,-210,24,175,189,192,247,264,182,36,-62,-170,-264,-223,-204,-260,-307,-269,-212,-258,-240,-120,-46,-29,-34,-40,-42,-76,-72,-57,-104,-140,-197,-256,-278,-278,-222,-163,-126,-100,-79,-26,16,24,17,-30,-59,-72,-75,-60,-82,-103,-129,-150,-138,-130,-108,-45,-10,35,92,25}
        },
        {    // H-10e180a.wav
            {2,-7,2,-2,2,1,-8,16,-28,22,-34,19,-12,-5,37,439,4123,4644,-2953,-6605,-2025,1616,894,2141,9629,13168,5690,-459,920,705,-2065,-2971,-4108,-6001,-5670,-3535,-2415,-2686,-2284,-163,1294,909,1258,2171,1828,1383,1148,572,16,-535,-646,-637,-1073,-1400,-1545,-1674,-1415,-682,-261,-163,137,465,741,862,834,795,727,559,288,-7,-346,-601,-699,-737,-758,-820,-806,-594,-356,-226,-103,90,222,216,186,213,234,138,1,-87,-220,-356,-342,-260,-259,-307,-306,-234,-206,-192,-90,1,24,9,-22,-50,-84,-86,-77,-115,-155,-204,-257,-272,-258,-203,-159,-136,-115,-95,-49,-2,19,2,-31,-47,-55,-59,-62,-87,-119,-134,-147,-154,-159,-108,-32,18,57,17},
            {2,-7,2,-2,2,1,-8,16,-28,22,-34,19,-12,-5,37,439,4123,4644,-2953,-6605,-2025,1616,894,2141,9629,13168,5690,-459,920,705,-2065,-2971,-4108,-6001,-5670,-3535,-2415,-2686,-2284,-163,1294,909,1258,2171,1828,1383,1148,572,16,-535,-646,-637,-1073,-1400,-1545,-1674,-1415,-682,-261,-163,137,465,741,862,834,795,727,559,288,-7,-346,-601,-699,-737,-758,-820,-806,-594,-356,-226,-103,90,222,216,186,213,234,138,1,-87,-220,-356,-342,-260,-259,-307,-306,-234,-206,-192,-90,1,24,9,-22,-50,-84,-86,-77,-115,-155,-204,-257,-272,-258,-203,-159,-136,-115,-95,-49,-2,19,2,-31,-47,-55,-59,-62,-87,-119,-134,-147,-154,-159,-108,-32,18,57,17}
        }
    },
    {    // elev-20 
        {    // H-20e000a.wav
            {5,-9,18,-14,9,-4,-29,55,-88,89,-98,84,18,3273,7761,-3907,-10445,793,-1647,-2446,9071,9738,3792,4375,14116,10055,-7794,-6030,1450,-7350,-10901,-512,203,-8026,-5594,829,1687,-51,463,3940,4158,1807,2004,2129,-806,-2426,-1248,-1790,-3586,-3764,-2467,-1199,-1408,-1299,590,1273,710,1298,1825,1399,988,899,756,324,-407,-776,-594,-921,-1315,-948,-745,-1031,-815,-274,-107,-46,130,452,533,372,391,356,160,-52,-204,-312,-417,-531,-512,-323,-329,-419,-267,-127,-180,-160,8,106,125,121,140,95,-24,-104,-154,-110,-108,-135,-78,-24,-60,-126,-62,-31,-112,-112,4,-52,-205,-219,-228,-207,-133,-17,-10,-90,-90,-28,8,-24,-102,-231,-248,-261,-276,-308,-257,-286,-455,-122},
            {5,-9,18,-14,9,-4,-29,55,-88,89,-98,84,18,3273,7761,-3907,-10445,793,-1647,-2446,9071,9738,3792,4375,14116,10055,-7794,-6030,1450,-7350,-10901,-512,203,-8026,-5594,829,1687,-51,463,3940,4158,1807,2004,2129,-806,-2426,-1248,-1790,-3586,-3764,-2467,-1199,-1408,-1299,590,1273,710,1298,1825,1399,988,899,756,324,-407,-776,-594,-921,-1315,-948,-745,-1031,-815,-274,-107,-46,130,452,533,372,391,356,160,-52,-204,-312,-417,-531,-512,-323,-329,-419,-267,-127,-180,-160,8,106,125,121,140,95,-24,-104,-154,-110,-108,-135,-78,-24,-60,-126,-62,-31,-112,-112,4,-52,-205,-219,-228,-207,-133,-17,-10,-90,-90,-28,8,-24,-102,-231,-248,-261,-276,-308,-257,-286,-455,-122}
        },
        {    // H-20e005a.wav
            {-6,6,-6,7,4,-10,17,-42,47,-50,23,-9,-18,46,1297,6480,1394,-9352,-3033,-456,-4475,4544,9973,6024,3748,9705,12564,-569,-6445,47,-3749,-10265,-3849,1185,-4754,-6401,-1536,842,404,-171,2021,3746,1988,1314,2263,792,-1420,-1215,-921,-2235,-3079,-2564,-1987,-1820,-1298,-82,597,440,810,1360,1405,1198,849,566,474,110,-502,-518,-508,-935,-1026,-772,-752,-813,-472,-196,-197,-59,255,349,213,279,340,216,78,-32,-186,-304,-388,-460,-354,-317,-378,-338,-240,-188,-154,-41,50,96,133,154,95,-15,-89,-130,-103,-60,-81,-89,-31,-24,-99,-104,-34,-57,-122,-130,-179,-281,-255,-144,-83,-22,-10,-28,-66,-19,44,-5,-101,-252,-322,-324,-273,-349,-340,-331,-468,-123},
            {-9,17,-8,-5,15,-50,75,-95,73,-58,23,19,2474,8793,-1465,-12741,-924,-375,-3736,8998,11565,4274,3507,14425,13272,-7624,-8821,1684,-6390,-12289,-1405,1374,-8155,-7032,464,1687,159,632,3956,4681,2314,2354,2714,-627,-3117,-1750,-1780,-3985,-4446,-2750,-1140,-1380,-1452,553,1590,1004,1489,2071,1541,1009,917,798,435,-280,-832,-746,-1087,-1531,-1104,-734,-1006,-977,-369,-60,26,218,502,635,517,508,466,183,-146,-283,-362,-458,-610,-637,-371,-335,-402,-238,-94,-131,-147,15,137,142,115,90,49,-9,-77,-143,-147,-154,-183,-119,-7,-30,-113,-66,-23,-94,-98,30,44,-124,-181,-199,-267,-220,-102,-28,-72,-80,-57,-47,-21,-53,-152,-243,-223,-239,-240,-235,-239,-399,-519,-118}
        },
        {    // H-20e010a.wav
            {-4,-4,6,-5,9,-3,-5,9,-32,39,-49,29,-22,12,19,1509,5860,382,-8074,-2129,-880,-3659,4369,8624,5485,3772,9081,10916,-228,-4773,-400,-4009,-8592,-3243,324,-4434,-5380,-1422,462,207,62,1868,2901,1493,1037,1759,762,-904,-897,-721,-1637,-2228,-1994,-1833,-1805,-1288,-212,238,38,430,1013,1140,913,646,527,526,254,-253,-297,-373,-754,-809,-630,-698,-752,-456,-308,-319,-139,134,193,100,212,308,213,114,30,-112,-244,-321,-365,-350,-357,-383,-351,-280,-228,-148,-5,73,107,128,153,117,-15,-84,-139,-127,-87,-117,-103,-52,-25,-69,-70,-37,-80,-167,-200,-241,-288,-186,-80,-27,-32,-41,-40,-28,38,40,-60,-205,-284,-358,-343,-355,-349,-305,-357,-93},
            {8,4,-17,32,-65,77,-74,33,3,-51,73,1627,9130,1818,-14029,-4059,814,-4479,8209,13577,5213,2666,14051,16425,-6247,-11646,1147,-5374,-13127,-2293,2219,-7925,-8511,-523,1782,922,779,3569,5058,2660,2635,3480,-149,-3733,-2846,-2003,-3552,-4366,-3288,-1676,-1288,-1295,597,1818,965,1435,2408,1861,1056,773,727,461,-231,-822,-757,-1006,-1663,-1365,-820,-1028,-963,-334,-52,13,255,611,717,536,551,505,197,-89,-243,-353,-514,-699,-737,-451,-322,-448,-302,-54,-73,-119,40,174,198,144,89,34,-45,-79,-142,-147,-156,-204,-154,-59,-46,-130,-92,-3,-68,-103,51,130,20,-65,-129,-246,-295,-193,-104,-82,-63,-57,-89,-76,-22,-77,-182,-230,-209,-198,-174,-193,-301,-512,-537,-111}
        },
        {    // H-20e015a.wav
            {-4,-3,-3,4,-6,7,-4,-2,3,-25,30,-45,29,-24,22,8,1567,5163,-87,-6846,-1669,-1034,-2999,3930,7452,4935,3691,8332,9762,489,-3846,-896,-3487,-7114,-3039,-173,-3994,-4670,-1483,81,31,74,1731,2384,808,574,1660,945,-588,-591,-335,-1073,-1617,-1467,-1450,-1711,-1527,-577,-44,-269,-62,514,801,773,684,674,640,299,-93,-68,-216,-640,-692,-514,-584,-703,-551,-410,-355,-213,19,95,31,122,249,245,132,15,-95,-176,-243,-326,-315,-368,-443,-355,-236,-178,-122,-25,82,124,124,128,40,-43,-109,-171,-141,-119,-91,-71,-16,30,-48,-87,-74,-136,-230,-272,-268,-233,-135,-16,-11,-52,-59,-23,37,58,-1,-157,-269,-342,-364,-376,-346,-297,-289,-69},
            {19,-30,42,-67,57,-35,-28,69,-127,148,801,8522,5662,-13408,-8415,1163,-4436,6434,15298,7056,2078,12746,19247,-3295,-14293,-333,-4083,-13582,-3422,3048,-7308,-10553,-1882,2738,1696,443,3247,5256,2717,2676,4275,703,-4456,-4232,-1935,-2468,-4013,-4038,-2449,-1182,-798,608,1698,921,1269,2504,2183,1191,619,546,452,-192,-864,-713,-812,-1642,-1605,-942,-918,-987,-423,-38,69,350,647,742,534,493,494,254,-19,-229,-358,-491,-682,-777,-531,-383,-508,-363,-71,-55,-116,51,202,209,200,163,64,-91,-153,-148,-124,-117,-210,-210,-104,-89,-178,-147,-32,-64,-84,67,185,90,45,12,-167,-286,-248,-159,-170,-106,-37,-89,-126,-74,-44,-120,-181,-226,-171,-154,-152,-202,-414,-590,-530,-108}
        },
        {    // H-20e020a.wav
            {-1,-1,-4,-3,4,-6,7,-5,0,0,-18,24,-37,28,-20,21,9,1513,4497,-219,-5743,-1393,-1061,-2506,3405,6349,4440,3604,7622,8986,976,-3341,-884,-2765,-6011,-2817,-504,-3618,-4162,-1614,-182,-65,78,1343,1623,414,584,1714,979,-378,-155,171,-538,-1231,-1265,-1219,-1505,-1584,-1020,-624,-659,-297,290,635,799,796,706,639,362,60,29,-171,-499,-534,-406,-531,-692,-570,-454,-380,-269,-101,-5,8,140,217,168,104,12,-70,-119,-216,-313,-327,-331,-339,-293,-186,-133,-111,-22,42,74,81,31,-27,-85,-121,-134,-103,-51,-48,-18,36,11,-74,-106,-116,-201,-306,-298,-239,-176,-46,5,-28,-61,-27,42,57,38,-80,-220,-318,-346,-360,-348,-303,-265,-59},
            {-32,40,-57,23,12,-87,118,-175,191,194,6963,9150,-10304,-12943,-176,-3690,4048,16004,9557,2415,10857,21036,1205,-15983,-3051,-2813,-13236,-4783,3403,-6655,-12323,-2877,3195,2270,790,2443,5030,3042,2575,4613,1240,-4793,-5222,-1519,-1141,-3995,-4790,-2854,-1036,-480,529,1492,816,1160,2495,2294,1245,462,401,453,-125,-827,-774,-731,-1547,-1674,-892,-779,-1048,-586,-46,101,374,679,688,475,524,584,272,-52,-232,-350,-454,-640,-804,-599,-388,-499,-460,-184,-61,-86,57,184,176,210,230,129,-82,-193,-191,-138,-90,-181,-226,-157,-143,-224,-248,-118,-67,-78,81,214,151,115,105,-61,-230,-249,-210,-224,-169,-50,-83,-155,-150,-88,-76,-128,-207,-235,-140,-137,-116,-249,-589,-657,-430,-76}
        },
        {    // H-20e025a.wav
            {-1,2,-1,-3,-2,2,-4,6,-4,2,0,-11,20,-30,28,-16,15,10,1368,3890,-117,-4753,-1252,-1043,-2125,2813,5319,4056,3550,6969,8205,1233,-2694,-601,-2158,-5017,-2624,-812,-3279,-3793,-1692,-288,-156,-273,606,1116,598,863,1605,943,26,386,528,-386,-1090,-1115,-1086,-1379,-1728,-1507,-1066,-745,-224,303,599,667,679,686,621,404,126,66,-83,-367,-379,-338,-541,-687,-565,-431,-408,-343,-153,-34,-11,93,165,116,29,-8,-49,-119,-198,-271,-256,-247,-249,-209,-181,-159,-116,-50,-14,-9,-23,-25,-46,-81,-88,-77,-20,9,0,-1,11,-16,-100,-146,-178,-260,-328,-293,-199,-96,-17,-5,-46,-36,30,74,66,-27,-150,-283,-317,-307,-325,-344,-306,-64},
            {19,-23,-15,61,-123,139,-168,174,-79,4836,11309,-5084,-16046,-3469,-2741,1763,15301,12016,3691,9276,21561,6357,-15887,-6561,-2336,-12078,-5642,2547,-6347,-12441,-3660,2437,2412,1803,2011,4163,3332,2773,4157,1038,-4294,-4913,-1440,-685,-3617,-4871,-3098,-1081,-441,255,1416,931,912,2323,2268,1302,450,179,387,30,-695,-892,-749,-1364,-1599,-844,-667,-998,-648,-32,86,241,569,694,539,527,631,344,5,-201,-384,-472,-582,-741,-627,-405,-483,-489,-250,-91,-64,63,186,150,209,265,144,-68,-180,-157,-133,-92,-149,-218,-158,-138,-240,-312,-221,-125,-79,76,262,221,137,190,80,-140,-238,-224,-235,-215,-66,-41,-147,-182,-134,-82,-66,-151,-265,-195,-121,-71,-73,-406,-724,-604,-240,-20}
        },
        {    // H-20e030a.wav
            {-1,-1,0,-1,-4,-2,2,-4,5,-5,2,0,-10,14,-23,24,-15,10,6,1162,3355,138,-3873,-1242,-1000,-1806,2163,4418,3824,3524,6220,7270,1570,-1846,-356,-1618,-4097,-2562,-1086,-2900,-3345,-1708,-674,-557,-599,214,1016,899,1033,1493,1107,522,585,420,-367,-924,-1010,-1171,-1524,-1771,-1546,-1052,-583,-106,197,357,476,541,573,616,467,146,54,-9,-211,-327,-356,-497,-619,-532,-431,-398,-349,-213,-98,-48,16,61,74,28,-40,-74,-81,-125,-198,-228,-234,-234,-203,-149,-133,-149,-130,-73,-55,-64,-59,-59,-67,-63,-17,44,56,6,-40,-45,-42,-98,-174,-251,-324,-334,-258,-118,-56,-42,-49,-27,37,70,69,-11,-101,-236,-278,-271,-277,-344,-412,-99},
            {15,-67,98,-131,106,-98,54,-41,2507,11536,1603,-16453,-8395,-2487,-149,13297,13798,5633,8295,20980,11987,-13611,-10279,-2847,-10724,-6354,907,-5363,-11472,-5465,1402,2531,2190,1915,3843,3621,2366,3266,795,-3177,-3649,-1897,-1239,-2908,-4077,-3078,-1547,-697,-12,1179,1127,846,1958,2053,1351,648,99,204,43,-608,-947,-722,-1093,-1517,-949,-596,-801,-605,-72,30,96,474,640,492,484,626,441,107,-99,-332,-534,-589,-691,-620,-374,-474,-548,-337,-123,-32,33,170,167,185,254,154,-46,-190,-189,-156,-87,-61,-150,-185,-169,-230,-306,-283,-209,-124,23,232,283,211,230,162,-61,-196,-199,-236,-257,-136,-38,-94,-153,-164,-120,-68,-99,-220,-256,-152,-105,26,-147,-620,-743,-478,-33,42}
        },
        {    // H-20e035a.wav
            {-1,-2,-2,-1,-2,-5,-3,0,-6,2,-2,-2,-1,-10,11,-19,15,-11,0,0,935,2878,495,-3121,-1343,-889,-1573,1507,3726,3678,3440,5331,6342,2113,-1006,-207,-1061,-3317,-2592,-1156,-2365,-3200,-2195,-969,-554,-725,-28,1041,1178,1179,1552,1248,540,451,358,-289,-869,-1147,-1294,-1393,-1514,-1251,-753,-526,-351,-71,189,337,431,501,543,434,163,75,37,-144,-241,-308,-438,-499,-477,-445,-428,-380,-251,-148,-107,-54,14,67,33,-17,-44,-84,-113,-192,-241,-235,-201,-136,-114,-130,-158,-151,-122,-85,-71,-72,-77,-56,-2,35,76,42,-16,-48,-38,-27,-112,-234,-315,-327,-296,-179,-87,-62,-58,-19,33,58,78,-1,-85,-191,-212,-235,-240,-290,-435,-116},
            {-67,83,-85,12,35,-116,154,664,9491,8129,-12990,-13804,-3681,-1518,10274,14720,7283,7959,19930,17075,-8928,-13195,-3886,-9900,-7907,-13,-3726,-10474,-7473,-127,2415,2528,1691,3506,4320,1781,2058,970,-1964,-2497,-2181,-1855,-2444,-3262,-2719,-1815,-1071,-410,696,1162,851,1671,1816,1352,961,90,64,90,-501,-1044,-906,-778,-1260,-1125,-656,-608,-497,-112,1,21,364,589,421,342,572,501,220,-11,-267,-427,-554,-688,-672,-422,-388,-527,-392,-203,-83,23,150,189,161,212,165,-1,-184,-236,-209,-131,-34,-70,-107,-160,-243,-322,-297,-225,-196,-69,151,297,252,256,224,54,-117,-205,-239,-281,-193,-112,-91,-102,-120,-136,-95,-76,-174,-236,-215,-142,-44,80,-347,-773,-673,-357,191,109}
        },
        {    // H-20e040a.wav
            {1,0,0,-1,-1,0,-3,-3,2,-2,3,0,-1,1,-5,10,-13,15,-5,-4,1,707,2478,881,-2518,-1463,-748,-1413,973,3214,3539,3246,4384,5565,2707,-284,-12,-549,-2664,-2457,-1290,-2377,-3173,-2118,-921,-652,-855,-42,1266,1470,1162,1250,1061,569,443,237,-384,-957,-1128,-997,-992,-1144,-1007,-742,-707,-592,-206,104,180,278,401,470,374,153,135,91,-67,-138,-215,-360,-481,-471,-457,-458,-382,-269,-196,-156,-82,4,36,24,2,-63,-124,-172,-200,-190,-161,-130,-128,-118,-139,-167,-161,-148,-120,-89,-65,-54,-39,3,47,44,25,-5,-12,-18,-55,-152,-286,-329,-315,-236,-129,-72,-79,-55,6,46,54,-10,-62,-157,-172,-196,-210,-258,-389,-104},
            {2,27,-103,143,-206,239,-170,5794,12246,-5470,-17654,-7118,-2215,6499,14641,8805,7355,18438,21532,-2183,-14881,-5195,-9061,-10245,-549,-1911,-9463,-8953,-2012,1605,2186,2010,3318,4176,1435,1578,1810,-1244,-2181,-1854,-1934,-2261,-2875,-2421,-1847,-1468,-651,350,805,554,1489,1849,1176,1093,488,68,-55,-332,-840,-1108,-914,-1103,-1001,-687,-606,-468,-91,84,-66,192,539,415,263,487,507,244,49,-135,-334,-490,-591,-699,-540,-394,-435,-347,-242,-161,-35,142,192,109,142,195,56,-153,-246,-234,-169,-97,-59,-47,-85,-173,-279,-330,-266,-223,-122,62,223,269,241,263,146,10,-109,-245,-315,-267,-167,-165,-109,-68,-74,-117,-76,-97,-203,-207,-208,-90,53,-1,-583,-799,-552,-222,406,168}
        },
        {    // H-20e045a.wav
            {1,0,-1,-1,-2,-1,-2,-4,-2,1,-3,2,0,-3,3,-8,8,-9,8,-1,-14,-1,503,2124,1216,-2029,-1597,-605,-1263,566,2835,3326,2926,3526,4920,3204,397,280,-44,-2242,-2793,-1586,-1938,-2693,-2027,-1049,-762,-722,280,1395,1217,760,961,1022,622,296,-44,-479,-648,-616,-640,-802,-1038,-1038,-835,-765,-688,-371,-69,71,178,273,392,352,182,170,167,50,-91,-193,-317,-473,-486,-425,-422,-408,-338,-225,-166,-137,-32,33,-14,-73,-98,-114,-134,-155,-120,-97,-126,-133,-148,-168,-191,-171,-129,-116,-102,-75,-43,-25,-12,6,39,39,35,16,-24,-93,-229,-308,-304,-237,-175,-134,-108,-92,-39,18,22,-23,-41,-108,-132,-179,-200,-222,-326,-87},
            {78,-143,132,-110,58,-59,1969,12040,4482,-16897,-13133,-3055,2996,12865,10468,6559,15864,24388,6813,-13910,-7967,-7922,-11504,-1752,-913,-7878,-9536,-4474,398,1576,2184,2671,3554,1797,1251,2753,-33,-2100,-1771,-1790,-1719,-2531,-2605,-2013,-1705,-919,0,628,222,826,1869,1260,1064,781,317,202,-306,-722,-993,-1002,-1144,-1169,-666,-462,-493,-230,93,19,25,377,429,250,424,574,283,36,-70,-224,-391,-572,-674,-565,-434,-432,-328,-185,-145,-109,50,163,94,100,143,76,-97,-207,-211,-212,-134,-85,-72,-48,-85,-164,-273,-336,-270,-153,3,149,188,232,282,220,76,-13,-127,-279,-318,-249,-229,-214,-79,-36,-57,-74,-66,-112,-186,-187,-178,-9,92,-193,-751,-727,-433,-62,542,186}
        },
        {    // H-20e050a.wav
            {1,0,0,0,-1,-1,-1,-1,-1,-2,1,-1,1,1,-3,6,-7,5,-5,7,2,-21,9,334,1810,1480,-1630,-1699,-471,-1092,319,2515,2996,2542,2857,4405,3597,1181,606,-192,-2302,-2629,-1298,-1444,-2291,-2003,-1179,-597,-318,298,920,796,546,806,948,476,116,51,-67,-147,-301,-631,-945,-1060,-969,-863,-849,-748,-485,-207,-11,125,217,295,331,250,234,248,98,-90,-187,-270,-406,-463,-460,-458,-428,-365,-259,-188,-134,-71,-44,-47,-63,-62,-45,-72,-102,-98,-92,-116,-180,-191,-174,-169,-156,-140,-110,-94,-75,-42,-22,-17,13,56,86,61,1,-67,-167,-245,-263,-225,-200,-185,-167,-119,-58,-23,-6,-30,-25,-65,-99,-163,-194,-200,-270,-72},
            {-3,-75,130,-212,267,-162,7105,12642,-7970,-19599,-7096,547,9056,12192,6419,11836,24445,17156,-7913,-11932,-7299,-11270,-4215,-53,-5767,-9401,-7247,-1346,1000,1860,1972,2298,2041,1205,3456,1698,-1707,-1518,-1528,-1354,-2063,-2772,-2219,-2194,-1471,-365,387,269,160,1425,1466,1067,1027,491,438,76,-440,-899,-1079,-982,-1270,-1011,-559,-426,-284,-71,19,-58,260,438,202,319,605,495,161,-69,-206,-333,-493,-640,-645,-476,-379,-367,-232,-119,-68,-5,78,66,57,143,87,-61,-192,-213,-206,-176,-98,-82,-47,-67,-112,-187,-270,-290,-236,-83,70,162,175,234,254,157,59,-39,-193,-293,-272,-269,-285,-202,-63,-44,-55,-60,-63,-101,-166,-176,-126,77,31,-439,-823,-626,-286,146,581,163}
        },
        {    // H-20e055a.wav
            {1,1,0,2,1,0,0,-1,0,-1,-1,2,1,1,3,-1,7,-6,4,3,3,1,-15,15,210,1533,1619,-1277,-1763,-354,-839,149,2180,2570,2188,2455,4039,3958,1541,284,-239,-1746,-2201,-1024,-1013,-1992,-1873,-989,-480,-435,-90,512,620,341,490,802,607,434,416,247,-61,-447,-763,-931,-982,-987,-890,-828,-818,-566,-234,-75,24,140,291,381,314,285,261,95,-70,-158,-241,-399,-518,-510,-475,-428,-356,-267,-207,-183,-119,-27,-1,-31,-35,-22,-16,-55,-113,-136,-158,-160,-166,-189,-212,-195,-130,-81,-68,-70,-47,-17,25,55,74,63,3,-44,-99,-169,-224,-230,-209,-182,-187,-156,-83,-55,-40,-43,-15,-35,-88,-159,-186,-183,-231,-61},
            {-112,111,-97,30,-18,1625,12546,5954,-18676,-15564,-1340,4919,11792,8051,7362,20876,24526,2991,-13536,-9095,-8841,-6696,-137,-3559,-8754,-9006,-4040,231,1378,1457,931,1638,1082,2781,3893,-60,-1619,-1079,-708,-1278,-2969,-2614,-2128,-2119,-1222,-131,347,-124,612,1483,1139,1073,694,540,460,-17,-410,-888,-944,-1115,-1207,-834,-611,-482,-227,38,-93,-10,386,304,195,481,635,423,101,-158,-301,-423,-575,-655,-560,-400,-335,-292,-183,-75,-12,76,80,-9,49,137,39,-155,-264,-234,-186,-116,-67,-33,-10,-82,-162,-232,-243,-232,-174,-36,94,161,182,238,185,106,69,-51,-229,-298,-260,-296,-289,-163,-54,-59,-69,-77,-61,-64,-121,-137,-74,100,-98,-591,-790,-529,-129,279,513,127}
        },
        {    // H-20e060a.wav
            {3,0,1,1,1,0,0,1,-1,0,1,-1,2,1,2,4,-1,7,-5,5,3,-1,8,-12,17,147,1271,1619,-954,-1749,-265,-554,56,1817,2151,2000,2423,3533,3370,1670,696,40,-1257,-1763,-791,-554,-1464,-1719,-1327,-870,-499,-165,172,175,47,521,1164,1051,655,374,33,-193,-393,-744,-956,-959,-976,-910,-825,-770,-589,-362,-154,37,209,327,369,332,284,254,107,-104,-197,-276,-442,-530,-525,-465,-395,-363,-288,-215,-158,-88,-16,-3,-21,5,11,-19,-73,-110,-124,-154,-193,-229,-241,-222,-179,-107,-51,-47,-48,-22,23,41,38,29,0,-28,-55,-115,-191,-211,-190,-159,-160,-158,-125,-96,-70,-60,-29,-51,-94,-152,-175,-180,-218,-55},
            {-119,186,-250,273,-304,5542,14612,-5050,-23303,-8206,3016,8023,10718,5368,13564,26727,15958,-8438,-13194,-7354,-6968,-1788,-952,-7300,-10027,-6987,-1289,591,793,790,686,804,1260,3952,2775,-567,-888,-461,-183,-1894,-3191,-2607,-2283,-1824,-1164,-140,-46,-36,1056,1188,1012,875,596,670,421,107,-393,-782,-821,-1116,-1082,-865,-749,-525,-225,-60,-132,161,339,123,308,642,613,311,20,-158,-327,-476,-612,-632,-477,-364,-335,-284,-149,-36,33,93,23,-9,91,104,-49,-238,-273,-211,-164,-92,-38,15,12,-99,-197,-269,-255,-200,-124,16,119,134,160,205,141,98,58,-80,-233,-282,-279,-320,-260,-129,-61,-78,-105,-106,-52,-39,-79,-96,-36,53,-287,-689,-703,-386,35,323,426,104}
        },
        {    // H-20e065a.wav
            {1,2,1,1,1,1,0,1,1,1,2,0,0,3,3,2,1,2,6,-4,2,5,6,5,-11,25,130,1048,1484,-660,-1642,-243,-212,46,1454,2050,1938,1649,2529,3380,2335,1101,241,-900,-1183,-155,-140,-1603,-2222,-1603,-766,-461,-592,-418,20,456,1031,1378,1004,398,104,21,-104,-396,-771,-959,-967,-967,-855,-768,-775,-638,-364,-81,123,218,287,344,325,278,203,30,-171,-257,-301,-445,-526,-484,-426,-366,-334,-271,-188,-138,-70,-20,1,5,10,19,-5,-47,-111,-172,-215,-251,-246,-210,-191,-143,-75,-39,-24,-20,6,9,3,6,-4,-11,-37,-80,-148,-178,-149,-117,-131,-142,-137,-135,-107,-85,-61,-89,-106,-137,-162,-181,-229,-59},
            {-45,108,-203,268,131,10205,12133,-16026,-21775,-687,5489,9049,8212,6517,21138,25952,4012,-14009,-10115,-5673,-3310,525,-4222,-9638,-9546,-4755,28,118,132,540,697,63,1678,4306,1809,-488,-400,486,111,-2582,-3107,-2593,-2361,-1780,-1106,-413,-439,305,1081,882,851,687,735,808,501,209,-346,-631,-719,-982,-1009,-958,-818,-597,-345,-258,-103,292,163,43,429,698,583,213,-11,-100,-286,-501,-619,-544,-429,-399,-372,-269,-116,-14,55,45,-32,17,134,47,-170,-269,-234,-158,-136,-85,6,38,7,-95,-238,-321,-278,-179,-58,42,107,108,133,167,101,99,36,-111,-199,-238,-300,-356,-251,-107,-62,-103,-122,-116,-57,-28,-61,-67,-28,-47,-439,-728,-602,-228,161,321,347,85}
        },
        {    // H-20e070a.wav
            {0,1,1,1,1,1,1,0,2,-1,1,2,0,1,2,3,1,1,3,3,-2,3,7,5,-5,3,26,154,874,1204,-407,-1432,-245,173,276,1357,1370,912,1414,2619,3489,2699,1310,520,-116,-365,-188,-733,-1902,-2201,-1524,-949,-918,-895,-257,563,872,1005,1104,702,227,102,40,-126,-455,-827,-989,-941,-861,-804,-758,-715,-560,-258,-15,97,187,255,313,283,179,99,-63,-229,-298,-351,-406,-430,-416,-380,-354,-320,-246,-165,-106,-71,-16,17,10,19,3,-31,-83,-161,-230,-260,-234,-182,-168,-174,-147,-87,-28,-15,-17,-20,-16,-8,-7,-6,-18,-52,-112,-142,-129,-83,-88,-140,-165,-159,-122,-115,-118,-128,-116,-141,-162,-191,-241,-61},
            {65,-50,-19,61,1418,13938,6564,-23739,-16678,4804,6317,8525,6483,10697,26188,19786,-5685,-14320,-7234,-3502,491,-193,-7498,-10261,-8386,-3085,-70,-596,292,587,-94,-189,2738,3892,944,-279,135,1302,103,-2663,-2998,-2684,-2244,-1804,-1246,-862,-528,482,792,707,700,698,937,845,643,308,-207,-436,-716,-874,-874,-889,-846,-771,-546,-444,-49,286,-29,39,511,708,518,185,63,-21,-239,-458,-541,-477,-425,-430,-406,-253,-86,-34,25,-5,-58,58,128,-23,-212,-236,-149,-104,-108,-37,50,51,-20,-122,-273,-355,-247,-125,-41,28,77,115,162,133,44,60,39,-51,-134,-212,-339,-366,-215,-90,-61,-113,-125,-106,-51,-22,-50,-72,-47,-132,-537,-706,-507,-95,269,321,315,80}
        },
        {    // H-20e075a.wav
            {0,1,1,2,1,1,1,1,1,2,2,2,2,1,1,1,3,1,1,4,5,2,-2,6,4,0,11,35,225,700,831,-185,-1067,-64,852,134,-8,788,1252,1717,2627,3359,2867,1839,1233,299,-683,-780,-943,-1822,-2270,-1841,-1247,-832,-385,244,717,755,727,800,577,194,56,13,-231,-606,-842,-880,-827,-799,-758,-669,-591,-424,-196,-38,77,160,215,245,187,66,-39,-150,-266,-297,-277,-319,-375,-372,-353,-318,-276,-220,-129,-69,-28,-15,-32,-15,1,-24,-87,-148,-180,-201,-208,-187,-169,-171,-176,-156,-89,-29,0,-8,-18,-11,2,12,-1,-28,-80,-107,-105,-75,-76,-145,-187,-172,-126,-121,-140,-157,-140,-152,-159,-180,-223,-55},
            {159,-192,184,-191,3055,16079,424,-27736,-11028,7985,6295,7274,6239,15786,27300,12070,-10977,-12748,-5052,-574,2858,-2320,-9730,-9956,-7039,-2486,-747,-727,442,189,-826,118,3702,3338,130,-247,909,1929,-230,-2510,-2505,-2631,-2308,-1757,-1437,-1395,-623,487,507,471,703,868,920,810,834,540,-83,-350,-588,-789,-761,-725,-857,-924,-792,-586,-42,118,-164,47,550,717,437,206,172,87,-160,-394,-446,-452,-425,-395,-400,-269,-121,-56,-8,-79,-69,80,90,-81,-207,-161,-69,-56,-61,43,96,32,-67,-192,-301,-311,-197,-107,-55,26,85,110,146,76,3,47,67,40,-72,-211,-356,-335,-154,-82,-91,-129,-112,-84,-47,-25,-64,-92,-64,-195,-572,-658,-429,16,327,305,319,86}
        },
        {    // H-20e080a.wav
            {0,0,1,1,0,2,1,1,2,0,2,0,1,1,-1,1,0,0,-2,0,8,1,-3,-2,4,10,2,8,66,269,518,491,133,-97,27,-200,-538,152,1193,1597,1813,2498,3479,3485,2196,821,-136,-788,-1020,-1269,-2057,-2525,-1823,-733,-190,14,311,494,467,556,691,469,86,-62,-134,-353,-618,-730,-780,-791,-717,-644,-536,-460,-348,-168,-50,50,131,157,117,26,-57,-120,-183,-222,-244,-262,-276,-308,-311,-295,-269,-216,-163,-108,-63,-61,-64,-55,-50,-40,-72,-115,-130,-157,-181,-192,-198,-198,-190,-167,-126,-72,-11,13,14,11,13,18,0,-22,-54,-75,-84,-87,-120,-180,-205,-165,-111,-118,-138,-173,-165,-160,-149,-149,-190,-49},
            {216,-309,337,-367,4384,17007,-4316,-29273,-6702,9600,6048,5845,6994,19970,25738,5791,-13200,-10996,-2892,1939,3946,-4364,-11247,-9034,-5946,-2750,-1463,-537,505,-770,-1253,954,4083,2794,-176,-193,1326,2248,-294,-2422,-2211,-2151,-2100,-1995,-1770,-1602,-801,137,325,395,652,928,888,794,929,697,115,-197,-485,-685,-674,-637,-823,-1011,-950,-729,-162,-96,-305,87,545,645,400,246,289,177,-101,-322,-392,-378,-375,-402,-416,-313,-175,-105,-71,-156,-105,86,64,-108,-198,-112,-10,-17,8,99,92,-17,-124,-210,-321,-310,-181,-115,-38,38,62,49,46,23,17,74,80,46,-40,-178,-311,-286,-170,-118,-130,-145,-103,-100,-60,-43,-75,-98,-110,-265,-605,-607,-338,74,319,279,313,87}
        },
        {    // H-20e085a.wav
            {0,0,0,1,1,1,1,1,2,3,1,0,1,1,1,2,1,-1,0,2,6,5,-2,3,-2,11,5,8,11,83,336,395,711,834,-611,-1356,-164,449,581,1310,1782,2060,2991,3821,2981,1204,353,14,-885,-1693,-1953,-2157,-1929,-966,-91,112,11,46,204,466,578,442,221,-84,-197,-174,-358,-606,-730,-727,-660,-583,-500,-435,-378,-280,-157,-40,33,37,11,-23,-52,-114,-193,-189,-199,-235,-216,-211,-224,-224,-219,-211,-211,-173,-111,-97,-92,-91,-76,-53,-84,-102,-116,-143,-164,-210,-233,-213,-182,-141,-107,-80,-36,-3,42,59,30,-4,-36,-28,-38,-59,-79,-125,-181,-226,-218,-149,-94,-105,-132,-179,-174,-149,-122,-121,-166,-44},
            {258,-368,414,-451,4879,17348,-6480,-29724,-4533,10345,5854,4703,7740,22428,23627,1799,-13788,-9336,-943,3530,4380,-5577,-12139,-8225,-5150,-3292,-2248,-331,418,-1720,-1526,1492,4424,2482,-405,185,1642,2189,-357,-2169,-1937,-1887,-1663,-1931,-2179,-1879,-900,-166,-46,311,732,881,826,810,972,782,265,85,-298,-643,-619,-594,-743,-1015,-1040,-816,-343,-297,-422,72,531,560,400,321,361,248,-59,-234,-295,-303,-294,-401,-465,-348,-192,-131,-152,-225,-134,70,64,-112,-182,-87,20,49,61,125,94,-29,-126,-225,-335,-310,-173,-76,-11,6,-13,-26,8,-2,18,102,114,95,-1,-142,-261,-251,-171,-153,-165,-163,-113,-115,-75,-38,-58,-89,-125,-304,-618,-569,-276,115,301,239,301,88}
        },
        {    // H-20e090a.wav
            {0,0,1,2,2,0,1,2,0,2,2,2,2,-1,3,1,0,1,-3,5,6,-2,4,2,10,0,-1,16,-10,19,181,728,978,71,-698,-753,-493,432,1037,916,1422,2528,2960,2642,2394,1903,931,245,-285,-1454,-2555,-2145,-1084,-678,-354,30,30,-174,-97,304,478,305,105,-7,-121,-237,-285,-433,-653,-674,-583,-488,-419,-418,-349,-271,-230,-129,-42,-39,-76,-94,-98,-133,-195,-221,-207,-175,-153,-132,-112,-154,-195,-191,-196,-198,-182,-140,-85,-76,-90,-98,-125,-118,-119,-160,-193,-214,-212,-184,-147,-105,-67,-42,-18,-2,35,55,32,-6,-52,-61,-56,-56,-88,-148,-212,-252,-224,-149,-81,-79,-105,-158,-159,-129,-83,-77,-144,-42},
            {269,-368,392,-411,4329,17472,-5613,-30050,-4719,10788,5750,4024,7679,23175,22557,-132,-13809,-8009,731,4407,4530,-5780,-12678,-7833,-4630,-3714,-2941,-649,355,-2309,-1924,1666,4607,2514,-473,500,2028,2245,-509,-2164,-1541,-1574,-1562,-1784,-2077,-2114,-1293,-389,-246,47,643,930,788,747,962,862,382,254,-49,-507,-604,-579,-689,-970,-1062,-891,-478,-480,-541,18,477,533,365,327,422,295,13,-160,-215,-236,-256,-364,-482,-384,-216,-159,-197,-285,-169,34,32,-110,-154,-62,8,40,86,174,134,-32,-146,-227,-307,-268,-168,-109,-71,-54,-36,-51,-32,-53,-10,138,185,177,32,-139,-242,-228,-160,-204,-234,-186,-120,-125,-92,-29,-20,-63,-126,-334,-638,-560,-251,132,279,200,271,81}
        },
        {    // H-20e095a.wav
            {0,0,0,1,2,0,1,2,1,1,1,1,0,1,1,1,2,0,-2,6,-2,2,3,1,18,-4,3,-8,0,16,322,1136,654,-979,-920,139,269,122,700,1479,1802,2473,2795,1767,1135,1568,1541,520,-354,-975,-2108,-2411,-1053,152,72,-286,-140,-26,-101,1,196,224,31,-101,-115,-258,-425,-435,-464,-589,-572,-411,-310,-312,-328,-256,-197,-164,-88,-90,-139,-176,-186,-188,-237,-247,-225,-158,-76,-89,-109,-113,-129,-147,-180,-198,-180,-131,-85,-99,-128,-137,-161,-185,-197,-193,-192,-195,-175,-140,-102,-59,-18,1,17,17,7,1,-9,-28,-59,-79,-100,-104,-107,-142,-216,-262,-231,-156,-77,-59,-78,-124,-123,-100,-70,-61,-121,-37},
            {230,-282,240,-189,2839,17004,-1627,-29917,-7514,11014,5746,3748,6834,22104,23050,22,-13820,-7226,2002,4962,4619,-5049,-12806,-8067,-4310,-3897,-3534,-1526,164,-2347,-2496,1343,4724,2777,-423,801,2393,2461,-328,-2264,-1461,-1277,-1373,-1787,-2043,-1965,-1475,-836,-503,-65,423,787,844,770,873,868,493,385,125,-335,-484,-567,-678,-911,-1026,-945,-607,-563,-620,-52,407,454,339,314,446,350,71,-93,-159,-191,-230,-334,-442,-373,-239,-188,-208,-310,-219,-14,0,-125,-149,-52,1,23,88,203,163,-14,-129,-168,-250,-269,-190,-177,-144,-90,-46,-52,-68,-82,-14,162,241,235,93,-98,-239,-243,-191,-245,-273,-213,-118,-123,-90,-3,26,-23,-126,-340,-640,-561,-246,100,245,180,243,74}
        },
        {    // H-20e100a.wav
            {0,0,0,1,1,1,1,-1,1,2,1,0,-1,1,0,-2,3,-3,-1,2,-2,3,-7,8,7,7,0,-21,-13,178,937,895,-611,-1156,-375,304,670,689,686,1462,2821,2770,1411,945,924,754,881,680,-86,-1016,-1619,-1637,-1128,-67,700,345,-266,-160,125,-40,-165,-24,22,-111,-335,-457,-486,-497,-454,-482,-507,-385,-228,-188,-230,-189,-113,-117,-138,-147,-152,-198,-283,-308,-297,-251,-193,-177,-153,-117,-87,-75,-82,-111,-137,-117,-94,-117,-142,-142,-142,-180,-242,-273,-261,-212,-171,-154,-132,-100,-51,-8,23,27,19,20,-1,-46,-72,-82,-94,-105,-118,-129,-150,-169,-210,-235,-206,-165,-103,-59,-47,-73,-81,-83,-77,-82,-124,-34},
            {125,-64,-63,202,932,15064,4917,-27801,-13193,10564,6245,3399,5717,19156,24484,2810,-13912,-7413,2901,5514,4778,-3658,-12391,-8885,-4286,-3729,-3850,-2907,-426,-1861,-2972,492,4414,3420,-58,680,2665,2946,195,-2246,-1471,-1179,-1330,-1590,-2061,-2056,-1405,-924,-909,-393,299,671,737,768,885,864,507,447,333,-194,-383,-461,-616,-868,-1036,-960,-688,-583,-648,-181,341,389,296,290,408,396,130,-62,-108,-175,-220,-278,-390,-332,-217,-200,-212,-319,-276,-83,-28,-157,-208,-60,35,29,54,191,204,50,-73,-132,-231,-297,-214,-180,-180,-155,-95,-58,-44,-44,-19,129,239,287,188,-35,-253,-311,-244,-262,-276,-230,-122,-104,-74,27,48,-6,-99,-310,-620,-575,-280,48,186,148,235,73}
        },
        {    // H-20e105a.wav
            {3,3,3,5,4,3,4,3,3,4,4,5,5,6,3,5,6,3,7,1,9,5,2,9,13,16,0,-2,54,826,1233,-457,-1537,-480,374,510,611,937,1554,2408,2826,2042,779,170,484,558,-14,-104,-42,-555,-1252,-1225,-510,-90,402,922,596,-15,-101,36,-179,-312,-130,-198,-484,-719,-671,-482,-503,-519,-431,-307,-180,-78,-3,-35,-75,-84,-90,-101,-172,-239,-313,-371,-322,-266,-262,-263,-228,-146,-85,-64,-56,-27,11,-19,-66,-99,-131,-150,-198,-255,-296,-302,-265,-214,-151,-95,-61,-30,-6,14,38,38,37,29,-9,-67,-117,-132,-115,-106,-128,-138,-160,-182,-188,-180,-165,-157,-111,-48,-8,-19,-34,-66,-87,-105,-138,-35},
            {-63,218,-388,556,-454,10925,11848,-21287,-20684,7730,7887,2664,4644,14945,24994,8494,-12984,-9159,3322,6259,5005,-1844,-11281,-9971,-4727,-3456,-3715,-4305,-1860,-1129,-2962,-799,3566,4040,831,505,2435,3404,1320,-1949,-1667,-964,-1388,-1614,-1891,-2110,-1669,-940,-903,-747,-157,541,775,643,807,962,604,365,429,49,-280,-374,-521,-772,-1021,-1015,-733,-556,-683,-330,285,381,240,199,332,415,199,-34,-90,-146,-205,-215,-294,-303,-204,-193,-208,-310,-341,-176,-76,-161,-235,-118,-2,44,64,173,238,105,-39,-127,-217,-295,-235,-183,-206,-201,-131,-62,-17,-4,-24,92,205,284,249,39,-216,-373,-322,-284,-273,-222,-131,-82,-61,18,66,16,-74,-256,-583,-598,-336,-36,117,122,212,64}
        },
        {    // H-20e110a.wav
            {-1,-1,-1,-1,0,0,0,-1,-3,-3,-1,-2,-2,-2,-3,1,-4,0,-4,-4,2,-3,-4,-2,9,-11,15,1,627,1495,50,-1881,-1159,354,832,699,722,1287,2583,3470,2266,511,85,258,59,-284,-409,-666,-744,-412,-447,-761,-485,217,550,806,1190,823,16,-268,-212,-249,-394,-538,-708,-815,-801,-722,-578,-542,-505,-280,-35,104,103,28,1,15,8,-69,-204,-286,-304,-340,-407,-434,-395,-336,-271,-231,-179,-65,22,50,57,34,-19,-90,-150,-200,-261,-299,-321,-322,-267,-202,-139,-71,-25,0,-17,-23,14,21,29,12,-61,-127,-157,-147,-131,-138,-165,-171,-158,-160,-187,-184,-170,-160,-102,-51,-15,-17,-27,-72,-132,-164,-173,-40},
            {-213,363,-456,482,-581,5351,15555,-9402,-26294,151,10270,2522,3113,10711,22951,15607,-8742,-12359,2215,7508,5403,181,-9391,-10920,-5669,-3459,-3226,-4857,-4131,-1204,-2053,-2025,2007,4381,1926,537,2125,3417,2516,-957,-1901,-847,-1136,-1697,-1949,-2033,-1886,-1237,-957,-786,-478,30,703,748,690,880,772,420,393,238,-117,-286,-426,-653,-912,-1039,-863,-533,-630,-505,136,385,231,86,206,408,270,4,-95,-114,-132,-163,-229,-276,-198,-166,-227,-325,-389,-275,-136,-159,-276,-194,-42,46,103,148,220,126,-10,-73,-185,-316,-288,-191,-171,-198,-173,-84,-41,5,-6,53,172,221,232,113,-128,-368,-416,-324,-241,-202,-135,-88,-85,-15,71,43,-59,-190,-518,-640,-423,-130,60,81,148,47}
        },
        {    // H-20e115a.wav
            {3,3,1,4,3,2,4,2,2,1,4,1,3,3,5,5,4,3,1,5,4,8,-5,21,-9,14,-2,424,1685,712,-1977,-1821,5,894,1011,877,1211,2460,3689,2945,954,-172,-302,-57,-240,-846,-1106,-993,-888,-695,-138,63,-244,68,828,1239,1293,1123,636,-83,-366,-316,-544,-857,-971,-888,-823,-889,-839,-606,-376,-191,15,183,189,152,185,171,79,-59,-124,-176,-336,-441,-485,-478,-442,-439,-378,-276,-151,-40,28,97,119,98,39,-91,-176,-200,-233,-271,-299,-271,-218,-162,-103,-65,-31,-9,-5,-8,6,27,19,-39,-105,-132,-129,-131,-141,-129,-110,-111,-144,-166,-177,-163,-139,-136,-97,-47,-7,8,-14,-85,-152,-179,-162,-34},
            {-166,169,-96,-56,176,812,13197,4587,-24082,-11867,10023,4800,989,6842,18537,20624,157,-14028,-2197,8688,6488,1972,-6569,-11323,-6905,-3892,-3007,-4156,-5968,-3025,-1178,-2082,31,3799,3167,761,1764,3357,3365,422,-1798,-816,-702,-1553,-2060,-2097,-2013,-1532,-1116,-1025,-600,-250,299,744,739,782,795,558,481,374,8,-180,-282,-504,-804,-966,-931,-631,-519,-613,-142,333,283,92,76,304,325,77,-38,-39,-59,-121,-161,-222,-222,-169,-229,-305,-387,-358,-217,-172,-263,-227,-56,49,90,99,195,196,48,-54,-127,-272,-333,-199,-114,-144,-177,-132,-69,1,27,44,127,180,206,149,-33,-279,-411,-361,-230,-152,-126,-114,-99,-34,62,80,-19,-131,-421,-642,-482,-197,-33,35,132,44}
        },
        {    // H-20e120a.wav
            {0,1,1,1,1,1,-1,1,-1,0,1,0,-1,2,2,3,3,-3,4,-6,11,-9,11,4,-3,9,206,1667,1506,-1784,-2613,-440,925,1137,985,1276,2506,4079,3574,1038,-345,-323,-201,-511,-1073,-1275,-1421,-1382,-887,-451,-162,182,350,309,801,1524,1480,1071,784,486,-46,-631,-892,-1014,-1046,-1020,-1063,-1018,-874,-613,-334,-179,-21,173,322,357,293,217,159,92,-68,-281,-424,-455,-464,-535,-578,-525,-412,-290,-186,-82,25,131,148,51,-21,-55,-117,-203,-246,-220,-201,-194,-187,-181,-156,-113,-54,-26,-19,-4,-5,-19,-52,-109,-142,-154,-147,-126,-100,-62,-48,-76,-151,-218,-212,-158,-125,-127,-128,-95,-18,3,-38,-120,-173,-172,-150,-32},
            {55,-178,291,-392,479,-558,6311,13202,-11443,-21989,2511,8791,488,2620,13182,21169,10409,-9535,-8638,6732,8980,3416,-3157,-10472,-8539,-4358,-3587,-3151,-5819,-5716,-2059,-1323,-1054,2100,3885,1525,1231,3110,3853,2146,-1276,-1186,-77,-1038,-2028,-2237,-2129,-1901,-1289,-1178,-983,-454,-10,517,716,748,810,647,526,566,227,-137,-208,-314,-616,-884,-904,-741,-533,-631,-464,134,323,145,11,155,350,215,22,1,9,-45,-119,-201,-254,-212,-213,-292,-400,-456,-343,-175,-166,-221,-119,-9,39,73,159,228,94,-48,-71,-145,-286,-267,-150,-124,-143,-141,-117,-66,8,45,97,165,181,138,10,-186,-357,-360,-234,-134,-109,-140,-137,-89,9,83,10,-82,-313,-616,-560,-282,-123,-27,84,33}
        },
        {    // H-20e125a.wav
            {1,1,2,1,2,0,2,0,1,2,0,1,2,4,3,7,-1,7,-5,11,-1,-2,21,-19,42,62,1470,2250,-1244,-3364,-1103,873,1375,1170,1186,2495,4517,4429,1521,-575,-814,-440,-306,-1037,-1682,-1871,-1707,-1223,-789,-206,77,95,520,1004,1199,1202,1262,1152,876,727,219,-603,-1109,-1160,-1126,-1198,-1164,-1013,-812,-623,-422,-144,57,214,379,428,418,365,232,40,-170,-272,-336,-451,-551,-605,-581,-518,-433,-323,-223,-67,60,61,50,39,5,-45,-103,-135,-148,-132,-128,-164,-196,-204,-183,-135,-84,-31,-3,-11,-36,-87,-120,-146,-176,-173,-128,-58,-1,25,7,-62,-170,-246,-239,-172,-123,-124,-139,-120,-51,-40,-65,-106,-129,-124,-129,-31},
            {110,-167,142,-48,-78,187,649,11344,4966,-20241,-11386,8622,3958,-897,6982,17994,17060,425,-10402,26,10081,5995,-318,-7583,-10103,-5252,-3840,-3613,-4169,-6627,-4719,-1683,-943,533,3234,2699,952,2505,3886,3483,527,-1607,-303,-74,-1465,-2369,-2280,-2130,-1731,-1254,-1177,-770,-349,172,620,720,812,793,553,566,565,102,-225,-255,-375,-666,-834,-822,-654,-626,-656,-213,230,235,53,71,293,333,155,49,57,0,-99,-165,-253,-255,-237,-334,-419,-463,-381,-212,-127,-175,-177,-61,16,52,73,177,180,37,-20,-66,-188,-280,-216,-134,-130,-139,-131,-108,-25,45,74,152,180,148,38,-129,-286,-340,-209,-96,-95,-157,-181,-138,-62,49,44,-49,-217,-533,-607,-350,-204,-110,29,20}
        },
        {    // H-20e130a.wav
            {0,2,-1,2,1,0,0,-1,2,-1,0,-1,4,-1,6,-3,8,-3,2,11,-19,35,-33,50,-7,1162,2864,-394,-4038,-1979,737,1534,1465,1293,2430,4743,5231,2177,-559,-1056,-791,-592,-1128,-1624,-1962,-2238,-1806,-1084,-334,11,118,412,759,1420,1509,963,798,954,1061,637,79,-400,-987,-1225,-1247,-1219,-1153,-1037,-794,-582,-337,-64,119,233,367,535,523,288,92,4,-97,-239,-391,-485,-552,-609,-566,-482,-420,-316,-200,-112,-38,2,30,18,-24,-37,-31,-28,-72,-120,-145,-169,-183,-201,-185,-137,-90,-37,-27,-62,-100,-148,-186,-192,-160,-114,-67,1,65,87,44,-72,-221,-289,-256,-187,-137,-134,-153,-147,-106,-85,-62,-72,-76,-80,-117,-31},
            {-56,101,-186,236,-276,284,-337,3712,12141,-4866,-20126,-1589,8194,-276,727,11760,18553,10403,-4867,-5567,6395,8580,2344,-3680,-9413,-7746,-3574,-4032,-4102,-5268,-6304,-3758,-1487,-211,1992,3167,1509,1570,3555,4027,2504,-558,-1065,141,-479,-1905,-2497,-2303,-2081,-1626,-1331,-959,-536,-257,267,595,788,958,765,432,539,506,33,-242,-317,-465,-669,-793,-781,-678,-719,-570,-40,251,160,59,202,405,335,111,28,17,-84,-152,-215,-322,-336,-364,-399,-405,-397,-304,-188,-135,-154,-102,-36,-10,20,99,219,160,8,-73,-132,-220,-233,-175,-163,-171,-149,-94,-42,11,24,89,186,175,72,-90,-239,-318,-228,-80,-60,-160,-240,-200,-130,-24,32,-41,-153,-417,-614,-429,-279,-220,-49,5}
        },
        {    // H-20e135a.wav
            {1,1,0,1,-1,-1,-2,2,-1,0,-2,4,-1,5,-3,4,7,-14,22,-28,35,-21,36,-11,803,3244,750,-4472,-3110,485,1632,1765,1518,2511,5036,5863,2735,-521,-1210,-952,-691,-1284,-2032,-2138,-2270,-2112,-1574,-811,-82,230,363,760,1460,1504,1155,947,585,670,761,322,-175,-433,-556,-972,-1341,-1353,-1103,-813,-684,-444,-188,-58,167,396,431,351,289,273,162,-75,-224,-273,-364,-489,-549,-548,-496,-390,-361,-352,-251,-121,-49,-54,-51,-6,44,39,-14,-70,-109,-110,-127,-153,-175,-187,-157,-117,-90,-77,-95,-146,-186,-184,-164,-156,-125,-68,-6,64,104,103,22,-126,-267,-320,-268,-197,-167,-160,-159,-174,-146,-83,-32,-39,-51,-53,-89,-26},
            {-60,44,-29,-53,138,-242,320,-228,6785,9277,-11636,-15242,4069,4692,-2098,4103,14464,16220,4763,-5386,695,8786,4843,-1012,-5564,-9004,-5705,-3081,-4492,-4863,-5769,-5339,-2886,-1370,533,2871,2638,1124,2444,4146,3686,1386,-889,-398,209,-1055,-2320,-2507,-2315,-1946,-1509,-1306,-759,-339,-30,384,632,870,955,671,417,531,366,-45,-220,-365,-562,-715,-779,-711,-690,-752,-423,90,232,176,228,399,410,194,28,-14,-50,-149,-240,-341,-381,-308,-320,-393,-430,-376,-242,-124,-122,-134,-55,-25,18,71,158,199,50,-66,-87,-136,-197,-196,-167,-165,-160,-93,-47,-26,14,46,158,206,120,-14,-193,-296,-251,-113,-49,-123,-226,-233,-170,-99,-22,-47,-108,-267,-548,-513,-334,-286,-128,-7}
        },
        {    // H-20e140a.wav
            {2,0,1,-1,1,-3,2,1,1,-3,5,2,2,2,-4,14,-18,27,-28,24,-4,14,29,466,3368,2028,-4543,-4410,79,1682,1966,1847,2734,5409,6507,3251,-488,-1429,-1194,-736,-1291,-2279,-2376,-2585,-2445,-1772,-1072,-284,63,283,793,1541,1799,1294,857,633,734,455,-149,-174,-208,-359,-580,-907,-1081,-1100,-904,-648,-455,-251,5,170,186,235,326,315,222,94,-46,-139,-234,-335,-409,-450,-445,-395,-394,-430,-356,-239,-167,-163,-153,-56,23,50,12,-67,-83,-68,-76,-114,-144,-137,-133,-123,-121,-137,-145,-151,-154,-155,-159,-160,-137,-106,-50,1,41,83,97,76,-25,-178,-303,-327,-272,-215,-189,-167,-158,-163,-103,-48,-12,-8,-24,-30,-70,-23},
            {51,-92,93,-93,52,6,-89,148,549,8627,5053,-14496,-9398,5566,979,-1401,7039,14896,13141,1597,-2879,5457,7941,670,-3155,-5944,-7943,-4263,-3360,-5237,-5298,-5608,-4194,-2263,-1166,1095,3083,2339,1400,3160,4127,2942,708,-720,6,-140,-1665,-2521,-2519,-2207,-1740,-1477,-1178,-542,-132,240,637,800,776,727,592,542,532,106,-215,-251,-394,-606,-747,-750,-688,-720,-668,-202,241,312,285,317,376,277,54,-73,-102,-129,-214,-288,-336,-328,-297,-361,-422,-416,-328,-173,-83,-106,-81,-2,33,44,43,112,103,-13,-61,-75,-129,-187,-161,-132,-151,-129,-71,-43,-5,61,124,189,155,31,-126,-264,-278,-183,-95,-82,-161,-242,-203,-141,-84,-82,-129,-150,-392,-563,-408,-318,-207,-26}
        },
        {    // H-20e145a.wav
            {-1,3,-4,0,-3,-1,-1,-1,-3,2,4,-1,6,-12,21,-21,22,-14,1,20,-23,83,215,3247,3288,-4217,-5786,-496,1731,2049,2143,3087,5960,7146,3686,-433,-1571,-1469,-952,-1312,-2542,-2554,-2589,-2813,-2257,-1385,-337,128,194,565,1482,2112,1511,1008,761,516,438,-6,-487,-721,-634,-543,-651,-730,-676,-568,-690,-520,24,190,57,69,214,305,222,70,-9,-110,-210,-235,-262,-359,-397,-358,-380,-385,-371,-295,-198,-199,-184,-128,-51,-1,-24,-92,-139,-101,-55,-69,-118,-131,-109,-95,-106,-149,-175,-184,-170,-134,-130,-133,-122,-103,-79,-61,-21,29,69,80,49,-13,-104,-211,-311,-329,-289,-250,-207,-159,-127,-98,-40,-22,4,5,-8,-36,-117,-37},
            {-14,37,-77,87,-117,107,-88,34,-19,1540,9137,1213,-14395,-4854,4301,-1213,481,8461,14117,10638,879,668,7638,4985,-2457,-3654,-5831,-6956,-3449,-4120,-5706,-5298,-5159,-3246,-1785,-798,1422,3009,2238,1942,3634,3653,2164,360,-374,106,-861,-2160,-2440,-2364,-2145,-1715,-1340,-929,-283,156,494,818,855,768,671,452,450,398,-63,-357,-408,-435,-556,-760,-819,-697,-566,-354,79,332,301,268,259,226,102,-43,-130,-156,-157,-199,-271,-362,-368,-353,-390,-371,-341,-266,-134,-55,-35,-19,-17,-20,-8,27,86,54,-33,-59,-55,-116,-178,-143,-124,-137,-105,-46,-6,38,94,143,162,61,-102,-245,-290,-212,-134,-100,-134,-210,-218,-162,-124,-129,-180,-158,-203,-486,-495,-342,-291,-63}
        },
        {    // H-20e150a.wav
            {2,-2,0,-4,-1,0,-3,-3,-3,6,-4,9,-17,17,-17,11,-2,-19,41,-60,123,70,2957,4390,-3483,-7127,-1332,1807,2061,2365,3477,6655,7897,4038,-380,-1647,-1706,-1186,-1420,-2898,-2864,-2526,-2916,-2592,-1816,-646,202,289,505,1416,2105,1664,1242,770,608,721,-129,-712,-881,-1041,-943,-862,-673,-510,-364,-158,-11,36,89,234,305,276,221,76,-56,-93,-221,-350,-335,-273,-275,-352,-420,-423,-338,-275,-244,-181,-114,-61,-57,-44,-49,-122,-173,-181,-137,-113,-118,-106,-109,-101,-114,-134,-174,-225,-196,-117,-87,-107,-116,-85,-38,-52,-59,-36,2,37,43,34,-32,-99,-170,-250,-322,-338,-299,-235,-176,-146,-78,-15,27,8,-1,-17,-33,-84,-203,-60},
            {-13,8,10,-51,74,-118,134,-147,122,-113,2417,8787,-1462,-12736,-2424,2091,-1652,2137,8595,13156,9242,1835,3720,7199,1507,-3678,-3361,-5727,-6220,-3392,-4744,-5740,-5058,-4626,-2646,-1355,-231,1724,2777,2223,2508,3749,3037,1589,191,-289,-174,-1361,-2334,-2422,-2278,-1966,-1578,-1214,-610,70,379,654,935,916,789,672,392,257,68,-269,-380,-459,-563,-694,-742,-624,-477,-372,-141,226,277,158,190,212,142,-3,-94,-90,-121,-201,-290,-353,-385,-350,-341,-371,-342,-277,-156,-53,-34,-64,-55,-39,-32,-8,17,72,38,-24,-31,-49,-130,-175,-115,-90,-96,-76,-24,12,76,116,107,61,-79,-204,-266,-210,-147,-137,-151,-168,-187,-183,-156,-177,-190,-220,-120,-280,-517,-394,-321,-82}
        },
        {    // H-20e155a.wav
            {-1,0,-2,-3,2,-3,-2,-4,6,-4,12,-16,14,-10,-1,12,-35,58,-75,122,35,2637,5180,-2487,-8234,-2394,1881,2068,2512,3856,7441,8778,4339,-372,-1698,-1898,-1398,-1520,-3258,-3382,-2597,-2900,-2763,-2081,-962,93,312,544,1437,2262,1730,1002,1017,1069,694,-257,-855,-1044,-1104,-1075,-1167,-1200,-844,-68,258,214,333,432,445,409,374,234,46,-68,-167,-341,-459,-408,-353,-395,-443,-416,-393,-345,-295,-219,-71,36,66,6,-49,-54,-102,-194,-239,-206,-161,-136,-151,-159,-142,-155,-180,-215,-218,-142,-71,-48,-70,-76,-40,-5,-7,-43,-38,-17,1,9,-12,-52,-95,-137,-221,-299,-340,-320,-266,-190,-134,-83,3,37,48,5,-17,-62,-107,-167,-259,-69},
            {23,-27,24,-7,-32,56,-107,139,-171,178,-145,3035,8008,-2816,-10663,-1876,223,-1016,2906,8157,12471,8924,3462,5281,5319,-1294,-3503,-2776,-5910,-5657,-3714,-5156,-5383,-4923,-4002,-2060,-1033,281,1948,2670,2334,2880,3374,2411,1348,61,-329,-678,-1777,-2199,-2328,-2256,-1869,-1304,-863,-329,247,511,835,1027,952,805,580,334,172,-150,-467,-515,-529,-592,-708,-667,-442,-257,-240,-159,114,208,222,229,157,100,12,-65,-143,-217,-286,-317,-344,-404,-368,-344,-313,-255,-213,-116,-38,-25,-52,-73,-77,-38,0,33,72,44,-9,-23,-40,-122,-143,-93,-82,-86,-61,-18,33,74,78,49,-45,-164,-236,-211,-137,-121,-171,-192,-170,-159,-165,-208,-209,-255,-169,-111,-354,-468,-348,-71}
        },
        {    // H-20e160a.wav
            {-3,-2,-4,2,-2,-3,-6,6,-5,9,-14,8,-3,-8,15,-42,59,-68,98,37,2408,5628,-1439,-8913,-3654,1859,2134,2593,4250,8157,9720,4708,-346,-1718,-2151,-1588,-1584,-3547,-3916,-2907,-3007,-2875,-2179,-1131,10,235,484,1572,2258,1758,1401,1174,806,663,-112,-867,-1135,-1253,-1278,-1390,-1292,-898,-347,6,276,665,889,867,595,314,253,200,-19,-195,-331,-499,-540,-515,-506,-521,-546,-481,-317,-238,-202,-23,142,149,61,12,-6,-70,-157,-225,-218,-212,-220,-228,-253,-244,-236,-223,-209,-187,-114,-20,5,-24,-24,-4,18,13,-3,-29,-42,-30,-36,-73,-110,-97,-93,-160,-273,-339,-344,-273,-182,-138,-97,-24,54,61,40,-23,-68,-150,-204,-221,-279,-73},
            {-14,28,-33,30,-22,-11,32,-85,123,-176,202,-143,3369,7167,-3093,-9006,-2463,-776,-194,2919,7813,12148,9193,4988,5312,3118,-2740,-3117,-2151,-5863,-5843,-3859,-5093,-5291,-4690,-3298,-1460,-737,579,2172,2723,2384,2861,2928,1896,1113,12,-497,-1109,-2010,-2143,-2166,-2093,-1707,-1069,-583,-49,395,582,940,1093,898,702,504,274,141,-146,-478,-654,-694,-610,-618,-591,-454,-320,-271,-122,124,217,290,292,181,61,-31,-87,-156,-252,-361,-385,-388,-406,-362,-329,-271,-212,-170,-79,-31,-38,-63,-82,-72,-35,11,59,79,42,22,17,-39,-143,-156,-99,-101,-103,-81,-21,46,75,39,-46,-141,-212,-184,-139,-124,-165,-202,-176,-143,-151,-224,-239,-257,-244,-129,-149,-391,-420,-82}
        },
        {    // H-20e165a.wav
            {-2,-4,2,-2,-3,-5,7,-6,10,-11,7,-2,-8,16,-42,52,-52,77,44,2318,5792,-568,-9043,-4917,1550,2302,2650,4673,8800,10498,5171,-186,-1644,-2416,-1858,-1663,-3760,-4364,-3264,-3221,-3148,-2297,-1150,-17,314,381,1334,2499,2236,1420,1054,867,667,-190,-871,-1098,-1486,-1591,-1339,-1138,-990,-590,-189,199,686,974,1019,882,646,410,224,70,-85,-328,-574,-630,-556,-591,-697,-680,-557,-336,-190,-113,-1,79,189,198,106,47,-21,-84,-161,-213,-241,-307,-356,-377,-337,-276,-249,-213,-165,-80,19,55,27,25,42,49,37,17,12,-32,-72,-96,-115,-140,-137,-93,-107,-190,-284,-310,-281,-203,-144,-96,-41,3,65,60,23,-74,-154,-225,-248,-252,-292,-72},
            {10,-13,24,-28,31,-30,6,12,-56,95,-152,194,-113,3433,6490,-2637,-8047,-3450,-1048,274,2800,7761,11757,9778,6037,4396,1222,-3131,-2527,-2208,-5559,-5730,-4452,-4784,-4946,-4485,-2676,-995,-302,716,2276,2937,2225,2453,2613,1760,790,-215,-675,-1382,-1966,-2064,-2073,-1903,-1498,-791,-359,58,469,742,938,895,844,711,503,341,170,-174,-540,-662,-638,-647,-683,-667,-580,-430,-323,-82,240,321,299,250,203,157,24,-109,-237,-359,-413,-400,-407,-416,-362,-296,-230,-205,-154,-98,-64,-29,-45,-34,-29,-13,36,84,98,51,12,-6,-63,-150,-170,-163,-139,-113,-57,20,43,23,-44,-105,-180,-193,-146,-128,-155,-174,-151,-142,-150,-211,-245,-253,-264,-249,-110,-205,-416,-106}
        },
        {    // H-20e170a.wav
            {-5,1,-1,-2,-6,5,-5,9,-12,6,-7,-9,11,-36,40,-50,80,30,2365,5817,-127,-8729,-5823,841,2455,2789,5095,9441,11005,5595,154,-1452,-2591,-2179,-1859,-3991,-4704,-3594,-3484,-3457,-2590,-1180,140,186,223,1690,2746,2165,1454,1133,933,666,-164,-1010,-1468,-1525,-1380,-1378,-1419,-1120,-434,-11,167,375,685,1038,1032,832,705,483,156,-71,-274,-543,-707,-710,-700,-744,-737,-626,-405,-250,-144,57,195,227,183,154,157,88,-36,-170,-242,-302,-383,-437,-453,-405,-337,-275,-213,-154,-73,36,93,65,42,57,77,59,38,21,-29,-84,-124,-155,-188,-191,-125,-86,-132,-208,-259,-245,-214,-176,-120,-80,-41,16,58,26,-60,-160,-217,-264,-281,-299,-269,-55},
            {-8,9,-10,18,-24,26,-29,11,-3,-36,65,-118,163,-65,3297,6067,-1890,-7711,-4332,-1078,524,3047,7551,11223,10553,6459,3095,-7,-3006,-2072,-2371,-5617,-5398,-4308,-4961,-4696,-3754,-2314,-746,120,932,2153,2789,2399,2256,1912,1500,943,-387,-1127,-1461,-1774,-1905,-1928,-1770,-1323,-604,-125,181,371,623,956,990,813,695,604,336,35,-233,-415,-512,-562,-641,-849,-915,-726,-450,-268,-79,167,346,426,362,254,149,23,-139,-301,-387,-400,-383,-410,-424,-385,-308,-236,-223,-198,-123,-22,37,27,14,16,38,70,76,71,37,-8,-36,-97,-167,-200,-182,-145,-89,-30,13,6,-42,-94,-158,-182,-173,-132,-140,-133,-95,-107,-140,-204,-214,-250,-255,-325,-232,-98,-288,-99}
        },
        {    // H-20e175a.wav
            {1,0,-1,-6,5,-5,12,-12,10,-12,-3,7,-32,39,-58,92,18,2510,5813,-132,-8244,-6092,-97,2315,3093,5543,10031,11327,5887,602,-1153,-2597,-2378,-2202,-4329,-4921,-3877,-3771,-3766,-2857,-1374,-132,435,679,1584,2627,2346,1696,1215,968,689,-405,-1194,-1331,-1411,-1649,-1704,-1371,-947,-369,-76,79,431,682,843,899,855,778,644,430,132,-247,-578,-749,-761,-760,-800,-760,-669,-527,-336,-118,105,233,290,305,264,195,98,-43,-186,-307,-379,-401,-452,-485,-453,-380,-274,-206,-147,-66,28,118,110,57,42,72,89,54,31,-5,-79,-129,-159,-198,-216,-175,-89,-67,-128,-183,-203,-194,-194,-168,-101,-61,-19,20,11,-50,-145,-203,-233,-287,-328,-315,-178,-21},
            {-1,-4,6,-6,14,-19,23,-24,9,-4,-27,46,-83,127,-14,3059,5872,-1184,-7720,-5029,-1050,1029,3402,6906,10794,11172,6339,1940,-663,-2666,-2018,-2579,-5296,-5348,-4130,-4391,-4627,-3557,-1768,-367,326,921,1994,2589,2375,2328,1676,926,612,-174,-1040,-1622,-1746,-1739,-1760,-1611,-1146,-454,-125,82,404,712,922,991,867,628,450,309,222,-53,-387,-506,-637,-823,-924,-879,-720,-536,-363,-111,189,375,431,394,295,161,16,-125,-258,-348,-391,-402,-430,-467,-413,-339,-286,-241,-181,-83,17,82,94,74,29,46,68,58,43,27,3,-84,-145,-188,-198,-177,-135,-67,-32,-34,-63,-89,-149,-189,-186,-141,-124,-102,-40,-37,-95,-202,-204,-227,-256,-327,-339,-156,-144,-51}
        },
        {    // H-20e180a.wav
            {-2,0,-4,5,-5,11,-14,14,-17,2,2,-31,42,-68,105,5,2712,5838,-457,-7881,-5773,-865,1733,3400,6127,10471,11469,6185,1166,-923,-2513,-2305,-2520,-4795,-5127,-4081,-4098,-3945,-3351,-1885,94,648,677,1666,2608,2458,1988,1485,980,382,-510,-880,-1213,-1798,-1921,-1670,-1349,-945,-437,-133,76,406,786,1012,857,630,667,659,470,268,-74,-474,-756,-799,-741,-821,-869,-758,-501,-328,-182,121,344,426,366,266,223,107,-74,-255,-362,-387,-411,-456,-486,-453,-376,-286,-212,-157,-66,57,125,113,69,44,61,67,60,53,17,-49,-116,-163,-202,-205,-176,-116,-59,-54,-91,-137,-157,-182,-191,-153,-107,-57,-15,-3,-44,-139,-194,-212,-251,-318,-357,-257,-104,-14},
            {-2,0,-4,5,-5,11,-14,14,-17,2,2,-31,42,-68,105,5,2712,5838,-457,-7881,-5773,-865,1733,3400,6127,10471,11469,6185,1166,-923,-2513,-2305,-2520,-4795,-5127,-4081,-4098,-3945,-3351,-1885,94,648,677,1666,2608,2458,1988,1485,980,382,-510,-880,-1213,-1798,-1921,-1670,-1349,-945,-437,-133,76,406,786,1012,857,630,667,659,470,268,-74,-474,-756,-799,-741,-821,-869,-758,-501,-328,-182,121,344,426,366,266,223,107,-74,-255,-362,-387,-411,-456,-486,-453,-376,-286,-212,-157,-66,57,125,113,69,44,61,67,60,53,17,-49,-116,-163,-202,-205,-176,-116,-59,-54,-91,-137,-157,-182,-191,-153,-107,-57,-15,-3,-44,-139,-194,-212,-251,-318,-357,-257,-104,-14}
        }
    },
    {    // elev-30 
        {    // H-30e000a.wav
            {-8,4,1,-5,15,-21,23,-37,15,-2,-35,47,-80,90,319,5004,5557,-7159,-7715,459,-3621,503,9907,8742,4396,5117,13205,8726,-5840,-5128,-2112,-9098,-8147,1040,-591,-6383,-3307,845,1091,-234,-92,1357,532,-548,1118,1471,-1120,-1569,48,143,-1029,-1434,-814,-584,-748,-263,385,4,-234,355,759,690,372,146,58,27,-327,-542,-422,-600,-664,-398,-181,-280,-275,-11,47,-20,67,161,53,-28,-66,-122,-166,-175,-130,-90,-48,-134,-177,-95,-68,-53,-34,-16,-82,-156,-118,-137,-185,-60,-3,-344,-631,-571,-466,-120,368,489,367,268,34,-286,-438,-581,-778,-839,-436,143,293,258,249,174,65,20,-32,-22,78,144,111,-22,-105,-239,-244,-285,-326,-360,-506,-134},
            {-8,4,1,-5,15,-21,23,-37,15,-2,-35,47,-80,90,319,5004,5557,-7159,-7715,459,-3621,503,9907,8742,4396,5117,13205,8726,-5840,-5128,-2112,-9098,-8147,1040,-591,-6383,-3307,845,1091,-234,-92,1357,532,-548,1118,1471,-1120,-1569,48,143,-1029,-1434,-814,-584,-748,-263,385,4,-234,355,759,690,372,146,58,27,-327,-542,-422,-600,-664,-398,-181,-280,-275,-11,47,-20,67,161,53,-28,-66,-122,-166,-175,-130,-90,-48,-134,-177,-95,-68,-53,-34,-16,-82,-156,-118,-137,-185,-60,-3,-344,-631,-571,-466,-120,368,489,367,268,34,-286,-438,-581,-778,-839,-436,143,293,258,249,174,65,20,-32,-22,78,144,111,-22,-105,-239,-244,-285,-326,-360,-506,-134}
        },
        {    // H-30e006a.wav
            {-2,-4,-4,8,-9,13,-9,6,-3,-23,30,-52,42,-51,45,17,2332,5980,-1337,-8217,-2239,-2818,-4036,5282,9245,6377,5092,9819,10842,248,-4568,-1553,-5271,-8777,-2325,1461,-3148,-3993,-1117,-455,-538,-747,-329,720,-7,-184,1564,1041,-393,-113,197,-262,-1118,-1227,-691,-1058,-1402,-235,212,-366,245,879,536,339,325,15,12,20,-173,-131,-342,-509,-384,-290,-316,-365,-269,-191,-143,-86,46,48,-107,-21,93,-35,-96,44,43,-5,-18,-71,-31,-46,-130,-205,-247,-317,-396,-315,-72,39,-328,-644,-566,-446,-104,472,682,517,362,157,-96,-361,-596,-850,-1062,-785,-203,53,49,80,138,229,281,291,233,192,224,139,-23,-147,-225,-358,-378,-397,-409,-485,-591,-143},
            {2,3,-5,19,-24,27,-37,12,6,-49,65,-101,109,271,5351,6542,-7762,-9244,347,-3958,513,11397,9655,4517,5317,14475,9830,-6967,-6126,-2477,-10359,-8612,1420,-939,-6603,-2976,1055,1428,-25,-119,1611,444,-1258,771,1475,-1278,-1343,486,68,-1353,-1461,-499,-526,-1078,-364,580,87,-199,456,645,512,439,337,179,2,-368,-493,-407,-724,-822,-518,-314,-366,-234,115,153,33,120,255,82,-6,15,-175,-296,-272,-206,-166,-113,-158,-182,-88,-86,-44,21,47,-2,-30,-11,-107,-204,-114,43,-243,-634,-651,-590,-323,238,503,380,310,149,-148,-342,-517,-773,-924,-599,56,359,290,249,156,58,39,50,49,85,157,133,31,-130,-239,-318,-326,-357,-325,-357,-497,-129}
        },
        {    // H-30e012a.wav
            {1,-1,-3,-3,6,-8,11,-5,5,-2,-18,24,-42,34,-38,38,18,1968,5200,-753,-6927,-2225,-2530,-3629,4180,7855,6079,5202,8391,9383,1247,-3417,-1364,-4082,-7323,-2559,717,-2680,-3425,-1487,-930,-780,-1099,-628,658,200,-39,1478,1309,247,335,330,-203,-971,-1076,-737,-1226,-1629,-699,-152,-413,135,644,376,276,373,200,263,340,121,42,-177,-409,-421,-377,-403,-433,-371,-312,-266,-258,-111,2,-19,79,131,37,18,85,67,39,50,28,-20,-69,-149,-249,-327,-422,-487,-369,-88,-64,-445,-623,-470,-307,123,592,669,509,268,47,-189,-410,-607,-852,-975,-638,-165,30,114,113,138,149,165,199,210,222,199,117,-35,-89,-208,-275,-381,-450,-485,-609,-156},
            {8,-8,24,-26,27,-35,4,20,-65,81,-117,126,149,5251,7839,-7262,-11308,-397,-3746,-39,12354,10996,4778,5395,15476,11289,-7406,-7363,-2963,-11301,-9621,1797,-153,-6937,-3306,1289,1562,19,-146,1857,279,-2485,6,2133,-366,-1209,294,193,-1138,-1424,-371,-450,-1375,-650,568,69,-298,392,548,387,350,315,345,244,-269,-447,-276,-562,-789,-630,-443,-530,-448,16,215,99,168,334,123,-16,61,-107,-326,-359,-300,-267,-222,-195,-141,-53,-83,-38,111,132,26,-12,30,-61,-212,-162,47,-162,-643,-703,-590,-429,27,430,417,341,262,-11,-210,-405,-715,-983,-808,-127,337,339,265,150,15,40,78,110,156,220,220,69,-87,-227,-320,-422,-438,-364,-314,-406,-438,-93}
        },
        {    // H-30e018a.wav
            {-4,1,-2,-3,-4,4,-7,7,-4,2,0,-16,19,-34,26,-28,27,10,1580,4455,-103,-5689,-2339,-2224,-3151,3032,6580,5891,5006,6893,8180,2153,-2270,-1065,-2996,-5866,-2816,28,-2184,-3153,-1718,-996,-1087,-1652,-1094,427,384,305,1615,1565,760,840,773,-29,-1081,-1231,-934,-1384,-1796,-1101,-462,-447,-35,355,271,310,527,542,569,516,275,177,-79,-358,-368,-374,-495,-572,-517,-519,-532,-403,-145,46,89,159,188,118,94,144,116,55,34,-5,-19,-88,-207,-310,-364,-421,-474,-333,-128,-213,-535,-570,-390,-160,285,600,597,422,182,-49,-238,-427,-628,-855,-846,-444,-81,89,124,87,68,83,75,105,182,225,194,60,4,-102,-182,-291,-387,-482,-602,-151},
            {-8,27,-30,24,-28,-12,37,-85,95,-130,135,14,4708,9169,-5543,-13379,-2140,-3253,-594,12479,12271,5635,5536,15976,13185,-6989,-8730,-4219,-12659,-9895,2887,585,-7256,-3975,921,1641,330,-60,1755,-397,-3913,-314,3676,736,-1598,-241,611,-262,-1223,-733,-789,-1487,-689,520,-115,-702,233,538,307,267,274,437,400,-156,-323,5,-356,-753,-617,-436,-567,-594,-172,5,-12,228,424,113,-108,77,-9,-300,-387,-315,-289,-225,-212,-186,-39,-56,-23,107,143,58,15,101,-21,-244,-252,-15,-40,-552,-777,-638,-508,-131,357,446,392,352,126,-86,-286,-588,-955,-1030,-410,270,346,231,140,13,32,66,112,227,297,312,200,5,-162,-299,-452,-521,-444,-357,-372,-438,-284,-37}
        },
        {    // H-30e024a.wav
            {-1,-1,0,-1,-1,-3,4,-5,7,-3,2,3,-15,15,-23,19,-15,20,1,1158,3777,683,-4582,-2584,-1842,-2773,1862,5627,5674,4481,5563,7266,2995,-1223,-695,-1913,-4745,-3147,-328,-1715,-2965,-1818,-1208,-1599,-2093,-1248,391,616,667,1741,1849,1205,1075,865,48,-994,-1372,-1272,-1491,-1790,-1261,-621,-631,-315,232,418,518,666,685,712,647,379,220,-30,-275,-329,-404,-575,-730,-746,-672,-554,-426,-180,59,144,203,258,235,159,146,118,54,-7,-72,-97,-111,-179,-274,-336,-403,-425,-298,-169,-341,-585,-531,-308,9,376,516,454,320,103,-98,-294,-450,-612,-749,-608,-246,12,89,93,3,7,13,-5,82,182,224,107,24,-57,-96,-195,-265,-370,-546,-142},
            {29,-27,18,-13,-31,58,-100,103,-126,122,-70,3760,10159,-2662,-14842,-4719,-3029,-1263,12184,13172,6547,6220,16394,14966,-5547,-9674,-7094,-14163,-8155,3783,423,-6855,-4489,-318,1259,1248,79,652,-1154,-4301,-76,4716,1361,-1799,-331,1115,437,-992,-1125,-1244,-1575,-624,348,-399,-900,30,315,222,355,290,369,438,28,-89,199,-217,-689,-508,-295,-506,-639,-354,-168,-142,88,322,83,-81,82,-16,-272,-341,-263,-211,-157,-167,-181,-63,-49,-32,77,104,35,-7,79,47,-146,-271,-127,16,-385,-802,-720,-542,-255,265,472,417,460,322,48,-204,-510,-880,-1131,-730,117,390,201,83,-28,42,109,93,256,407,412,318,124,-68,-199,-415,-563,-543,-451,-373,-402,-332,-153,-21}
        },
        {    // H-30e030a.wav
            {0,0,-1,1,-1,-1,-3,3,-2,4,1,0,4,-12,14,-17,14,-4,8,-1,780,3119,1335,-3548,-2741,-1511,-2450,976,4834,5119,3896,4607,6350,3545,-183,-193,-1086,-3864,-3222,-605,-1311,-2691,-2204,-1804,-1869,-1850,-1068,309,807,954,1855,1990,1246,980,752,70,-763,-1247,-1381,-1630,-1810,-1342,-781,-678,-343,246,533,644,741,673,649,650,442,230,-8,-234,-373,-511,-649,-763,-754,-683,-573,-414,-202,45,130,171,271,266,212,164,74,5,-43,-85,-60,-87,-183,-272,-325,-356,-394,-287,-239,-436,-554,-430,-206,92,342,387,335,202,32,-158,-316,-417,-536,-560,-362,-98,5,43,5,-66,-81,-46,5,50,134,111,39,-25,-26,-110,-176,-237,-397,-110},
            {-8,-1,6,-55,71,-103,85,-89,54,-56,2428,10377,1499,-15095,-8197,-2911,-2227,10871,14107,7400,6653,16814,17578,-3466,-11333,-9198,-14604,-7517,4248,907,-6638,-5225,-1500,558,1924,-136,-918,-1125,-3108,-50,4193,1879,-1085,-212,1224,760,-680,-1125,-1681,-1987,-661,313,-677,-1150,-34,193,60,267,259,346,537,323,-43,170,34,-411,-454,-336,-415,-650,-472,-246,-281,-92,173,-13,-118,96,26,-210,-311,-249,-149,-56,-109,-216,-68,3,-36,16,37,6,-25,30,27,-118,-253,-202,27,-140,-691,-838,-620,-357,135,476,403,421,453,247,-53,-392,-779,-1163,-1048,-180,409,240,20,-110,-49,111,108,263,475,514,437,243,18,-105,-301,-557,-595,-555,-470,-418,-357,-178,-91,-23}
        },
        {    // H-30e036a.wav
            {-1,-2,-1,-3,0,-2,-2,-5,0,-4,-1,0,-4,2,-14,7,-13,7,2,-7,-1,478,2536,1827,-2644,-2859,-1330,-2110,395,4023,4438,3479,3858,5430,3926,787,282,-517,-3152,-3128,-817,-1127,-2574,-2542,-2188,-1797,-1410,-815,338,1055,1160,1530,1620,1194,984,703,87,-631,-1119,-1313,-1613,-1851,-1405,-717,-464,-174,230,420,546,639,564,514,587,437,163,-59,-273,-387,-476,-595,-681,-716,-651,-538,-464,-257,-31,48,126,213,259,196,118,90,26,-13,-30,-70,-118,-207,-287,-332,-380,-369,-311,-330,-441,-448,-333,-158,105,279,280,205,92,-64,-207,-306,-351,-406,-392,-216,-94,-46,-34,-73,-140,-144,-91,-63,4,69,68,-7,-2,-51,-114,-154,-270,-77},
            {-20,33,-76,72,-77,30,-12,-48,51,1050,9284,6297,-13080,-12380,-3390,-2896,8316,14449,8478,6914,16765,20754,-755,-12818,-9294,-14713,-8734,4338,1613,-6297,-6089,-2283,-188,1402,-182,-1920,-916,-1383,61,3156,1964,-135,179,1206,839,-696,-1012,-1566,-2365,-1245,227,-481,-1393,-260,204,20,211,90,275,649,573,98,103,181,-180,-342,-303,-427,-691,-612,-373,-374,-185,159,-48,-239,51,108,-74,-192,-253,-204,-38,-50,-222,-132,7,-10,6,14,-11,-6,24,-25,-141,-206,-234,-74,24,-410,-812,-681,-449,-76,402,443,371,447,364,90,-238,-592,-1012,-1210,-618,277,355,15,-160,-179,-2,91,260,557,622,521,375,126,-19,-152,-490,-621,-590,-584,-481,-360,-204,-103,-68,-10}
        },
        {    // H-30e042a.wav
            {1,1,-2,0,-2,-1,-1,-2,-4,1,-2,-1,4,-6,5,-10,6,-1,2,9,-7,4,262,2010,2088,-1816,-2829,-1228,-1673,23,3140,3776,3171,3232,4570,4137,1643,634,-92,-2386,-3078,-1183,-908,-2305,-2687,-2250,-1472,-988,-543,503,1037,792,1022,1474,1277,926,635,148,-512,-1022,-1231,-1469,-1606,-1171,-518,-319,-232,70,266,342,444,483,464,446,284,93,-29,-179,-307,-414,-506,-593,-636,-607,-564,-463,-265,-67,22,83,160,183,176,152,97,54,56,7,-93,-163,-230,-282,-313,-353,-357,-311,-348,-386,-314,-228,-74,114,199,169,100,13,-119,-235,-253,-239,-277,-258,-178,-122,-83,-59,-109,-184,-196,-142,-63,6,78,53,27,1,-41,-77,-159,-48},
            {32,-67,44,-21,-46,79,-144,173,95,6861,10265,-8177,-16176,-5448,-2777,5157,13780,9509,6994,16271,22996,3471,-12644,-9597,-14086,-10050,3448,2042,-6032,-6526,-2586,-1247,-210,-219,-1392,-770,-975,381,3031,1981,295,507,1306,930,-975,-1203,-1250,-2331,-1786,-293,-335,-1286,-430,162,-72,279,162,195,484,663,426,161,141,-155,-258,-192,-361,-795,-812,-448,-445,-332,99,50,-200,35,130,-47,-96,-134,-209,-165,-95,-171,-161,-119,-102,9,76,42,-22,19,-1,-145,-176,-208,-156,38,-147,-672,-760,-525,-279,239,486,346,383,396,173,-110,-427,-830,-1147,-908,-36,386,74,-192,-279,-150,9,167,540,746,634,480,264,46,-56,-333,-614,-634,-631,-568,-397,-228,-124,-87,-30,2}
        },
        {    // H-30e048a.wav
            {3,0,1,0,0,-1,0,1,0,-1,1,0,1,7,-4,8,-4,4,6,-3,14,-8,6,136,1549,2133,-1083,-2677,-1203,-1223,-218,2280,3192,2940,2748,3791,4086,2356,1137,57,-2135,-2954,-1257,-561,-1897,-2657,-2146,-1056,-451,-381,134,663,633,808,1293,1293,911,516,60,-540,-902,-895,-1030,-1186,-960,-538,-401,-357,-123,60,208,333,318,279,298,202,79,26,-106,-241,-337,-429,-517,-560,-554,-523,-419,-244,-82,-16,8,53,110,147,156,118,43,20,-5,-63,-130,-218,-263,-295,-346,-347,-330,-330,-287,-206,-117,10,95,73,45,27,-51,-180,-241,-193,-161,-199,-228,-200,-139,-67,-80,-164,-232,-210,-111,-52,21,72,63,26,0,-32,-91,-28},
            {-12,-33,62,-114,117,-142,134,-171,3328,11876,181,-17602,-10140,-2521,2094,11721,10506,7056,13982,23784,11122,-10338,-11124,-12361,-11431,1312,2822,-5259,-7143,-3708,-2308,-1375,-79,-854,-861,-752,92,2844,2903,1063,437,824,1193,-523,-1584,-1476,-2311,-1955,-738,-567,-1237,-503,311,-80,203,309,302,470,610,579,227,161,-29,-339,-385,-293,-578,-896,-694,-556,-415,50,140,-147,17,206,63,-46,-88,-178,-214,-114,-191,-258,-165,-128,-85,-35,49,81,77,65,-88,-157,-119,-132,-17,36,-443,-831,-635,-422,12,476,388,294,371,282,26,-287,-680,-1031,-1004,-342,325,165,-245,-349,-244,-44,74,359,759,784,607,432,150,-30,-201,-487,-619,-649,-626,-468,-253,-120,-101,-51,-2,-2}
        },
        {    // H-30e054a.wav
            {1,2,0,0,0,0,0,0,0,0,-1,-1,3,2,4,0,6,-5,3,2,-6,16,-11,9,84,1180,1949,-518,-2337,-1205,-849,-323,1521,2670,2702,2352,3216,4115,2786,968,-179,-1664,-2327,-1006,-319,-1583,-2397,-1671,-676,-512,-600,-135,445,587,727,1117,1133,739,213,-201,-282,-262,-418,-784,-1021,-914,-651,-507,-451,-298,-84,90,160,135,105,151,146,97,71,-49,-180,-266,-328,-407,-480,-480,-449,-366,-248,-154,-113,-76,-2,52,82,105,68,16,38,36,-17,-84,-180,-258,-335,-368,-337,-305,-247,-181,-120,-49,5,8,-22,-38,-62,-141,-209,-186,-130,-139,-214,-239,-196,-127,-91,-138,-192,-192,-157,-112,-43,31,62,32,15,-7,-60,-20},
            {-59,69,-70,1,38,-116,144,437,8991,9357,-12624,-16799,-4162,122,8242,11220,7274,10642,21847,19732,-3885,-12859,-10971,-12171,-1743,3711,-3290,-7876,-5973,-3182,-2314,-41,3,-1357,-1027,-345,2464,3864,1918,541,677,1414,99,-1723,-1795,-2398,-2493,-1250,-498,-1180,-1000,400,232,65,437,537,603,503,612,427,176,-6,-338,-528,-522,-509,-781,-798,-602,-549,-126,205,-33,-31,217,169,17,-18,-97,-222,-159,-186,-317,-278,-199,-113,-103,-96,18,117,194,102,-79,-112,-90,-34,110,-135,-761,-808,-544,-281,296,468,270,272,289,176,-66,-477,-907,-1020,-614,118,293,-206,-485,-387,-130,45,196,615,851,723,566,319,65,-127,-392,-577,-622,-615,-532,-334,-136,-92,-73,-2,11,0}
        },
        {    // H-30e060a.wav
            {0,1,1,1,1,0,1,2,-1,0,1,0,2,3,3,5,1,3,-2,3,4,-1,9,-2,6,87,933,1597,-162,-1829,-1148,-632,-342,943,2130,2551,2493,2795,3257,2530,1011,-67,-908,-1442,-826,-210,-987,-1896,-1615,-801,-548,-652,-284,348,503,529,842,753,314,177,269,273,58,-306,-713,-948,-901,-713,-558,-508,-425,-216,-77,-74,-47,1,91,136,124,128,12,-91,-154,-254,-324,-391,-394,-369,-373,-314,-241,-193,-114,-64,-12,37,37,66,85,90,68,-7,-73,-176,-285,-340,-352,-285,-209,-156,-103,-102,-82,-47,-59,-67,-94,-132,-172,-189,-128,-97,-162,-247,-283,-198,-94,-87,-127,-158,-159,-132,-85,-27,21,18,10,1,-35,-12},
            {-41,84,-135,135,-149,125,-156,3339,13040,-143,-20279,-10468,-415,3861,10856,8310,7341,17468,25161,6982,-12572,-11349,-11340,-5076,3868,-589,-7541,-8529,-4540,-2847,-1269,816,-973,-1545,-713,1430,3724,3032,1514,386,1260,1395,-1174,-2352,-2676,-2799,-1931,-789,-748,-1345,-237,466,250,523,626,773,668,615,501,200,184,-223,-655,-677,-583,-704,-932,-695,-512,-318,136,56,-110,126,265,166,29,5,-90,-146,-131,-318,-393,-304,-231,-164,-168,-83,63,183,239,116,-4,-27,-44,67,152,-374,-878,-717,-531,-81,426,323,216,241,193,121,-173,-670,-955,-770,-200,295,49,-522,-628,-331,-13,103,406,806,819,679,498,245,-2,-302,-537,-591,-592,-535,-390,-210,-91,-78,-19,43,40,11}
        },
        {    // H-30e066a.wav
            {0,0,1,1,1,1,1,1,0,2,2,1,2,2,2,2,3,1,-1,1,6,1,-4,7,7,-3,137,775,1144,-14,-1222,-991,-622,-360,683,2011,2518,2019,1847,2469,2530,1462,254,-361,-572,-238,-17,-943,-1785,-1488,-866,-643,-648,-345,91,209,209,347,572,692,624,496,352,128,-274,-728,-912,-835,-682,-593,-611,-569,-417,-281,-202,-131,-27,108,173,172,165,83,-35,-121,-176,-238,-315,-352,-401,-423,-366,-291,-213,-168,-114,-22,30,69,97,93,102,76,-8,-125,-229,-269,-289,-270,-195,-144,-128,-132,-133,-105,-80,-84,-104,-134,-165,-185,-159,-111,-148,-238,-283,-250,-149,-59,-57,-104,-136,-143,-120,-87,-27,5,-7,-16,-37,-12},
            {10,14,-88,142,-225,265,-110,7553,12545,-10968,-20772,-3724,1725,6678,10360,5876,11031,24304,19622,-5180,-13957,-10305,-7423,1706,2701,-4929,-9874,-7773,-3065,-2459,-550,148,-1279,-1009,110,2745,3456,2384,1083,762,2117,355,-2078,-2654,-3229,-2818,-1433,-539,-1318,-1168,281,477,396,602,962,1050,797,685,232,40,98,-373,-801,-826,-780,-955,-903,-590,-464,-55,182,-91,-67,210,307,160,62,41,-23,-59,-249,-455,-442,-349,-271,-248,-189,-36,135,270,242,112,46,27,5,164,114,-580,-871,-662,-489,75,344,167,204,181,165,104,-344,-823,-829,-413,112,252,-301,-765,-614,-218,-2,155,602,844,774,652,413,200,-87,-453,-598,-572,-541,-433,-264,-126,-86,-57,34,59,50,13}
        },
        {    // H-30e072a.wav
            {1,2,2,2,2,3,3,3,3,4,3,5,5,4,5,3,5,3,6,5,2,11,-1,2,12,12,5,187,680,722,-16,-645,-823,-678,28,896,1334,1543,1637,1727,2191,2570,1856,563,272,587,153,-702,-1225,-1374,-1285,-1023,-760,-669,-551,-371,-202,151,633,951,924,683,463,306,86,-350,-737,-773,-688,-707,-782,-781,-660,-511,-368,-250,-122,61,158,173,196,177,108,13,-63,-133,-235,-304,-376,-449,-431,-356,-279,-225,-171,-88,-21,35,83,108,123,100,33,-65,-170,-216,-222,-212,-173,-162,-168,-145,-124,-113,-110,-123,-124,-124,-149,-195,-227,-196,-151,-166,-216,-237,-193,-90,-23,-40,-99,-153,-145,-109,-55,-15,-26,-49,-60,-15},
            {64,-79,15,56,-165,221,581,11233,8761,-18894,-17336,1092,2899,7807,8410,6025,16715,25906,10658,-11704,-13258,-7906,-1849,3982,-294,-7734,-10646,-6114,-2503,-2868,-209,64,-1447,-579,1377,2993,2852,2171,576,1218,2350,-373,-2459,-3002,-3049,-2505,-1459,-861,-1398,-738,345,437,350,740,1350,1214,937,686,47,-33,30,-517,-898,-890,-949,-1156,-896,-518,-339,55,60,-139,38,334,356,154,129,98,10,-71,-329,-533,-494,-357,-305,-317,-182,22,202,317,245,123,100,73,52,244,36,-682,-816,-645,-426,120,193,86,196,137,206,74,-508,-855,-634,-122,320,153,-596,-906,-563,-157,-14,242,705,813,739,603,377,192,-167,-532,-574,-531,-490,-320,-154,-85,-86,-13,34,22,56,16}
        },
        {    // H-30e078a.wav
            {0,0,0,0,1,1,1,2,2,3,3,1,2,1,0,0,-1,2,3,2,0,4,7,-2,7,4,8,14,249,592,319,-64,-196,-381,-206,-126,-62,652,1383,1858,2012,2052,2426,2338,1452,709,391,-213,-1016,-1248,-1100,-1126,-1224,-1058,-859,-875,-620,90,751,988,936,832,629,354,143,-85,-389,-617,-707,-762,-873,-920,-819,-667,-500,-350,-203,-44,93,163,163,182,178,127,52,-70,-203,-310,-372,-387,-386,-372,-339,-281,-200,-142,-99,-34,23,92,150,129,46,-48,-105,-152,-204,-205,-172,-149,-154,-166,-136,-113,-129,-150,-167,-170,-180,-226,-272,-271,-189,-105,-127,-175,-170,-108,-49,-55,-97,-140,-135,-106,-83,-67,-67,-82,-80,-17},
            {101,-156,111,-50,-63,109,1411,13374,4782,-23008,-13695,3898,3396,7115,7051,8387,20301,23970,4087,-14652,-11931,-4427,2074,3685,-2824,-9194,-10172,-4858,-2954,-3244,-20,-25,-1327,-244,2071,3087,2545,1682,226,1703,2128,-861,-2410,-2900,-2829,-2279,-1492,-1323,-1412,-408,309,265,310,968,1484,1239,1054,779,65,-100,-91,-629,-950,-910,-1062,-1296,-958,-523,-220,61,-46,-130,128,472,418,206,179,91,-24,-155,-347,-518,-526,-381,-344,-353,-166,72,235,277,220,195,184,103,99,288,-62,-746,-770,-655,-372,111,36,62,201,145,264,-30,-659,-810,-420,94,376,-8,-773,-902,-497,-192,-29,345,750,783,678,531,374,183,-221,-545,-547,-502,-426,-221,-69,-87,-102,12,17,-6,36,10}
        },
        {    // H-30e084a.wav
            {0,0,0,0,0,1,1,1,2,2,2,3,1,1,0,-1,-1,1,3,-3,1,6,2,11,3,-6,3,11,49,270,434,104,186,556,-309,-1085,-699,-73,892,1764,2086,2188,2381,2872,2549,1076,34,-51,-214,-899,-1286,-1139,-1133,-1352,-1416,-1131,-610,-15,647,1057,1002,819,651,435,183,-26,-197,-436,-666,-828,-900,-882,-871,-783,-601,-408,-234,-109,0,75,115,181,228,199,94,-48,-179,-287,-354,-358,-337,-315,-313,-314,-272,-204,-123,-54,-7,47,111,154,121,15,-84,-140,-174,-185,-181,-168,-152,-137,-119,-128,-153,-177,-202,-227,-246,-259,-289,-284,-198,-94,-52,-60,-85,-100,-100,-103,-119,-135,-114,-98,-98,-110,-111,-98,-84,-18},
            {126,-204,182,-124,16,36,1880,14358,2392,-24817,-11407,5647,3564,5745,6583,10800,21527,21464,70,-16060,-10023,-1099,4335,2936,-4818,-9956,-9280,-4301,-3578,-3282,66,-452,-1421,190,2473,3022,2542,1388,-66,1949,2092,-1143,-2659,-2597,-2183,-2094,-1590,-1496,-1524,-481,250,191,228,979,1478,1221,1102,860,204,1,-194,-710,-924,-913,-1128,-1379,-1002,-549,-186,71,-100,-166,171,545,473,272,191,47,-98,-197,-335,-485,-497,-387,-338,-339,-172,52,215,277,232,209,209,130,142,326,-102,-792,-793,-682,-351,69,-66,23,176,180,321,-64,-689,-727,-271,186,348,-142,-873,-862,-463,-252,-65,335,719,759,633,508,380,174,-195,-478,-529,-489,-345,-162,-64,-122,-142,-24,-38,-38,23,8}
        },
        {    // H-30e090a.wav
            {0,0,0,0,1,1,1,3,3,3,2,3,2,0,1,-1,0,3,1,-1,4,4,4,7,9,3,-11,12,4,59,281,550,692,199,-611,-1012,-913,-151,665,1302,2037,2513,2972,2939,1979,1094,450,-135,-314,-337,-766,-1300,-1326,-1244,-1469,-1453,-715,233,673,854,1077,984,594,312,173,18,-199,-450,-654,-782,-868,-893,-818,-721,-623,-423,-247,-160,-65,20,107,156,167,178,101,-18,-154,-292,-341,-338,-300,-277,-300,-309,-293,-215,-117,-68,-12,50,95,126,122,75,-17,-97,-149,-205,-237,-207,-133,-102,-124,-149,-186,-223,-248,-260,-269,-298,-304,-252,-172,-75,9,43,5,-73,-133,-170,-166,-135,-121,-121,-113,-127,-119,-88,-76,-17},
            {139,-220,190,-120,-6,84,1569,14304,2876,-25046,-11520,6583,3588,4317,6365,12052,21436,19797,-1452,-16251,-8287,1070,5439,2723,-6074,-10300,-8544,-4333,-4024,-3326,-21,-808,-1760,108,2783,3260,2371,1447,90,1818,2119,-1130,-2850,-2574,-1829,-1597,-1412,-1712,-1646,-525,-15,-62,268,977,1328,1138,1067,926,334,124,-89,-693,-952,-886,-1077,-1425,-1087,-547,-173,46,-154,-228,178,567,502,326,195,19,-128,-224,-337,-448,-436,-339,-327,-353,-176,59,216,250,214,204,203,158,154,310,-108,-779,-762,-679,-380,4,-152,-11,182,235,377,-80,-662,-628,-180,203,270,-236,-900,-811,-434,-276,-87,270,654,742,626,539,396,156,-122,-377,-512,-482,-299,-123,-68,-150,-190,-95,-100,-60,39,14}
        },
        {    // H-30e096a.wav
            {0,1,1,1,1,2,2,3,4,4,4,3,2,3,0,0,2,3,0,4,4,1,7,6,11,8,8,-14,2,2,301,1092,697,-738,-1074,-686,-257,247,765,1237,1733,2883,3294,2243,1419,808,218,36,-187,-523,-645,-727,-1167,-1448,-1316,-1187,-748,126,851,1035,949,878,636,282,54,-110,-306,-481,-664,-816,-819,-798,-777,-635,-489,-406,-288,-141,-46,7,69,92,101,146,93,-63,-202,-265,-285,-331,-351,-321,-286,-243,-205,-176,-122,-31,47,73,77,79,80,93,50,-51,-149,-234,-279,-252,-158,-88,-116,-179,-225,-256,-261,-274,-281,-280,-273,-221,-153,-48,65,102,48,-59,-154,-197,-187,-159,-146,-150,-125,-108,-76,-54,-83,-23},
            {124,-176,108,0,-159,289,551,12875,6470,-23304,-14482,6533,3844,3105,5849,11641,20729,19473,-445,-15645,-7568,2326,5787,3167,-6102,-10551,-8530,-4665,-4073,-3729,-351,-815,-2252,-341,2715,3532,2551,1720,266,1669,2416,-918,-3005,-2582,-1754,-1506,-1116,-1416,-1799,-858,-204,-248,63,905,1318,1014,884,950,507,213,41,-530,-873,-851,-991,-1365,-1141,-632,-268,9,-171,-285,126,544,506,317,210,38,-137,-226,-330,-398,-389,-335,-297,-309,-140,85,195,192,138,156,189,121,95,299,-12,-681,-723,-658,-452,-94,-195,-40,201,271,408,-60,-634,-569,-161,160,204,-255,-882,-800,-435,-282,-95,212,570,695,624,588,435,144,-59,-279,-492,-475,-295,-131,-89,-183,-244,-160,-140,-91,38,20}
        },
        {    // H-30e102a.wav
            {0,0,0,1,1,1,1,1,2,2,2,1,1,0,0,0,0,-1,1,2,1,4,0,9,0,12,9,-6,-18,138,930,926,-495,-1144,-870,-396,386,944,1078,1376,2390,2850,2163,1485,893,539,206,-294,-357,-484,-763,-784,-641,-667,-1166,-1223,-471,224,763,1165,1088,674,445,374,11,-392,-509,-576,-700,-824,-833,-716,-656,-606,-446,-257,-138,-96,-70,-19,51,99,83,9,-63,-98,-175,-293,-384,-404,-364,-331,-275,-205,-133,-51,-5,27,65,74,63,49,48,59,36,-35,-164,-285,-312,-271,-208,-159,-141,-192,-280,-311,-278,-238,-224,-233,-234,-182,-99,-8,51,67,16,-94,-179,-206,-197,-205,-192,-159,-116,-79,-39,-40,-91,-27},
            {59,-44,-68,189,-347,490,-371,9578,11339,-18019,-19476,4581,4869,1887,5101,9868,19206,20327,2508,-14282,-7918,3007,5862,3797,-4892,-10546,-9168,-5295,-3800,-4378,-1337,-331,-2352,-1282,2195,3886,2809,2056,739,1373,2771,-185,-2918,-2758,-1856,-1515,-1200,-1207,-1603,-1056,-546,-435,-62,637,1189,1055,771,849,621,287,206,-285,-730,-724,-837,-1260,-1219,-757,-414,-96,-147,-297,46,485,485,284,191,76,-71,-188,-319,-393,-356,-253,-214,-264,-140,83,188,138,50,34,73,91,81,330,149,-571,-707,-628,-472,-131,-231,-111,213,313,422,-48,-635,-557,-169,118,157,-216,-818,-807,-423,-255,-110,156,509,649,606,613,484,159,-24,-195,-445,-457,-318,-182,-140,-211,-262,-200,-152,-112,17,20}
        },
        {    // H-30e108a.wav
            {-1,0,1,2,1,2,2,1,2,4,4,2,2,1,0,3,0,0,2,-2,3,0,8,-3,7,11,0,17,68,930,1201,-618,-1532,-860,-318,412,995,1190,1523,2437,3088,2146,698,248,477,280,-48,-204,-811,-1000,-690,-608,-374,-145,-293,-710,-602,300,999,1111,918,685,454,159,-134,-505,-764,-743,-731,-775,-816,-778,-563,-397,-318,-192,-51,35,35,52,45,-20,-28,-42,-103,-199,-326,-389,-410,-424,-397,-344,-224,-90,-21,53,108,117,106,65,29,-8,7,62,22,-70,-195,-319,-348,-319,-239,-180,-208,-274,-318,-279,-200,-164,-152,-163,-157,-101,-56,-20,-18,-30,-53,-136,-186,-199,-216,-205,-171,-133,-85,-60,-15,-16,-79,-24},
            {-58,124,-238,286,-344,356,-427,4621,14304,-7402,-23861,-1533,6810,902,3922,7765,15823,21398,7848,-11465,-9470,2665,6203,4368,-2819,-9690,-9985,-6656,-3767,-4480,-3103,-276,-1640,-2163,1036,3936,3319,2324,1407,1190,2987,977,-2481,-2756,-2050,-1762,-1470,-1251,-1608,-1189,-585,-654,-392,381,1072,1043,723,818,745,301,319,113,-528,-683,-672,-1050,-1289,-959,-580,-255,-143,-268,-59,366,445,258,185,105,-47,-153,-233,-286,-319,-239,-124,-196,-181,-1,121,80,-47,-67,-25,55,75,290,311,-358,-667,-605,-507,-169,-190,-168,169,310,381,-29,-629,-563,-205,31,106,-140,-672,-784,-435,-224,-128,85,454,609,555,602,525,190,-5,-116,-381,-455,-359,-260,-191,-228,-272,-219,-162,-121,-9,12}
        },
        {    // H-30e114a.wav
            {-1,0,0,0,2,0,2,0,1,2,1,1,0,-1,0,1,-2,4,-4,-1,-5,5,-1,-7,16,-10,30,31,910,1614,-458,-2098,-1280,-363,591,1286,1378,1531,2460,3654,2677,564,-145,-270,-519,-272,-116,-676,-1042,-1106,-1024,-310,189,99,171,210,42,229,764,1020,837,602,438,48,-463,-700,-770,-879,-918,-830,-713,-596,-484,-352,-166,-44,32,168,187,33,-44,-15,-68,-209,-304,-321,-356,-444,-502,-473,-373,-242,-121,-26,70,160,187,151,96,27,2,7,-10,-4,-19,-105,-244,-364,-392,-367,-306,-242,-257,-308,-299,-211,-99,-56,-64,-83,-86,-54,-67,-122,-143,-133,-139,-179,-225,-222,-179,-141,-116,-105,-64,-27,-6,-15,-53,-16},
            {-109,141,-169,84,-2,-137,232,522,11542,5703,-20924,-12339,6867,1882,1445,6535,11252,19738,14683,-5576,-11176,590,6804,5055,-688,-7680,-10086,-8390,-4925,-3959,-4481,-1634,-742,-2307,-445,3313,3862,2594,2118,1320,2767,2600,-1472,-2905,-1993,-1795,-1965,-1643,-1667,-1544,-810,-629,-578,-115,797,1214,790,669,904,583,320,360,-163,-589,-614,-870,-1227,-1118,-786,-473,-197,-246,-182,211,423,281,123,98,30,-65,-109,-150,-222,-257,-146,-133,-235,-168,-18,45,-48,-120,-101,-5,55,226,417,-114,-592,-567,-513,-224,-150,-193,82,277,341,6,-603,-620,-247,-58,16,-65,-491,-726,-440,-194,-139,7,365,563,489,544,546,254,17,-66,-313,-467,-399,-338,-239,-241,-306,-246,-158,-95,-27,-1}
        },
        {    // H-30e120a.wav
            {0,1,1,1,2,3,0,1,2,1,3,1,1,2,4,0,5,-2,4,-4,-1,9,-16,20,-21,35,9,837,2067,-97,-2673,-1761,-471,534,1527,1699,1762,2704,4132,3151,586,-351,-465,-743,-887,-983,-1048,-1059,-1135,-1123,-634,-122,208,602,710,740,869,705,390,400,778,780,154,-303,-465,-767,-1051,-1050,-870,-714,-584,-463,-383,-218,21,166,140,56,122,205,67,-191,-344,-326,-311,-409,-493,-490,-439,-367,-290,-191,-66,77,190,184,116,102,115,86,28,-7,-19,-49,-108,-183,-276,-386,-446,-389,-310,-308,-316,-275,-179,-75,-10,16,10,17,12,-61,-170,-251,-259,-228,-209,-219,-245,-212,-116,-46,-19,-27,-23,1,20,14,-15,-7},
            {-8,-41,89,-187,240,-304,332,-400,4604,12672,-7334,-20886,-343,5515,-1114,4348,8945,14287,18385,4207,-10210,-3338,6584,6392,1139,-5350,-8911,-9131,-7157,-4491,-4493,-3519,-885,-1607,-1904,1801,4326,3118,2468,1996,2145,3585,916,-2589,-2481,-1681,-1942,-2137,-2014,-2010,-1306,-804,-662,-339,251,1116,1173,740,839,927,563,444,188,-397,-596,-714,-1100,-1216,-933,-701,-412,-272,-266,49,345,319,152,124,165,73,-19,-70,-123,-189,-228,-218,-296,-264,-84,4,-56,-133,-130,-48,48,148,425,135,-502,-530,-459,-268,-118,-211,-28,237,374,97,-563,-715,-309,-83,-69,-60,-312,-616,-449,-163,-112,-52,237,498,441,467,544,331,91,-18,-238,-467,-443,-378,-289,-228,-317,-298,-161,-55,-6,1}
        },
        {    // H-30e126a.wav
            {0,0,1,1,2,0,0,3,-2,2,1,0,1,5,1,7,-1,3,2,-9,17,-19,23,-23,23,-2,699,2478,485,-3237,-2427,-493,561,1625,1863,1993,3026,4804,3950,586,-899,-741,-740,-1015,-1262,-1535,-1918,-1679,-1158,-694,-134,104,292,725,1212,1471,1292,821,354,253,407,405,80,-488,-843,-869,-908,-957,-897,-716,-461,-249,-33,71,-13,11,200,292,156,-46,-160,-228,-317,-434,-519,-533,-482,-385,-308,-261,-196,-93,14,65,79,106,137,128,100,82,54,6,-70,-151,-221,-291,-344,-375,-366,-329,-358,-404,-345,-194,-29,52,47,31,56,92,34,-129,-298,-378,-370,-310,-259,-266,-262,-161,-39,29,70,61,54,50,27,16,-21,-10},
            {66,-101,89,-67,-14,98,-217,314,-29,8588,8069,-15354,-13953,4975,1356,-936,7465,10676,15049,13297,-2827,-7305,3884,8034,3480,-3077,-7590,-8314,-8089,-6700,-4951,-4521,-2396,-713,-1984,-818,3296,4221,2899,2724,2111,3000,3154,-427,-2475,-1996,-1951,-2424,-2264,-2297,-2099,-1296,-1021,-542,29,690,1253,1082,909,1086,947,579,431,-60,-548,-618,-876,-1228,-1118,-857,-711,-457,-350,-202,221,452,332,157,174,230,130,-14,-135,-229,-278,-240,-246,-329,-238,-66,-36,-99,-112,-88,-7,68,307,349,-306,-587,-438,-309,-82,-114,-101,95,341,281,-395,-797,-431,-89,-157,-150,-174,-473,-498,-216,-81,-50,130,406,380,336,528,435,181,43,-155,-437,-517,-398,-327,-254,-300,-365,-217,-42,20,7}
        },
        {    // H-30e132a.wav
            {1,2,2,2,2,1,2,-1,3,1,1,-1,6,0,5,2,0,9,-13,21,-23,24,-9,10,5,538,2823,1255,-3771,-3377,-531,708,1835,2079,2076,3254,5562,4942,766,-1382,-1177,-1028,-1164,-1358,-1735,-2298,-2148,-1773,-1190,-85,231,243,676,1040,1448,1719,1404,729,503,576,91,-534,-626,-489,-588,-829,-928,-909,-749,-403,-147,-55,0,55,175,269,186,15,-30,-75,-244,-356,-438,-541,-589,-529,-396,-285,-169,-70,-63,-83,-42,18,43,75,127,126,93,57,-1,-59,-156,-270,-326,-321,-308,-289,-251,-287,-408,-448,-314,-105,69,125,77,61,109,100,-48,-263,-402,-428,-409,-361,-340,-306,-189,-70,15,73,135,177,182,111,27,-27,-86,-27},
            {-22,54,-96,115,-142,121,-86,13,20,1298,10343,2169,-17393,-7055,5147,-1817,1105,9556,11385,13862,7885,-4648,-1783,7720,6533,-58,-5790,-8004,-7362,-7416,-6721,-5433,-4302,-1600,-684,-1627,475,3744,3719,3082,3091,2576,3416,2173,-1238,-2012,-1512,-2288,-3029,-2639,-2423,-1897,-1372,-1180,-370,467,1087,1241,1106,1187,1252,895,563,354,-235,-598,-693,-1022,-1236,-1063,-933,-790,-458,-262,7,370,473,365,297,284,156,-18,-119,-164,-214,-271,-266,-301,-302,-160,-35,-53,-108,-95,-45,22,137,353,18,-555,-483,-305,-113,14,-40,-4,193,415,-38,-718,-605,-123,-121,-293,-218,-344,-493,-298,-109,-32,92,333,400,245,416,559,340,116,-87,-326,-496,-429,-347,-312,-294,-383,-301,-73,49,16}
        },
        {    // H-30e138a.wav
            {1,2,0,1,0,3,-2,1,0,1,-3,4,2,3,5,-4,15,-16,26,-21,14,4,-3,32,386,3108,2128,-4217,-4531,-673,929,2097,2401,2282,3522,6202,5814,1031,-1764,-1615,-1278,-1312,-1653,-2010,-2522,-2506,-2107,-1426,-354,-11,293,799,1044,1510,1625,1316,1055,1001,852,78,-661,-903,-885,-720,-622,-665,-686,-450,-223,-305,-220,93,256,287,210,130,87,-23,-165,-320,-421,-465,-509,-551,-573,-470,-273,-120,-72,-76,-24,47,25,-9,40,73,73,65,-2,-80,-119,-156,-217,-286,-313,-282,-230,-161,-164,-316,-456,-426,-232,-15,112,118,87,123,137,14,-206,-386,-455,-447,-400,-356,-366,-274,-90,-9,38,124,241,287,228,99,23,-39,-140,-43},
            {-12,10,13,-57,88,-142,162,-176,154,-174,2684,10192,-2180,-16065,-2774,2995,-2944,3523,9994,11265,12078,4332,-3093,3116,8440,3368,-2724,-6586,-7784,-6731,-7001,-6820,-5763,-3913,-984,-799,-1153,1616,3926,3316,3087,3279,3090,3462,1248,-1656,-1648,-1376,-2465,-3145,-3061,-2754,-1734,-1183,-1043,-298,672,1326,1352,1187,1216,1245,859,576,286,-358,-656,-826,-1179,-1272,-1027,-881,-721,-462,-257,153,531,508,304,232,219,128,-9,-150,-216,-265,-275,-249,-296,-281,-136,-27,-71,-137,-121,-53,6,192,236,-302,-557,-341,-186,-8,40,24,71,349,324,-415,-742,-308,-48,-327,-444,-378,-495,-363,-169,-111,35,228,407,325,304,523,447,205,6,-209,-408,-484,-415,-385,-355,-376,-414,-225,-1,15}
        },
        {    // H-30e144a.wav
            {4,-1,2,-1,1,-2,1,0,-1,-3,4,1,1,7,-12,18,-22,24,-15,4,16,-22,70,256,3324,3062,-4525,-5837,-963,1182,2396,2751,2528,3937,6980,6605,1128,-2194,-2053,-1552,-1383,-1800,-2309,-2959,-2938,-2301,-1603,-421,27,29,580,1219,1707,1802,1548,903,636,919,438,-503,-1049,-1144,-1065,-972,-602,-212,-147,-164,-87,66,193,198,216,289,277,114,-60,-228,-463,-543,-494,-528,-573,-521,-414,-346,-281,-152,-32,59,133,131,74,44,56,35,-39,-142,-215,-194,-150,-184,-259,-272,-235,-186,-116,-66,-210,-436,-457,-309,-110,34,84,74,113,178,107,-141,-403,-485,-472,-394,-334,-366,-338,-164,-7,44,101,191,296,264,172,81,25,-56,-197,-59},
            {26,-29,27,-11,-30,63,-120,157,-196,207,-203,3530,9248,-4291,-13667,-1230,615,-2476,5060,9387,10558,10731,3489,-621,5996,7177,213,-3978,-6656,-7318,-6194,-6892,-6803,-5778,-3523,-659,-646,-641,1946,3930,3547,3333,3065,2848,3136,888,-1401,-1398,-1793,-2790,-2907,-2793,-2736,-1936,-1301,-775,124,890,1265,1261,1195,1278,1256,848,527,95,-492,-670,-827,-1142,-1199,-1020,-904,-649,-368,-195,172,458,415,301,290,242,98,-49,-160,-213,-258,-276,-255,-279,-257,-128,-53,-100,-167,-155,-80,42,260,76,-459,-478,-255,-102,74,103,49,185,463,83,-616,-578,-150,-201,-551,-521,-500,-488,-240,-177,-77,175,390,429,308,408,506,349,128,-114,-298,-441,-478,-434,-434,-398,-448,-399,-135,-4}
        },
        {    // H-30e150a.wav
            {1,4,-2,3,-2,1,1,-1,-2,2,4,-1,9,-14,21,-23,23,-13,-4,34,-48,111,176,3518,3948,-4769,-7149,-1356,1401,2775,3196,2805,4449,7784,7278,1258,-2539,-2577,-2000,-1547,-1903,-2475,-3260,-3398,-2657,-1785,-394,128,-13,432,1148,1928,2116,1687,846,575,926,236,-689,-1016,-1222,-1196,-951,-763,-690,-299,299,473,355,400,468,341,238,293,214,-81,-342,-560,-645,-581,-545,-564,-596,-530,-376,-225,-164,-115,48,220,254,176,122,65,-40,-124,-178,-231,-245,-208,-209,-241,-246,-214,-160,-75,10,-103,-377,-491,-384,-162,32,58,13,45,182,200,-41,-364,-516,-486,-421,-314,-316,-346,-221,-53,57,133,206,252,253,143,120,91,5,-103,-254,-74},
            {-15,30,-33,29,-20,-17,45,-104,145,-196,216,-181,3755,8342,-4543,-11634,-1569,-922,-1505,5426,8529,9814,10084,4361,1806,6706,4712,-1792,-4024,-6581,-7175,-5810,-6555,-6618,-5478,-3218,-785,-381,108,2169,3601,3343,3482,3252,2587,2355,493,-1034,-1149,-1972,-2913,-2841,-2625,-2448,-1661,-1203,-756,243,1006,1260,1212,1169,1211,1106,736,488,70,-515,-687,-813,-1066,-1094,-986,-924,-659,-334,-106,205,368,318,311,337,229,63,-51,-154,-225,-272,-278,-246,-260,-230,-141,-108,-127,-149,-121,-95,87,291,-91,-534,-408,-195,-25,149,124,50,275,404,-135,-597,-401,-182,-437,-651,-541,-566,-439,-191,-155,60,358,456,383,334,442,457,278,10,-209,-343,-454,-476,-469,-489,-486,-464,-280,-39}
        },
        {    // H-30e156a.wav
            {5,-2,3,-2,-1,2,-2,-3,0,4,-2,11,-17,19,-23,19,-11,-14,42,-63,124,176,3749,4628,-5002,-8329,-1798,1519,3117,3817,3255,5068,8533,7626,1325,-2683,-2955,-2493,-1979,-2134,-2554,-3482,-3817,-2960,-1995,-403,236,-98,514,1383,2002,2114,1717,1008,686,829,146,-849,-1291,-1256,-1111,-1152,-1096,-780,-321,56,355,747,1010,871,609,480,350,88,-157,-322,-564,-672,-638,-705,-788,-735,-539,-373,-255,-116,-22,77,199,264,213,109,37,-36,-79,-143,-232,-257,-218,-204,-249,-265,-237,-163,-83,29,-21,-320,-488,-422,-228,-18,72,17,-7,95,198,63,-274,-461,-480,-463,-374,-287,-311,-246,-112,19,153,209,264,247,164,86,113,43,-58,-163,-349,-100},
            {11,-15,27,-29,30,-20,-9,33,-84,128,-177,204,-152,3595,7548,-3719,-10060,-2711,-1730,-708,5018,7769,9365,9833,5703,3820,6134,2118,-2913,-3666,-6331,-6972,-5399,-6184,-6330,-5037,-2918,-799,-273,397,2330,3503,3024,3130,3085,2519,2199,325,-1144,-1270,-1938,-2599,-2626,-2640,-2328,-1282,-760,-452,268,761,1030,1183,1166,1138,1012,614,359,31,-460,-643,-804,-1056,-1075,-911,-759,-526,-331,-166,154,331,308,306,286,168,31,-65,-180,-252,-267,-243,-185,-200,-200,-166,-140,-120,-115,-101,-56,173,209,-266,-547,-370,-184,22,202,83,35,327,308,-211,-480,-312,-303,-626,-663,-540,-601,-368,-129,-47,243,459,411,299,323,442,398,167,-75,-208,-308,-454,-499,-552,-563,-500,-396,-78}
        },
        {    // H-30e162a.wav
            {-3,0,-3,-2,-2,-4,-6,-2,1,-4,8,-21,18,-28,18,-15,-19,41,-66,116,248,4058,4998,-5251,-9229,-2271,1573,3295,4431,4057,5906,9125,7589,1307,-2645,-3206,-2850,-2513,-2692,-2738,-3504,-4132,-3333,-2229,-553,471,133,398,1441,2176,2277,1927,941,566,906,125,-908,-1278,-1501,-1606,-1373,-952,-682,-482,-144,321,661,990,1237,1082,725,473,238,-56,-270,-565,-777,-784,-827,-873,-855,-727,-495,-207,-20,54,130,205,202,111,75,75,26,-51,-118,-182,-236,-236,-215,-236,-254,-232,-189,-130,-21,39,-233,-524,-499,-299,-19,113,18,-68,32,170,117,-186,-420,-448,-483,-416,-302,-311,-310,-153,-2,140,212,219,261,166,126,119,103,-22,-132,-284,-511,-139},
            {-10,12,-13,22,-21,21,-17,-10,30,-76,110,-155,176,-136,3058,7112,-2106,-9226,-4148,-2059,-407,4480,7263,8979,9943,7053,5020,4956,198,-3282,-3611,-6304,-6427,-4659,-5653,-6097,-4831,-2747,-641,-15,434,1998,3196,3024,3085,2771,2056,1920,582,-798,-1421,-2267,-2590,-2356,-2265,-1948,-1106,-698,-255,539,867,932,982,956,981,915,538,261,-75,-505,-615,-711,-883,-894,-783,-732,-576,-328,-131,123,245,245,267,215,89,-12,-100,-196,-226,-207,-165,-126,-162,-187,-150,-97,-75,-80,-100,-57,163,73,-415,-585,-422,-186,122,238,39,75,363,227,-225,-407,-309,-452,-696,-615,-602,-588,-216,-9,83,357,412,295,214,299,405,305,116,-62,-162,-326,-438,-551,-650,-617,-496,-103}
        },
        {    // H-30e168a.wav
            {1,-4,0,0,-2,-5,1,0,1,8,-16,18,-29,22,-19,-8,22,-41,84,427,4515,4859,-5626,-9528,-2739,1485,3484,4863,5011,7083,9594,7196,1244,-2516,-3395,-3075,-3005,-3287,-3074,-3668,-4310,-3722,-2408,-384,510,124,434,1591,2445,2392,1981,1038,677,979,151,-1017,-1634,-1816,-1695,-1458,-1167,-747,-265,11,281,629,914,1015,964,934,857,540,131,-199,-611,-827,-742,-808,-988,-977,-766,-509,-273,-86,30,121,194,223,174,99,58,34,-4,-74,-131,-183,-204,-219,-231,-219,-227,-206,-182,-57,92,-116,-529,-597,-361,-53,165,76,-68,-7,169,161,-124,-389,-443,-464,-456,-320,-333,-329,-173,-6,134,193,190,209,228,178,198,132,64,-86,-272,-436,-580,-145},
            {1,-8,9,-10,18,-16,14,-9,-15,28,-67,87,-122,134,-100,2448,6677,-413,-8493,-5476,-2405,-205,4245,6839,8320,9929,8338,5597,3618,-889,-3639,-3786,-5731,-5762,-4173,-4988,-5564,-4645,-2856,-610,227,437,1659,2818,2781,2948,2830,1942,1528,447,-750,-1355,-2045,-2382,-2375,-2253,-1726,-800,-319,-21,513,811,981,1035,841,698,590,329,194,-38,-410,-493,-499,-654,-825,-864,-773,-561,-335,-173,35,175,205,216,143,35,-26,-69,-158,-208,-182,-116,-47,-91,-127,-96,-35,-34,-116,-202,-130,104,-107,-562,-600,-380,-109,196,237,43,161,348,135,-239,-372,-372,-579,-708,-567,-562,-449,-81,46,180,353,309,190,173,278,326,263,110,4,-151,-327,-520,-640,-676,-620,-134}
        },
        {    // H-30e174a.wav
            {-5,2,-2,-1,-8,2,-1,2,5,-11,14,-30,27,-35,17,-13,-4,41,714,5095,4179,-6196,-9156,-3079,1149,3734,5268,5891,8276,9964,6771,1271,-2399,-3603,-3257,-3503,-3882,-3384,-4036,-4527,-3655,-2612,-729,457,330,801,1802,2396,2430,2121,1357,1109,904,-309,-1272,-1680,-1872,-1897,-1765,-1297,-621,-154,66,389,659,846,966,865,748,759,636,333,-34,-490,-739,-765,-823,-907,-867,-737,-587,-373,-234,-97,67,199,252,186,140,106,31,-41,-84,-104,-104,-131,-175,-201,-197,-207,-258,-254,-139,80,-3,-457,-647,-454,-136,180,192,-17,5,173,169,-96,-357,-442,-505,-525,-386,-325,-361,-177,6,125,171,157,180,193,242,248,235,93,-14,-216,-402,-504,-633,-161},
            {-4,1,-9,6,-8,12,-10,4,0,-25,33,-62,65,-86,87,-59,1757,6274,1376,-7806,-6861,-2799,161,4175,6311,7519,9663,9329,6109,2451,-1787,-3737,-3741,-5131,-4926,-3686,-4712,-5261,-4256,-2649,-659,163,315,1277,2461,2826,2962,2550,1587,1422,672,-718,-1545,-2025,-2110,-2055,-1984,-1632,-840,-220,184,623,752,854,962,867,682,459,179,60,-2,-186,-274,-438,-718,-876,-863,-786,-636,-401,-214,-13,132,179,168,87,32,24,-32,-125,-142,-124,-66,-10,-55,-94,-65,-54,-130,-243,-290,-136,46,-228,-628,-581,-325,5,274,186,39,196,294,45,-265,-404,-467,-662,-636,-446,-471,-316,-30,105,189,264,210,142,162,249,307,214,140,-7,-174,-439,-599,-655,-693,-162}
        },
        {    // H-30e180a.wav
            {2,-2,0,-6,5,-4,10,-1,-4,10,-28,34,-50,44,-46,42,-8,1175,5747,2948,-7022,-8171,-3041,746,4070,5754,6656,9114,9903,6422,1616,-2283,-3817,-3466,-4078,-4471,-3729,-4176,-4800,-4092,-2577,-598,261,217,1028,2173,2565,2781,2564,1423,941,661,-309,-1234,-1883,-2155,-2085,-1770,-1292,-623,-204,-45,379,823,1036,975,746,591,516,382,295,140,-263,-555,-638,-720,-831,-860,-786,-629,-411,-236,-60,66,111,164,158,133,89,7,-69,-113,-80,-42,-34,-95,-140,-125,-137,-208,-292,-265,-59,48,-319,-630,-525,-259,82,263,130,26,189,212,-22,-303,-425,-506,-636,-495,-351,-372,-241,4,112,181,175,143,153,184,287,268,217,65,-72,-310,-490,-568,-697,-176},
            {2,-2,0,-6,5,-4,10,-1,-4,10,-28,34,-50,44,-46,42,-8,1175,5747,2948,-7022,-8171,-3041,746,4070,5754,6656,9114,9903,6422,1616,-2283,-3817,-3466,-4078,-4471,-3729,-4176,-4800,-4092,-2577,-598,261,217,1028,2173,2565,2781,2564,1423,941,661,-309,-1234,-1883,-2155,-2085,-1770,-1292,-623,-204,-45,379,823,1036,975,746,591,516,382,295,140,-263,-555,-638,-720,-831,-860,-786,-629,-411,-236,-60,66,111,164,158,133,89,7,-69,-113,-80,-42,-34,-95,-140,-125,-137,-208,-292,-265,-59,48,-319,-630,-525,-259,82,263,130,26,189,212,-22,-303,-425,-506,-636,-495,-351,-372,-241,4,112,181,175,143,153,184,287,268,217,65,-72,-310,-490,-568,-697,-176}
        }
    },
    {    // elev-40 
        {    // H-40e000a.wav
            {-10,9,-5,10,-1,-2,11,-34,42,-50,40,-41,28,-28,1455,6385,1490,-8468,-3448,676,-1811,4073,9321,7324,3168,4624,10219,5243,-3917,-4195,-4340,-8209,-4733,414,-3786,-6622,-3582,-1276,-720,-570,619,1593,1175,960,2585,2621,383,161,532,294,-238,-1068,-1074,-1052,-1366,-1013,-535,-913,-847,-27,216,90,279,495,633,586,65,-74,-171,-615,-319,223,217,182,281,194,34,-271,-534,-633,-1038,-1238,-808,-386,-120,205,349,461,533,332,270,168,-169,-432,-605,-613,-418,-176,-25,72,59,22,63,-26,-116,-108,-73,-70,-177,-256,-201,-119,-104,-93,-156,-265,-271,-211,-176,-172,-87,16,46,58,91,106,72,-1,-70,-92,-131,-161,-202,-224,-216,-267,-253,-163,-64,-4},
            {-10,9,-5,10,-1,-2,11,-34,42,-50,40,-41,28,-28,1455,6385,1490,-8468,-3448,676,-1811,4073,9321,7324,3168,4624,10219,5243,-3917,-4195,-4340,-8209,-4733,414,-3786,-6622,-3582,-1276,-720,-570,619,1593,1175,960,2585,2621,383,161,532,294,-238,-1068,-1074,-1052,-1366,-1013,-535,-913,-847,-27,216,90,279,495,633,586,65,-74,-171,-615,-319,223,217,182,281,194,34,-271,-534,-633,-1038,-1238,-808,-386,-120,205,349,461,533,332,270,168,-169,-432,-605,-613,-418,-176,-25,72,59,22,63,-26,-116,-108,-73,-70,-177,-256,-201,-119,-104,-93,-156,-265,-271,-211,-176,-172,-87,16,46,58,91,106,72,-1,-70,-92,-131,-161,-202,-224,-216,-267,-253,-163,-64,-4}
        },
        {    // H-40e006a.wav
            {0,-4,3,3,-1,14,-11,17,-21,14,-6,-11,25,-42,53,281,3898,4649,-4338,-6541,-1445,-2605,414,7547,8033,5202,4105,7339,7829,1207,-2453,-2603,-6287,-7116,-1634,-795,-4496,-4987,-3334,-1561,-638,-45,911,1052,607,1556,2816,1731,549,674,621,1,-676,-938,-1170,-1451,-1322,-831,-777,-850,-506,-148,149,408,489,320,294,78,-89,460,635,359,393,337,0,-244,-328,-331,-579,-1039,-1070,-880,-736,-351,58,151,270,490,507,452,199,-122,-313,-586,-659,-435,-211,-105,-39,35,132,142,-11,-69,-80,-95,-50,-121,-287,-358,-280,-215,-206,-180,-142,-125,-83,-27,-40,-56,-71,-68,-23,48,58,-13,-50,-75,-109,-114,-63,-52,-93,-64,-95,-235,-253,-200,-168,-36},
            {3,-2,7,6,-13,23,-46,40,-39,16,-9,-26,30,858,6355,3689,-8627,-5674,761,-2173,3067,9981,8867,4040,3766,10864,7581,-4088,-5524,-4334,-8400,-5619,959,-2977,-7489,-4385,-1431,-1085,-1290,117,1628,1512,1226,2695,3222,943,364,668,192,-231,-1147,-1508,-1407,-1505,-1160,-540,-811,-900,16,436,251,292,480,576,580,39,-268,-191,-626,-514,170,275,159,231,135,24,-183,-520,-681,-1087,-1317,-819,-257,-7,227,382,462,618,493,327,169,-236,-512,-664,-702,-501,-262,-121,-12,24,11,90,55,-27,8,47,43,-70,-195,-201,-145,-145,-154,-217,-349,-362,-293,-215,-184,-121,-18,8,37,92,126,103,71,17,-16,-75,-165,-206,-307,-325,-328,-298,-195,-112,37,28}
        },
        {    // H-40e013a.wav
            {-2,-1,-5,2,0,1,8,-7,13,-23,16,-13,-1,12,-23,28,428,3876,3697,-4440,-5418,-1269,-2266,1214,6738,6673,4803,4216,6983,6789,949,-1849,-2400,-5752,-6332,-1950,-1136,-4235,-4857,-2881,-884,-391,-159,769,1158,1039,1752,2226,1129,591,898,512,-333,-872,-1036,-1196,-1325,-1204,-858,-737,-659,-377,-47,273,418,346,264,376,171,164,653,595,382,375,119,-218,-394,-445,-444,-692,-1035,-956,-764,-569,-175,99,175,294,347,318,284,66,-152,-332,-561,-553,-319,-140,-62,2,75,147,63,-74,-94,-157,-171,-128,-221,-343,-340,-236,-186,-179,-137,-136,-128,-42,14,-25,-55,-38,-16,19,46,15,-62,-105,-152,-188,-144,-74,-55,-72,-40,-107,-183,-162,-157,-39},
            {4,-1,16,-22,30,-44,29,-15,-17,38,-86,98,371,5819,5982,-7781,-8340,494,-2003,1738,10221,10241,5326,3203,10808,9962,-3787,-6773,-4225,-8573,-6514,1343,-2146,-8267,-5259,-1501,-1605,-2520,-411,2506,2317,1063,2379,3839,1753,734,974,-30,-615,-1149,-1520,-1790,-2030,-1435,-568,-714,-880,115,669,412,356,500,628,690,163,-380,-291,-584,-709,21,294,59,107,45,-21,-81,-429,-641,-1050,-1392,-905,-205,141,342,467,496,583,533,423,263,-197,-563,-745,-834,-622,-269,-135,-105,-22,20,145,168,47,52,121,152,71,-94,-180,-144,-131,-155,-256,-421,-448,-383,-281,-187,-117,-18,20,25,81,133,145,112,58,40,-3,-115,-195,-286,-398,-390,-347,-221,-106,-17,146,53}
        },
        {    // H-40e019a.wav
            {0,0,-1,-4,2,1,2,9,-8,14,-17,9,-5,-6,21,-23,32,294,3142,3593,-3218,-4995,-1363,-1603,815,5081,5720,4808,4005,6015,6292,1706,-1126,-1996,-4797,-5877,-2372,-1082,-3847,-4628,-2656,-667,-296,-304,607,1281,1394,1749,1856,1045,659,745,219,-591,-1073,-1097,-1020,-1164,-1248,-851,-511,-444,-269,25,326,457,401,395,474,249,262,555,391,288,267,10,-297,-516,-518,-547,-860,-1105,-898,-593,-334,39,237,278,327,264,199,139,-50,-224,-428,-613,-499,-236,-67,-20,-5,64,100,13,-77,-108,-182,-197,-164,-234,-318,-292,-196,-180,-183,-143,-135,-98,-12,13,-33,-47,-11,26,39,20,-45,-91,-132,-201,-218,-162,-87,-80,-25,14,-33,-83,-131,-36},
            {-3,22,-28,35,-42,18,4,-40,64,-114,127,184,5601,7388,-7218,-10390,-247,-1694,1388,10509,11079,6464,3631,10760,10717,-3129,-7002,-5540,-9153,-5667,1537,-2661,-8707,-5543,-2196,-2773,-3345,-172,3823,3159,918,2181,4247,2555,1049,896,-84,-915,-1610,-1660,-1864,-2400,-1825,-722,-749,-882,280,894,517,407,665,838,840,329,-312,-368,-698,-956,-289,190,16,20,20,-78,-135,-376,-562,-1023,-1401,-940,-186,305,537,592,497,480,470,437,324,-156,-577,-772,-885,-715,-371,-195,-160,-44,75,239,303,148,89,137,185,153,26,-106,-148,-150,-152,-255,-484,-511,-460,-382,-232,-85,67,66,28,63,113,130,129,91,59,30,-83,-163,-268,-418,-466,-361,-237,-103,-4,101,220,59}
        },
        {    // H-40e026a.wav
            {-4,0,0,-2,-3,3,1,2,8,-5,10,-15,14,-10,5,13,-15,24,358,3015,2956,-3138,-4262,-1105,-1091,868,4118,5143,4567,3825,5551,5491,1693,-727,-1929,-4603,-5281,-1912,-1159,-3902,-4248,-2096,-394,-290,-218,650,1304,1519,1736,1690,921,476,435,-45,-761,-1114,-968,-923,-1206,-1186,-624,-317,-328,-171,136,434,560,577,542,349,80,219,391,212,166,105,-91,-345,-547,-595,-744,-1015,-1047,-704,-364,-64,257,375,384,352,230,93,-69,-247,-371,-533,-625,-452,-161,21,16,-30,18,67,10,-76,-136,-182,-168,-154,-219,-268,-223,-184,-221,-211,-144,-116,-66,-15,-15,-21,-12,10,21,19,-28,-82,-129,-174,-212,-222,-133,-72,-9,60,53,-23,-113,-34},
            {26,-24,22,-13,-19,47,-80,94,-128,125,-87,3787,9212,-2992,-13007,-2872,-595,-217,9342,11768,8286,4025,8578,13322,676,-7687,-6394,-9605,-6522,1618,-1822,-9003,-6826,-3060,-3389,-3673,-369,3880,3742,1562,2253,4181,3000,1393,921,-108,-737,-1638,-2137,-2085,-2352,-1942,-978,-913,-1072,110,898,613,568,855,982,930,616,-82,-433,-694,-1140,-793,-66,-7,12,108,-21,-115,-343,-466,-847,-1362,-1067,-355,219,569,665,544,439,377,352,365,27,-433,-724,-905,-803,-457,-203,-189,-135,20,209,368,282,152,133,156,176,131,16,-90,-137,-158,-250,-483,-569,-502,-447,-299,-115,74,140,85,62,57,62,109,109,42,35,-37,-125,-194,-358,-473,-444,-289,-147,-19,98,178,183,38}
        },
        {    // H-40e032a.wav
            {1,-2,0,0,0,-2,2,2,2,7,-5,10,-9,10,-3,1,16,-14,23,223,2397,2871,-2183,-3875,-953,-724,113,3029,4665,4328,3516,4750,5027,2188,-175,-1623,-4052,-4668,-1799,-1152,-3532,-3780,-1773,-230,-258,-281,592,1312,1452,1363,1355,975,491,215,-242,-712,-858,-795,-926,-1178,-1003,-440,-237,-339,-210,239,680,703,563,441,199,10,71,104,41,26,-87,-223,-407,-535,-562,-726,-894,-837,-527,-185,107,348,438,420,283,91,-48,-200,-379,-528,-619,-572,-337,-62,46,-42,-89,5,52,3,-72,-124,-163,-170,-148,-174,-200,-187,-197,-252,-219,-126,-89,-64,-51,-19,2,-23,-38,-13,-9,-65,-116,-156,-205,-236,-158,-37,18,44,80,32,-70,-25},
            {-11,4,2,-43,63,-89,84,-105,75,-101,2649,9735,367,-13999,-5884,5,-393,8546,12302,8663,3744,8637,15738,2711,-7840,-7345,-10777,-6608,1908,-1477,-9162,-8394,-4354,-3269,-2726,-401,3084,3761,2385,3109,4433,2950,1323,751,-220,-575,-1568,-2613,-2661,-2354,-1761,-1091,-957,-1165,-19,868,707,792,878,1007,1055,808,89,-470,-747,-1294,-1201,-327,24,-18,131,116,-22,-290,-449,-741,-1266,-1073,-446,103,451,540,536,439,337,318,382,182,-255,-652,-953,-887,-543,-237,-154,-116,6,144,321,309,168,131,171,175,173,148,22,-74,-129,-247,-501,-630,-587,-515,-303,-105,65,174,123,74,40,14,49,44,-4,15,4,-70,-152,-290,-430,-469,-358,-172,-61,59,141,151,160,39}
        },
        {    // H-40e039a.wav
            {-1,2,0,0,0,0,-1,2,1,3,5,1,10,-9,12,-4,6,5,-3,13,286,2304,2299,-2222,-3111,-571,-781,4,2825,4294,3879,3320,4365,4297,1947,1,-1593,-3763,-3886,-1541,-1496,-3209,-2827,-1181,-247,-356,-125,726,1226,1142,925,1070,967,571,171,-352,-641,-623,-673,-941,-1089,-870,-477,-276,-231,-10,423,730,659,425,199,-6,-92,-61,-61,-80,-122,-204,-264,-384,-429,-461,-621,-712,-625,-366,-75,175,327,360,299,117,-48,-147,-269,-429,-546,-554,-416,-171,-15,-42,-119,-87,-10,-3,-26,-60,-137,-193,-164,-138,-146,-155,-161,-192,-220,-153,-88,-80,-69,-74,-65,-53,-67,-50,-16,-40,-104,-146,-178,-205,-169,-63,23,32,68,79,0,-9},
            {-23,41,-69,66,-57,17,1,-66,63,744,8213,6585,-11453,-11542,-581,-494,5805,12547,9350,3882,7463,17524,8062,-6609,-8044,-11435,-8661,1391,376,-8343,-10146,-6022,-3199,-1695,-889,1310,3340,2906,3598,5021,3419,1290,785,9,-494,-1378,-2553,-3098,-2850,-1821,-1075,-919,-1162,-192,787,721,873,871,889,982,985,458,-311,-757,-1260,-1437,-750,-47,-50,75,276,158,-165,-424,-617,-1042,-1086,-666,-133,276,393,432,442,362,283,441,392,-13,-397,-843,-999,-734,-376,-159,-126,-27,65,206,331,219,117,175,211,196,225,132,3,-57,-148,-398,-643,-645,-587,-393,-159,20,179,183,102,28,-13,-18,33,2,-19,22,-14,-99,-219,-338,-448,-437,-262,-72,16,126,154,110,168,49}
        },
        {    // H-40e045a.wav
            {1,1,1,-1,1,0,0,-1,3,1,5,7,4,8,-6,12,-7,9,3,7,-1,376,2170,1653,-2120,-2254,-462,-948,144,2701,3852,3466,3089,3866,3624,1901,231,-1721,-3572,-3178,-1351,-1501,-2519,-2043,-915,-267,-202,85,594,847,723,709,1105,1017,547,107,-342,-529,-511,-599,-932,-1164,-872,-295,-37,-39,112,393,483,369,271,59,-171,-209,-151,-82,-95,-161,-186,-246,-323,-306,-361,-520,-586,-484,-257,-31,135,216,216,109,-56,-108,-125,-241,-381,-434,-383,-259,-117,-76,-152,-189,-110,-41,-28,-43,-125,-189,-171,-129,-111,-118,-123,-125,-132,-116,-87,-91,-106,-119,-136,-122,-94,-76,-54,-32,-60,-108,-134,-160,-159,-117,-29,34,59,100,70,8},
            {35,-48,28,6,-56,80,-142,157,-31,5660,10146,-6221,-15552,-3476,385,4275,11551,8945,4593,7078,18066,13062,-4813,-9041,-12002,-9684,1382,880,-8043,-11122,-6971,-3044,-1241,-614,-75,2147,3193,3718,5130,4087,1872,810,-62,-273,-1191,-2566,-3307,-3400,-2171,-1018,-679,-1165,-429,964,842,794,779,812,962,925,681,-67,-702,-1159,-1497,-1192,-339,21,12,209,276,90,-226,-570,-911,-985,-761,-356,53,228,284,341,403,360,415,477,221,-148,-633,-937,-784,-491,-281,-226,-124,9,99,210,214,146,188,303,281,249,222,103,8,-100,-303,-557,-667,-624,-460,-235,-56,123,200,140,63,-10,-77,-39,17,-8,17,48,-34,-207,-312,-378,-453,-343,-141,1,116,188,146,99,106,28}
        },
        {    // H-40e051a.wav
            {0,-1,-1,-1,-1,-1,-1,0,-2,1,1,3,2,0,2,-5,11,-7,4,-1,1,-13,339,1748,1314,-1453,-1652,-657,-929,191,2179,3180,3053,2811,3355,3242,2000,300,-1694,-3014,-2427,-1073,-1217,-1827,-1443,-648,-141,-157,-108,204,516,613,689,973,850,383,26,-202,-325,-468,-731,-971,-884,-468,-76,-35,-131,-74,103,229,173,58,-88,-181,-202,-206,-98,-20,-73,-141,-181,-218,-271,-381,-479,-485,-402,-241,-86,17,46,23,-37,-96,-68,-65,-151,-231,-259,-235,-212,-212,-222,-245,-210,-137,-113,-121,-150,-176,-156,-121,-99,-99,-86,-57,-61,-67,-82,-104,-123,-155,-173,-188,-172,-133,-99,-45,-30,-69,-93,-107,-131,-150,-133,-42,24,68,98,23},
            {17,-59,80,-97,71,-74,24,-59,1723,10243,4027,-15215,-10756,149,2337,9131,9582,5994,5475,14559,19523,1780,-9220,-11414,-12063,-970,2615,-5778,-11458,-8777,-3811,-1956,-525,-163,894,2251,3006,4996,4711,2594,1670,371,-359,-711,-1976,-3140,-3790,-2815,-1527,-800,-921,-848,672,998,849,855,718,906,913,868,261,-500,-1049,-1389,-1375,-906,-187,-44,8,293,311,78,-311,-769,-958,-859,-527,-130,31,104,176,380,517,442,426,342,127,-339,-824,-830,-555,-327,-335,-308,-99,13,94,159,138,126,262,357,342,331,227,116,-47,-253,-438,-602,-668,-555,-324,-163,6,160,182,98,20,-56,-96,-20,7,10,42,35,-120,-307,-345,-404,-401,-241,-98,29,181,214,139,73,10,-4}
        },
        {    // H-40e058a.wav
            {3,2,1,2,2,0,3,4,2,2,4,3,6,3,6,4,3,9,-5,7,-7,5,1,510,1525,664,-1147,-1072,-797,-698,509,1878,2692,2761,2813,3007,2511,1563,97,-1640,-2372,-1603,-778,-984,-1133,-751,-348,-261,-312,-86,142,288,399,560,710,541,286,67,-147,-321,-500,-638,-662,-472,-204,-134,-216,-249,-162,-31,15,20,-15,-130,-208,-238,-152,24,71,4,-74,-144,-226,-334,-424,-445,-391,-324,-245,-136,-55,-4,-7,-67,-70,-27,-26,-76,-136,-166,-203,-239,-246,-255,-242,-213,-191,-182,-176,-163,-151,-118,-72,-53,-54,-51,-47,-44,-48,-62,-92,-139,-172,-193,-181,-146,-113,-77,-34,-20,-42,-59,-100,-134,-155,-111,-35,12,69,23},
            {-41,24,7,-72,95,-164,177,-128,5496,11209,-5988,-17576,-4370,1983,5652,9786,7294,5258,9240,20901,12318,-6852,-11111,-12928,-4998,3606,-2473,-10223,-10826,-5683,-2631,-1077,88,251,1480,1722,3555,5422,3531,1963,982,240,78,-1428,-2682,-3615,-3388,-2083,-1413,-1012,-1134,116,1101,833,1008,874,891,858,897,666,-163,-868,-1380,-1401,-1161,-639,-204,-232,45,463,371,13,-502,-842,-822,-720,-327,-53,-29,23,174,516,565,433,380,258,-33,-579,-824,-616,-380,-327,-387,-255,-89,-16,59,117,118,159,293,357,418,395,281,117,-167,-393,-517,-622,-635,-442,-247,-114,46,167,165,69,6,-82,-57,-3,-34,30,53,-25,-204,-329,-331,-383,-326,-178,-83,62,201,207,139,43,-40,-17}
        },
        {    // H-40e064a.wav
            {4,1,1,2,3,2,2,3,3,2,2,3,1,6,3,4,2,6,2,-7,3,0,9,17,532,1142,338,-682,-717,-809,-502,519,1488,2288,2599,2436,2160,1903,1498,333,-1226,-1665,-869,-312,-261,-304,-504,-534,-397,-304,-277,-254,-62,107,249,447,501,287,-48,-226,-197,-158,-261,-340,-284,-235,-263,-323,-353,-341,-234,-101,-62,-125,-245,-264,-180,-43,118,151,64,-49,-171,-271,-355,-409,-403,-373,-328,-263,-142,-15,3,-39,-86,-97,-52,-41,-61,-87,-133,-181,-217,-234,-246,-256,-240,-228,-224,-199,-175,-145,-92,-49,-58,-97,-81,-31,-10,-12,-42,-91,-145,-179,-160,-136,-135,-125,-78,-22,-16,-34,-78,-139,-172,-169,-119,-66,-30,-3},
            {-58,78,-87,31,-12,-68,64,874,9892,7003,-15525,-13897,1018,3216,7973,8699,5489,6069,16410,20846,1220,-11585,-12629,-8357,2757,1381,-7797,-12093,-8478,-3023,-1962,-337,43,419,1449,1999,4384,4151,2430,1648,490,794,104,-1860,-3384,-3804,-2347,-1715,-1593,-1616,-807,939,992,970,1073,1013,1001,809,839,257,-521,-1203,-1529,-1327,-1037,-439,-278,-404,138,551,426,-63,-682,-744,-664,-550,-201,-97,-106,1,339,629,532,347,247,111,-298,-703,-653,-388,-254,-346,-393,-247,-113,-47,8,69,107,240,345,387,436,371,295,60,-277,-460,-558,-629,-578,-358,-182,-80,51,150,148,92,-11,-78,-21,-46,-45,40,-11,-124,-217,-258,-312,-362,-276,-173,-48,122,183,150,91,-2,-52,-12}
        },
        {    // H-40e071a.wav
            {3,2,1,2,3,3,2,3,3,3,2,1,0,2,4,3,2,0,5,-2,3,3,0,-2,83,631,801,0,-454,-545,-682,-196,746,1572,1865,1878,1915,1766,1728,1462,338,-834,-766,50,234,-10,-323,-621,-618,-544,-506,-546,-483,-274,-110,181,414,343,57,-127,25,233,184,-77,-257,-297,-343,-394,-437,-452,-408,-312,-219,-191,-228,-260,-223,-128,28,193,220,85,-90,-221,-297,-344,-381,-385,-357,-304,-193,-63,-19,-58,-106,-144,-137,-104,-93,-71,-43,-65,-138,-195,-212,-224,-245,-261,-262,-244,-215,-187,-154,-113,-91,-104,-100,-48,9,25,5,-36,-91,-126,-141,-148,-148,-134,-105,-60,-28,-45,-75,-136,-178,-195,-185,-132,-98,-22},
            {-54,91,-125,96,-94,34,-67,2285,12128,1709,-19777,-9164,3150,3780,8835,7171,4845,8939,20560,16599,-5765,-13565,-11133,-2404,4696,-2040,-10131,-12124,-6250,-1970,-1828,-238,-395,578,1510,2387,4241,3230,2063,1008,782,1374,-247,-2012,-3578,-3471,-1951,-1596,-1707,-1944,-419,1080,922,1014,1072,1224,1008,746,679,26,-695,-1364,-1509,-1284,-953,-358,-402,-386,247,517,434,-145,-707,-639,-588,-405,-153,-165,-123,108,521,686,441,223,99,-104,-487,-669,-434,-211,-204,-358,-398,-279,-160,-45,9,46,144,322,429,422,365,310,234,-22,-293,-460,-556,-607,-542,-324,-158,-42,81,155,147,89,-26,-55,6,-73,-41,36,-79,-169,-189,-209,-295,-329,-254,-175,-12,159,178,119,25,-75,-52,0}
        },
        {    // H-40e077a.wav
            {0,0,1,1,1,2,3,1,2,1,-1,-1,-1,0,1,-1,0,1,-1,3,2,2,-4,-2,-1,122,529,520,-70,-308,-343,-278,257,712,827,891,1285,1813,1914,1879,1655,872,176,238,379,-39,-380,-467,-625,-794,-837,-749,-743,-668,-431,-167,140,221,94,143,377,576,554,264,-115,-340,-408,-495,-581,-530,-475,-498,-461,-349,-246,-237,-243,-175,-60,115,234,193,67,-70,-191,-291,-325,-318,-334,-314,-258,-196,-113,-88,-134,-194,-226,-224,-185,-87,20,69,14,-87,-158,-208,-246,-271,-289,-290,-274,-253,-213,-174,-150,-126,-97,-45,12,33,32,16,-18,-54,-121,-161,-155,-134,-115,-108,-86,-87,-93,-124,-163,-202,-213,-198,-174,-38},
            {-38,92,-158,168,-195,176,-195,4167,13104,-4717,-21148,-3771,4179,4361,8362,5543,5582,12707,22291,10071,-11525,-13906,-6761,3194,3633,-5370,-11611,-11018,-3790,-1940,-2008,-317,-850,439,1562,3106,3867,2453,1551,408,1336,1601,-362,-2162,-3672,-2591,-1510,-1708,-1974,-1862,-91,798,738,927,1069,1266,949,751,440,-138,-639,-1336,-1434,-1212,-904,-462,-595,-293,380,522,342,-260,-545,-421,-463,-368,-243,-242,-131,213,619,595,244,104,43,-201,-522,-544,-238,-91,-208,-361,-403,-366,-210,-21,15,26,158,368,482,426,330,311,170,-110,-323,-462,-483,-542,-549,-332,-147,-2,122,153,131,71,-18,-33,-12,-64,-37,-16,-124,-176,-123,-173,-318,-312,-235,-129,49,172,158,54,-62,-117,-44,4}
        },
        {    // H-40e084a.wav
            {1,1,0,3,2,3,4,1,1,1,0,-2,0,1,1,1,2,4,0,2,7,4,2,-5,0,1,169,472,318,-131,-108,198,129,-193,-81,444,926,1523,2125,2209,2086,2060,1496,469,-56,-165,-435,-632,-580,-677,-1028,-1094,-816,-665,-575,-362,-112,38,112,350,706,822,659,426,81,-314,-489,-529,-646,-705,-593,-504,-514,-470,-340,-234,-189,-155,-77,31,127,173,147,92,-21,-181,-281,-297,-284,-285,-278,-262,-245,-199,-160,-201,-281,-312,-234,-82,58,146,123,0,-125,-200,-238,-274,-303,-306,-288,-260,-241,-218,-174,-137,-91,-42,11,48,40,42,17,-42,-108,-143,-145,-134,-120,-122,-125,-116,-97,-117,-142,-192,-208,-196,-196,-45},
            {-33,93,-173,207,-254,258,-269,4912,13221,-7384,-21168,-1444,4721,4146,7369,5143,6505,14603,22196,6261,-14302,-13159,-2945,5682,2291,-6990,-11990,-9714,-2787,-2462,-2163,-752,-1350,527,1717,3197,3581,2232,1167,285,1710,1506,-439,-2081,-3234,-2083,-1398,-1623,-2153,-1853,15,606,443,624,1024,1216,913,805,358,-161,-544,-1168,-1278,-1200,-944,-601,-704,-205,431,548,318,-342,-491,-275,-316,-337,-318,-324,-172,268,628,469,119,57,43,-182,-444,-418,-183,-128,-258,-333,-356,-420,-279,-19,37,25,122,343,507,433,357,325,108,-144,-355,-470,-425,-494,-538,-361,-165,1,139,183,126,41,-18,-14,-1,-56,-78,-77,-141,-157,-72,-149,-365,-345,-190,-57,97,158,105,-8,-99,-117,-75,-12}
        },
        {    // H-40e090a.wav
            {1,1,1,3,3,3,3,2,2,0,0,-1,-2,1,2,2,4,4,2,2,4,6,2,-3,-11,-4,18,195,376,312,378,288,-360,-744,-481,206,1032,1487,1746,2285,2809,2777,2040,747,-332,-539,-418,-596,-890,-905,-858,-1060,-1000,-568,-369,-395,-295,-118,111,506,850,895,727,484,176,-204,-548,-684,-666,-708,-741,-633,-480,-404,-379,-282,-152,-118,-103,-48,38,143,202,177,38,-98,-171,-226,-234,-270,-324,-317,-308,-293,-263,-255,-277,-303,-226,-76,59,152,128,17,-110,-178,-207,-262,-286,-282,-270,-249,-255,-244,-184,-135,-94,-49,7,46,51,51,8,-60,-119,-131,-134,-142,-132,-127,-119,-112,-97,-119,-134,-162,-173,-182,-210,-51},
            {-44,111,-192,234,-284,295,-321,4716,13310,-7559,-21268,-607,5440,3217,6075,5158,7303,15426,21490,4029,-15804,-11673,570,6853,970,-8105,-11610,-8367,-2531,-2946,-2508,-1344,-1863,400,1944,3071,3153,2257,1187,365,1797,1459,-465,-2126,-2557,-1348,-1389,-1784,-2108,-1716,-224,306,161,272,817,1088,943,836,376,-11,-367,-988,-1095,-1099,-1011,-785,-778,-167,448,548,309,-288,-456,-219,-177,-308,-382,-442,-262,301,620,353,25,60,94,-121,-324,-296,-162,-195,-313,-317,-330,-412,-292,-58,-28,-15,141,373,517,430,396,359,102,-151,-375,-474,-413,-448,-478,-369,-200,-8,134,187,121,40,13,1,33,-42,-127,-107,-151,-171,-61,-107,-353,-348,-137,-7,107,166,87,-56,-139,-134,-70,-9}
        },
        {    // H-40e096a.wav
            {0,0,0,1,2,2,2,1,-1,-1,0,-2,-3,-2,1,2,-1,2,4,5,0,-2,0,-5,-4,-11,4,14,296,952,731,-453,-1002,-736,-131,546,985,1346,1783,2436,3088,2850,1633,548,-4,-477,-737,-792,-1025,-1256,-1072,-632,-551,-636,-308,33,-46,-230,-64,431,820,879,736,493,102,-270,-483,-683,-799,-750,-684,-648,-558,-389,-266,-242,-206,-153,-116,-66,39,152,152,102,42,-30,-66,-107,-180,-281,-381,-413,-368,-327,-321,-308,-267,-227,-163,-81,-11,19,-17,-49,-61,-85,-154,-227,-233,-214,-216,-247,-271,-259,-208,-142,-83,-57,-22,27,42,26,-40,-99,-143,-162,-156,-145,-131,-118,-93,-92,-86,-103,-100,-126,-151,-188,-244,-61},
            {-71,147,-218,229,-232,200,-211,3197,13384,-3948,-21970,-2600,6281,2224,5130,5208,7275,14874,21104,5301,-15566,-11405,1717,7121,1112,-8153,-11093,-7944,-2837,-3080,-2926,-1658,-2277,-25,1795,2774,3169,2344,1349,603,1807,1562,-415,-2019,-2327,-1108,-1060,-1780,-2259,-1727,-348,34,-158,108,650,888,920,894,528,123,-201,-766,-1034,-1059,-976,-864,-923,-261,500,616,330,-250,-436,-223,-193,-352,-429,-457,-258,283,595,358,25,29,79,-79,-233,-213,-155,-264,-366,-308,-318,-427,-335,-98,-59,-48,170,425,510,408,394,376,152,-117,-380,-505,-462,-437,-410,-330,-216,-52,83,157,129,78,60,8,13,-60,-138,-109,-172,-205,-82,-68,-287,-325,-142,-28,88,163,75,-63,-129,-119,-52,-5}
        },
        {    // H-40e103a.wav
            {3,2,2,2,3,4,3,3,3,2,2,1,0,1,2,1,2,3,5,7,2,2,-4,1,-4,2,3,141,767,875,-175,-931,-808,-218,484,877,1044,1300,2158,3059,2624,1464,889,597,143,-231,-712,-1242,-1281,-1063,-948,-717,-303,-79,-95,118,370,106,-188,73,587,866,699,319,-46,-355,-508,-584,-683,-748,-708,-580,-482,-388,-255,-186,-196,-183,-62,58,76,48,24,47,64,48,-15,-128,-217,-305,-362,-383,-393,-345,-288,-254,-223,-183,-126,-118,-145,-146,-111,-44,-17,-43,-100,-135,-128,-134,-174,-241,-277,-253,-185,-134,-99,-65,-24,28,37,-2,-77,-137,-174,-173,-162,-146,-116,-82,-46,-51,-46,-68,-63,-97,-138,-180,-253,-66},
            {-101,160,-188,135,-75,-36,105,1226,12201,2172,-21356,-7219,7029,1778,3801,5114,6736,13594,20402,8710,-13654,-12315,1649,7150,2083,-7512,-10802,-7924,-3281,-2990,-3499,-1773,-2469,-930,1521,2392,3160,2652,1572,739,1844,2013,-234,-1997,-2219,-1109,-907,-1625,-2172,-1941,-678,-12,-325,-205,455,773,861,892,738,339,-84,-571,-929,-1011,-971,-864,-977,-473,450,733,444,-208,-501,-278,-218,-387,-497,-483,-217,274,567,385,53,28,69,-49,-143,-150,-155,-316,-436,-315,-306,-450,-396,-137,-28,-53,150,440,503,398,371,379,240,-48,-350,-532,-525,-416,-359,-298,-233,-104,45,107,125,92,90,50,-5,-76,-154,-138,-184,-215,-86,-39,-203,-286,-190,-64,56,129,84,-16,-60,-84,-64,-9}
        },
        {    // H-40e109a.wav
            {3,2,2,2,3,4,2,3,2,2,3,2,1,4,1,0,1,1,4,1,9,-2,4,0,-1,9,159,972,1009,-642,-1432,-731,123,813,1102,1116,1226,2097,3104,2522,989,78,-57,147,208,-226,-852,-1184,-1238,-965,-550,-411,-286,163,562,561,496,369,-5,-155,133,494,472,73,-256,-380,-453,-545,-615,-622,-591,-540,-427,-301,-267,-205,-72,-34,-13,61,60,-28,-89,-27,49,14,-103,-218,-272,-304,-312,-322,-338,-292,-251,-228,-186,-173,-176,-206,-236,-211,-154,-87,-45,-27,-31,-27,-30,-79,-144,-212,-259,-261,-198,-124,-93,-87,-48,6,11,-29,-109,-173,-216,-206,-186,-146,-72,-29,-3,-21,-23,-34,-36,-82,-131,-185,-257,-66},
            {-72,64,-27,-87,184,-313,412,-298,8115,9761,-15623,-15181,5855,3034,1411,5021,5821,11429,18719,13499,-8264,-14109,-249,7092,3436,-5980,-10537,-8279,-4157,-2621,-4002,-2315,-1888,-1863,634,2002,3139,3008,1953,1021,1508,2490,567,-1832,-2443,-1485,-838,-1548,-2082,-1918,-1072,-259,-312,-336,193,607,862,913,839,597,128,-388,-851,-966,-933,-910,-1013,-652,244,651,545,8,-451,-317,-227,-419,-567,-567,-251,268,542,397,83,55,136,5,-129,-175,-202,-335,-472,-380,-314,-410,-414,-200,-4,-29,74,365,493,423,353,361,291,32,-277,-508,-567,-440,-369,-303,-247,-167,9,52,96,101,93,112,6,-91,-186,-211,-202,-205,-92,-20,-114,-237,-263,-158,2,101,115,35,-17,-45,-78,-20}
        },
        {    // H-40e116a.wav
            {4,3,2,4,3,2,4,2,4,4,3,3,3,3,1,0,-1,4,-3,7,0,-3,8,-4,15,89,984,1450,-474,-1924,-1225,-103,980,1518,1470,1388,2051,3357,2963,838,-544,-577,-392,-458,-447,-585,-901,-973,-759,-495,-367,-155,158,376,683,957,820,389,10,-152,-134,-78,-18,-18,-168,-395,-556,-560,-534,-516,-459,-438,-366,-218,-127,-114,-79,26,107,61,-54,-119,-116,-76,-64,-127,-230,-276,-263,-231,-238,-317,-315,-232,-220,-242,-217,-158,-135,-193,-257,-253,-196,-118,-68,-39,-9,24,8,-47,-103,-186,-241,-248,-207,-142,-84,-54,-51,-57,-54,-59,-114,-177,-228,-222,-185,-128,-59,-12,19,0,1,-15,-35,-78,-115,-174,-251,-64},
            {23,-78,134,-205,221,-225,202,-220,3151,12435,-4488,-20272,-466,5991,-499,3754,5725,9027,16203,16597,-617,-14070,-3891,6667,4739,-3945,-10086,-8727,-5128,-2678,-3913,-3453,-1368,-1787,-249,1441,2646,3432,2494,1416,1194,2425,1550,-1227,-2482,-2099,-1138,-1377,-2068,-1988,-1297,-409,-274,-430,87,576,789,911,858,755,332,-180,-646,-996,-935,-824,-1010,-870,-38,554,587,197,-318,-326,-214,-413,-591,-622,-355,223,556,467,190,66,159,71,-133,-203,-272,-382,-440,-396,-333,-362,-370,-225,-21,13,30,261,465,461,380,342,289,110,-170,-426,-565,-495,-397,-343,-246,-174,-12,39,45,123,120,150,60,-109,-208,-242,-212,-177,-101,-19,-36,-165,-279,-235,-52,77,111,62,24,21,-49,-21}
        },
        {    // H-40e122a.wav
            {3,3,3,4,2,2,2,3,3,4,4,3,6,4,2,-7,5,-4,4,1,-11,8,-15,25,68,1118,1898,-496,-2488,-1540,-183,1046,1744,1784,1745,2433,4061,3545,629,-1125,-1115,-952,-1031,-1086,-1389,-1478,-958,-484,-163,61,128,347,681,847,962,986,774,480,67,-285,-436,-537,-450,-234,-199,-403,-578,-568,-500,-439,-335,-134,-31,-105,-119,-54,35,129,92,-85,-218,-213,-140,-104,-193,-327,-338,-269,-207,-201,-303,-370,-314,-235,-172,-142,-117,-75,-82,-165,-264,-319,-284,-164,-78,-38,-4,14,-2,-23,-71,-165,-216,-229,-197,-128,-48,-10,-69,-144,-150,-115,-121,-152,-201,-209,-167,-111,-63,-31,9,11,24,-3,-39,-79,-113,-165,-237,-62},
            {62,-84,66,-26,-73,157,-258,352,-178,7673,8743,-14313,-13411,5709,1786,-316,5264,7327,12207,16866,9066,-8479,-9212,3851,6780,-845,-9057,-9802,-6152,-3386,-3326,-4606,-2247,-945,-807,1038,2050,3103,3108,2206,1461,1778,2212,-29,-2174,-2471,-1829,-1440,-2011,-2229,-1680,-694,-62,-279,-181,510,842,867,824,856,621,-1,-342,-738,-1042,-899,-982,-1031,-403,328,608,389,-176,-378,-204,-315,-546,-648,-499,110,558,519,353,143,96,94,-126,-269,-304,-424,-474,-417,-349,-290,-272,-241,-90,30,29,179,417,468,379,314,265,157,-47,-333,-564,-579,-448,-371,-272,-174,-58,63,46,93,150,145,115,-54,-226,-276,-240,-169,-114,-57,-9,-83,-231,-264,-147,-13,77,72,42,76,31,-4}
        },
        {    // H-40e129a.wav
            {3,2,2,2,2,3,3,3,3,3,2,7,4,6,-3,4,-1,-2,12,-18,14,-24,28,7,936,2413,87,-3000,-2072,-349,980,1921,1973,1947,2493,4472,4596,1107,-1509,-1533,-1171,-1331,-1528,-1887,-2089,-1659,-1024,-236,216,306,714,1072,1156,1234,1269,872,348,308,307,-137,-763,-957,-712,-507,-386,-344,-495,-623,-447,-129,36,47,11,-20,-8,40,127,92,-176,-336,-234,-116,-120,-195,-291,-368,-344,-267,-262,-408,-520,-385,-192,-100,-38,4,29,25,-60,-197,-319,-392,-354,-222,-98,1,23,-18,-37,-25,-46,-128,-206,-229,-160,-46,18,-29,-133,-190,-185,-152,-133,-127,-176,-190,-146,-87,-46,-48,-25,-1,36,14,-20,-84,-141,-165,-219,-58},
            {-13,47,-89,116,-155,133,-105,45,-25,1685,10741,346,-17915,-4168,5845,-1251,1860,6626,9106,14405,14289,727,-9814,-1757,6692,3000,-6040,-10910,-8149,-4259,-2927,-4357,-4000,-1048,-530,345,1924,2918,3366,2494,1875,1694,2190,1165,-1560,-2582,-2226,-1707,-1887,-2406,-2146,-1207,-174,70,-191,220,819,928,882,856,856,306,-268,-497,-964,-977,-890,-1101,-704,38,472,482,27,-386,-330,-291,-434,-505,-497,-79,459,528,441,274,89,59,-95,-316,-382,-457,-512,-401,-338,-307,-215,-201,-134,22,80,155,331,446,399,259,180,136,28,-227,-528,-620,-505,-384,-301,-180,-90,33,100,70,145,167,113,11,-188,-305,-284,-185,-115,-113,-67,-47,-155,-230,-197,-113,3,69,47,61,73,13}
        },
        {    // H-40e135a.wav
            {3,2,2,-1,2,1,1,1,3,1,7,3,8,0,0,6,-10,20,-18,17,-27,20,-4,660,2800,961,-3454,-2849,-499,940,2144,2187,2126,2528,4706,5683,1859,-1803,-1968,-1355,-1613,-1839,-2109,-2564,-2208,-1515,-824,-129,239,747,1312,1543,1637,1590,1080,559,452,401,197,-347,-940,-1115,-981,-804,-677,-513,-336,-151,-51,32,192,202,114,58,19,36,10,-186,-351,-337,-205,-55,-59,-222,-377,-395,-373,-421,-556,-653,-507,-249,-45,99,167,166,124,25,-111,-251,-406,-488,-412,-247,-92,3,-9,-37,-10,-2,-43,-132,-202,-181,-78,1,-1,-85,-172,-187,-182,-184,-180,-158,-151,-139,-135,-111,-60,-36,-8,20,40,-12,-47,-114,-158,-164,-220,-59},
            {-22,27,-9,-36,74,-140,172,-206,212,-241,3476,10244,-4429,-15766,-613,3593,-1394,3442,7245,9717,14200,11089,-2190,-6488,2226,5299,-983,-8430,-10192,-6921,-4243,-3548,-4181,-2797,-597,-20,1247,2487,3518,3530,2316,1601,1625,2071,395,-2185,-2672,-2121,-1834,-2194,-2511,-2009,-933,-26,84,38,582,966,1044,1003,904,708,-15,-359,-607,-982,-816,-978,-1020,-414,142,423,227,-213,-377,-303,-326,-394,-408,-270,251,543,423,399,239,55,-37,-321,-488,-494,-550,-438,-279,-280,-223,-141,-135,-34,118,205,276,335,362,276,101,-1,-1,-62,-325,-571,-576,-450,-341,-204,-86,-28,89,127,133,203,151,38,-110,-285,-319,-220,-116,-128,-152,-98,-108,-150,-174,-184,-107,42,70,37,89,30}
        },
        {    // H-40e141a.wav
            {2,1,-2,2,-3,2,1,1,0,6,4,10,2,-1,12,-16,28,-25,28,-18,11,12,628,3383,1384,-4445,-3514,-352,1085,2589,2599,2424,2763,5238,6645,2045,-2420,-2409,-1527,-1926,-2268,-2441,-2969,-2667,-1912,-1037,-208,18,477,1268,1764,1846,1844,1485,789,609,606,277,-353,-816,-841,-1033,-1354,-1222,-734,-318,17,254,345,410,364,227,103,-39,-79,-22,-236,-523,-427,-148,14,-10,-163,-336,-468,-558,-584,-610,-705,-614,-281,16,213,306,276,208,97,-77,-234,-397,-519,-477,-356,-256,-158,-61,11,51,33,-10,-46,-95,-104,-77,-70,-95,-92,-77,-97,-162,-238,-240,-195,-139,-133,-172,-192,-134,-28,36,80,68,15,-56,-96,-156,-189,-208,-247,-61},
            {29,-41,54,-52,26,2,-72,132,-206,267,-179,5562,8323,-8546,-12328,1237,1258,-191,4921,7598,10364,13294,7676,-3110,-2534,3728,2227,-4203,-9500,-9120,-5740,-4193,-4310,-3942,-1373,114,420,1681,2970,3897,3257,2228,1704,1553,1372,-543,-2205,-2291,-2111,-2187,-2467,-2389,-1693,-703,-59,14,338,894,1048,1120,1039,901,410,-216,-332,-749,-902,-827,-1055,-747,-200,170,257,27,-221,-332,-340,-385,-379,-329,-21,466,474,384,398,161,-11,-229,-508,-553,-569,-503,-287,-228,-233,-108,-97,-127,13,189,293,300,279,233,92,-38,-42,-22,-172,-440,-573,-505,-369,-249,-133,-62,25,149,150,160,186,84,-43,-201,-316,-268,-152,-127,-180,-165,-133,-148,-142,-169,-191,-45,79,78,83,23}
        },
        {    // H-40e148a.wav
            {4,-1,2,0,0,1,2,-1,7,6,9,12,-5,22,-20,31,-20,15,17,-24,65,340,3552,2703,-4829,-4835,-329,1045,2743,3050,2709,3002,5324,7511,2922,-2698,-2960,-1646,-2049,-2658,-2641,-3293,-3128,-2191,-1399,-333,54,384,1068,1553,1949,2122,1753,1001,741,666,311,-258,-922,-1038,-869,-929,-1092,-1090,-733,-158,336,593,670,566,283,72,23,-19,-24,-212,-547,-555,-282,-11,57,-127,-397,-537,-547,-531,-588,-746,-669,-287,69,263,334,317,250,124,-62,-243,-377,-482,-506,-412,-322,-232,-128,-44,45,81,52,19,-16,-25,1,-45,-149,-180,-110,-52,-79,-171,-239,-217,-168,-140,-186,-237,-207,-100,18,119,174,98,-1,-99,-141,-183,-206,-222,-270,-68},
            {-1,20,-33,52,-70,64,-59,11,41,-119,182,247,6913,5724,-10302,-9092,1170,-74,1390,5783,7602,10589,12184,5196,-2393,481,3188,-853,-6327,-9456,-7906,-5133,-4118,-4280,-3485,-891,492,1090,2006,3120,3902,3067,2125,1720,1662,886,-1193,-2182,-1984,-2022,-2371,-2601,-2290,-1456,-529,-83,9,499,1003,1171,1221,1019,702,98,-236,-382,-756,-743,-900,-957,-480,-36,201,96,-87,-237,-353,-386,-410,-391,-277,174,512,398,406,342,99,-69,-348,-529,-558,-549,-392,-251,-251,-179,-66,-112,-108,31,188,314,298,184,99,31,-20,-43,-108,-282,-479,-524,-414,-278,-172,-98,-63,37,137,138,165,149,32,-96,-208,-261,-213,-161,-190,-207,-174,-164,-155,-148,-196,-133,15,99,107,22}
        },
        {    // H-40e154a.wav
            {-3,2,-4,1,1,-1,-4,7,3,4,11,-12,25,-26,36,-23,12,27,-35,90,327,4114,3332,-5900,-5932,29,1365,3018,3522,3057,3505,6063,8275,2991,-3362,-3589,-1885,-2166,-3109,-3088,-3556,-3517,-2503,-1471,-298,-8,229,1123,1832,2122,2142,1883,1116,760,786,279,-597,-1257,-1144,-859,-944,-934,-714,-496,-284,81,507,726,709,478,191,52,-1,96,-41,-564,-699,-391,-107,-79,-274,-456,-523,-513,-527,-541,-616,-612,-280,108,345,469,408,226,43,-146,-285,-417,-546,-577,-493,-345,-222,-116,-26,39,76,82,82,53,31,54,26,-96,-186,-198,-153,-122,-138,-161,-189,-188,-179,-191,-246,-249,-154,-22,102,188,183,62,-45,-140,-177,-214,-225,-224,-265,-67},
            {3,2,16,-25,44,-60,60,-56,17,26,-94,150,301,6426,5462,-8912,-8743,-2,-200,1705,5936,7534,9673,11130,5701,-407,973,1506,-2267,-6750,-9219,-7021,-4399,-4252,-4388,-3039,-768,340,1103,2155,3196,3676,2935,2375,1940,1489,767,-919,-1959,-2082,-2160,-2283,-2436,-2201,-1472,-586,-55,186,656,951,1044,1096,877,462,-54,-182,-287,-519,-578,-848,-741,-292,-6,141,26,-130,-323,-461,-440,-422,-398,-238,181,402,369,462,352,136,-23,-281,-433,-541,-592,-474,-371,-298,-144,-72,-121,-84,24,193,307,220,134,130,83,-4,-75,-186,-342,-458,-441,-307,-206,-162,-139,-109,-8,109,131,129,125,44,-41,-135,-202,-195,-202,-214,-218,-203,-179,-159,-161,-162,-106,35,131,34}
        },
        {    // H-40e161a.wav
            {0,-3,1,1,-1,-4,6,5,1,14,-16,29,-30,29,-9,-15,51,-67,130,159,4041,4609,-5718,-7636,-354,1707,3163,3945,3319,3811,6332,8874,3879,-3288,-4187,-2309,-2336,-3421,-3375,-3851,-3889,-2707,-1799,-600,-15,391,1262,1879,2326,2353,1963,1103,704,736,178,-519,-1190,-1384,-1136,-1069,-924,-672,-344,-16,92,206,478,727,629,339,246,111,88,88,-402,-773,-624,-313,-131,-190,-372,-539,-573,-529,-489,-541,-614,-351,79,356,531,508,283,33,-159,-283,-421,-594,-692,-627,-445,-235,-83,-37,-4,77,125,149,119,55,66,69,-21,-156,-219,-222,-213,-185,-153,-150,-176,-184,-213,-265,-268,-161,-44,60,160,174,108,-3,-77,-173,-227,-242,-212,-195,-243,-63},
            {4,-2,8,8,-16,33,-54,61,-68,44,-22,-33,71,632,6599,4292,-8841,-7932,-435,0,2404,6168,7519,9183,9987,5512,1123,953,-530,-3663,-6994,-8341,-5790,-3999,-4448,-4352,-2668,-474,538,1070,1947,3108,3599,2943,2455,1905,1349,558,-940,-1682,-1930,-2334,-2494,-2393,-1876,-1033,-298,-55,141,667,924,868,754,587,282,-4,-60,-220,-364,-567,-778,-508,-159,62,110,-55,-255,-458,-529,-514,-451,-387,-196,171,313,411,523,364,172,-50,-261,-430,-652,-688,-595,-471,-294,-127,-92,-129,-49,75,219,262,171,157,166,77,-45,-176,-309,-391,-415,-342,-240,-205,-196,-175,-144,-55,50,68,95,122,65,-24,-102,-164,-202,-216,-245,-259,-239,-211,-191,-159,-151,-96,27,18}
        },
        {    // H-40e167a.wav
            {-6,0,-2,-2,-7,5,4,1,13,-19,29,-34,32,-20,-9,41,-61,123,278,4706,4764,-6709,-8335,-407,1931,3840,4576,3614,4409,7126,8982,3676,-3199,-4501,-3058,-2845,-3694,-3483,-4155,-4580,-3172,-1797,-389,128,480,1515,2259,2664,2545,2031,982,464,616,78,-654,-1301,-1518,-1287,-1220,-1018,-669,-332,-28,200,425,531,595,525,244,235,304,269,143,-460,-919,-670,-208,-2,-91,-313,-505,-535,-538,-569,-590,-616,-378,61,351,528,591,431,118,-188,-354,-454,-584,-709,-686,-512,-309,-127,-53,-14,61,123,181,195,184,176,94,-50,-155,-214,-249,-266,-248,-180,-119,-143,-206,-237,-267,-251,-163,-42,66,158,184,118,21,-84,-160,-222,-223,-218,-194,-192,-226,-55},
            {-9,5,1,1,14,-20,30,-44,42,-44,13,10,-60,102,379,5628,5288,-7108,-8943,-1402,369,2715,6124,6716,7937,9260,6662,2499,313,-1641,-4002,-6379,-7222,-5176,-3958,-4569,-4244,-2706,-662,542,972,1800,2866,3354,2876,2452,1922,1295,717,-574,-1511,-1898,-2199,-2189,-2104,-1745,-1046,-375,13,255,539,682,702,738,603,213,-45,-116,-173,-245,-514,-619,-322,-40,88,61,-66,-289,-527,-591,-540,-437,-382,-240,51,257,485,602,429,177,-73,-257,-470,-683,-724,-674,-526,-305,-130,-105,-98,33,152,247,289,251,201,123,12,-119,-271,-363,-336,-274,-222,-189,-194,-204,-208,-205,-120,-14,15,87,178,146,60,-19,-134,-202,-208,-249,-273,-253,-227,-176,-129,-133,-99,-15}
        },
        {    // H-40e174a.wav
            {-2,-1,0,-5,4,4,0,15,-17,29,-31,28,-13,-18,44,-71,128,229,4618,5468,-6151,-9258,-1196,1684,3877,5415,4241,4757,7207,8726,4252,-2155,-4261,-3871,-3647,-3970,-3664,-4259,-4959,-3688,-2126,-476,442,715,1511,2332,2843,2609,2120,1324,673,551,-124,-837,-1336,-1608,-1457,-1361,-1181,-902,-511,-10,279,533,728,750,572,131,22,149,117,69,-304,-709,-608,-212,73,50,-102,-320,-497,-562,-641,-643,-647,-523,-104,256,487,626,549,271,-88,-305,-439,-625,-730,-693,-529,-341,-185,-97,-78,18,110,168,238,251,216,125,-10,-127,-201,-257,-284,-265,-188,-128,-157,-217,-254,-247,-233,-174,-83,30,166,216,148,41,-65,-159,-200,-238,-224,-208,-190,-179,-208,-52},
            {-2,-9,5,1,3,13,-17,27,-39,38,-41,12,6,-46,89,467,5564,4996,-7160,-8902,-1392,793,3460,6292,6098,6832,8460,7187,2965,-461,-2608,-4332,-5786,-6092,-4435,-4110,-4932,-4046,-2360,-558,573,1135,1846,2613,3104,2735,2337,1752,1103,615,-485,-1242,-1645,-2026,-2032,-1918,-1563,-984,-440,-53,254,602,812,844,761,398,24,-100,-230,-225,-229,-474,-483,-204,36,96,30,-106,-333,-486,-555,-568,-539,-520,-294,60,339,567,584,395,123,-123,-291,-557,-760,-768,-662,-447,-254,-148,-132,-41,132,218,282,299,236,152,46,-90,-221,-314,-305,-225,-184,-173,-187,-227,-251,-251,-218,-136,-52,8,115,211,169,100,-5,-169,-215,-227,-261,-253,-234,-226,-176,-125,-119,-29}
        },
        {    // H-40e180a.wav
            {-2,-1,-7,1,6,-1,17,-19,27,-30,24,-10,-21,44,-77,129,182,4528,5939,-5525,-9740,-1970,1235,3479,5957,5259,5461,7392,8128,4447,-935,-3656,-4135,-4518,-4974,-4006,-4002,-5098,-4322,-2446,-353,691,769,1449,2401,2948,2708,2332,1587,807,616,-68,-884,-1536,-1853,-1628,-1589,-1502,-1058,-502,-51,244,573,808,868,812,356,-117,-213,-175,-7,-149,-569,-562,-185,129,136,-6,-186,-374,-480,-597,-655,-660,-615,-298,118,442,654,614,351,16,-199,-341,-586,-776,-776,-600,-368,-213,-127,-94,-12,108,195,263,265,226,143,14,-113,-220,-263,-250,-216,-186,-166,-198,-247,-246,-233,-222,-172,-82,6,135,215,177,92,-36,-152,-200,-222,-267,-236,-209,-184,-149,-163,-42},
            {-2,-1,-7,1,6,-1,17,-19,27,-30,24,-10,-21,44,-77,129,182,4528,5939,-5525,-9740,-1970,1235,3479,5957,5259,5461,7392,8128,4447,-935,-3656,-4135,-4518,-4974,-4006,-4002,-5098,-4322,-2446,-353,691,769,1449,2401,2948,2708,2332,1587,807,616,-68,-884,-1536,-1853,-1628,-1589,-1502,-1058,-502,-51,244,573,808,868,812,356,-117,-213,-175,-7,-149,-569,-562,-185,129,136,-6,-186,-374,-480,-597,-655,-660,-615,-298,118,442,654,614,351,16,-199,-341,-586,-776,-776,-600,-368,-213,-127,-94,-12,108,195,263,265,226,143,14,-113,-220,-263,-250,-216,-186,-166,-198,-247,-246,-233,-222,-172,-82,6,135,215,177,92,-36,-152,-200,-222,-267,-236,-209,-184,-149,-163,-42}
        }
    },
    {    // elev0 
        {    // H0e000a.wav
            {10,-12,26,-27,31,-24,3,29,-82,133,-169,189,51,4864,7267,-4810,-3900,2957,-5107,64,9185,3622,3640,12917,10387,-6104,-6581,4354,-3565,-14484,-7288,562,-4544,-6604,661,2727,-56,1062,4056,3725,1523,2025,2394,112,-1047,545,1001,-983,-1665,-1087,-1199,-1990,-2674,-2550,-2190,-1752,-822,-13,115,259,766,1327,1390,975,725,606,333,-121,-258,-259,-621,-820,-680,-749,-923,-762,-554,-586,-548,-218,32,99,211,413,557,389,110,-32,-11,-57,-264,-301,-269,-363,-379,-245,-158,-178,-143,-9,-37,-224,-198,6,78,29,22,30,-69,-147,-118,-151,-196,-179,-202,-243,-192,-45,61,62,-8,-45,-33,-96,-197,-195,-156,-183,-186,-119,-63,-44,-21,-26,-56,-57,-39,-51,-66,-14},
            {10,-12,26,-27,31,-24,3,29,-82,133,-169,189,51,4864,7267,-4810,-3900,2957,-5107,64,9185,3622,3640,12917,10387,-6104,-6581,4354,-3565,-14484,-7288,562,-4544,-6604,661,2727,-56,1062,4056,3725,1523,2025,2394,112,-1047,545,1001,-983,-1665,-1087,-1199,-1990,-2674,-2550,-2190,-1752,-822,-13,115,259,766,1327,1390,975,725,606,333,-121,-258,-259,-621,-820,-680,-749,-923,-762,-554,-586,-548,-218,32,99,211,413,557,389,110,-32,-11,-57,-264,-301,-269,-363,-379,-245,-158,-178,-143,-9,-37,-224,-198,6,78,29,22,30,-69,-147,-118,-151,-196,-179,-202,-243,-192,-45,61,62,-8,-45,-33,-96,-197,-195,-156,-183,-186,-119,-63,-44,-21,-26,-56,-57,-39,-51,-66,-14}
        },
        {    // H0e005a.wav
            {-5,8,-6,17,-22,26,-18,-6,30,-70,106,-134,152,63,4065,6620,-3503,-3645,2621,-4135,-759,7762,3922,3206,10919,10224,-3628,-6078,2961,-2317,-12198,-7492,-176,-3559,-5979,-257,2274,238,679,3094,3319,1531,1609,2274,715,-734,312,1198,-324,-1544,-1223,-1104,-2022,-2710,-2241,-1707,-1527,-901,13,376,371,420,765,1066,826,484,365,248,-71,-235,-273,-558,-766,-652,-634,-830,-742,-474,-417,-407,-169,98,181,229,326,382,273,58,-114,-112,-135,-277,-253,-181,-254,-305,-194,-113,-178,-164,-49,-68,-200,-180,-10,44,-24,-25,-21,-103,-152,-121,-117,-143,-149,-171,-198,-146,-44,37,72,25,-23,-41,-106,-191,-201,-169,-194,-200,-142,-94,-82,-71,-48,-52,-54,-45,-33,-7},
            {-13,31,-30,32,-18,-18,58,-120,169,-204,218,-60,4710,8706,-4682,-5472,3401,-5272,-505,10310,3955,3388,13960,11842,-6951,-8297,5056,-2862,-15865,-8401,974,-4435,-7555,483,3275,-191,756,4486,4429,1704,2182,2824,134,-1418,300,953,-1037,-1701,-1059,-1156,-1965,-2652,-2748,-2677,-2152,-1099,-343,-192,430,1276,1622,1599,1189,921,785,485,4,-242,-268,-613,-841,-699,-774,-1001,-843,-642,-674,-650,-331,-46,6,166,411,582,490,230,68,53,-3,-237,-272,-197,-375,-507,-343,-196,-230,-190,-29,-32,-227,-201,65,138,54,50,65,-29,-115,-83,-151,-237,-210,-242,-291,-247,-103,31,52,-6,-51,-46,-78,-174,-173,-127,-184,-182,-115,-66,-32,-3,22,-28,-54,-36,-54,-78,-64,-12}
        },
        {    // H0e010a.wav
            {-2,-1,7,-10,19,-18,17,-9,-5,25,-56,84,-104,124,78,3528,5901,-2639,-3265,2184,-3327,-1052,6567,4041,3018,9425,9680,-2020,-5501,1884,-1483,-10298,-7378,-626,-2877,-5402,-759,1922,352,303,2442,3029,1376,1400,2307,1030,-510,188,1056,-91,-1191,-1133,-1225,-2030,-2449,-1883,-1493,-1403,-818,0,443,513,393,387,543,518,353,243,70,-183,-206,-224,-551,-758,-608,-575,-722,-605,-321,-220,-231,-58,128,180,198,199,230,147,-16,-139,-180,-197,-294,-241,-111,-171,-253,-206,-118,-119,-151,-87,-84,-186,-166,-28,39,-19,-62,-50,-101,-156,-130,-125,-149,-144,-136,-153,-143,-56,47,86,32,-37,-65,-105,-164,-172,-172,-219,-219,-170,-119,-99,-78,-56,-68,-58,-31,-5},
            {31,-29,24,1,-35,84,-157,206,-220,212,-112,4390,10153,-4104,-7332,3537,-5281,-1053,11499,4174,3339,15209,13028,-7722,-9877,5352,-2586,-16725,-8978,921,-4466,-7995,355,3429,-272,596,4552,4967,2072,2404,3205,350,-1855,-469,1207,-483,-1888,-1208,-1104,-2034,-2763,-2886,-3006,-2665,-1673,-648,31,790,1445,1790,1909,1485,1083,830,501,65,-143,-199,-652,-913,-705,-768,-1062,-911,-661,-764,-792,-403,-77,-10,149,383,598,569,333,117,48,6,-192,-224,-185,-367,-487,-384,-288,-330,-287,-81,-46,-198,-155,98,207,134,112,102,-22,-125,-98,-133,-224,-236,-271,-344,-312,-159,-19,29,-30,-75,-49,-70,-138,-130,-101,-162,-184,-119,-69,-45,16,43,-9,-50,-38,-67,-87,-55,-83,-28}
        },
        {    // H0e015a.wav
            {-3,-1,-1,6,-6,12,-12,15,-8,-9,26,-51,63,-79,98,59,2888,5380,-1711,-3137,1893,-2516,-1466,5551,4065,2687,8031,9246,-552,-5053,1152,-534,-8601,-7165,-997,-2286,-4923,-1285,1536,244,-49,1970,2662,1335,1433,2309,1214,-329,127,884,-36,-876,-896,-1199,-1836,-2097,-1811,-1496,-1233,-693,-21,327,382,282,235,284,226,154,73,-37,-172,-238,-232,-433,-683,-601,-484,-529,-392,-173,-119,-138,-52,85,119,94,106,146,88,-68,-194,-187,-199,-280,-231,-135,-152,-215,-157,-88,-135,-148,-101,-96,-172,-167,-20,38,-6,-33,-65,-125,-177,-161,-152,-169,-126,-109,-128,-108,-49,27,47,-1,-52,-77,-89,-124,-159,-177,-225,-231,-166,-130,-112,-93,-66,-58,-66,-16},
            {-5,8,13,-67,122,-184,200,-189,151,-88,3586,11452,-2153,-9666,2895,-4345,-2327,12175,5145,3024,16021,14722,-7552,-11835,4924,-1759,-17406,-9911,1028,-4246,-8615,175,3801,-496,284,4484,5379,2398,2531,3867,409,-2748,-708,1916,-205,-1957,-1030,-1235,-2376,-2841,-2842,-3547,-3639,-2060,-303,475,862,1353,1932,2283,1792,1195,855,528,69,-158,-160,-616,-920,-748,-820,-1112,-903,-624,-830,-886,-459,-83,-10,121,384,648,632,334,104,87,71,-169,-227,-155,-360,-513,-403,-344,-429,-347,-79,-19,-186,-173,125,289,225,177,114,-11,-107,-75,-133,-265,-255,-292,-384,-367,-205,-30,28,-36,-109,-77,-51,-123,-120,-51,-122,-168,-121,-76,-42,4,47,-3,-52,-51,-61,-83,-60,-56,-65,-12}
        },
        {    // H0e020a.wav
            {2,-5,-2,1,4,-7,10,-8,10,-1,-12,30,-46,51,-56,74,34,2241,4908,-811,-3008,1597,-1784,-1734,4561,3937,2413,6708,8757,810,-4488,589,297,-6939,-6860,-1353,-1799,-4534,-1753,1037,75,-224,1495,2373,1518,1414,2135,1364,-107,53,759,102,-657,-691,-967,-1614,-1953,-1770,-1386,-1057,-676,-227,-10,118,273,268,109,-47,-60,-11,-10,-128,-236,-236,-325,-470,-454,-415,-412,-276,-145,-113,-139,-92,33,80,70,63,75,15,-103,-195,-190,-161,-235,-249,-163,-140,-183,-161,-104,-127,-157,-99,-53,-117,-148,-39,45,-5,-64,-69,-125,-192,-179,-159,-145,-117,-98,-99,-102,-64,-22,-3,-20,-58,-54,-60,-116,-147,-157,-179,-191,-178,-129,-121,-103,-73,-82,-20},
            {-22,54,-92,131,-181,165,-107,30,23,2471,12013,1231,-11533,689,-2623,-3358,11528,6350,3350,16219,16058,-5788,-13227,3043,-773,-16816,-11576,-37,-2932,-8651,-1144,4292,8,-191,3873,5622,3177,2461,3681,416,-2703,-668,1987,359,-1695,-1198,-1210,-2417,-3079,-3217,-4252,-4503,-2080,541,669,430,1414,2287,2535,1881,1172,922,644,129,-199,-238,-654,-913,-732,-865,-1192,-945,-606,-773,-902,-485,-40,-41,76,411,683,634,341,121,35,71,-76,-174,-147,-392,-596,-513,-410,-407,-323,-86,-12,-175,-180,107,329,297,220,146,8,-90,-80,-143,-269,-288,-324,-442,-448,-247,-34,60,-8,-106,-92,-89,-126,-117,-58,-103,-156,-97,-62,-55,-8,25,-23,-77,-89,-71,-61,-14,-9,-50,2,9}
        },
        {    // H0e025a.wav
            {-5,2,-1,-2,-1,4,-3,8,-3,5,5,-16,31,-39,38,-32,55,14,1611,4386,115,-2821,1180,-988,-1882,3468,3792,2184,5413,8182,2100,-3732,71,975,-5263,-6449,-1775,-1471,-4083,-2197,412,14,-287,1106,2191,1557,1324,2008,1460,105,52,764,327,-514,-720,-859,-1288,-1716,-1609,-1283,-1173,-931,-526,-211,7,131,142,27,-105,-115,13,111,-55,-201,-124,-164,-334,-367,-374,-449,-360,-158,-95,-156,-105,40,64,5,-6,34,6,-95,-164,-156,-151,-220,-233,-168,-162,-205,-170,-117,-129,-130,-63,-6,-67,-119,-58,-7,-44,-77,-68,-108,-166,-171,-155,-139,-117,-103,-123,-133,-88,-30,-15,-40,-65,-49,-45,-89,-115,-110,-123,-160,-163,-154,-146,-127,-96,-19},
            {62,-108,130,-139,78,16,-110,178,1228,11306,5876,-11619,-3399,-949,-3647,9852,7365,3485,16440,17356,-3323,-13148,510,-545,-15205,-12621,-2586,-2537,-7123,-2318,3544,782,124,3292,5077,3883,2785,2464,227,-1197,-588,1243,1076,-1026,-1443,-1400,-1992,-3135,-4458,-5137,-4254,-1651,440,532,535,1517,2407,2675,1977,1171,892,718,281,-219,-335,-615,-934,-836,-881,-1194,-1031,-653,-701,-795,-447,-9,-25,25,379,701,715,363,58,-29,38,0,-128,-160,-390,-661,-589,-423,-373,-292,-102,-7,-124,-179,60,325,349,275,156,15,-79,-96,-149,-264,-291,-355,-497,-498,-286,-58,72,47,-67,-96,-98,-119,-131,-87,-105,-148,-102,-64,-45,-19,1,-38,-110,-139,-96,-38,31,62,26,12,-18,-9}
        },
        {    // H0e030a.wav
            {0,-3,2,-1,-1,-2,2,-1,3,-1,-1,8,-17,27,-32,22,-9,32,2,1047,3774,988,-2515,682,-221,-1913,2368,3568,2008,4233,7425,3295,-2754,-422,1466,-3636,-5942,-2284,-1217,-3537,-2699,-178,131,-275,654,1876,1655,1303,1804,1541,412,224,739,301,-534,-707,-643,-916,-1413,-1637,-1550,-1366,-1081,-717,-429,-221,-52,37,91,82,43,109,187,75,-55,-52,-140,-356,-437,-405,-464,-441,-242,-95,-99,-105,-39,-8,-27,-9,60,48,-57,-159,-179,-150,-198,-230,-183,-176,-219,-211,-147,-111,-99,-40,9,-41,-103,-82,-46,-68,-91,-79,-95,-139,-151,-156,-159,-139,-127,-142,-148,-96,-51,-39,-50,-61,-45,-36,-48,-71,-76,-106,-142,-170,-167,-154,-143,-31},
            {-76,79,-64,-29,120,-225,299,217,9162,10387,-8661,-8305,-988,-2858,7589,8103,3601,15703,18959,86,-12312,-1846,-342,-13453,-13289,-5148,-3287,-6063,-3043,3049,1279,84,3458,5275,3586,1701,2315,1229,-1001,-636,1382,1275,-698,-1250,-1159,-1899,-3686,-5490,-5416,-3354,-1468,-454,313,1027,1766,2220,2491,2108,1411,967,621,233,-208,-299,-521,-927,-985,-923,-1178,-1154,-721,-607,-609,-426,-105,24,130,425,691,706,346,67,-20,-44,-88,-162,-175,-366,-615,-567,-397,-356,-293,-107,-4,-100,-179,41,325,356,288,190,25,-127,-140,-135,-251,-297,-350,-505,-530,-333,-82,78,87,-12,-86,-112,-131,-134,-69,-86,-169,-148,-96,-50,-26,-3,-36,-120,-165,-141,-43,61,121,84,38,1,-44,-13}
        },
        {    // H0e035a.wav
            {-4,1,-1,0,0,-1,-1,2,1,1,1,-4,13,-18,20,-17,3,16,1,14,601,3036,1741,-2001,103,425,-1708,1286,3193,1951,3199,6445,4317,-1501,-813,1617,-2102,-5234,-2791,-1054,-2975,-3035,-609,124,-384,315,1626,1728,1304,1645,1705,758,190,468,304,-321,-497,-491,-887,-1462,-1728,-1636,-1447,-1302,-1000,-605,-337,-115,100,318,373,254,228,269,193,-4,-129,-226,-430,-512,-465,-484,-444,-299,-146,-106,-147,-73,17,37,29,50,79,-23,-155,-183,-154,-174,-216,-201,-193,-236,-229,-142,-104,-99,-43,27,-5,-102,-100,-55,-73,-99,-91,-96,-126,-145,-134,-137,-158,-157,-167,-143,-101,-80,-55,-39,-43,-31,-7,-21,-52,-78,-81,-123,-147,-155,-176,-43},
            {-4,41,-125,197,-272,329,-262,6094,13116,-2947,-11656,-3511,-1844,5870,7927,3761,14888,19810,3236,-9903,-3235,-994,-11286,-12723,-7986,-5157,-4940,-3800,1415,2126,799,3212,5573,3407,248,2401,2684,-823,-1047,1181,1488,-267,-900,-841,-2147,-4537,-5973,-4815,-2660,-1703,-1097,75,1263,1982,2028,2176,2152,1705,1173,548,56,-255,-222,-464,-891,-978,-1046,-1217,-1212,-795,-499,-489,-430,-213,84,327,529,695,643,333,104,-19,-152,-255,-237,-145,-323,-570,-514,-362,-296,-242,-112,-30,-99,-129,21,265,366,312,205,17,-164,-187,-174,-259,-287,-318,-442,-532,-410,-125,94,156,32,-89,-118,-137,-128,-73,-81,-163,-175,-145,-91,-29,5,-38,-122,-166,-144,-42,50,121,112,62,17,-28,8,10}
        },
        {    // H0e040a.wav
            {1,-1,0,0,-1,1,-1,-2,1,2,-1,3,-3,10,-14,12,-6,-9,26,-16,35,270,2248,2265,-1293,-468,867,-1253,281,2655,1987,2350,5306,5050,-36,-1076,1409,-690,-4286,-3207,-996,-2315,-3243,-1235,53,-268,59,1331,1835,1417,1494,1617,884,226,362,463,-57,-596,-822,-1024,-1336,-1662,-1785,-1671,-1462,-1084,-615,-275,-8,289,523,575,469,313,264,183,-60,-258,-373,-485,-551,-532,-497,-456,-354,-218,-129,-92,-21,62,69,35,52,69,3,-116,-181,-156,-172,-240,-243,-210,-223,-216,-155,-101,-87,-60,-2,-17,-81,-100,-79,-72,-101,-99,-78,-105,-121,-133,-156,-165,-171,-153,-157,-137,-91,-55,-21,-27,-17,-4,-8,-48,-67,-84,-108,-135,-164,-40},
            {88,-179,221,-214,190,-182,2915,13258,4096,-12008,-7498,-1986,4755,7781,3182,13796,21295,5772,-8161,-3310,-684,-10053,-11652,-8740,-8112,-5445,-3467,-175,1256,1268,4482,5479,2024,332,3230,2877,-400,-630,474,1028,216,-275,-694,-2854,-5186,-5613,-4068,-2649,-1956,-1007,84,989,1808,1984,1974,2062,1855,1405,564,-70,-255,-214,-505,-876,-893,-1084,-1336,-1305,-767,-433,-504,-411,-137,180,363,611,775,649,337,50,-95,-259,-321,-226,-180,-340,-520,-464,-302,-266,-233,-60,18,-41,-106,-44,188,323,347,268,13,-213,-265,-224,-270,-298,-264,-371,-515,-439,-170,97,199,87,-50,-123,-151,-121,-82,-89,-178,-210,-177,-131,-42,6,-16,-98,-172,-134,-25,46,96,111,59,19,-29,-8,74,25}
        },
        {    // H0e045a.wav
            {3,1,0,0,-1,-1,2,-1,-1,2,2,-3,7,-2,6,-4,5,10,-15,31,-12,36,89,1488,2436,-424,-883,1013,-612,-512,1960,2025,1773,4132,5341,1463,-1053,985,466,-3066,-3286,-1183,-1957,-3261,-1619,-25,-168,-40,1138,1837,1344,1207,1567,1166,452,267,216,-253,-792,-975,-1033,-1300,-1716,-1881,-1682,-1366,-956,-465,-124,139,448,659,687,523,331,218,48,-193,-383,-442,-506,-596,-568,-525,-475,-349,-192,-69,-45,3,70,71,66,58,52,12,-75,-154,-193,-220,-254,-242,-196,-191,-202,-157,-107,-105,-94,-49,-30,-70,-94,-58,-42,-74,-84,-72,-78,-122,-153,-152,-161,-159,-176,-165,-131,-97,-43,-14,0,-6,-6,-18,-54,-84,-85,-103,-129,-32},
            {-95,79,-11,-98,185,498,10468,10829,-8467,-11824,-3441,3404,7745,2753,10969,23026,9597,-6948,-3791,276,-8199,-10869,-8323,-10004,-7099,-3774,-1518,552,717,4371,5516,1838,878,3380,3454,478,-387,56,537,529,-193,-971,-3278,-5328,-4925,-3762,-2907,-2059,-850,464,911,1215,1696,1949,1981,1767,1531,746,-8,-248,-328,-475,-843,-954,-1032,-1407,-1463,-855,-384,-395,-389,-73,273,412,621,763,703,358,-36,-173,-297,-328,-228,-206,-324,-490,-458,-292,-278,-235,-22,106,49,-63,-78,57,245,365,306,45,-223,-331,-303,-309,-302,-232,-315,-473,-465,-238,66,223,148,2,-108,-163,-133,-81,-80,-180,-252,-249,-196,-76,7,-2,-70,-141,-133,-33,54,99,90,48,-7,-47,-32,39,99,25}
        },
        {    // H0e050a.wav
            {1,1,0,2,0,1,-1,-1,-1,-1,-1,2,-2,2,-1,0,1,-6,15,-15,20,-2,22,17,835,2256,464,-1019,851,78,-979,1138,1993,1459,3042,5129,2781,-609,518,1373,-1695,-3385,-1673,-1495,-2877,-1970,-215,66,-32,738,1542,1390,1275,1620,1279,192,-337,-79,-244,-893,-1193,-1157,-1224,-1557,-1730,-1486,-1111,-709,-301,2,265,500,644,656,474,236,61,-96,-290,-467,-489,-516,-618,-597,-495,-402,-290,-142,-34,-47,-31,68,112,66,26,41,15,-90,-185,-212,-212,-238,-242,-195,-181,-202,-179,-137,-132,-126,-72,-25,-46,-76,-40,-16,-58,-80,-60,-80,-141,-160,-153,-167,-183,-170,-153,-129,-90,-48,-6,-14,-31,-41,-48,-69,-86,-73,-76,-20},
            {-101,200,-281,322,-357,5498,14511,-210,-14789,-7027,2071,7177,3301,6669,22874,15506,-4816,-5151,1151,-5480,-10566,-7493,-9804,-9546,-4566,-2447,-657,239,2997,4525,2132,1721,3639,4244,1470,1,448,99,390,-10,-1590,-3885,-5088,-4149,-3699,-3430,-2108,-507,617,950,1042,1335,1677,1810,1712,1564,951,171,-195,-352,-455,-773,-990,-1101,-1457,-1580,-1067,-373,-250,-312,-33,317,516,588,707,720,372,-13,-147,-265,-398,-336,-177,-196,-429,-519,-370,-269,-202,-43,137,135,8,-43,-16,151,325,338,129,-209,-366,-354,-348,-325,-236,-242,-403,-493,-318,7,210,213,63,-85,-154,-142,-60,-44,-142,-250,-304,-282,-172,-43,27,-9,-87,-129,-72,65,125,124,70,-27,-102,-92,28,109,74,10}
        },
        {    // H0e055a.wav
            {1,1,2,1,1,1,1,-1,-1,0,0,0,0,0,1,0,-2,4,-4,14,-10,10,12,5,10,362,1794,1197,-781,475,636,-1055,302,1802,1365,2177,4481,3762,431,272,1518,-600,-2914,-1978,-1239,-2359,-2093,-428,88,-165,485,1532,1655,1259,1015,636,-70,-479,-304,-489,-1060,-1206,-1022,-964,-1217,-1381,-1182,-819,-449,-187,17,248,438,525,477,320,127,-86,-232,-334,-470,-520,-531,-552,-501,-401,-302,-232,-143,-54,-47,-19,50,72,57,12,-2,-26,-104,-159,-191,-199,-230,-260,-215,-186,-202,-194,-154,-125,-110,-70,-35,-42,-48,-26,-7,-43,-68,-69,-102,-128,-152,-164,-174,-175,-150,-138,-122,-98,-78,-60,-49,-53,-44,-41,-45,-54,-60,-14},
            {76,-38,-30,82,1032,12140,10469,-11886,-13480,-141,6418,4609,2614,18678,22324,155,-7178,975,-1792,-9394,-7839,-8389,-10821,-6067,-3301,-1869,58,714,2659,2812,1876,2897,5097,3803,539,413,675,562,-258,-2107,-3923,-5101,-4213,-3582,-3718,-2378,-434,717,1041,1072,1166,1375,1651,1617,1394,1150,487,-113,-312,-429,-662,-939,-1183,-1586,-1716,-1197,-513,-250,-190,11,316,590,597,576,670,556,125,-188,-221,-384,-454,-230,-131,-317,-522,-440,-273,-236,-94,146,212,87,-41,-64,96,292,336,210,-117,-386,-425,-387,-335,-246,-203,-328,-479,-406,-116,167,252,116,-44,-129,-154,-77,-17,-69,-196,-303,-343,-298,-152,-16,26,-27,-109,-98,36,148,162,120,4,-117,-152,-78,67,120,53,5}
        },
        {    // H0e060a.wav
            {-1,0,0,1,1,1,1,-1,-1,-2,-1,-1,0,-2,0,-2,0,-5,4,2,4,-5,-2,27,-6,6,105,1192,1595,-202,68,881,-787,-375,1434,1371,1627,3734,4370,1459,-8,1432,598,-2094,-2280,-1147,-1710,-2134,-868,82,203,594,1205,1193,553,314,355,-190,-781,-683,-537,-852,-989,-714,-552,-765,-1011,-877,-552,-349,-220,-66,122,257,305,277,147,-31,-185,-272,-353,-466,-474,-413,-404,-394,-312,-235,-214,-161,-79,-41,-36,-23,22,29,-23,-41,-47,-84,-128,-187,-215,-236,-265,-227,-184,-182,-168,-134,-110,-104,-79,-37,-35,-46,-25,-17,-38,-67,-76,-75,-114,-149,-160,-174,-163,-146,-152,-151,-143,-117,-74,-49,-24,-21,-16,-28,-60,-16},
            {167,-255,294,-313,5052,15890,485,-18426,-6923,5731,6162,1220,10251,25710,10208,-8132,-1753,1947,-6130,-8601,-7067,-10683,-8578,-3570,-2838,-827,-594,265,2514,1900,2130,4352,5291,2763,878,1138,970,187,-2152,-4031,-4735,-4680,-3951,-3949,-2963,-727,799,1106,1030,1147,1243,1473,1528,1336,1213,788,100,-244,-279,-557,-970,-1141,-1487,-1827,-1534,-814,-247,-116,36,278,468,605,559,620,685,385,-47,-247,-326,-456,-375,-156,-236,-446,-460,-334,-258,-188,77,257,170,18,-71,-1,213,371,309,28,-323,-489,-450,-349,-252,-179,-236,-415,-487,-305,50,253,190,27,-100,-155,-119,-5,12,-110,-249,-349,-371,-263,-103,-8,-6,-74,-110,-14,145,189,153,76,-59,-148,-134,-19,85,71,18,2}
        },
        {    // H0e065a.wav
            {3,3,3,5,4,4,5,4,4,4,3,6,6,6,4,8,4,7,7,7,16,3,8,15,33,-6,11,27,640,1590,547,-130,751,-293,-701,905,1493,1623,2751,3907,2590,641,1245,1239,-1073,-2168,-1342,-1327,-1785,-783,302,227,-29,195,531,292,-144,-264,-485,-710,-568,-423,-512,-473,-240,-162,-384,-659,-669,-470,-346,-350,-255,-63,48,79,54,-3,-91,-217,-290,-287,-297,-307,-290,-281,-275,-233,-185,-194,-180,-105,-63,-79,-74,-28,-8,-20,-39,-52,-69,-113,-173,-212,-226,-217,-187,-146,-126,-129,-118,-103,-83,-67,-54,-33,-35,-29,-9,-16,-31,-44,-58,-88,-135,-156,-168,-180,-174,-166,-155,-138,-97,-52,-18,0,4,-13,-38,-11},
            {121,-254,332,53,10348,14594,-10737,-18249,1077,8161,2911,2521,20125,22169,-2493,-7256,2949,-443,-7774,-7279,-8520,-10683,-5695,-2757,-1799,-1337,-2181,1186,2492,1090,2701,5309,4862,1807,1500,2127,1041,-1402,-3943,-4275,-4513,-4627,-4353,-3751,-1658,347,1288,1173,920,1097,1404,1551,1310,1234,1100,434,-174,-202,-264,-844,-1291,-1337,-1559,-1777,-1354,-546,-60,26,158,375,503,505,635,818,611,138,-147,-177,-389,-533,-275,-139,-330,-518,-424,-261,-239,-81,200,260,96,-39,-42,87,287,372,229,-145,-451,-484,-420,-298,-180,-149,-281,-490,-465,-177,152,253,120,-42,-155,-158,-30,48,-7,-158,-321,-375,-330,-192,-61,-18,-49,-124,-80,91,187,166,126,50,-74,-155,-76,47,53,17,-14,-7}
        },
        {    // H0e070a.wav
            {0,0,0,0,1,1,3,1,2,2,0,-1,1,0,-1,2,3,-2,5,0,-2,16,-6,9,12,12,1,-8,19,249,1237,1156,13,376,129,-547,667,1367,1095,1895,3599,3571,1552,1005,1406,-85,-1843,-1463,-604,-911,-1004,-601,-583,-650,-371,-35,-294,-760,-627,-294,-302,-365,-164,24,65,132,93,-181,-476,-581,-532,-514,-566,-467,-299,-225,-149,-108,-103,-143,-203,-177,-128,-140,-199,-211,-180,-192,-208,-205,-221,-211,-184,-161,-136,-130,-82,-41,-54,-66,-79,-80,-108,-175,-198,-178,-162,-143,-134,-128,-125,-127,-102,-109,-113,-83,-58,-25,-19,-20,-17,-33,-37,-65,-121,-156,-193,-200,-197,-191,-169,-159,-116,-83,-65,-36,-15,-16,-43,-14},
            {-31,-52,84,1523,14875,9206,-19012,-13584,7227,7454,129,8146,25695,12509,-9306,-2683,4799,-2709,-7982,-7130,-9719,-9143,-3719,-2138,-1747,-3240,-2301,2466,2068,818,3468,5639,3711,1556,2330,2174,414,-2585,-4298,-4025,-4434,-4683,-4561,-3105,-687,826,1331,1005,811,1108,1538,1516,1235,1251,867,119,-177,-146,-466,-1122,-1362,-1403,-1677,-1657,-1064,-326,-69,-22,203,446,509,474,743,912,496,-27,-126,-184,-486,-477,-170,-178,-472,-563,-398,-270,-205,52,289,202,20,-41,14,150,302,317,85,-292,-485,-441,-346,-234,-156,-184,-377,-548,-418,-39,225,187,22,-113,-176,-130,13,54,-55,-217,-360,-388,-292,-136,-28,-24,-102,-147,-57,119,171,142,116,0,-107,-122,-2,74,32,-32,-99,-29}
        },
        {    // H0e075a.wav
            {0,0,-1,-1,0,0,0,1,1,2,1,0,0,0,0,0,0,0,-2,3,-1,-3,18,-1,-5,19,13,2,-14,20,56,778,1450,471,71,645,53,-176,720,1316,1686,2943,3959,2583,989,1208,892,-598,-1052,-595,-1092,-1917,-1629,-1020,-1001,-1085,-861,-719,-763,-465,24,153,107,223,430,507,389,151,-152,-407,-594,-710,-732,-754,-704,-552,-406,-280,-201,-134,-73,-41,-15,-5,-29,-92,-132,-125,-150,-212,-243,-265,-284,-264,-212,-170,-156,-132,-91,-71,-81,-87,-87,-90,-97,-120,-127,-120,-134,-133,-120,-127,-138,-147,-142,-114,-74,-36,-23,-24,-26,-27,-38,-72,-103,-128,-165,-189,-202,-196,-173,-159,-123,-116,-110,-83,-54,-27,-40,-13},
            {-201,224,-279,3695,17485,2419,-23237,-7758,10789,5404,-675,14663,25947,2602,-10927,1931,5245,-4303,-8080,-7204,-10060,-7604,-2189,-1790,-3153,-4858,-1149,3239,1246,1188,4444,5193,2577,1695,2817,1593,-697,-2907,-3498,-3533,-4695,-4906,-4044,-2328,-442,867,1222,724,637,1210,1648,1393,1223,1320,693,-134,-161,-27,-606,-1296,-1351,-1427,-1721,-1533,-802,-195,-145,-160,178,548,495,501,834,900,425,-67,-81,-255,-535,-329,-71,-264,-603,-578,-351,-275,-167,177,309,136,-29,-27,68,172,326,267,-52,-391,-477,-350,-234,-166,-157,-256,-478,-545,-308,79,236,93,-57,-162,-183,-83,40,43,-88,-265,-379,-367,-231,-75,14,-7,-152,-196,-33,153,176,125,78,-34,-117,-61,86,82,-12,-84,-138,-37}
        },
        {    // H0e080a.wav
            {0,-1,-1,-1,-1,-1,0,-1,0,1,0,0,-1,0,2,0,0,0,-1,0,1,0,2,12,0,-3,28,16,-10,-17,1,12,454,1414,1271,329,200,29,-55,678,1224,1455,2408,3761,3340,1725,1671,1855,163,-1528,-1636,-1621,-2215,-2272,-1778,-1567,-1505,-1181,-712,-412,-109,391,667,575,547,697,719,450,64,-230,-467,-713,-897,-964,-945,-865,-693,-502,-352,-165,-12,66,111,92,78,46,-30,-70,-112,-169,-262,-328,-299,-304,-296,-252,-226,-191,-164,-117,-87,-95,-68,-25,-7,-35,-88,-104,-107,-124,-138,-148,-157,-168,-159,-124,-100,-77,-51,-32,-31,-53,-63,-69,-90,-106,-134,-164,-184,-185,-162,-158,-159,-144,-129,-124,-108,-74,-41,-7},
            {-313,427,-549,5703,18346,-3205,-24555,-3065,12396,3551,-8,19449,23330,-4674,-10113,5669,5356,-5669,-7994,-6878,-10150,-6513,-926,-1963,-5185,-5720,491,3486,119,1830,5551,4517,1627,1927,2836,523,-1568,-2476,-2520,-3274,-4723,-4558,-3678,-1984,-107,723,681,472,684,1202,1496,1318,1368,1281,446,-223,-35,29,-681,-1245,-1338,-1507,-1692,-1392,-641,-183,-241,-238,135,521,481,541,899,885,331,-56,-55,-311,-505,-222,-23,-346,-683,-563,-320,-251,-117,215,273,69,-60,-16,71,195,339,211,-131,-455,-447,-276,-174,-106,-151,-314,-550,-544,-211,150,203,22,-131,-222,-199,-54,70,14,-137,-297,-380,-312,-169,-33,20,-49,-192,-194,0,170,150,94,45,-69,-114,-35,108,67,-39,-98,-173,-49}
        },
        {    // H0e085a.wav
            {1,0,-1,-1,-1,0,0,0,0,1,2,2,1,1,1,0,1,-1,-2,0,0,5,1,-3,15,9,5,23,10,-19,-32,29,79,567,1634,1254,-154,205,817,298,352,955,1282,1888,3569,4640,3268,1615,1081,-152,-1947,-2260,-1942,-2614,-3006,-2342,-1668,-1406,-1105,-508,35,375,728,1008,953,751,738,681,361,-76,-443,-633,-825,-1061,-1113,-1034,-934,-754,-493,-222,-26,93,171,191,159,107,82,29,-92,-178,-229,-286,-320,-323,-316,-322,-310,-260,-209,-175,-123,-55,-21,-7,25,31,-16,-62,-95,-119,-131,-149,-162,-170,-163,-139,-119,-108,-101,-79,-42,-40,-64,-74,-87,-99,-110,-121,-139,-165,-156,-145,-162,-167,-162,-154,-132,-86,-34,-4},
            {-364,528,-672,6734,18447,-6239,-24773,-392,13048,2580,861,21690,20597,-8987,-9077,8636,5805,-6892,-7729,-6086,-10294,-5993,78,-2484,-7212,-5841,1924,3018,-523,2575,5797,4224,1441,1803,2407,-447,-1936,-1862,-1868,-3153,-4455,-3795,-3330,-1992,-19,705,314,8,651,1260,1240,1180,1470,1246,267,-257,147,130,-702,-1157,-1223,-1515,-1750,-1284,-483,-219,-342,-268,97,440,454,574,917,855,296,-54,-56,-300,-457,-166,-3,-385,-692,-516,-276,-227,-91,242,216,-20,-83,-20,83,213,325,173,-169,-442,-414,-259,-128,-42,-115,-335,-594,-529,-158,184,188,-34,-184,-263,-210,-40,71,1,-156,-302,-340,-272,-148,-7,19,-69,-191,-162,15,160,161,93,16,-109,-138,-29,107,69,-31,-111,-193,-53}
        },
        {    // H0e090a.wav
            {0,-1,-1,-1,-1,-1,-1,0,0,-1,1,0,-1,1,0,-1,0,-2,-3,-2,-1,4,-1,-2,5,17,10,-1,15,-6,-22,15,332,735,433,440,1109,809,485,894,762,404,455,868,2178,4418,5250,3093,558,-100,-394,-1689,-2680,-2748,-2962,-3011,-2300,-1543,-1133,-763,-160,425,717,971,1181,1105,797,565,497,175,-344,-652,-792,-902,-1078,-1178,-1062,-883,-614,-318,-125,46,157,209,215,161,117,37,-41,-105,-200,-238,-286,-344,-342,-342,-345,-351,-294,-180,-107,-55,-21,3,32,44,22,-37,-79,-90,-104,-130,-164,-192,-175,-147,-157,-161,-139,-101,-67,-52,-52,-73,-98,-94,-100,-112,-120,-132,-132,-145,-158,-176,-195,-171,-115,-62,-32,-6},
            {-371,536,-699,6457,18519,-6301,-25112,64,13460,2553,1173,21732,19204,-10847,-8960,10799,7037,-7628,-7732,-5030,-10254,-6135,806,-3061,-8824,-5745,2482,2689,-666,2814,5790,3917,1586,2017,1740,-1311,-1931,-1345,-1620,-3007,-3993,-3239,-2915,-1758,-170,479,217,-236,369,1108,1132,1031,1349,1187,286,-222,147,241,-547,-1069,-1151,-1420,-1723,-1326,-424,-158,-374,-342,15,388,399,546,889,803,287,-37,-42,-283,-440,-149,35,-355,-674,-468,-228,-218,-103,242,177,-114,-140,-10,88,192,316,166,-184,-446,-374,-201,-77,-17,-123,-332,-596,-529,-148,182,171,-75,-216,-291,-241,-53,74,20,-144,-305,-356,-286,-129,26,37,-69,-201,-174,26,184,167,72,-31,-148,-161,-43,96,58,-45,-118,-168,-44}
        },
        {    // H0e095a.wav
            {-1,-1,-1,-1,-1,-1,-1,-1,0,-1,-1,-1,1,0,0,1,0,-3,-2,-2,-1,2,-4,2,6,11,9,13,-5,-6,2,226,777,551,-221,-25,843,1293,1065,805,1258,1692,327,-745,1235,3469,4120,3726,1991,26,-622,-561,-1590,-3032,-3204,-2725,-2435,-2095,-1360,-618,-324,17,576,953,1121,1131,977,649,378,205,-148,-545,-801,-825,-851,-1066,-1111,-915,-645,-434,-272,-68,81,167,195,143,85,49,24,-24,-121,-212,-278,-308,-318,-369,-396,-367,-290,-187,-118,-68,-32,-4,18,13,-1,-33,-52,-36,-60,-127,-168,-185,-197,-202,-187,-162,-152,-134,-101,-85,-75,-61,-70,-95,-120,-128,-114,-106,-118,-142,-159,-165,-163,-150,-103,-51,-32,-7},
            {-337,431,-559,4939,18393,-3304,-25514,-1853,13811,3343,747,20000,19405,-10383,-10129,11753,9342,-7410,-8325,-4031,-9694,-6855,1073,-3232,-9830,-6066,2108,2864,-362,2377,5593,3970,1658,2083,1717,-1842,-2228,-874,-1423,-2864,-3670,-2849,-2524,-1573,-87,326,-87,-362,376,859,805,933,1275,1071,287,-133,135,275,-413,-922,-1013,-1352,-1659,-1313,-460,-129,-327,-390,-85,335,361,496,808,728,288,-18,-22,-247,-437,-165,79,-267,-609,-451,-202,-177,-132,190,159,-128,-203,-78,75,166,300,177,-164,-409,-337,-162,-52,6,-114,-334,-577,-509,-160,144,153,-77,-246,-330,-247,-47,93,35,-169,-335,-368,-278,-111,52,57,-76,-203,-153,42,179,145,41,-45,-147,-180,-82,49,34,-31,-92,-145,-38}
        },
        {    // H0e100a.wav
            {1,0,-1,-1,0,0,0,0,0,0,0,0,1,2,1,3,2,1,1,-1,3,-1,0,5,10,5,13,13,9,-13,158,805,783,-177,-274,397,581,542,1028,1764,2145,2200,1001,-941,-294,2182,2902,2306,2005,1434,57,-798,-815,-1640,-2806,-2856,-2272,-1943,-1596,-890,-402,-227,156,728,1017,958,861,750,480,114,-157,-409,-627,-697,-746,-819,-886,-844,-671,-516,-367,-202,-53,54,62,49,82,95,80,21,-76,-172,-231,-245,-295,-375,-382,-296,-220,-200,-156,-83,-36,-30,-42,-36,-18,-15,-23,-31,-47,-85,-146,-201,-217,-202,-174,-151,-152,-165,-148,-100,-69,-65,-75,-85,-108,-124,-117,-115,-122,-122,-105,-107,-110,-97,-82,-56,-35,-7},
            {-206,177,-189,2599,17206,2516,-24823,-6513,13735,5166,-247,16671,20694,-7413,-12302,10747,12628,-5589,-9500,-3547,-8445,-7893,676,-2727,-10233,-6978,1034,3182,325,1646,5133,4154,1934,2063,1740,-1684,-2492,-889,-1207,-2453,-3518,-2867,-2084,-1406,-143,365,-85,-556,157,838,706,658,1053,1098,368,-179,47,331,-275,-827,-873,-1205,-1574,-1314,-461,-101,-313,-374,-121,250,287,428,737,691,276,-40,-2,-163,-409,-224,110,-148,-543,-435,-199,-148,-154,145,174,-125,-216,-131,12,117,279,232,-85,-358,-326,-154,-29,41,-87,-310,-561,-524,-179,124,160,-85,-263,-310,-238,-43,90,22,-179,-339,-343,-251,-132,23,72,-23,-143,-143,2,130,137,73,-33,-157,-208,-118,41,47,-17,-74,-120,-30}
        },
        {    // H0e105a.wav
            {1,0,2,2,0,1,2,-1,1,0,0,0,0,0,2,2,1,1,1,1,0,0,0,14,-2,8,17,8,10,95,786,1022,-55,-440,293,546,304,322,916,2349,3340,2189,543,2,-183,171,980,1226,1119,1207,1106,267,-722,-1045,-1302,-2028,-2351,-1777,-1266,-1158,-881,-464,-13,339,544,707,718,634,448,154,-143,-356,-425,-475,-566,-628,-633,-625,-619,-568,-426,-296,-248,-183,-85,11,52,80,91,16,-65,-117,-153,-213,-278,-270,-249,-245,-217,-176,-133,-111,-110,-92,-82,-67,-23,-15,-50,-67,-58,-75,-135,-172,-174,-170,-159,-165,-182,-182,-156,-110,-82,-86,-94,-86,-87,-113,-138,-135,-111,-76,-47,-47,-48,-62,-61,-56,-61,-14},
            {28,-207,345,334,13797,9833,-20690,-13571,11733,8332,-1055,11494,21891,-1529,-14322,6987,15909,-1354,-10645,-4222,-6427,-8825,-704,-1557,-9833,-8431,-621,3171,1210,971,4364,4450,2255,2050,2035,-1234,-2833,-938,-974,-2127,-3172,-3068,-2037,-1276,-188,330,-8,-477,-83,600,751,682,776,920,536,-80,-179,228,-97,-734,-828,-1062,-1377,-1287,-571,-53,-216,-382,-188,190,246,311,621,697,317,-85,-38,-73,-332,-289,73,-12,-470,-467,-226,-135,-149,78,197,-88,-247,-165,-35,48,238,279,8,-289,-341,-162,-30,50,-54,-286,-504,-547,-261,74,165,-34,-247,-290,-234,-124,25,49,-105,-279,-369,-307,-172,-7,111,37,-126,-185,-63,122,159,68,-53,-165,-197,-121,23,57,-5,-67,-93,-21}
        },
        {    // H0e110a.wav
            {0,0,1,1,0,2,0,0,0,0,0,-1,1,0,0,2,3,0,3,2,2,-6,9,8,-2,11,11,20,50,749,1276,124,-649,183,642,258,91,719,2106,2972,2341,1508,1011,353,-21,-514,-927,-243,501,643,877,963,444,-363,-776,-895,-1211,-1493,-1445,-1187,-1037,-793,-327,-49,89,273,446,456,249,66,-10,-130,-269,-318,-317,-368,-464,-479,-460,-464,-485,-505,-407,-295,-204,-74,-19,-7,4,-8,-35,-103,-134,-108,-118,-159,-191,-187,-167,-153,-131,-155,-178,-146,-103,-59,-73,-88,-80,-112,-118,-96,-82,-94,-116,-132,-166,-203,-199,-168,-144,-133,-118,-99,-100,-97,-113,-132,-123,-99,-69,-55,-23,-10,-2,-20,-47,-67,-103,-28},
            {246,-465,610,-674,8136,15246,-11239,-20243,5546,12026,186,4827,20716,6947,-13957,510,17119,5294,-10066,-6575,-4308,-8653,-3246,-525,-8088,-9908,-2996,2594,2093,565,3286,4685,2778,1957,2328,-91,-3108,-1646,-450,-1563,-2949,-3262,-2119,-1321,-381,300,85,-376,-190,461,683,689,772,821,530,47,-250,10,-53,-646,-809,-910,-1173,-1225,-698,-74,-63,-304,-303,65,274,236,464,670,433,-51,-138,-11,-212,-320,-33,70,-347,-528,-291,-122,-124,0,191,-10,-242,-202,-34,50,157,276,106,-183,-322,-197,-49,22,-29,-220,-426,-546,-361,-20,175,56,-176,-298,-311,-182,21,123,-13,-250,-400,-363,-182,0,82,17,-117,-168,-68,92,130,37,-39,-99,-152,-135,-5,76,31,-35,-76,-18}
        },
        {    // H0e115a.wav
            {1,1,1,2,2,1,3,1,0,1,0,2,1,0,0,4,0,3,1,7,0,-1,9,2,11,4,31,20,683,1530,396,-861,-11,731,289,-29,617,2276,3275,2249,1012,882,966,587,-367,-1160,-1287,-1133,-590,206,572,772,1104,830,-19,-292,-149,-639,-1351,-1452,-1041,-766,-782,-582,-265,-94,5,65,45,2,76,116,1,-125,-148,-154,-253,-343,-367,-424,-507,-533,-479,-354,-274,-227,-160,-114,-88,-91,-81,-35,11,25,-16,-95,-139,-110,-95,-136,-171,-172,-170,-164,-144,-119,-126,-160,-175,-152,-108,-82,-64,-45,-60,-117,-177,-203,-182,-159,-146,-127,-129,-124,-123,-130,-136,-122,-81,-52,-35,-35,-16,8,25,-6,-46,-89,-134,-34},
            {216,-276,223,-183,2390,14944,1893,-21081,-5204,12856,4874,-751,14598,15460,-8411,-6883,14049,12486,-5740,-9651,-3794,-6644,-5972,-1087,-5184,-10100,-6102,971,2851,632,1875,4541,3569,2007,2234,1328,-2303,-2844,-684,-634,-2310,-3519,-2481,-1315,-686,17,155,-163,-298,288,752,700,661,857,722,105,-321,-155,-63,-603,-892,-798,-927,-1134,-867,-175,64,-178,-312,-108,238,240,309,596,541,81,-200,-26,-82,-310,-180,47,-218,-556,-388,-148,-114,-89,131,100,-169,-210,-55,76,110,210,179,-56,-272,-250,-107,-20,-23,-165,-333,-513,-452,-128,141,112,-169,-308,-280,-170,11,104,12,-196,-341,-330,-237,-112,-10,8,-52,-128,-117,-6,83,64,17,-42,-113,-139,-37,90,80,1,-67,-20}
        },
        {    // H0e120a.wav
            {0,2,0,3,2,1,1,-1,0,0,1,1,2,-2,2,1,3,0,6,3,0,8,-5,18,-5,39,12,596,1749,746,-1028,-306,797,379,-192,566,2656,3673,2275,959,859,539,126,-140,-845,-1396,-1261,-1096,-1046,-569,249,871,1063,1104,1142,775,115,-277,-664,-1119,-1165,-975,-927,-926,-740,-518,-422,-377,-226,45,181,218,222,141,50,-20,-104,-267,-380,-392,-404,-426,-465,-456,-389,-326,-280,-278,-260,-127,23,72,65,52,29,-10,-52,-72,-74,-94,-137,-171,-182,-186,-188,-196,-231,-241,-204,-141,-93,-85,-52,-35,-72,-119,-155,-166,-158,-145,-135,-123,-129,-153,-169,-146,-117,-82,-51,-47,-33,-12,14,5,-3,-33,-67,-102,-145,-37},
            {-56,183,-349,475,-427,8731,12098,-12126,-15790,6787,10753,-852,4444,18195,3131,-10739,5921,16653,2632,-10445,-6240,-3873,-6806,-3641,-3070,-8000,-8506,-2302,2780,1525,533,3466,4383,2633,1814,2057,-322,-3111,-1877,-430,-1258,-3033,-3075,-1674,-900,-287,-51,-41,-154,47,660,843,667,720,907,440,-276,-418,-142,-388,-950,-912,-781,-933,-961,-449,78,-19,-230,-185,124,257,181,434,615,306,-135,-107,13,-237,-324,-99,-115,-486,-524,-242,-126,-147,9,165,-18,-166,-85,71,113,161,204,49,-184,-298,-185,-77,-44,-114,-268,-422,-483,-273,-25,52,-68,-198,-198,-178,-95,28,56,-56,-237,-358,-336,-216,-72,11,-41,-149,-186,-68,86,98,41,-9,-62,-103,-55,72,108,25,-44,-16}
        },
        {    // H0e125a.wav
            {2,1,2,1,1,1,-1,0,-1,0,-2,-2,-1,1,-2,1,-3,3,4,-7,10,-10,17,-8,30,16,515,1931,1146,-1163,-657,824,480,-305,507,3057,4225,2358,815,926,545,-143,-618,-1418,-1608,-1064,-996,-1088,-881,-591,43,664,921,1271,1604,1327,556,-91,-292,-439,-923,-1217,-1105,-1048,-1103,-1044,-891,-665,-302,19,188,270,341,378,256,25,-117,-175,-261,-315,-347,-396,-441,-469,-453,-442,-468,-391,-189,-47,4,24,52,82,46,5,17,25,-24,-92,-121,-164,-200,-194,-238,-292,-309,-253,-165,-150,-122,-72,-55,-76,-123,-135,-128,-123,-103,-104,-125,-147,-165,-153,-157,-141,-95,-63,-44,-49,-26,0,-3,-30,-46,-76,-96,-113,-141,-35},
            {-154,223,-234,135,-100,1838,12616,2913,-17273,-5688,11519,5402,-2662,10638,14618,-5111,-4205,13882,11975,-5528,-10105,-3387,-4598,-6266,-3600,-5100,-8282,-5957,533,2655,226,1556,4413,3707,1940,1722,1412,-1531,-2762,-1241,-808,-1967,-3027,-2261,-1335,-711,-214,-167,-63,0,429,866,803,660,863,784,57,-497,-363,-200,-703,-1056,-901,-817,-887,-713,-166,76,-75,-148,20,260,169,164,500,567,139,-156,-19,-118,-387,-320,-122,-319,-613,-441,-175,-138,-119,102,143,-38,-70,46,123,126,195,124,-84,-271,-283,-147,-73,-74,-202,-345,-480,-473,-220,39,75,-87,-197,-213,-152,-3,114,29,-205,-367,-354,-238,-154,-97,-91,-147,-177,-102,41,113,72,15,-13,-48,-45,22,100,68,-29,-16}
        },
        {    // H0e130a.wav
            {1,2,2,1,1,-2,1,-2,1,0,-1,-2,1,-2,3,0,-2,8,-6,10,-8,18,-6,25,22,449,2106,1584,-1258,-1073,799,601,-396,494,3563,4792,2387,730,1069,517,-395,-798,-1737,-2265,-1614,-1035,-942,-897,-496,138,210,213,936,1543,1335,1009,855,452,15,-281,-533,-889,-1267,-1334,-1316,-1402,-1226,-706,-291,-107,81,351,471,329,235,182,42,-98,-194,-250,-348,-419,-405,-427,-526,-551,-389,-215,-167,-149,-91,4,44,8,33,98,113,68,-22,-100,-141,-159,-161,-202,-285,-316,-290,-234,-175,-148,-121,-96,-96,-123,-156,-145,-94,-61,-51,-80,-133,-162,-166,-136,-114,-90,-74,-71,-51,-35,-28,-35,-50,-79,-92,-111,-106,-100,-122,-31},
            {47,-121,204,-305,372,-421,5307,11817,-5420,-15226,2465,11204,-15,-1076,14447,8793,-6891,3508,15951,4874,-9954,-7121,-1844,-5731,-6293,-3978,-6044,-7512,-3258,1923,1458,-119,2862,4690,2848,1399,1686,670,-1996,-2141,-1088,-1343,-2364,-2543,-1658,-1245,-769,-248,-80,-39,190,720,940,753,724,899,524,-232,-504,-214,-335,-912,-1025,-875,-842,-845,-509,-16,60,-51,-42,192,286,107,216,526,475,44,-98,-36,-298,-482,-302,-191,-477,-622,-354,-150,-158,-25,209,142,-10,15,134,150,146,167,31,-172,-308,-222,-82,-64,-170,-356,-458,-460,-309,-61,50,-50,-165,-159,-77,-10,26,20,-101,-245,-332,-316,-232,-189,-149,-104,-122,-130,-36,100,128,51,32,21,-13,-17,67,99,-14,-17}
        },
        {    // H0e135a.wav
            {3,1,-1,0,-2,0,-2,0,-2,-1,-3,2,-1,-1,0,-3,9,-9,10,-13,16,-2,13,35,398,2256,2024,-1311,-1512,728,698,-500,561,4186,5359,2342,605,1243,577,-662,-1052,-1967,-2731,-2023,-1256,-1267,-1167,-450,421,516,331,716,1064,972,826,759,701,647,357,-87,-370,-643,-1107,-1523,-1610,-1417,-1063,-740,-463,-153,52,194,325,356,325,260,101,-57,-152,-259,-354,-413,-434,-419,-393,-359,-282,-220,-229,-195,-138,-111,-64,21,122,142,78,9,-50,-117,-150,-122,-138,-219,-281,-278,-226,-199,-200,-170,-139,-150,-166,-172,-158,-118,-63,-31,-59,-116,-153,-142,-118,-99,-68,-46,-62,-83,-81,-62,-61,-96,-115,-133,-128,-117,-103,-91,-107,-27},
            {62,-69,38,31,-146,238,80,7898,8373,-9999,-10456,7288,7999,-3821,2355,15565,4164,-4967,9137,13938,-1795,-10527,-3548,-1990,-7308,-6128,-3945,-6525,-6195,-1019,1966,373,368,3837,4416,2004,1143,1575,33,-1995,-1614,-1169,-1776,-2337,-2052,-1436,-1280,-826,-243,-72,3,400,890,933,725,786,796,291,-297,-365,-183,-532,-977,-918,-826,-874,-774,-354,4,22,-14,69,284,279,150,309,468,268,-61,-46,-94,-435,-517,-294,-304,-597,-565,-258,-133,-117,100,262,122,25,100,177,127,122,113,-50,-206,-232,-162,-166,-217,-260,-314,-379,-398,-283,-111,-20,-46,-66,-54,-54,-26,7,-25,-154,-299,-350,-305,-221,-158,-113,-99,-124,-81,41,126,108,61,52,32,-17,-14,44,30,0}
        },
        {    // H0e140a.wav
            {1,-1,0,-3,0,-2,0,-1,0,-3,0,0,-1,2,-4,9,-9,12,-13,12,0,9,43,371,2434,2444,-1363,-1953,642,809,-622,665,4931,5930,2230,502,1424,567,-907,-1233,-2223,-3197,-2371,-1397,-1433,-1420,-728,369,731,573,1039,1361,807,289,416,549,422,363,426,271,-284,-766,-1015,-1339,-1476,-1156,-844,-703,-585,-371,-18,143,217,341,310,173,64,-9,-165,-335,-348,-261,-254,-339,-319,-204,-191,-248,-267,-237,-192,-154,-72,43,101,70,19,-42,-119,-124,-80,-90,-173,-228,-193,-157,-173,-191,-186,-174,-192,-211,-194,-176,-130,-70,-44,-84,-140,-140,-121,-84,-36,-5,-22,-68,-100,-96,-82,-95,-125,-147,-138,-148,-133,-107,-86,-81,-107,-28},
            {-61,92,-112,99,-80,14,9,1029,8963,4714,-11392,-5578,8991,3661,-5231,5998,14960,1540,-1730,11938,9697,-6073,-8397,-1126,-3652,-8465,-5239,-4011,-6713,-4614,300,1434,-209,1279,4382,3601,1457,1179,1279,-413,-1800,-1286,-1276,-1819,-2119,-1862,-1434,-1277,-764,-345,-193,98,602,951,821,720,852,724,185,-260,-270,-255,-669,-959,-795,-714,-790,-733,-337,-23,-37,7,173,352,272,186,350,346,33,-174,-42,-132,-483,-524,-324,-399,-606,-440,-151,-105,-102,140,263,130,86,133,125,61,106,109,-63,-239,-273,-186,-153,-187,-270,-368,-445,-428,-251,-50,10,-50,-59,-21,-16,-38,-67,-124,-228,-303,-300,-237,-175,-157,-123,-95,-81,-21,64,119,94,59,40,-10,-49,-18,29,8}
        },
        {    // H0e145a.wav
            {-1,-2,-5,-1,-4,0,-2,-1,-3,-2,0,-1,1,-5,9,-14,14,-14,8,2,-3,49,365,2647,2841,-1469,-2405,556,919,-748,851,5818,6434,1957,467,1715,458,-1290,-1394,-2389,-3648,-2753,-1495,-1557,-1679,-833,432,656,503,1282,1671,1008,420,284,154,52,96,161,230,112,-280,-775,-1054,-962,-774,-756,-841,-772,-521,-285,-124,11,110,155,114,46,-29,-160,-186,-95,-104,-221,-278,-211,-128,-140,-219,-260,-243,-216,-202,-164,-81,-13,-5,-34,-69,-107,-116,-80,-85,-141,-170,-134,-99,-124,-156,-150,-146,-190,-228,-215,-194,-157,-111,-107,-137,-167,-166,-128,-52,24,40,-1,-78,-126,-125,-106,-105,-134,-150,-162,-163,-157,-115,-91,-85,-97,-126,-32},
            {12,-48,69,-96,106,-118,96,-106,1923,8954,1885,-10785,-1634,8153,-224,-4495,8753,13545,693,1390,12044,5229,-7416,-5450,-602,-5809,-8404,-4204,-4516,-6299,-3154,594,911,-180,2169,4458,2690,1098,1243,1099,-718,-1680,-1038,-1194,-1615,-1948,-1754,-1495,-1372,-718,-454,-320,136,688,958,765,725,905,758,184,-240,-233,-329,-753,-843,-638,-637,-722,-637,-311,-135,-68,81,236,323,184,160,312,268,-71,-274,-140,-218,-448,-421,-297,-424,-542,-313,-91,-106,-82,151,232,127,108,129,81,19,59,27,-89,-144,-134,-138,-224,-301,-360,-396,-410,-352,-194,-50,0,-26,-29,-38,-72,-103,-125,-153,-203,-228,-228,-208,-185,-151,-87,-50,-40,0,71,91,56,25,4,-25,-44,-20,0}
        },
        {    // H0e150a.wav
            {0,-4,0,-2,-2,-3,-1,-5,-1,-1,-1,4,-7,11,-16,13,-16,11,5,-9,51,374,2901,3210,-1613,-2843,459,1029,-858,1097,6827,6890,1555,446,2085,380,-1770,-1635,-2512,-4061,-3102,-1562,-1686,-1896,-903,490,708,523,1336,1793,1109,443,439,357,-126,-325,-151,-25,-191,-388,-448,-649,-710,-457,-382,-486,-558,-507,-337,-290,-247,-126,-64,-127,-245,-201,-70,3,1,-40,-90,-181,-163,-63,-71,-138,-182,-174,-197,-258,-208,-93,-78,-152,-152,-111,-147,-158,-92,-63,-114,-142,-102,-78,-115,-108,-63,-88,-140,-164,-184,-197,-178,-156,-160,-203,-224,-185,-116,-38,28,53,-4,-94,-149,-139,-100,-87,-106,-145,-165,-169,-148,-119,-95,-102,-111,-112,-110,-24},
            {11,1,-29,52,-86,100,-124,118,-125,2503,8424,166,-9136,656,5843,-2494,-2704,10083,12136,1191,3424,10316,2085,-6635,-3256,-1594,-7259,-7394,-3777,-4998,-5414,-2219,358,556,329,2815,4077,1981,907,1296,864,-891,-1423,-973,-1073,-1226,-1718,-1716,-1654,-1495,-750,-544,-425,93,687,937,786,752,922,806,233,-220,-231,-329,-705,-743,-592,-585,-636,-543,-231,-131,-81,57,139,163,72,120,226,131,-117,-219,-142,-284,-463,-329,-201,-364,-434,-229,-92,-139,-87,136,176,105,114,75,-40,-43,105,126,9,-112,-178,-219,-282,-313,-357,-395,-382,-289,-141,-62,-57,-62,-51,-72,-115,-128,-107,-111,-153,-190,-211,-192,-161,-110,-47,-25,-22,-6,36,42,14,7,-6,-50,-68,-15}
        },
        {    // H0e155a.wav
            {-4,-1,-3,-1,0,-1,-4,1,1,0,3,-6,12,-18,16,-16,10,8,-7,48,405,3190,3528,-1806,-3245,382,1105,-958,1446,7893,7254,1071,484,2476,266,-2254,-1951,-2634,-4409,-3494,-1606,-1746,-2128,-941,631,721,490,1506,1970,1098,377,430,416,-37,-279,-303,-381,-514,-628,-690,-720,-572,-223,6,-54,-154,-159,-172,-264,-293,-224,-301,-506,-521,-267,-119,-154,-66,41,-15,-116,-106,18,46,-60,-119,-116,-148,-198,-168,-103,-122,-173,-195,-239,-303,-258,-84,-16,-116,-160,-118,-80,-74,-66,-23,-15,-56,-92,-133,-184,-195,-164,-165,-212,-243,-218,-149,-60,10,15,-65,-157,-175,-125,-64,-50,-79,-122,-158,-159,-133,-110,-100,-108,-131,-134,-107,-61,-9},
            {-12,20,-8,-20,43,-78,101,-129,135,-112,2745,7718,-461,-7209,1208,3323,-3043,-975,10116,11261,2431,4076,7958,680,-4974,-2363,-3108,-7481,-6251,-4005,-5069,-4443,-1814,26,441,927,3085,3475,1591,1016,1207,448,-822,-1043,-965,-1000,-929,-1340,-1605,-1899,-1625,-849,-682,-461,111,648,825,777,870,994,766,222,-84,-100,-354,-691,-631,-527,-534,-534,-428,-186,-99,-77,-78,-59,-17,-67,-1,120,111,-51,-93,-43,-277,-473,-323,-144,-216,-274,-193,-165,-179,-83,107,88,-6,25,69,74,78,111,61,-40,-114,-162,-223,-282,-314,-320,-296,-313,-294,-226,-145,-83,-68,-47,-68,-110,-113,-91,-90,-120,-153,-168,-158,-120,-72,-36,-17,-20,-4,6,-5,-19,-19,-16,-39,-13}
        },
        {    // H0e160a.wav
            {-2,-3,0,-3,-2,-5,0,1,3,3,-5,13,-19,18,-20,15,3,-3,50,468,3537,3753,-2076,-3569,316,1146,-1038,1905,9036,7493,515,619,2870,74,-2724,-2289,-2854,-4688,-3808,-1723,-1814,-2332,-918,836,734,489,1625,2090,1206,381,357,370,-144,-349,-190,-364,-782,-873,-894,-1138,-864,-106,309,248,98,175,251,47,-158,-263,-408,-504,-519,-525,-475,-306,-110,-48,-167,-226,-27,163,115,-7,-36,-31,-84,-148,-132,-38,-34,-160,-248,-318,-390,-336,-174,-88,-146,-190,-120,-62,-80,-45,34,56,10,-70,-133,-172,-142,-97,-116,-175,-243,-242,-178,-101,-48,-71,-153,-233,-226,-131,-35,-9,-34,-88,-136,-139,-112,-84,-95,-125,-151,-153,-124,-65,5,8},
            {15,-18,21,-10,-15,34,-72,96,-128,143,-104,2712,7022,-221,-5604,509,1450,-2462,63,9306,11060,3844,3617,5782,641,-3368,-2602,-4226,-6782,-5635,-4476,-4709,-3583,-1838,-303,772,1247,2722,3058,1686,1094,863,283,-630,-915,-829,-829,-860,-1137,-1359,-1912,-1867,-1106,-707,-353,112,475,657,795,949,1036,784,259,-12,-71,-303,-584,-539,-415,-435,-469,-399,-252,-193,-156,-166,-223,-222,-185,-89,73,164,60,2,-5,-188,-362,-304,-167,-183,-176,-131,-190,-276,-230,-18,72,67,91,69,38,46,62,24,-39,-102,-143,-192,-231,-239,-258,-286,-355,-369,-299,-200,-100,-38,-19,-64,-117,-114,-89,-70,-65,-92,-138,-146,-115,-62,-15,2,-14,-50,-49,-46,-46,-21,-23,-8}
        },
        {    // H0e165a.wav
            {-4,2,-2,-2,-4,1,-1,1,2,-5,12,-23,17,-24,17,-5,4,45,572,3916,3878,-2394,-3799,279,1123,-1080,2457,10124,7638,-17,813,3241,-184,-3180,-2582,-3126,-5015,-4054,-1804,-1889,-2538,-948,1088,832,468,1772,2202,1197,428,410,303,-285,-458,-256,-377,-757,-1076,-1258,-1200,-827,-360,22,267,396,467,446,290,119,54,-28,-355,-696,-693,-545,-428,-340,-326,-336,-292,-118,55,106,80,47,83,25,-93,-31,74,15,-159,-246,-292,-402,-392,-238,-183,-271,-262,-132,-71,-61,13,83,59,-8,-71,-115,-127,-86,-19,-18,-114,-210,-241,-220,-170,-140,-137,-196,-292,-293,-183,-46,13,-7,-46,-94,-104,-77,-66,-83,-119,-149,-164,-144,-82,-11,22,6},
            {-7,16,-19,20,-11,-13,24,-60,86,-116,132,-92,2482,6427,548,-4551,-733,455,-1456,336,8144,11358,5087,2536,4132,1381,-2285,-3321,-4577,-5867,-5510,-4775,-4135,-2967,-2029,-549,1149,1431,2131,2590,1960,1337,570,153,-384,-870,-787,-574,-707,-1196,-1421,-1662,-1728,-1380,-880,-211,176,240,485,813,993,1024,738,340,92,-64,-245,-405,-380,-313,-341,-512,-574,-396,-288,-277,-323,-289,-208,-228,-147,79,243,169,78,22,-178,-284,-179,-99,-194,-291,-265,-219,-245,-217,-46,63,94,68,-7,-57,-41,43,84,47,-42,-112,-162,-201,-231,-267,-309,-379,-402,-349,-224,-99,-45,-31,-64,-103,-102,-63,-23,-29,-82,-127,-135,-106,-43,0,0,-46,-90,-93,-78,-56,-37,-8}
        },
        {    // H0e170a.wav
            {1,-1,-1,-6,3,-3,2,0,-1,11,-24,20,-29,25,-17,13,34,741,4340,3836,-2779,-3891,282,1021,-1073,3160,11114,7627,-437,1094,3508,-502,-3620,-2882,-3377,-5331,-4342,-1902,-1926,-2655,-946,1247,927,548,1912,2335,1221,364,397,302,-322,-537,-293,-500,-1171,-1213,-1002,-1187,-1013,-513,-86,150,250,465,521,407,532,646,288,-276,-525,-518,-569,-640,-571,-457,-502,-553,-318,-29,51,42,42,63,73,74,130,180,86,-86,-205,-316,-428,-406,-236,-186,-316,-356,-226,-106,-69,20,96,34,-51,-74,-60,-44,-16,29,30,-45,-133,-213,-263,-257,-211,-188,-255,-343,-331,-199,-58,-6,-17,-38,-60,-64,-40,-26,-55,-114,-141,-147,-136,-104,-39,-1,-36,-14},
            {6,-8,14,-12,18,-9,-12,22,-49,70,-93,108,-72,2117,5950,1523,-3985,-1986,131,-511,79,6937,11862,6053,1288,3038,2327,-1718,-3951,-4398,-5091,-5562,-4913,-3519,-2531,-2307,-650,1407,1415,1649,2254,2028,1438,769,144,-500,-663,-693,-565,-567,-1188,-1523,-1603,-1476,-1193,-951,-422,107,306,449,707,851,872,780,479,197,48,-133,-293,-309,-302,-390,-607,-739,-578,-379,-351,-401,-335,-174,-95,-19,142,259,210,109,41,-120,-292,-254,-131,-135,-241,-329,-291,-250,-185,-32,37,17,-63,-87,-34,8,79,121,111,33,-87,-173,-233,-266,-268,-292,-362,-426,-396,-248,-100,-31,-38,-72,-81,-64,-27,-2,-20,-67,-105,-111,-92,-57,-16,-16,-67,-121,-119,-90,-71,-15}
        },
        {    // H0e175a.wav
            {-1,-1,-6,4,-3,3,-3,3,8,-23,23,-32,32,-31,29,15,986,4761,3601,-3140,-3815,294,852,-993,3973,11854,7459,-588,1456,3604,-850,-3964,-3217,-3681,-5514,-4604,-2139,-1995,-2666,-860,1359,1003,651,1985,2452,1338,308,311,276,-320,-528,-535,-780,-1064,-1197,-1278,-1286,-919,-479,-184,45,101,179,394,721,947,736,387,110,-126,-310,-569,-654,-553,-594,-758,-782,-495,-172,-38,-32,-34,38,79,98,204,305,206,-7,-143,-293,-425,-377,-209,-181,-324,-350,-247,-187,-161,-52,60,22,-54,-54,-19,7,48,94,89,-2,-127,-209,-260,-268,-246,-251,-318,-390,-356,-212,-69,-14,-22,-50,-55,-49,-18,9,-21,-71,-132,-150,-135,-95,-52,-27,-51,-106,-30},
            {-7,4,-5,11,-9,11,-4,-14,19,-42,55,-70,80,-43,1711,5549,2413,-3689,-2919,156,169,-360,5852,12229,6695,241,2367,3069,-1443,-4246,-3992,-4494,-5636,-4894,-2927,-2294,-2529,-658,1511,1217,1243,2161,2114,1380,697,397,-176,-835,-743,-385,-598,-1185,-1447,-1540,-1474,-1034,-633,-406,-165,181,564,617,555,770,870,656,309,79,-44,-303,-431,-374,-465,-725,-861,-679,-463,-372,-304,-217,-113,-39,101,309,351,181,23,-49,-180,-319,-272,-118,-102,-213,-304,-315,-319,-265,-90,20,13,-47,-68,-32,11,94,160,148,46,-92,-201,-264,-266,-256,-295,-383,-434,-385,-241,-101,-39,-33,-65,-76,-55,-16,19,9,-43,-102,-128,-118,-74,-42,-31,-79,-126,-119,-101,-22}
        },
        {    // H0e180a.wav
            {-2,-6,5,-5,6,-6,6,2,-20,20,-36,42,-50,51,-13,1314,5166,3131,-3449,-3526,253,600,-765,4872,12260,7150,-396,1876,3489,-1191,-4210,-3566,-4059,-5625,-4774,-2483,-2126,-2633,-730,1471,1071,901,2067,2314,1397,470,306,194,-481,-869,-544,-530,-1144,-1372,-1380,-1443,-1040,-437,-101,-109,-159,251,710,684,675,828,722,347,-25,-217,-341,-457,-533,-633,-813,-888,-627,-343,-271,-209,-63,40,34,94,271,376,220,-34,-132,-217,-324,-297,-176,-142,-268,-346,-286,-268,-263,-132,38,66,-30,-71,-54,5,103,171,150,10,-131,-208,-251,-265,-273,-291,-353,-415,-373,-231,-87,-29,-37,-50,-66,-47,-7,23,11,-54,-110,-144,-135,-100,-42,-27,-73,-119,-125,-28},
            {-2,-6,5,-5,6,-6,6,2,-20,20,-36,42,-50,51,-13,1314,5166,3131,-3449,-3526,253,600,-765,4872,12260,7150,-396,1876,3489,-1191,-4210,-3566,-4059,-5625,-4774,-2483,-2126,-2633,-730,1471,1071,901,2067,2314,1397,470,306,194,-481,-869,-544,-530,-1144,-1372,-1380,-1443,-1040,-437,-101,-109,-159,251,710,684,675,828,722,347,-25,-217,-341,-457,-533,-633,-813,-888,-627,-343,-271,-209,-63,40,34,94,271,376,220,-34,-132,-217,-324,-297,-176,-142,-268,-346,-286,-268,-263,-132,38,66,-30,-71,-54,5,103,171,150,10,-131,-208,-251,-265,-273,-291,-353,-415,-373,-231,-87,-29,-37,-50,-66,-47,-7,23,11,-54,-110,-144,-135,-100,-42,-27,-73,-119,-125,-28}
        }
    },
    {    // elev10 
        {    // H10e000a.wav
            {6,-6,10,4,-11,33,-61,78,-89,77,-51,13,29,1568,7786,2398,-5535,381,-3005,-4114,6762,5453,4107,12156,10101,-3052,-5461,2934,-1036,-12098,-10035,-1734,-2584,-6284,-1675,2213,106,843,3539,2920,1178,1879,2849,1403,-87,104,709,-324,-1291,-673,-533,-1726,-2854,-2131,-744,-261,-281,-316,-443,-466,-10,305,176,-111,-45,224,217,-57,-253,-70,-165,-526,-592,-585,-652,-414,-10,-38,-229,-117,39,-61,-96,92,126,-99,-269,-269,-220,-171,-180,-169,-132,-184,-229,-155,-38,-3,-13,2,-36,-124,-128,-11,31,-64,-83,-106,-230,-297,-258,-227,-200,-126,-125,-162,-89,64,157,176,106,-34,-110,-123,-137,-145,-117,-151,-239,-204,-111,-67,-28,-25,-104,-161,-116,-69,-59,-14},
            {6,-6,10,4,-11,33,-61,78,-89,77,-51,13,29,1568,7786,2398,-5535,381,-3005,-4114,6762,5453,4107,12156,10101,-3052,-5461,2934,-1036,-12098,-10035,-1734,-2584,-6284,-1675,2213,106,843,3539,2920,1178,1879,2849,1403,-87,104,709,-324,-1291,-673,-533,-1726,-2854,-2131,-744,-261,-281,-316,-443,-466,-10,305,176,-111,-45,224,217,-57,-253,-70,-165,-526,-592,-585,-652,-414,-10,-38,-229,-117,39,-61,-96,92,126,-99,-269,-269,-220,-171,-180,-169,-132,-184,-229,-155,-38,-3,-13,2,-36,-124,-128,-11,31,-64,-83,-106,-230,-297,-258,-227,-200,-126,-125,-162,-89,64,157,176,106,-34,-110,-123,-137,-145,-117,-151,-239,-204,-111,-67,-28,-25,-104,-161,-116,-69,-59,-14}
        },
        {    // H10e005a.wav
            {-4,4,-4,4,8,-13,29,-50,61,-69,46,-20,-14,50,1203,6675,2906,-4588,131,-2247,-4204,5306,5135,3682,10663,9784,-1237,-4561,2070,-595,-10170,-9259,-2429,-2537,-5482,-1898,1607,52,658,2920,2468,1293,1900,2489,1186,2,260,794,-13,-900,-641,-576,-1323,-2312,-2070,-960,-602,-694,-301,-48,-214,-23,269,351,136,-106,-224,-261,-210,-296,-255,-318,-529,-475,-441,-522,-331,-15,-21,-190,-129,51,7,-65,14,74,-22,-185,-228,-255,-259,-207,-185,-156,-178,-209,-127,-25,9,9,29,-8,-140,-160,-29,8,-82,-116,-123,-204,-262,-213,-199,-242,-202,-160,-147,-91,23,136,187,142,10,-81,-104,-116,-136,-124,-152,-218,-186,-125,-92,-58,-26,-93,-162,-131,-89,-18},
            {2,1,14,-27,51,-74,78,-82,48,7,-78,126,1002,8144,4352,-6410,-539,-2430,-5262,6854,6474,3904,12707,11743,-2705,-7073,2481,100,-12135,-11597,-2685,-1940,-6312,-2685,2192,413,726,3584,3417,1468,1583,2956,1986,318,74,613,-195,-1444,-947,-811,-2035,-2882,-2268,-1042,-143,155,-74,-685,-919,-227,167,-127,-371,200,752,498,161,-10,115,11,-424,-607,-661,-773,-565,-104,-67,-238,-158,-56,-168,-148,73,141,-52,-264,-253,-193,-131,-97,-108,-97,-173,-270,-223,-90,-41,-42,-2,-25,-163,-198,-21,74,-4,-45,-108,-257,-320,-222,-160,-173,-115,-105,-148,-91,47,158,175,90,-56,-147,-148,-150,-158,-125,-166,-260,-229,-134,-73,-3,42,-60,-173,-132,-73,-52,0,8}
        },
        {    // H10e010a.wav
            {-3,-2,5,-5,5,7,-10,24,-39,51,-60,42,-17,-2,41,1112,5902,2733,-3745,-57,-2006,-3536,4202,4586,4019,9483,8718,-140,-3456,1196,-831,-8332,-8298,-3046,-2428,-4520,-1895,966,167,726,2262,2060,1521,1852,1876,967,305,421,789,151,-680,-611,-649,-1234,-1859,-1694,-1114,-869,-675,-147,126,-110,-108,112,264,184,-114,-451,-528,-380,-365,-332,-405,-511,-370,-293,-412,-344,-56,2,-124,-95,12,-3,-34,33,90,11,-124,-215,-292,-285,-244,-213,-159,-172,-199,-125,-13,19,5,16,-6,-107,-173,-91,-30,-75,-95,-126,-210,-247,-189,-182,-244,-223,-175,-147,-76,35,119,158,125,32,-51,-99,-137,-150,-113,-127,-188,-181,-126,-96,-56,-35,-99,-166,-145,-29},
            {-4,28,-39,63,-79,75,-65,16,65,-147,209,638,8308,6084,-6837,-1680,-2152,-6059,7068,7298,3712,13846,13069,-3121,-8112,2311,271,-12584,-11986,-3055,-2289,-6309,-2704,2028,46,765,3913,3459,1668,1689,2853,2143,784,465,637,-173,-1354,-1343,-1458,-2088,-2740,-2495,-1222,-124,267,158,-533,-1148,-756,-349,-265,-100,435,805,641,473,252,318,194,-346,-564,-633,-809,-658,-193,-114,-300,-231,-110,-232,-266,-38,138,3,-197,-185,-162,-95,1,11,-30,-181,-319,-299,-194,-85,-18,15,-48,-217,-235,-44,98,30,-67,-129,-239,-270,-159,-94,-121,-76,-77,-151,-106,42,138,153,92,-68,-171,-175,-168,-169,-128,-164,-287,-270,-167,-90,11,93,5,-120,-116,-78,-67,-16,39,10}
        },
        {    // H10e015a.wav
            {-1,-3,-3,3,-4,4,7,-10,22,-31,38,-47,33,-8,-3,37,907,5113,2875,-3079,-404,-1423,-3181,2991,4442,4052,8086,8039,1082,-2792,289,-419,-6492,-7801,-3538,-1962,-3747,-2263,494,397,509,1527,1917,1751,1439,1393,1221,655,382,715,364,-472,-594,-684,-1250,-1570,-1208,-1033,-1078,-556,65,-20,-378,-267,-13,87,25,-138,-371,-506,-450,-424,-370,-391,-427,-318,-283,-387,-325,-62,2,-106,-65,24,-32,-40,58,95,10,-116,-201,-273,-265,-220,-195,-159,-171,-192,-137,-49,-7,-17,-8,-14,-107,-162,-104,-46,-53,-79,-121,-203,-243,-206,-185,-191,-160,-149,-147,-87,15,99,117,91,13,-52,-83,-123,-136,-102,-114,-176,-164,-120,-92,-87,-56,-83,-148,-38},
            {38,-52,70,-76,55,-25,-48,146,-238,310,176,7789,8522,-6368,-3805,-1673,-6576,6100,8491,3898,14067,15078,-2315,-9737,1409,1088,-12598,-13209,-3561,-1771,-6518,-3443,2421,96,29,4101,3846,1630,1728,2968,2138,965,939,986,112,-1610,-2061,-1477,-1741,-2938,-2838,-1389,-277,166,312,-180,-1376,-1561,-798,93,446,440,629,650,707,505,407,303,-216,-449,-560,-831,-715,-213,-151,-408,-343,-155,-300,-405,-127,111,50,-138,-163,-121,-51,83,111,49,-139,-381,-413,-248,-93,-29,-14,-90,-252,-295,-105,65,-5,-61,-80,-199,-234,-109,-24,-67,-58,-62,-140,-129,5,119,149,80,-100,-211,-211,-180,-174,-138,-164,-299,-310,-205,-107,2,105,43,-87,-105,-67,-61,-27,25,-28,-16}
        },
        {    // H10e020a.wav
            {0,0,-2,-1,2,-2,4,7,-9,20,-26,29,-30,16,6,-13,43,651,4324,3137,-2505,-706,-785,-3030,1949,4366,3790,6771,7619,2153,-2365,-320,246,-4953,-7417,-3717,-1472,-3315,-2624,249,478,52,1012,1985,1637,1017,1405,1474,691,348,844,557,-440,-635,-675,-1022,-1118,-977,-1032,-997,-504,-123,-343,-665,-496,-177,-42,-96,-126,-119,-256,-427,-494,-350,-302,-417,-385,-328,-335,-227,-62,-46,-94,-45,3,-61,-92,-3,80,38,-71,-148,-202,-198,-183,-194,-172,-170,-199,-188,-120,-55,-33,-18,-27,-89,-154,-115,-38,-51,-84,-105,-163,-225,-209,-161,-137,-112,-116,-140,-121,-33,59,94,57,-14,-63,-73,-92,-124,-106,-106,-145,-156,-115,-109,-96,-53,-79,-25},
            {-39,59,-55,12,33,-123,217,-294,341,-137,6406,10837,-4225,-6276,-1765,-6300,4523,8651,4393,14344,16324,-275,-9774,-687,1133,-11224,-14066,-5705,-1463,-5094,-4540,1632,955,-178,3454,3963,1988,1603,2892,2420,1036,1206,1510,338,-2038,-2287,-1037,-1552,-2976,-3077,-1997,-620,195,276,-186,-1610,-2128,-799,795,832,217,549,784,811,551,279,309,7,-314,-477,-730,-769,-255,-40,-435,-505,-266,-341,-451,-242,87,150,-103,-199,-116,7,136,181,111,-136,-370,-368,-231,-138,-92,-38,-74,-298,-411,-234,-28,20,4,-19,-130,-189,-64,40,-24,-52,-46,-114,-148,-46,103,149,84,-110,-230,-226,-218,-196,-152,-135,-264,-328,-241,-133,6,128,79,-86,-132,-83,-34,-6,23,-19,-84,-22}
        },
        {    // H10e025a.wav
            {-5,-1,1,-2,-1,2,1,1,9,-10,17,-21,21,-17,2,23,-25,60,390,3535,3394,-1915,-948,-230,-2891,1075,4171,3390,5662,7243,2987,-1908,-635,826,-3691,-6823,-3723,-1277,-2970,-2779,-15,314,-346,819,1905,1383,907,1371,1479,875,536,817,436,-366,-419,-459,-688,-778,-967,-1239,-1015,-503,-463,-761,-956,-680,-247,-95,-68,10,72,-31,-260,-470,-425,-295,-363,-428,-343,-261,-194,-85,-90,-138,-117,-95,-116,-129,-39,96,123,16,-87,-134,-161,-173,-168,-166,-204,-256,-249,-165,-87,-57,-28,-29,-97,-149,-117,-48,-43,-74,-81,-127,-179,-165,-144,-136,-116,-105,-122,-129,-55,23,42,27,-45,-84,-87,-95,-89,-94,-88,-120,-141,-119,-117,-100,-67,-14},
            {19,-5,-45,94,-179,237,-265,261,-191,4422,12389,-223,-8560,-3255,-5641,2888,8588,4491,14321,18173,1917,-9004,-2080,165,-10018,-13615,-8096,-3111,-3615,-4104,346,923,125,3452,3864,1936,1810,2751,2443,1288,1348,1610,-60,-2157,-1464,-784,-1662,-2457,-3159,-2822,-1137,351,173,-989,-2070,-1823,-195,886,772,436,660,856,791,461,194,253,105,-144,-427,-730,-711,-266,-88,-423,-531,-437,-455,-446,-228,154,229,-43,-201,-118,36,119,119,28,-124,-256,-289,-263,-202,-74,-5,-88,-332,-498,-379,-100,55,48,5,-87,-123,-43,25,-6,3,-18,-138,-173,-69,89,129,65,-79,-225,-258,-253,-225,-165,-142,-241,-324,-265,-143,10,140,91,-70,-139,-113,-77,-21,23,-6,-89,-131,-33}
        },
        {    // H10e030a.wav
            {-4,-2,-1,0,-3,-1,1,1,-2,9,-11,14,-14,7,0,-13,28,-28,60,175,2744,3516,-1207,-1153,136,-2602,267,3780,3055,4710,6758,3637,-1284,-787,1142,-2479,-5981,-3798,-1257,-2554,-2838,-403,78,-441,741,1560,1122,897,1339,1620,1070,456,622,583,65,-200,-290,-354,-775,-1387,-1430,-922,-694,-939,-1084,-1026,-689,-254,-30,51,123,207,143,-113,-405,-421,-277,-313,-373,-326,-279,-240,-182,-162,-217,-260,-185,-124,-91,18,131,156,61,-21,-67,-122,-150,-191,-201,-233,-291,-267,-210,-137,-74,-50,-38,-79,-151,-130,-49,-30,-46,-61,-99,-135,-128,-124,-146,-122,-96,-118,-124,-86,-49,-30,-24,-46,-96,-110,-80,-68,-48,-63,-112,-145,-138,-123,-118,-27},
            {42,-94,129,-176,184,-148,91,-38,2334,12155,4994,-8716,-6054,-5175,1601,7942,4417,13557,19373,4592,-7227,-2684,-531,-9205,-12946,-9640,-5383,-3342,-3723,-337,1230,-102,2980,4447,2243,1480,2638,2665,1528,1429,788,-412,-1084,-986,-762,-1189,-2085,-3252,-3258,-1568,29,-374,-1928,-2294,-822,433,488,612,927,1128,840,497,380,220,202,59,-113,-400,-739,-612,-267,-116,-267,-500,-540,-587,-491,-90,220,258,14,-119,-33,-14,2,17,29,-41,-212,-261,-212,-170,-86,-33,-110,-319,-498,-412,-139,34,80,72,-37,-118,-80,27,72,49,2,-128,-179,-91,41,127,95,-41,-197,-283,-271,-211,-143,-114,-214,-307,-283,-159,12,147,143,-16,-127,-140,-98,-32,20,-9,-92,-122,-93,-16}
        },
        {    // H10e035a.wav
            {-4,-2,-1,-3,2,-3,-1,0,1,-4,7,-9,9,-8,0,12,-29,36,-30,52,53,1958,3466,-382,-1318,334,-2128,-469,3240,2820,3866,6114,4143,-498,-856,1264,-1323,-5030,-3875,-1349,-2135,-2806,-798,5,-375,344,1065,1164,1035,1215,1515,1126,613,756,880,401,-134,-339,-471,-991,-1595,-1556,-1113,-983,-1119,-1153,-995,-581,-187,32,151,220,283,246,57,-265,-365,-236,-257,-360,-401,-379,-350,-301,-260,-296,-317,-212,-79,-25,44,156,188,107,28,-34,-85,-155,-245,-248,-229,-273,-303,-243,-159,-105,-61,-43,-82,-147,-124,-44,-32,-49,-36,-45,-84,-105,-98,-108,-129,-133,-149,-153,-126,-99,-69,-40,-51,-82,-95,-68,-32,-44,-55,-116,-149,-129,-129,-31},
            {-91,114,-132,73,0,-108,188,647,10078,9900,-5919,-9146,-6079,704,7272,3942,12220,20552,7001,-5579,-1999,-576,-8683,-11819,-10396,-8324,-3938,-3020,-1778,783,722,2673,4074,2868,2047,2414,2682,1901,1065,-683,-488,562,-801,-972,-585,-1704,-3141,-3418,-1836,-669,-1548,-2579,-1795,-77,422,262,700,1237,1527,964,218,170,268,248,-35,-300,-444,-655,-683,-410,-83,-122,-443,-598,-650,-462,-47,179,267,174,37,-43,-122,-113,-64,16,-27,-208,-295,-246,-176,-114,-103,-125,-234,-411,-424,-235,30,139,92,-51,-174,-133,-24,71,86,5,-137,-206,-155,-33,105,136,-3,-203,-313,-304,-214,-137,-124,-191,-275,-301,-237,-66,129,166,26,-109,-173,-150,-67,-1,-37,-123,-158,-122,-17,7}
        },
        {    // H10e040a.wav
            {-1,-1,-3,-1,-3,1,-2,-1,1,1,-3,5,-7,4,0,-5,18,-30,30,-20,42,-8,1260,3198,477,-1350,326,-1499,-1085,2550,2677,3118,5378,4485,390,-771,1197,-320,-3991,-3874,-1547,-1696,-2517,-1139,-219,-473,16,908,1196,810,989,1688,1520,915,905,966,276,-420,-467,-588,-1254,-1794,-1657,-1262,-1066,-1071,-1093,-905,-470,-97,110,216,281,394,370,143,-131,-245,-236,-331,-451,-471,-462,-482,-421,-309,-302,-310,-203,-54,43,92,159,211,141,31,-41,-99,-174,-258,-250,-223,-265,-287,-250,-184,-130,-92,-70,-92,-128,-108,-53,-34,-27,0,9,-37,-83,-96,-128,-159,-173,-175,-173,-158,-121,-78,-46,-44,-65,-70,-50,-61,-60,-58,-87,-126,-134,-30},
            {20,-9,-62,152,-252,334,-225,6628,13002,-428,-10675,-8489,-859,7115,3586,9666,21514,10195,-4337,-1718,599,-7363,-11228,-9950,-10367,-6270,-2724,-2380,-418,185,2674,4792,3060,2189,2918,3656,1903,-485,-1273,-168,1000,-359,-619,-326,-1678,-2711,-2953,-2276,-1841,-2614,-2563,-1069,-18,134,379,959,1420,1669,1144,218,90,200,178,-9,-420,-559,-656,-800,-484,-100,-165,-374,-481,-539,-420,-94,170,339,332,146,2,-111,-206,-151,-6,-3,-180,-354,-325,-272,-231,-81,-3,-114,-336,-380,-228,-6,169,172,-2,-205,-208,-80,29,65,38,-95,-230,-223,-102,96,192,68,-159,-296,-318,-233,-120,-90,-144,-247,-297,-280,-131,93,182,83,-82,-171,-160,-84,-24,-31,-104,-152,-165,-79,64,26}
        },
        {    // H10e045a.wav
            {0,0,-2,-2,2,-2,2,0,1,0,1,-1,3,-2,0,9,-7,17,-23,22,-4,18,-6,699,2692,1259,-1149,148,-834,-1461,1737,2521,2509,4561,4642,1329,-531,991,460,-2876,-3682,-1680,-1229,-2298,-1615,-367,-374,-244,483,942,944,1288,1963,1862,1017,547,571,113,-570,-715,-854,-1414,-1778,-1582,-1232,-1010,-987,-1008,-774,-324,13,156,269,379,473,415,199,-53,-254,-318,-380,-516,-577,-555,-534,-434,-320,-299,-265,-148,5,97,115,138,167,117,13,-62,-98,-157,-225,-237,-223,-223,-264,-268,-213,-170,-126,-92,-86,-96,-84,-26,7,0,22,23,-25,-81,-124,-140,-163,-166,-170,-185,-176,-136,-73,-29,-24,-47,-62,-75,-68,-58,-37,-58,-111,-30},
            {76,-157,205,-212,190,-188,2780,12896,6755,-9273,-11366,-3780,6324,4618,5946,20884,14822,-2906,-2037,2012,-5387,-10450,-8927,-10974,-9095,-3213,-2894,-1827,-450,1400,4629,4077,2987,3099,4385,2733,-1680,-1652,56,627,169,-220,-167,-1496,-2390,-2570,-2677,-2908,-3456,-2286,-400,-176,-358,427,1435,1660,1505,1197,519,149,122,56,-155,-406,-522,-777,-971,-609,-159,-174,-403,-454,-351,-276,-119,100,390,482,256,102,-73,-245,-219,-30,14,-199,-392,-443,-408,-314,-90,64,16,-188,-311,-233,-53,165,236,119,-148,-279,-180,-52,42,24,-86,-232,-281,-167,51,221,154,-88,-263,-304,-253,-118,-55,-111,-204,-289,-309,-206,33,182,112,-28,-145,-183,-108,-24,-27,-69,-127,-172,-144,-15,91,28}
        },
        {    // H10e050a.wav
            {0,1,-1,0,-2,0,-2,0,0,1,-2,-1,1,-2,0,-4,12,-8,8,-6,0,8,5,14,308,2019,1827,-681,-162,-252,-1498,848,2260,2067,3774,4552,2166,-59,737,965,-1618,-3140,-1979,-1161,-1894,-1688,-628,-679,-628,442,1235,1310,1573,1920,1460,626,304,271,-245,-838,-871,-959,-1355,-1516,-1373,-1175,-957,-861,-838,-607,-232,88,232,285,400,484,363,121,-76,-242,-392,-507,-583,-591,-550,-517,-441,-324,-257,-168,-58,8,63,73,68,89,73,22,-45,-100,-135,-186,-212,-220,-249,-267,-270,-239,-195,-156,-104,-64,-47,-43,-18,-1,-5,4,4,-41,-100,-115,-125,-151,-164,-184,-207,-192,-130,-65,-33,-31,-48,-78,-67,-62,-53,-36,-60,-18},
            {-57,26,40,-143,220,201,8957,13030,-3433,-13655,-7667,3753,6401,3197,16950,20207,547,-3747,3139,-2107,-9601,-8588,-9622,-11250,-5243,-2716,-3049,-1680,-352,3673,4568,3109,4112,5562,3032,-2044,-1151,432,-329,258,241,98,-1317,-2286,-2099,-3260,-4124,-3728,-1814,-302,-428,-351,364,1458,1946,1608,1237,645,173,211,109,-337,-562,-467,-721,-1152,-841,-325,-237,-375,-461,-287,-197,-82,138,369,575,461,211,-47,-249,-252,-49,-4,-249,-465,-511,-468,-430,-154,91,70,-55,-199,-213,-138,97,321,243,-76,-275,-240,-154,-47,-2,-78,-261,-342,-233,-17,205,211,16,-191,-293,-284,-150,-25,-64,-177,-274,-330,-283,-64,145,134,10,-111,-178,-137,-51,-15,-45,-99,-173,-188,-85,25,52,10}
        },
        {    // H10e055a.wav
            {1,1,2,1,0,1,1,0,1,2,0,-1,1,3,-2,2,-1,11,-2,5,7,-15,18,9,29,85,1327,2053,-16,-397,106,-1216,19,1831,1800,3020,4236,2858,603,692,1365,-593,-2661,-2093,-934,-1482,-2047,-1243,-607,-173,768,1411,1289,1075,1237,1140,496,-93,-299,-504,-797,-824,-861,-1080,-1222,-1226,-1018,-737,-726,-751,-462,-87,107,187,291,324,300,272,117,-124,-353,-467,-499,-530,-530,-511,-481,-400,-260,-155,-109,-90,-54,1,11,2,39,72,27,-28,-69,-122,-175,-219,-224,-239,-267,-255,-233,-202,-157,-98,-28,-23,-46,-31,-5,-9,-32,-20,-23,-67,-96,-120,-160,-185,-182,-177,-179,-139,-76,-43,-28,-50,-61,-52,-49,-56,-67,-16},
            {-113,180,-211,186,-203,3322,14077,6568,-12380,-12578,-432,7205,3061,10202,23126,7755,-5457,2185,1858,-7116,-8794,-8080,-11602,-8271,-2761,-3561,-2779,-1725,937,4443,3639,3978,5848,4156,-538,-1177,419,-82,467,79,-158,-435,-2051,-2339,-3558,-5132,-4231,-1526,-203,-727,-347,540,1358,1953,1807,1471,870,143,91,188,-186,-569,-635,-763,-1128,-1030,-607,-390,-436,-448,-203,-196,-176,127,475,738,630,296,18,-156,-253,-179,-43,-202,-473,-563,-543,-490,-256,58,148,18,-161,-202,-127,55,291,329,74,-221,-280,-217,-118,-33,-80,-257,-386,-322,-120,141,252,130,-90,-242,-293,-223,-43,-2,-103,-227,-345,-356,-186,75,166,59,-81,-176,-172,-60,11,-17,-73,-154,-213,-163,-26,40,15,-1}
        },
        {    // H10e060a.wav
            {0,0,0,1,0,0,0,-1,-1,-1,1,-1,-1,-1,1,-3,2,0,8,0,-2,12,-23,21,17,17,5,731,1900,711,-423,158,-730,-548,1210,1564,2408,3807,3404,1564,745,1147,228,-1583,-2005,-1402,-1510,-1795,-967,-90,305,573,550,598,780,819,587,72,-377,-517,-519,-532,-562,-732,-910,-897,-826,-772,-697,-652,-581,-356,-101,59,88,72,159,233,163,-19,-200,-342,-429,-423,-417,-455,-459,-397,-297,-216,-175,-149,-152,-118,-46,-44,-35,13,44,31,-14,-70,-141,-175,-191,-211,-227,-243,-237,-217,-193,-153,-93,-52,-31,-31,-39,-35,-36,-17,5,-19,-71,-109,-139,-159,-161,-153,-174,-183,-136,-84,-44,-42,-35,-40,-55,-69,-99,-27},
            {-43,128,-220,273,5,8394,14917,-3308,-16683,-6930,5672,5580,4001,19499,17773,-3399,-2026,4908,-2612,-8544,-7323,-9502,-11129,-4971,-2943,-3697,-2502,-1458,2572,3816,3581,5711,4321,855,288,908,-163,444,1137,-322,-539,-1220,-2321,-3867,-6055,-5032,-1756,-290,-784,-489,620,1377,1900,1938,1751,1287,343,-83,64,-98,-331,-521,-857,-1157,-1194,-885,-586,-546,-497,-253,-175,-226,28,498,831,855,542,129,-88,-242,-281,-142,-144,-336,-545,-636,-561,-355,-27,206,104,-133,-234,-149,31,245,375,211,-103,-264,-271,-194,-59,-29,-193,-401,-419,-243,7,237,247,47,-158,-283,-279,-98,39,-29,-164,-308,-382,-288,-45,144,111,-19,-144,-206,-116,15,43,-12,-109,-211,-235,-104,30,40,22,4}
        },
        {    // H10e065a.wav
            {0,0,0,0,0,1,0,0,-2,-2,-1,0,-2,-1,0,-2,0,0,1,6,0,1,7,-18,23,21,0,-14,336,1501,1244,-160,42,-239,-770,452,1296,2071,3605,3709,1991,921,1339,867,-1072,-2161,-1428,-606,-733,-631,-359,-447,-295,28,184,160,156,169,-49,-337,-441,-280,-220,-473,-564,-445,-469,-601,-656,-589,-572,-559,-350,-194,-179,-138,-56,42,61,35,-34,-165,-256,-301,-311,-317,-371,-362,-294,-279,-256,-234,-217,-184,-152,-96,-79,-70,-21,11,27,-12,-82,-120,-149,-165,-192,-220,-215,-210,-197,-178,-161,-118,-63,-31,-37,-47,-30,-19,-17,-22,-43,-69,-107,-120,-138,-154,-151,-164,-156,-130,-89,-65,-39,-39,-67,-93,-116,-29},
            {83,-63,-9,52,1538,13336,10993,-12483,-15765,131,7952,3081,9985,22940,6715,-6474,3244,3559,-5750,-8254,-7122,-10344,-8842,-3515,-3795,-3534,-2581,-102,3342,3382,4504,4180,1845,1405,1200,815,934,1490,320,-423,-204,-2061,-4098,-6207,-6244,-2883,-727,-726,-670,316,1421,1955,2003,1829,1766,1075,-48,-294,-114,-129,-314,-736,-1028,-1257,-1310,-902,-627,-579,-428,-271,-195,-70,365,815,991,827,368,84,-169,-400,-294,-92,-144,-461,-667,-623,-457,-175,152,215,-22,-242,-221,-58,134,351,352,91,-214,-309,-237,-138,-9,-73,-307,-454,-397,-169,124,298,193,-43,-227,-303,-197,16,54,-92,-256,-365,-348,-168,62,124,36,-87,-193,-195,-55,64,47,-19,-138,-258,-210,-34,64,44,9,1}
        },
        {    // H10e070a.wav
            {0,-1,0,0,0,0,0,0,0,-1,-1,-1,0,-2,-1,-1,-3,1,-3,3,2,-1,6,0,-5,17,11,-10,0,131,996,1469,324,-88,90,-667,-199,1183,1981,2995,3559,2762,1477,853,645,-140,-838,-369,103,-727,-1664,-1386,-745,-773,-903,-587,-226,-39,21,60,3,-200,-178,-66,-94,-106,-173,-300,-392,-477,-579,-647,-618,-520,-430,-371,-315,-226,-94,7,53,27,-57,-113,-171,-226,-242,-262,-279,-292,-317,-327,-305,-245,-202,-193,-147,-115,-97,-47,-2,24,-5,-64,-107,-132,-156,-183,-191,-177,-175,-188,-182,-167,-127,-80,-44,-18,-28,-42,-48,-43,-32,-34,-59,-86,-117,-138,-138,-141,-144,-142,-121,-105,-92,-91,-86,-92,-108,-26},
            {178,-256,266,-261,4213,16344,4367,-18375,-11677,5937,7127,2822,16764,19448,-2348,-4004,6272,1358,-7428,-7960,-7291,-9987,-6704,-3365,-4164,-3820,-2642,1487,3959,3682,3433,1649,2020,2210,926,1359,1962,1694,232,-46,-568,-3368,-6239,-7318,-4484,-1493,-1240,-1047,-10,1160,1837,2094,2011,1900,1709,802,-221,-471,-172,-72,-467,-863,-1081,-1405,-1396,-957,-666,-532,-448,-353,-99,218,596,978,1093,703,200,16,-222,-437,-255,-22,-207,-593,-716,-537,-319,-40,248,153,-134,-282,-180,7,184,374,284,-11,-262,-316,-208,-62,17,-151,-398,-452,-330,-82,225,296,101,-132,-268,-264,-112,61,15,-149,-290,-376,-306,-74,112,86,-35,-152,-230,-161,4,86,48,-47,-170,-257,-143,29,69,41,-23,-12}
        },
        {    // H10e075a.wav
            {1,0,0,0,0,0,0,1,1,1,0,0,0,0,2,1,-1,0,3,-1,4,1,0,14,2,0,10,7,-5,12,60,579,1350,792,22,299,-131,-422,475,1510,2933,3739,2619,1148,1086,1864,1853,732,-565,-1265,-1552,-1850,-1902,-1734,-1656,-1384,-820,-321,10,228,317,214,-1,65,358,328,38,-91,-103,-203,-449,-735,-848,-779,-686,-646,-594,-455,-259,-55,75,117,118,77,15,-78,-154,-160,-197,-287,-358,-381,-362,-312,-270,-263,-231,-165,-120,-88,-49,-1,25,-4,-60,-104,-126,-129,-129,-140,-159,-165,-164,-168,-163,-142,-86,-35,-22,-33,-56,-44,-29,-30,-27,-41,-76,-103,-124,-131,-126,-129,-125,-148,-154,-141,-111,-82,-91,-24},
            {192,-341,431,-399,7110,17082,-2171,-20957,-6863,9615,5183,4669,21015,12891,-7056,-199,7600,-257,-8630,-7596,-7201,-9342,-5351,-3400,-4385,-4437,-2275,2646,4448,3546,1216,893,3160,1612,1019,2400,2046,1467,866,747,-1651,-5452,-7315,-6235,-3051,-1868,-1645,-734,373,1622,1999,2033,2100,1988,1606,610,-333,-375,-58,-245,-667,-796,-1154,-1641,-1423,-956,-666,-521,-542,-363,30,416,790,1061,1033,554,126,-26,-258,-351,-147,-15,-335,-695,-645,-447,-240,62,271,103,-217,-313,-141,44,212,343,214,-92,-301,-274,-155,9,6,-242,-427,-435,-254,30,270,256,10,-191,-279,-246,-46,87,-7,-187,-321,-359,-271,-17,126,45,-86,-217,-241,-113,51,93,38,-52,-185,-234,-72,73,76,21,-60,-20}
        },
        {    // H10e080a.wav
            {1,1,1,0,-1,0,0,0,1,2,1,0,0,0,-1,0,1,-4,-1,4,-2,4,1,-1,20,-1,-2,8,-10,18,41,29,244,1023,1201,663,804,-12,-1147,44,1571,2285,2834,2778,2701,3137,3168,1877,-92,-1427,-1755,-1967,-2716,-2918,-2269,-1844,-1498,-790,-125,254,423,476,455,401,480,585,367,75,47,8,-254,-634,-928,-1022,-986,-916,-828,-642,-385,-152,29,131,189,224,184,96,-8,-103,-169,-259,-364,-403,-379,-366,-377,-348,-275,-206,-148,-112,-85,-49,-25,-6,-32,-83,-81,-65,-78,-111,-149,-151,-134,-147,-170,-184,-154,-95,-58,-29,-23,-36,-38,-44,-42,-24,-34,-67,-108,-132,-132,-141,-142,-165,-177,-170,-149,-123,-108,-24},
            {156,-334,467,-344,9311,16535,-6955,-21558,-2890,11519,3562,6953,22445,6866,-8790,3041,8493,-1390,-9570,-6903,-6938,-9068,-4570,-3225,-4812,-5011,-1603,3521,4355,2136,74,1934,3192,850,1727,2757,1861,1428,1393,1173,-2750,-7107,-7308,-4453,-2482,-2692,-1758,-392,609,1555,1874,2122,2170,1999,1536,518,-330,-160,103,-452,-812,-787,-1277,-1755,-1472,-905,-604,-606,-624,-351,104,523,919,1078,871,442,143,-10,-257,-280,-32,-26,-466,-747,-579,-365,-185,111,264,27,-278,-331,-125,50,221,341,132,-186,-326,-229,-73,45,-36,-298,-436,-402,-211,100,306,203,-65,-255,-304,-219,13,121,-48,-240,-344,-350,-223,6,96,-5,-141,-252,-250,-80,86,101,31,-92,-204,-201,-12,93,56,-5,-111,-36}
        },
        {    // H10e085a.wav
            {1,0,0,-1,-1,-1,-1,-1,1,1,1,1,-1,0,-2,-1,-1,-1,-3,-1,3,-1,1,2,0,26,2,-25,5,15,51,11,-29,90,961,1912,1213,491,50,-1071,-953,203,2078,4475,5201,4174,2778,1819,1072,-51,-1628,-3025,-3276,-2983,-2839,-2452,-1888,-1208,-475,46,440,673,754,778,721,633,528,367,134,-4,-105,-391,-812,-1179,-1274,-1147,-942,-750,-522,-239,-54,94,209,266,300,247,136,-15,-177,-265,-326,-372,-385,-414,-431,-406,-316,-218,-176,-137,-109,-91,-79,-79,-57,-34,-16,-5,-44,-95,-124,-133,-122,-127,-149,-180,-192,-160,-105,-50,-13,-7,-35,-56,-60,-42,-24,-41,-90,-125,-139,-161,-165,-170,-160,-176,-182,-162,-148,-33},
            {136,-322,472,-301,10300,16005,-9385,-21584,-553,12465,2836,8214,22275,3050,-9486,5302,9633,-2040,-10265,-6060,-6482,-9213,-4237,-2919,-5232,-5502,-987,4308,3582,264,91,3271,2771,445,2415,2731,1485,1561,1883,998,-3939,-7585,-6147,-3392,-2754,-2853,-1463,-578,430,1504,1664,2044,2210,2100,1567,364,-222,198,183,-584,-832,-811,-1432,-1836,-1416,-816,-589,-700,-670,-319,84,550,993,1023,759,389,202,56,-236,-203,42,-31,-530,-744,-515,-321,-128,148,228,-59,-328,-306,-98,34,227,358,79,-260,-332,-181,-19,82,-35,-305,-444,-389,-154,148,322,160,-127,-271,-288,-162,58,113,-77,-266,-340,-338,-197,36,81,-41,-182,-270,-229,-39,131,116,16,-116,-203,-155,31,101,41,-28,-122,-36}
        },
        {    // H10e090a.wav
            {1,2,1,0,1,2,-1,0,2,2,1,4,2,1,2,-2,1,1,1,0,4,3,1,4,4,15,24,-13,-20,49,29,9,-18,176,642,1017,1429,1549,1276,-501,-3050,-2048,2078,5631,6285,4079,2222,1958,1869,769,-1204,-2901,-3637,-3243,-2703,-2711,-2335,-1503,-810,-249,252,792,989,873,875,803,674,467,177,-8,-66,-193,-673,-1191,-1340,-1221,-1020,-804,-599,-354,-110,46,173,261,323,329,213,51,-125,-250,-297,-342,-384,-412,-425,-394,-322,-248,-193,-158,-126,-125,-150,-119,-65,-13,30,29,-5,-67,-109,-112,-120,-116,-110,-139,-171,-184,-143,-66,-26,-5,-16,-40,-57,-59,-54,-61,-70,-92,-123,-162,-179,-174,-151,-156,-170,-182,-176,-39},
            {152,-349,505,-402,9994,16089,-9477,-21722,-39,12898,2957,8053,21494,1704,-10117,6463,11147,-1954,-10755,-5477,-5698,-9489,-4491,-2637,-5458,-5944,-740,4880,2741,-1355,588,3983,2258,823,2814,2366,1260,1665,2094,651,-4843,-7519,-4715,-2740,-3163,-2721,-1159,-781,15,1184,1565,1881,2064,2260,1648,249,-96,519,232,-611,-735,-876,-1533,-1906,-1401,-684,-611,-801,-703,-309,40,481,983,969,687,375,262,123,-213,-138,99,-71,-555,-683,-472,-308,-125,138,189,-139,-377,-297,-66,22,205,350,57,-274,-350,-169,3,91,-6,-293,-458,-397,-133,164,291,123,-136,-257,-253,-147,52,95,-105,-274,-352,-340,-179,35,73,-73,-227,-279,-207,-12,125,100,26,-115,-210,-166,25,98,26,-37,-131,-40}
        },
        {    // H10e095a.wav
            {1,1,0,0,0,0,0,-2,0,1,0,1,1,0,2,-1,-2,0,-3,2,-1,-1,4,-1,7,7,3,15,0,8,27,0,139,631,692,49,594,2013,2007,-32,-3023,-2237,2791,5459,4564,3299,2646,2155,1653,861,-876,-2267,-2740,-3106,-3000,-2600,-2211,-1732,-1223,-567,138,675,878,871,912,910,759,490,198,1,-92,-213,-584,-1044,-1198,-1113,-1010,-867,-634,-402,-205,-17,105,198,279,283,200,59,-64,-176,-292,-344,-362,-386,-377,-336,-304,-281,-222,-174,-180,-194,-168,-104,-59,-35,-6,27,11,-46,-93,-122,-120,-102,-81,-97,-146,-160,-139,-104,-67,-48,-33,-20,-62,-93,-95,-86,-64,-80,-118,-167,-191,-177,-151,-162,-169,-165,-151,-33},
            {201,-399,542,-569,8404,16679,-7128,-22100,-1410,13008,3858,6622,20292,2753,-10833,6154,13024,-692,-11051,-5523,-4544,-9515,-5291,-2523,-5420,-6326,-1010,5014,2340,-2225,779,4058,2057,1273,3046,2300,967,1650,2192,293,-5076,-7239,-3941,-2314,-3014,-2494,-1256,-886,-166,752,1247,1732,1958,2251,1725,316,14,660,330,-465,-627,-912,-1539,-1920,-1425,-653,-616,-825,-739,-344,-2,394,890,928,687,367,298,203,-153,-103,121,-46,-529,-635,-436,-305,-142,79,163,-158,-411,-309,-70,36,193,330,75,-242,-333,-163,5,88,13,-253,-443,-417,-158,133,289,150,-113,-231,-238,-141,39,85,-105,-287,-353,-326,-169,35,64,-72,-217,-280,-216,-26,132,125,33,-113,-220,-196,3,112,42,-44,-134,-38}
        },
        {    // H10e100a.wav
            {1,1,0,0,0,0,0,-1,0,1,0,0,1,0,2,0,0,-1,-2,4,1,-3,1,4,8,9,-8,16,32,5,-15,128,673,856,140,-90,683,1152,1067,236,-823,470,2846,3203,2637,2533,2557,2096,1068,201,-481,-1268,-1877,-2277,-2633,-2573,-1979,-1604,-1400,-776,-98,348,588,732,902,860,649,475,302,12,-233,-327,-540,-769,-896,-949,-883,-793,-631,-420,-265,-108,28,114,159,156,125,51,-50,-150,-231,-283,-339,-340,-297,-285,-265,-251,-241,-233,-239,-193,-114,-73,-70,-71,-53,-19,-8,-40,-90,-117,-101,-73,-53,-70,-100,-102,-106,-112,-113,-94,-62,-57,-78,-90,-93,-80,-79,-101,-134,-175,-167,-167,-169,-161,-144,-111,-105,-26},
            {235,-403,486,-570,5762,16914,-2334,-22116,-4757,12598,5538,4504,18288,5813,-10995,3978,14756,2122,-10868,-6535,-3275,-8962,-6519,-2706,-5151,-6585,-1809,4553,2564,-2305,463,3768,2166,1557,2917,2506,1009,1344,2087,293,-4759,-7039,-3862,-2076,-2619,-2237,-1378,-970,-325,473,973,1436,1800,2179,1756,472,68,658,478,-275,-546,-896,-1461,-1870,-1503,-720,-647,-812,-737,-405,-45,295,777,888,698,371,270,281,-58,-106,99,15,-436,-641,-460,-320,-187,5,130,-134,-424,-350,-105,25,177,330,124,-191,-314,-160,-7,63,16,-233,-437,-452,-201,103,278,185,-83,-216,-233,-149,23,72,-96,-278,-355,-330,-191,22,82,-58,-221,-317,-246,-33,138,140,6,-150,-236,-198,-4,94,29,-54,-122,-32}
        },
        {    // H10e105a.wav
            {1,0,2,1,0,0,-1,1,-1,-1,-1,-1,-1,0,0,-2,2,1,-2,1,1,-1,1,-1,12,1,-2,11,24,20,66,673,1085,259,-261,378,718,244,-154,693,2412,2794,1821,1419,1618,1671,1509,1064,483,-37,-413,-567,-913,-1523,-1753,-1763,-1852,-1582,-1078,-780,-497,-120,244,556,667,620,494,380,270,-12,-306,-449,-461,-493,-620,-686,-693,-629,-502,-427,-321,-176,-91,-28,-8,9,29,-41,-100,-118,-154,-209,-266,-275,-264,-245,-204,-224,-279,-273,-203,-116,-93,-94,-90,-112,-100,-83,-85,-76,-97,-85,-52,-60,-46,-41,-48,-60,-90,-103,-130,-155,-140,-106,-75,-67,-79,-82,-111,-150,-162,-178,-170,-171,-156,-125,-105,-89,-87,-21},
            {195,-263,232,-220,2570,15423,4727,-19979,-10210,10708,8081,2440,14656,10246,-9195,-151,15129,6607,-9181,-8577,-2511,-7261,-7961,-3464,-4539,-6635,-3095,3291,3145,-1557,-260,3168,2536,1706,2519,2741,1325,1068,1847,570,-3751,-6779,-4410,-2008,-2237,-2130,-1424,-934,-497,178,813,1227,1527,1979,1816,712,121,559,661,-38,-504,-782,-1303,-1748,-1586,-885,-654,-807,-736,-466,-88,213,620,864,714,392,236,316,97,-84,62,87,-292,-620,-539,-366,-234,-85,97,-74,-396,-401,-170,14,138,339,228,-109,-284,-175,5,50,-1,-219,-439,-457,-223,74,239,182,-34,-184,-221,-153,-6,75,-50,-246,-346,-343,-207,18,98,-58,-244,-297,-221,-58,103,114,-21,-154,-209,-189,-43,63,36,-36,-105,-29}
        },
        {    // H10e110a.wav
            {0,0,0,0,1,1,1,0,0,-1,-1,-1,-1,0,0,0,1,0,-1,1,-2,6,-1,1,6,5,6,6,23,57,686,1293,405,-398,191,570,72,-336,671,2643,3158,2217,1668,1391,839,467,176,-246,-310,-63,-73,-367,-527,-468,-652,-1059,-1229,-1091,-915,-850,-687,-412,-127,155,301,345,280,142,59,-102,-303,-369,-347,-322,-374,-417,-411,-413,-366,-340,-314,-272,-256,-196,-152,-141,-153,-142,-88,-107,-121,-124,-187,-217,-206,-198,-219,-251,-214,-151,-120,-99,-101,-118,-127,-141,-146,-147,-157,-129,-83,-47,-26,-36,-21,-6,-13,-31,-81,-120,-158,-184,-159,-118,-81,-61,-74,-101,-147,-176,-181,-196,-177,-146,-107,-90,-86,-65,-62,-16},
            {37,29,-170,292,153,11204,11596,-13596,-16068,5912,10859,1991,9024,13842,-4075,-4798,12600,11567,-4843,-10603,-3470,-4513,-8603,-5242,-3897,-6105,-4551,1204,3347,-45,-777,2061,2884,2052,1969,2696,1896,876,1468,972,-2321,-5996,-5262,-2435,-1879,-2111,-1605,-878,-581,-77,648,1070,1324,1681,1782,1016,252,388,729,264,-458,-699,-1043,-1577,-1634,-1092,-691,-772,-779,-538,-159,168,466,758,745,443,213,298,247,18,15,100,-136,-562,-617,-444,-310,-186,14,-6,-318,-433,-253,-11,116,294,313,21,-221,-201,-15,40,-20,-199,-407,-437,-270,-2,172,166,4,-151,-195,-152,-33,70,-3,-196,-313,-319,-225,-57,35,-31,-169,-247,-234,-129,15,61,-4,-100,-184,-226,-108,59,74,-30,-118,-34}
        },
        {    // H10e115a.wav
            {1,1,2,3,1,3,2,2,2,1,1,1,1,1,1,3,4,1,5,1,6,3,2,6,4,17,-2,26,43,662,1528,630,-570,-10,526,-21,-435,920,3165,3135,1620,1477,1797,1192,378,-434,-1218,-1171,-635,-382,-179,-98,-40,205,101,-223,-304,-429,-730,-874,-746,-546,-432,-331,-127,16,-66,-177,-220,-265,-216,-172,-213,-196,-156,-139,-150,-193,-212,-229,-280,-364,-407,-358,-349,-323,-218,-167,-140,-116,-103,-94,-120,-140,-177,-231,-222,-143,-67,-50,-69,-102,-130,-142,-172,-192,-194,-197,-175,-127,-84,-54,-28,-6,21,22,-10,-45,-109,-161,-152,-128,-127,-136,-116,-80,-88,-129,-175,-196,-192,-184,-142,-117,-96,-73,-58,-37,-45,-13},
            {-131,246,-359,401,-483,5260,14506,-2762,-18593,-2501,11721,4660,2820,13396,4177,-6870,6638,14580,2146,-10346,-6641,-2248,-7200,-7505,-4245,-4884,-5422,-1462,2521,1530,-374,793,2593,2679,1744,2172,2414,1064,948,1064,-814,-4407,-5700,-3437,-1908,-1927,-1868,-1068,-560,-282,478,949,1166,1435,1647,1295,523,246,582,524,-232,-707,-854,-1272,-1615,-1288,-775,-730,-801,-631,-264,97,342,608,713,538,268,258,341,154,18,40,-40,-432,-677,-536,-395,-284,-121,-7,-199,-408,-305,-57,98,218,319,164,-93,-206,-92,5,-18,-130,-335,-410,-338,-130,70,135,49,-114,-164,-134,-60,41,43,-106,-251,-310,-290,-167,3,43,-101,-238,-283,-216,-65,40,17,-88,-168,-214,-145,3,68,-22,-123,-37}
        },
        {    // H10e120a.wav
            {0,0,1,1,1,1,1,-1,-1,-1,-1,-1,1,0,-2,3,0,2,-1,4,2,-3,0,1,21,-6,20,32,664,1719,841,-689,-229,468,-101,-479,1253,3655,3279,1470,1324,1484,706,302,-75,-1144,-1702,-1355,-937,-734,-516,72,618,506,433,692,524,-19,-385,-558,-699,-770,-712,-588,-525,-514,-485,-492,-489,-345,-143,-64,-69,-25,58,95,47,-21,-62,-157,-291,-397,-533,-598,-476,-322,-250,-239,-220,-164,-101,-61,-98,-173,-197,-147,-75,-36,1,-1,-56,-108,-162,-199,-220,-229,-220,-203,-160,-117,-103,-83,-41,20,52,6,-68,-121,-131,-111,-101,-103,-123,-151,-137,-119,-146,-178,-187,-181,-171,-148,-123,-117,-91,-55,-44,-47,-38,-7},
            {-102,116,-81,-46,128,695,11098,8352,-13489,-11876,7414,9335,105,7119,11555,-2768,-772,13046,9558,-5634,-10101,-2838,-3884,-8516,-6092,-3966,-5020,-3945,403,2353,638,224,1749,2874,2245,1523,2442,1726,581,775,70,-2345,-4941,-4433,-2577,-1943,-1893,-1468,-672,-408,155,890,1091,1244,1476,1458,915,296,329,572,104,-582,-832,-1021,-1393,-1394,-917,-715,-773,-687,-410,-14,203,422,654,619,423,265,363,304,51,-12,-32,-282,-641,-653,-465,-360,-269,-100,-106,-296,-305,-109,89,154,256,254,50,-137,-152,-43,-8,-47,-216,-383,-400,-262,-55,78,85,-43,-130,-119,-65,20,76,-14,-208,-328,-288,-159,-41,15,-87,-233,-298,-241,-105,-14,-2,-56,-107,-163,-179,-100,12,-2,-91,-29}
        },
        {    // H10e125a.wav
            {0,3,2,2,2,2,0,0,1,0,2,0,0,1,2,-1,3,1,5,3,1,3,-7,23,-1,28,22,673,1941,1057,-838,-472,444,-144,-546,1653,4231,3349,1313,1409,1584,386,-357,-592,-1264,-1530,-1142,-1061,-1294,-1039,-256,286,429,774,1165,1058,707,444,156,-233,-600,-815,-864,-859,-902,-935,-895,-813,-603,-322,-164,-58,86,219,243,211,222,157,4,-147,-342,-531,-585,-536,-447,-361,-335,-332,-264,-155,-109,-145,-165,-88,-31,-42,-8,43,47,4,-73,-141,-197,-231,-219,-206,-206,-192,-145,-112,-110,-67,0,26,-18,-86,-124,-116,-74,-48,-66,-113,-133,-131,-141,-174,-200,-175,-146,-142,-139,-121,-104,-89,-69,-45,-45,-36,8,7},
            {65,-141,209,-278,308,-361,4220,12560,-1175,-15497,-2462,10839,3677,-631,11061,6998,-3851,6165,13538,2692,-9697,-6794,-1384,-6489,-8423,-4582,-3821,-5036,-2604,1785,1758,104,1209,2484,2647,1664,1765,2379,876,266,269,-875,-3098,-4456,-3430,-2456,-2010,-1643,-1057,-525,-229,588,1133,1156,1291,1471,1224,602,237,424,346,-333,-784,-919,-1111,-1315,-1104,-737,-714,-690,-519,-195,83,198,472,681,599,368,322,398,179,-64,-89,-173,-506,-721,-581,-398,-367,-255,-75,-161,-271,-175,55,159,163,240,145,-37,-128,-74,1,-15,-115,-310,-423,-355,-172,-16,58,16,-67,-73,-42,-7,13,-21,-115,-195,-222,-196,-150,-97,-100,-186,-248,-249,-180,-65,15,0,-80,-161,-199,-170,-59,-2,-49,-16}
        },
        {    // H10e130a.wav
            {0,0,1,0,-1,-1,-2,-1,-1,-1,-2,-2,-2,1,-3,1,-3,2,0,-6,5,-12,20,-6,25,27,700,2158,1269,-996,-735,384,-176,-554,2085,4818,3383,1154,1559,1732,173,-793,-932,-1709,-2136,-1304,-721,-1058,-1154,-505,58,86,342,1066,1401,1070,776,750,494,-18,-413,-641,-922,-1194,-1255,-1212,-1150,-961,-638,-387,-224,5,228,324,319,325,346,244,-59,-340,-420,-459,-451,-387,-431,-512,-461,-306,-238,-271,-253,-125,-11,-13,-5,32,53,67,12,-58,-118,-195,-208,-181,-180,-196,-199,-181,-164,-118,-44,-13,-26,-72,-132,-145,-119,-75,-37,-47,-81,-128,-151,-146,-167,-190,-178,-150,-131,-138,-124,-88,-83,-70,-59,-53,-36,-3,37,13},
            {53,-56,21,47,-157,241,48,7740,9590,-8068,-11822,4639,9085,-1623,2143,12987,2866,-1472,10575,10491,-3377,-9898,-3226,-2436,-8491,-7079,-3270,-4334,-5041,-680,2475,510,376,2373,2618,2077,1494,2171,1719,132,63,-278,-1481,-3214,-3680,-3000,-2543,-1831,-1340,-858,-512,58,980,1195,1122,1356,1408,939,408,331,418,-59,-659,-835,-915,-1094,-1195,-889,-630,-652,-566,-353,-62,87,219,533,686,535,348,371,304,11,-164,-154,-329,-658,-694,-501,-372,-356,-185,-55,-189,-221,-44,146,155,160,169,42,-66,-55,7,-19,-89,-210,-344,-376,-283,-132,-15,53,21,-31,-51,-72,-53,16,22,-81,-194,-258,-258,-202,-131,-137,-207,-228,-181,-80,0,-12,-81,-160,-197,-185,-109,-14,-11,-8}
        },
        {    // H10e135a.wav
            {1,2,1,0,-1,-1,-1,-1,1,-1,-1,-2,1,-2,3,-2,1,1,-3,4,-13,22,-7,32,20,754,2414,1458,-1162,-999,328,-201,-544,2613,5413,3318,974,1779,1963,2,-1206,-1292,-2022,-2439,-1624,-1048,-1222,-1026,-139,324,-29,75,775,1033,902,964,1063,756,378,178,-96,-520,-995,-1324,-1459,-1412,-1145,-875,-711,-474,-166,99,239,276,375,449,285,-13,-182,-277,-346,-298,-291,-400,-521,-527,-417,-363,-354,-251,-113,-53,-29,-8,39,84,33,-10,-42,-130,-192,-189,-136,-128,-178,-190,-192,-181,-139,-58,6,-46,-130,-158,-150,-128,-111,-77,-51,-88,-132,-153,-159,-151,-154,-140,-135,-155,-154,-130,-87,-69,-70,-55,-43,-36,-22,-3,1,-1},
            {-59,89,-115,108,-99,40,-28,1330,9541,5012,-10904,-6304,7929,4433,-4066,6595,12686,257,1972,12112,5819,-6986,-7589,-1368,-4684,-9045,-5089,-2929,-5410,-4013,1250,1783,-345,1375,2953,2384,1678,1659,2199,811,-334,-91,-583,-1809,-3056,-3110,-2846,-2406,-1632,-1173,-801,-455,449,1189,1054,1041,1404,1300,703,374,408,203,-412,-758,-777,-885,-1086,-1042,-731,-606,-548,-404,-210,19,110,250,506,601,451,321,319,150,-132,-215,-219,-448,-678,-625,-453,-373,-315,-109,-65,-184,-142,30,145,114,125,107,-9,-51,-1,4,-76,-155,-248,-321,-323,-220,-92,1,23,-40,-57,-32,0,26,16,-65,-193,-278,-302,-273,-216,-157,-132,-139,-143,-125,-87,-69,-92,-137,-164,-164,-127,-51,-1,1}
        },
        {    // H10e140a.wav
            {1,1,0,0,-2,0,-1,1,-1,-1,-2,1,-2,1,-1,3,-1,-5,8,-18,19,-10,38,21,813,2699,1639,-1387,-1261,279,-221,-488,3177,6043,3224,732,1997,2197,-114,-1544,-1645,-2389,-2799,-1786,-1083,-1449,-1431,-256,684,435,310,717,813,608,601,855,835,556,356,233,-29,-539,-981,-1282,-1436,-1316,-1035,-790,-635,-419,-117,85,199,297,262,162,75,-74,-175,-177,-164,-206,-326,-447,-506,-495,-427,-298,-188,-146,-94,-69,-45,19,31,9,-23,-77,-134,-188,-173,-109,-97,-146,-188,-165,-154,-133,-57,-24,-64,-137,-159,-145,-140,-119,-95,-104,-127,-151,-173,-163,-136,-108,-101,-114,-150,-174,-133,-73,-46,-61,-58,-52,-27,-13,-22,-53,-110,-31},
            {1,-33,58,-97,120,-153,148,-165,2768,9650,1030,-10608,-1454,7544,-269,-3264,10447,10958,-611,5016,11123,1463,-7727,-4929,-1427,-6689,-8177,-3472,-3792,-5841,-2053,1942,529,-224,2277,3021,2156,1547,1751,1801,167,-560,-207,-664,-1977,-2914,-2732,-2570,-2205,-1613,-1042,-622,-306,634,1167,896,1000,1366,1149,644,399,296,-31,-544,-727,-682,-832,-1066,-942,-615,-524,-441,-234,-34,57,68,240,468,463,306,256,223,8,-192,-213,-236,-466,-625,-533,-435,-401,-258,-37,-59,-155,-57,64,60,37,104,97,-3,-26,10,-43,-129,-167,-210,-247,-245,-187,-130,-57,20,46,50,29,-10,-47,-103,-200,-275,-301,-289,-237,-160,-88,-85,-120,-139,-142,-127,-113,-108,-95,-92,-96,-86,-51,-6}
        },
        {    // H10e145a.wav
            {1,0,-1,-2,-2,-2,2,-1,-1,-2,1,-2,2,-5,2,1,-9,9,-17,20,-18,44,26,910,3015,1779,-1665,-1531,254,-233,-355,3852,6602,3042,536,2234,2356,-296,-1805,-1909,-2766,-3184,-1969,-1113,-1567,-1567,-358,535,463,651,1126,985,525,435,613,453,217,332,411,109,-327,-605,-875,-1110,-1127,-971,-808,-690,-496,-258,-70,40,54,82,73,-81,-134,-73,-77,-105,-135,-217,-401,-507,-402,-240,-203,-221,-145,-80,-77,-76,-64,-26,-29,-69,-95,-164,-220,-178,-83,-70,-137,-155,-152,-138,-90,-15,-9,-99,-144,-135,-133,-143,-128,-110,-113,-149,-194,-200,-179,-128,-73,-51,-107,-170,-162,-93,-30,-20,-36,-66,-51,-42,-21,-44,-87,-129,-190,-50},
            {19,-22,-4,29,-72,106,-155,178,-130,3847,8815,-1509,-8646,1330,5016,-3034,-750,12557,9015,-153,6655,8701,-1160,-6711,-3258,-2520,-7658,-6609,-3015,-4948,-4973,-472,1399,-187,400,2759,2861,1947,1549,1667,1246,-186,-461,-261,-900,-2016,-2628,-2475,-2393,-2056,-1497,-844,-450,-167,597,977,850,967,1202,1038,666,380,134,-201,-533,-580,-597,-836,-1027,-802,-496,-435,-291,-105,18,28,4,207,388,310,145,132,130,-38,-186,-202,-242,-429,-512,-440,-417,-418,-250,-12,-23,-91,-38,2,-34,-17,102,119,21,-34,-40,-87,-109,-114,-178,-245,-257,-175,-64,29,93,95,54,-30,-140,-206,-225,-241,-237,-232,-228,-199,-139,-87,-101,-126,-149,-163,-126,-84,-43,-31,-56,-89,-97,-22}
        },
        {    // H10e150a.wav
            {0,0,-2,0,-2,2,-1,-2,-3,1,-2,4,-3,2,1,-7,9,-18,25,-26,48,25,1045,3376,1863,-1997,-1778,243,-257,-160,4649,7139,2723,343,2564,2486,-582,-2083,-2116,-3099,-3561,-2160,-1127,-1676,-1715,-348,560,476,692,1169,1154,786,601,612,276,-121,-64,114,15,-268,-528,-714,-780,-727,-592,-515,-570,-523,-238,-114,-243,-141,21,-76,-234,-283,-203,-128,-90,-93,-249,-435,-369,-144,-95,-149,-127,-66,-59,-136,-144,-57,-31,-99,-133,-135,-207,-258,-195,-113,-97,-122,-133,-122,-121,-69,12,0,-78,-124,-120,-132,-155,-142,-104,-110,-160,-214,-246,-213,-114,-31,-64,-148,-180,-115,-29,3,-8,-35,-51,-62,-45,-71,-90,-117,-144,-184,-236,-59},
            {-17,32,-37,16,4,-47,86,-145,176,-29,4469,7693,-2563,-6381,1911,2240,-3689,1760,13155,7722,772,6682,6268,-1931,-5327,-2723,-3737,-7513,-5278,-3598,-5295,-3530,-20,631,-205,998,2842,2620,1827,1506,1516,694,-303,-32,-407,-1275,-1903,-2288,-2308,-2339,-1922,-1236,-658,-388,3,552,664,720,957,1110,944,596,295,76,-237,-483,-454,-535,-788,-888,-658,-410,-321,-214,-107,-19,-40,-40,123,251,217,78,59,67,-92,-211,-171,-174,-346,-429,-366,-374,-391,-249,-64,-26,-45,-43,-56,-92,-20,104,99,35,-20,-69,-127,-125,-102,-142,-191,-181,-94,8,92,105,44,-63,-187,-262,-253,-190,-156,-169,-219,-240,-211,-148,-104,-113,-129,-138,-105,-70,-41,-30,-27,-36,-67,-19}
        },
        {    // H10e155a.wav
            {-1,-2,0,-1,1,0,0,-3,2,-2,4,-4,6,-3,-8,13,-21,30,-31,53,20,1213,3775,1891,-2394,-1998,254,-294,89,5540,7645,2330,188,2902,2559,-889,-2364,-2337,-3444,-3899,-2354,-1148,-1711,-1830,-310,566,454,922,1346,1040,646,751,921,383,-240,-267,-117,-397,-708,-629,-690,-738,-494,-182,-62,-212,-211,-162,-278,-203,-50,-121,-306,-408,-354,-314,-308,-256,-257,-304,-305,-196,-76,-30,5,31,17,-43,-113,-108,-66,-80,-121,-152,-182,-237,-296,-249,-137,-123,-157,-144,-109,-76,-42,14,15,-45,-89,-101,-119,-150,-123,-87,-102,-163,-229,-262,-219,-129,-67,-70,-142,-153,-62,38,45,-6,-36,-63,-77,-89,-93,-118,-127,-156,-198,-224,-215,-47},
            {16,-20,34,-41,26,-14,-22,60,-118,160,76,4652,6709,-2437,-4756,1031,409,-3086,3343,12931,7292,1420,5608,4680,-1532,-4284,-2964,-4464,-6681,-4792,-4344,-4723,-2484,-260,190,80,1357,2610,2405,1900,1353,1110,461,-44,136,-574,-1355,-1850,-2089,-2122,-2265,-1828,-1093,-476,-192,113,447,369,499,931,1107,863,408,169,109,-185,-400,-347,-436,-683,-741,-530,-386,-303,-211,-182,-122,-128,-93,52,145,171,99,46,-7,-152,-206,-134,-135,-272,-345,-331,-355,-352,-227,-97,-69,-63,-72,-100,-99,5,101,58,-14,-55,-92,-123,-97,-71,-81,-100,-106,-66,-7,51,37,-57,-157,-230,-246,-204,-161,-156,-183,-224,-259,-254,-178,-110,-89,-82,-84,-83,-68,-40,-4,9,-13,-6}
        },
        {    // H10e160a.wav
            {-3,-1,-2,1,-1,-1,-4,2,-3,5,-6,5,-5,-10,10,-26,34,-39,63,14,1422,4207,1828,-2843,-2172,275,-351,404,6512,8071,1861,110,3283,2519,-1290,-2597,-2499,-3829,-4266,-2515,-1231,-1772,-1849,-201,617,353,1039,1598,1118,582,622,860,486,-69,-203,-216,-631,-1096,-1089,-1015,-822,-420,-60,224,243,44,8,88,16,-63,-131,-363,-591,-562,-415,-434,-517,-438,-280,-283,-263,-54,87,107,71,36,29,-25,-52,-29,-47,-138,-203,-206,-282,-349,-270,-174,-175,-209,-177,-107,-85,-54,14,19,-34,-79,-95,-109,-116,-77,-55,-106,-186,-252,-260,-218,-168,-134,-134,-138,-94,-5,67,83,36,-42,-114,-161,-157,-133,-122,-153,-180,-210,-220,-189,-149,-31},
            {-4,14,-16,30,-40,32,-26,0,35,-86,130,156,4515,6069,-1713,-4049,-268,-306,-2184,3965,12505,7434,1501,4189,4049,-690,-3784,-3463,-4492,-5836,-5006,-4641,-3786,-2000,-675,45,425,1410,2322,2332,1935,1125,671,584,321,-83,-631,-1129,-1732,-2012,-2136,-2156,-1631,-985,-396,5,263,282,171,391,845,1042,727,306,79,45,-21,-193,-256,-345,-547,-660,-547,-379,-324,-303,-257,-199,-177,-137,-8,153,180,81,72,22,-146,-229,-151,-103,-237,-310,-308,-327,-303,-187,-56,-77,-153,-148,-90,-51,-8,45,56,-1,-76,-95,-88,-48,-22,-29,-59,-107,-107,-61,4,20,-48,-142,-219,-230,-179,-160,-179,-207,-251,-278,-249,-164,-88,-53,-40,-52,-68,-47,-5,35,46,9}
        },
        {    // H10e165a.wav
            {-2,-1,1,-3,-1,-5,2,-4,6,-6,6,-7,-8,11,-26,37,-49,73,16,1664,4645,1719,-3325,-2301,325,-431,781,7519,8419,1374,97,3679,2410,-1725,-2826,-2638,-4130,-4628,-2704,-1305,-1880,-1886,-55,788,350,1039,1774,1231,547,658,881,321,-177,-83,-63,-679,-1343,-1390,-1327,-1106,-574,-46,222,205,360,533,381,253,231,16,-396,-650,-605,-638,-721,-522,-303,-402,-551,-354,1,134,83,46,85,91,16,18,74,18,-105,-167,-212,-311,-372,-304,-213,-224,-229,-179,-140,-120,-82,9,22,-48,-75,-69,-68,-70,-43,-24,-78,-166,-240,-292,-247,-154,-124,-145,-167,-116,1,132,173,86,-47,-155,-209,-209,-178,-161,-170,-204,-214,-205,-160,-104,-91,-22},
            {2,-3,12,-13,23,-36,27,-28,6,18,-61,96,194,4155,5779,-850,-4029,-1342,-289,-1486,3912,12100,7779,1154,2928,4046,128,-3677,-3804,-4059,-5387,-5402,-4400,-2975,-1911,-1049,50,686,1263,2101,2310,1784,908,598,707,358,-212,-621,-838,-1437,-2089,-2243,-1995,-1432,-895,-381,79,286,248,195,320,659,867,607,253,94,71,22,-50,-105,-279,-541,-719,-624,-426,-359,-347,-329,-253,-180,-130,0,166,191,93,71,32,-120,-222,-186,-154,-230,-292,-291,-293,-287,-172,-42,-73,-173,-207,-157,-67,32,88,50,-38,-95,-100,-78,-23,-1,-41,-96,-136,-130,-81,-7,18,-32,-105,-176,-216,-221,-213,-209,-228,-274,-287,-245,-155,-60,-17,-15,-58,-71,-34,17,68,21}
        },
        {    // H10e170a.wav
            {-4,1,-2,-2,-5,2,-4,7,-8,9,-11,-7,9,-28,38,-56,79,28,1975,5059,1509,-3809,-2376,393,-541,1249,8579,8620,895,208,4057,2176,-2229,-3005,-2780,-4441,-4925,-2900,-1389,-1949,-1945,12,945,514,1153,1847,1297,529,642,937,335,-278,-245,-125,-643,-1363,-1561,-1548,-1203,-667,-387,-88,311,543,627,639,612,520,206,-239,-578,-671,-669,-646,-531,-495,-529,-543,-411,-163,-35,41,96,66,31,51,114,157,94,-54,-126,-159,-281,-386,-341,-224,-212,-255,-233,-185,-160,-123,-41,1,-34,-52,-44,-49,-46,-20,-6,-59,-166,-238,-249,-203,-137,-132,-173,-190,-127,5,130,179,110,-23,-145,-227,-259,-237,-196,-190,-213,-239,-213,-160,-86,-37,-60,-19},
            {-3,3,0,9,-8,19,-29,19,-20,3,18,-50,79,187,3688,5722,-100,-4274,-1987,-12,-1091,3509,11685,8134,729,1974,4279,769,-3683,-3819,-3568,-5263,-5550,-3971,-2457,-1932,-1342,121,840,1017,1934,2334,1591,697,748,807,157,-224,-488,-671,-1162,-1984,-2213,-1945,-1410,-783,-285,50,200,259,323,400,494,574,601,365,53,76,77,-42,-137,-309,-543,-773,-729,-490,-367,-361,-318,-171,-128,-134,30,219,217,89,56,11,-136,-215,-157,-135,-259,-320,-290,-290,-282,-186,-69,-61,-121,-150,-119,-87,-18,66,62,-24,-109,-121,-84,-30,-10,-43,-117,-172,-159,-78,24,58,27,-66,-173,-239,-245,-225,-229,-255,-278,-274,-228,-129,-36,9,-23,-62,-54,-14,46,16}
        },
        {    // H10e175a.wav
            {1,-2,-2,-5,3,-4,8,-7,11,-14,-2,7,-24,39,-56,81,52,2332,5389,1239,-4189,-2409,431,-644,1758,9561,8690,531,441,4363,1882,-2754,-3169,-2899,-4718,-5166,-3143,-1538,-1932,-1896,-7,939,710,1401,1918,1354,559,568,954,376,-334,-331,-229,-763,-1483,-1658,-1587,-1255,-827,-498,-124,165,418,655,726,735,721,422,-72,-422,-475,-420,-525,-599,-551,-590,-653,-538,-290,-114,-53,-31,3,27,39,121,228,176,0,-57,-85,-245,-381,-330,-207,-226,-271,-236,-230,-248,-178,-39,-3,-53,-58,-22,-28,-35,6,12,-81,-191,-201,-165,-135,-113,-119,-163,-209,-151,-3,120,146,92,-7,-130,-235,-272,-255,-230,-215,-234,-241,-217,-142,-66,-30,-30,-58,-17},
            {-2,-4,2,-1,9,-8,15,-23,9,-10,-6,24,-50,76,146,3205,5704,466,-4451,-2283,242,-880,2954,11126,8425,445,1284,4484,1218,-3561,-3632,-3242,-5157,-5483,-3627,-2099,-1957,-1534,157,828,822,1855,2272,1398,629,777,833,200,-336,-449,-403,-1041,-1767,-1981,-2008,-1466,-688,-175,-30,21,280,447,496,557,587,498,278,117,40,-83,-200,-253,-360,-636,-819,-691,-511,-395,-279,-169,-87,-106,-99,74,247,216,71,23,-4,-139,-244,-185,-129,-240,-353,-342,-318,-292,-160,-27,-29,-95,-105,-65,-71,-64,-3,33,-6,-84,-126,-127,-82,-43,-62,-130,-192,-171,-60,74,115,44,-69,-177,-237,-248,-237,-234,-254,-283,-277,-215,-108,-26,-10,-26,-46,-41,-14,0}
        },
        {    // H10e180a.wav
            {-3,-3,-5,3,-3,8,-9,12,-17,0,-2,-18,31,-55,76,92,2739,5611,903,-4430,-2402,387,-752,2334,10419,8638,374,773,4521,1579,-3242,-3386,-3039,-4979,-5340,-3388,-1808,-1929,-1708,60,834,786,1699,2074,1334,630,646,854,332,-356,-433,-274,-863,-1672,-1795,-1747,-1466,-767,-247,-95,-3,247,572,692,682,686,489,82,-133,-80,-226,-460,-461,-458,-604,-803,-701,-365,-242,-217,-107,-1,-29,-62,97,241,207,79,0,-45,-199,-312,-241,-191,-264,-313,-301,-287,-268,-170,-38,-15,-66,-89,-60,-47,-30,18,3,-68,-131,-158,-153,-111,-75,-102,-158,-192,-148,-31,78,113,66,-31,-150,-238,-264,-253,-239,-246,-267,-268,-216,-123,-34,-12,-38,-58,-50,-10},
            {-3,-3,-5,3,-3,8,-9,12,-17,0,-2,-18,31,-55,76,92,2739,5611,903,-4430,-2402,387,-752,2334,10419,8638,374,773,4521,1579,-3242,-3386,-3039,-4979,-5340,-3388,-1808,-1929,-1708,60,834,786,1699,2074,1334,630,646,854,332,-356,-433,-274,-863,-1672,-1795,-1747,-1466,-767,-247,-95,-3,247,572,692,682,686,489,82,-133,-80,-226,-460,-461,-458,-604,-803,-701,-365,-242,-217,-107,-1,-29,-62,97,241,207,79,0,-45,-199,-312,-241,-191,-264,-313,-301,-287,-268,-170,-38,-15,-66,-89,-60,-47,-30,18,3,-68,-131,-158,-153,-111,-75,-102,-158,-192,-148,-31,78,113,66,-31,-150,-238,-264,-253,-239,-246,-267,-268,-216,-123,-34,-12,-38,-58,-50,-10}
        }
    },
    {    // elev20 
        {    // H20e000a.wav
            {2,-7,5,-8,25,-25,42,-42,31,-12,-31,87,-142,190,189,5258,6698,-1364,-1832,-3598,-4968,3432,4499,5801,11945,8001,-1496,-2268,2114,-1884,-8912,-9276,-5092,-2597,-3894,-2570,326,27,1124,2920,2273,2042,2528,1894,450,8,58,290,610,177,71,-421,-1627,-2465,-2353,-1369,-896,-952,-136,964,930,817,1010,644,-76,-491,-613,-902,-1130,-1185,-827,-394,-456,-577,-593,-477,-157,135,144,-10,7,110,101,84,156,238,119,-150,-290,-343,-409,-421,-359,-270,-241,-284,-245,-143,-4,151,188,79,-109,-162,-101,-38,-6,-17,-88,-225,-266,-198,-138,-123,-99,-141,-211,-178,-63,57,82,10,-130,-189,-161,-116,-58,-33,-91,-149,-117,-79,31,117,94,-47,-125,-127,-194,-53},
            {2,-7,5,-8,25,-25,42,-42,31,-12,-31,87,-142,190,189,5258,6698,-1364,-1832,-3598,-4968,3432,4499,5801,11945,8001,-1496,-2268,2114,-1884,-8912,-9276,-5092,-2597,-3894,-2570,326,27,1124,2920,2273,2042,2528,1894,450,8,58,290,610,177,71,-421,-1627,-2465,-2353,-1369,-896,-952,-136,964,930,817,1010,644,-76,-491,-613,-902,-1130,-1185,-827,-394,-456,-577,-593,-477,-157,135,144,-10,7,110,101,84,156,238,119,-150,-290,-343,-409,-421,-359,-270,-241,-284,-245,-143,-4,151,188,79,-109,-162,-101,-38,-6,-17,-88,-225,-266,-198,-138,-123,-99,-141,-211,-178,-63,57,82,10,-130,-189,-161,-116,-58,-33,-91,-149,-117,-79,31,117,94,-47,-125,-127,-194,-53}
        },
        {    // H20e005a.wav
            {-8,2,-4,3,-5,19,-20,33,-36,29,-15,-21,67,-104,146,224,4701,5937,-961,-1468,-2913,-4589,2403,4457,5379,10249,7816,-504,-1917,2028,-1229,-8050,-8853,-4583,-2363,-4109,-2681,462,-2,670,2646,2289,1845,2160,1590,529,289,138,320,632,138,78,-281,-1399,-2210,-2181,-1452,-948,-561,176,769,713,629,727,479,-64,-475,-682,-798,-828,-975,-924,-633,-514,-552,-619,-528,-214,133,155,-18,28,130,89,48,119,202,75,-170,-296,-332,-342,-337,-293,-220,-215,-252,-210,-123,-30,86,155,79,-98,-181,-145,-45,31,13,-68,-210,-284,-215,-137,-118,-121,-146,-179,-142,-36,63,71,-21,-135,-187,-160,-136,-102,-59,-90,-115,-82,-32,34,116,91,-15,-114,-168,-43},
            {-12,10,-13,27,-28,36,-28,1,30,-84,147,-194,226,-39,4616,8284,-486,-2668,-3458,-6392,3200,5602,4841,12849,10294,-1723,-3554,2368,-1286,-9453,-9787,-5627,-3208,-3933,-2547,264,-371,869,3401,2347,1858,2835,2426,780,-148,-178,256,755,247,150,-207,-1706,-2743,-2527,-1536,-1230,-1155,-151,864,961,1041,1092,649,115,-358,-671,-1105,-1365,-1181,-576,-146,-418,-555,-511,-470,-145,180,114,-106,-72,36,65,113,197,247,124,-79,-216,-356,-456,-448,-362,-247,-229,-307,-271,-138,-18,109,157,64,-102,-161,-104,-45,-29,-41,-73,-185,-256,-211,-129,-91,-93,-138,-221,-213,-93,68,134,46,-117,-200,-172,-139,-77,-11,-49,-152,-156,-96,-9,106,83,-45,-137,-144,-159,-161,-36}
        },
        {    // H20e010a.wav
            {2,-5,-1,-2,1,-2,15,-14,27,-31,31,-24,-1,42,-67,99,347,4430,5055,-788,-1084,-2812,-4120,2330,4157,4993,9457,7050,-349,-1074,2019,-1544,-7540,-7774,-3936,-2674,-4082,-2104,375,-287,718,2509,2042,1661,1835,1327,629,418,220,453,509,26,178,-252,-1370,-2008,-1928,-1410,-946,-137,687,600,207,400,510,242,-149,-556,-705,-719,-709,-758,-757,-715,-642,-500,-571,-567,-226,102,118,-33,0,106,43,3,103,138,-3,-176,-270,-302,-284,-241,-173,-140,-194,-240,-181,-108,-60,25,75,7,-107,-160,-131,-40,2,-1,-62,-199,-258,-226,-146,-107,-110,-130,-155,-116,-26,65,63,-34,-157,-203,-192,-167,-110,-60,-60,-98,-65,-18,51,107,86,-20,-131,-38},
            {10,-14,31,-21,21,0,-37,76,-130,181,-201,209,-124,3599,9567,1355,-3599,-3466,-7432,1751,6869,4831,12622,12770,-509,-5426,1821,-30,-9767,-11035,-6066,-3060,-4290,-3121,739,-217,-52,3478,2945,1580,2735,2993,1242,-54,-337,-34,901,497,162,84,-1490,-2984,-2916,-2002,-1701,-1092,-13,705,1075,1151,1085,717,237,-300,-881,-1446,-1490,-879,-288,-75,-299,-463,-430,-384,-163,186,216,-144,-236,-53,-1,61,188,283,183,-59,-235,-377,-450,-431,-316,-202,-212,-279,-217,-87,-32,50,103,38,-123,-198,-168,-109,-29,-19,-46,-161,-238,-190,-99,-63,-101,-153,-240,-217,-67,99,173,104,-69,-216,-215,-161,-86,-20,-46,-135,-167,-119,-12,110,99,-42,-159,-178,-181,-148,-49,0}
        },
        {    // H20e015a.wav
            {-3,1,-4,-2,-2,1,-1,11,-11,21,-27,26,-24,4,29,-51,76,375,3979,4467,-423,-916,-2807,-3520,2200,3550,4777,8762,6176,94,-261,1722,-1777,-6597,-6593,-3845,-2989,-3558,-1766,-42,-373,796,2179,1744,1524,1565,1158,787,612,375,358,288,181,249,-377,-1243,-1671,-1622,-1314,-798,139,667,281,-130,120,312,89,-310,-620,-619,-620,-613,-573,-573,-594,-602,-554,-553,-503,-288,-28,21,-42,-9,-24,-70,-12,85,99,-7,-152,-222,-215,-188,-145,-105,-96,-151,-213,-195,-140,-81,-41,-32,-59,-116,-133,-111,-73,-40,-27,-62,-161,-230,-192,-134,-101,-76,-103,-134,-117,-45,35,38,-31,-152,-229,-200,-169,-126,-60,-72,-85,-61,-3,59,100,84,-29,-22},
            {-9,22,-6,-1,31,-72,104,-145,167,-151,119,-57,2397,10105,4047,-4084,-4027,-7893,-40,7096,5239,12801,14424,1321,-5973,178,649,-8880,-12119,-7700,-3077,-3255,-4009,-12,788,-279,2682,3214,1838,2493,3112,1869,171,-351,-277,827,785,202,404,-1125,-2942,-3438,-3004,-1879,-732,-156,535,1242,1166,963,864,532,-397,-1441,-1824,-1190,-370,-268,-151,-143,-300,-294,-343,-201,162,291,-31,-270,-212,-157,-25,142,269,255,-42,-333,-406,-404,-367,-262,-200,-171,-194,-156,-59,-48,39,91,22,-167,-313,-270,-169,-57,-24,-34,-118,-207,-181,-102,-59,-94,-155,-237,-216,-71,124,242,175,-44,-246,-263,-191,-95,-25,-65,-160,-179,-136,-42,105,122,-17,-163,-205,-216,-171,-44,7,0}
        },
        {    // H20e020a.wav
            {-5,-1,1,-3,0,-2,1,-1,12,-10,17,-20,20,-17,5,24,-39,65,333,3455,4113,-7,-975,-2645,-2859,1760,3031,4673,7872,5517,744,279,1289,-1704,-5346,-5722,-4056,-2942,-2944,-1765,-433,-315,724,1727,1573,1418,1279,1195,1063,723,258,186,361,259,182,-282,-942,-1236,-1340,-1283,-775,74,377,-39,-355,-131,214,41,-551,-656,-431,-467,-508,-466,-332,-369,-548,-572,-555,-500,-370,-176,-97,-125,-74,-102,-166,-54,99,145,47,-114,-152,-123,-108,-78,-57,-80,-138,-183,-192,-178,-150,-113,-89,-85,-129,-167,-135,-81,-37,-27,-75,-142,-166,-130,-99,-95,-74,-83,-124,-126,-71,3,20,-41,-143,-206,-213,-193,-136,-74,-67,-78,-32,16,48,91,74,11},
            {4,16,-26,58,-91,107,-124,111,-56,-19,99,1192,9548,7247,-3288,-5142,-8163,-1829,6550,5312,12554,16479,3554,-5905,-846,318,-8010,-11876,-9513,-4791,-2361,-3116,-1159,472,294,2578,2892,1664,2573,3164,2167,563,-192,-450,605,1056,284,650,-442,-2898,-4267,-3652,-1770,-683,-296,411,1075,1109,1010,1010,659,-559,-1888,-1878,-695,-115,-430,-252,34,-30,-212,-462,-266,222,395,110,-201,-307,-306,-92,37,159,271,-31,-357,-445,-382,-286,-206,-143,-129,-131,-119,-33,-21,17,106,37,-198,-383,-367,-264,-107,-50,-44,-75,-172,-191,-151,-73,-64,-111,-176,-194,-84,117,294,249,-16,-266,-292,-208,-127,-44,-57,-148,-206,-183,-71,93,147,13,-151,-228,-230,-175,-42,32,-35,-21}
        },
        {    // H20e025a.wav
            {-3,-4,-2,0,-3,-2,-2,0,-1,9,-10,15,-17,13,-9,-2,22,-31,53,248,2898,3892,356,-1079,-2266,-2386,1163,2702,4424,6928,5150,1389,545,928,-1266,-4177,-5196,-4158,-2685,-2485,-1917,-695,-266,464,1405,1495,1246,1200,1317,1131,657,114,128,467,370,296,-5,-524,-951,-1439,-1459,-724,-45,-160,-469,-363,-58,89,-197,-617,-538,-256,-282,-389,-353,-196,-166,-386,-627,-663,-546,-411,-299,-273,-221,-147,-162,-172,-48,126,174,82,-28,-63,-60,-49,-51,-54,-71,-128,-182,-218,-226,-197,-148,-123,-138,-179,-187,-141,-71,-26,-37,-59,-102,-115,-89,-83,-78,-70,-85,-119,-123,-86,-39,-24,-66,-143,-185,-201,-209,-149,-67,-31,-48,-38,-9,26,71,20},
            {36,-46,71,-85,77,-66,14,73,-173,275,218,7838,10165,-768,-6043,-8871,-3465,5481,4953,11842,17660,6788,-4518,-2066,177,-7256,-11478,-10459,-7074,-2901,-2421,-1141,449,-199,2329,3608,1552,1861,3168,2768,836,-159,-345,399,1145,409,940,276,-3066,-5010,-3657,-1661,-1003,-289,275,631,999,1073,1063,488,-856,-1730,-1275,-479,-266,-485,-314,167,171,-242,-613,-381,241,549,289,-162,-294,-288,-209,-77,51,137,-21,-302,-479,-374,-244,-152,-65,-65,-55,-101,-53,-47,-2,125,69,-161,-409,-424,-350,-204,-56,-19,-94,-228,-228,-163,-83,-38,-49,-124,-161,-67,120,294,260,34,-234,-314,-265,-179,-45,-28,-134,-222,-226,-123,65,165,57,-139,-242,-256,-181,-44,45,12,-68,-20}
        },
        {    // H20e030a.wav
            {-4,-2,-2,-2,1,-2,-1,-2,2,0,8,-8,14,-11,11,0,-11,33,-32,46,161,2342,3705,674,-1081,-1825,-2128,617,2458,4008,6094,4991,1855,665,828,-728,-3260,-4715,-4069,-2428,-2197,-2046,-895,-331,250,1245,1458,1090,1087,1363,1101,446,53,333,664,611,639,195,-526,-1073,-1542,-1450,-833,-437,-604,-629,-248,22,-69,-412,-532,-266,-60,-181,-325,-227,-25,-59,-370,-651,-719,-595,-459,-413,-390,-319,-206,-159,-121,-10,109,185,143,59,33,11,-32,-86,-88,-65,-111,-193,-238,-245,-226,-190,-165,-171,-190,-169,-123,-71,-33,-12,-7,-55,-95,-82,-53,-40,-49,-82,-129,-151,-121,-64,-39,-75,-135,-173,-179,-159,-110,-47,-39,-64,-49,-17,9,5},
            {-35,54,-55,17,15,-93,176,-262,328,-245,5242,11776,3289,-5790,-9971,-5460,4518,4169,10245,18805,9452,-2525,-1542,-230,-6959,-10369,-10682,-9679,-4241,-1948,-1920,444,721,1467,3199,2453,2030,2308,2705,1770,43,-646,208,1451,505,986,763,-3245,-4997,-3480,-1955,-1045,-332,-43,301,889,1011,710,-59,-991,-880,-335,-639,-677,-277,-44,123,-14,-309,-622,-510,107,574,442,-18,-149,-256,-337,-132,-11,38,-84,-341,-412,-311,-262,-203,12,94,16,-93,-134,-111,-29,108,105,-81,-373,-467,-394,-256,-70,-20,-119,-297,-320,-198,-58,5,-9,-67,-131,-64,96,270,281,85,-189,-337,-314,-233,-76,1,-95,-229,-259,-172,22,169,99,-87,-250,-287,-217,-62,53,48,-28,-92,-26}
        },
        {    // H20e035a.wav
            {-2,-3,-3,-2,-3,-1,-3,-1,-3,1,-3,3,-9,9,-6,2,3,-17,33,-41,45,83,1794,3473,994,-974,-1447,-1981,163,2184,3520,5412,4849,2173,818,846,-255,-2492,-4184,-3888,-2283,-1988,-2128,-1087,-356,229,1148,1191,868,1054,1250,918,447,322,637,1015,891,456,-77,-544,-1098,-1729,-1631,-935,-695,-876,-617,-134,17,-214,-445,-276,-29,0,-152,-225,-119,-44,-90,-342,-633,-717,-640,-546,-510,-461,-357,-254,-162,-66,19,99,181,200,148,80,-3,-92,-133,-100,-69,-103,-201,-280,-287,-266,-226,-182,-172,-183,-170,-125,-71,-30,1,2,-31,-62,-67,-46,-53,-67,-106,-174,-183,-139,-85,-57,-81,-120,-150,-151,-129,-116,-80,-64,-71,-60,-59,-15},
            {9,9,-54,86,-145,190,-208,197,-178,2506,11274,7928,-3543,-10765,-8159,3297,4020,7343,18837,13053,-776,-1411,1319,-6052,-10812,-9467,-10793,-7487,-2081,-1860,-805,669,2080,3388,1992,2212,2906,2424,1669,584,-221,-416,1248,1212,882,352,-3112,-4026,-3246,-2710,-1038,-218,-319,-50,803,948,-47,-870,-814,193,430,-677,-914,-224,322,309,-270,-600,-662,-551,-101,390,483,220,71,-212,-413,-129,-3,-30,-137,-328,-333,-317,-304,-219,70,242,101,-92,-237,-197,-42,115,113,-73,-303,-419,-396,-272,-91,-37,-126,-309,-379,-284,-103,67,88,0,-138,-99,73,234,308,151,-140,-364,-367,-244,-94,14,-61,-209,-276,-207,-16,148,138,-24,-205,-301,-261,-115,48,88,24,-68,-130,-35}
        },
        {    // H20e040a.wav
            {1,0,-2,-1,-1,-4,2,-1,0,-1,5,-2,5,-2,8,3,-2,10,-16,31,-30,47,26,1306,3178,1310,-773,-1134,-1842,-220,1870,3063,4801,4700,2467,977,913,181,-1816,-3627,-3661,-2188,-1817,-2109,-1106,-261,126,845,862,667,1023,1191,934,771,852,923,867,566,238,-113,-680,-1399,-1855,-1512,-959,-917,-928,-501,-70,-4,-189,-317,-115,98,37,-143,-194,-118,-44,-78,-329,-586,-684,-677,-631,-561,-452,-357,-256,-127,-23,62,126,191,228,159,49,-41,-102,-117,-106,-87,-109,-213,-312,-318,-254,-204,-186,-155,-144,-144,-116,-66,-12,9,28,14,-40,-69,-79,-70,-82,-127,-167,-176,-153,-90,-37,-38,-83,-138,-144,-128,-102,-75,-62,-72,-80,-19},
            {49,-92,100,-113,88,-31,-52,134,476,8590,11609,932,-10197,-11348,799,4852,4496,16589,16600,2249,-1492,2063,-3497,-10256,-9621,-10562,-9502,-3969,-2420,-1487,209,1141,3644,3364,1985,2368,2899,2657,500,-415,-99,904,1363,591,-204,-2528,-3272,-2883,-2891,-1419,-417,-295,-45,551,502,-786,-1420,-506,824,844,-344,-799,-206,424,435,-205,-653,-804,-860,-389,183,409,372,166,-110,-297,-137,-12,-29,-91,-245,-275,-345,-397,-233,141,349,148,-147,-300,-229,-89,81,105,-51,-238,-379,-381,-300,-112,-18,-74,-266,-433,-358,-168,61,148,52,-109,-132,15,188,305,217,-81,-364,-415,-300,-118,30,5,-157,-287,-251,-75,118,165,42,-136,-291,-313,-159,21,101,69,-32,-137,-129,-20}
        },
        {    // H20e045a.wav
            {1,0,-1,-1,-3,0,-3,1,-2,-1,-1,2,-3,1,-1,6,5,-10,13,-20,27,-20,31,-4,888,2795,1581,-498,-878,-1714,-551,1546,2609,4236,4582,2690,1094,1025,563,-1276,-3076,-3341,-2108,-1589,-1892,-1155,-360,-103,383,587,772,1088,1227,1378,1213,713,490,660,474,-60,-421,-885,-1502,-1668,-1296,-1056,-1042,-816,-323,-15,-39,-150,-196,-26,65,-48,-120,-141,-105,-44,-103,-338,-562,-656,-717,-691,-529,-395,-338,-231,-83,5,59,115,169,181,112,22,-45,-95,-124,-135,-123,-148,-246,-304,-288,-252,-205,-155,-110,-113,-129,-103,-57,-17,15,29,4,-52,-86,-86,-101,-111,-128,-158,-167,-147,-80,-24,-25,-67,-126,-153,-122,-96,-62,-58,-97,-26},
            {-38,16,1,-65,135,-217,281,-296,4587,12621,6832,-7076,-13861,-3769,5666,3192,12293,18804,6224,-1080,2395,-589,-8812,-9641,-9644,-11189,-5933,-2644,-3184,-826,772,2620,3534,2948,3167,2258,2716,2174,-43,-603,579,1802,-52,-1297,-1373,-2499,-3002,-2732,-1590,-729,-446,56,486,-48,-1615,-1771,-4,1126,834,44,-396,-23,398,372,-11,-487,-785,-1055,-881,-244,295,416,141,-59,-107,-89,-45,-14,74,-34,-289,-392,-355,-241,62,363,239,-144,-363,-282,-124,-2,60,9,-145,-374,-431,-313,-118,10,-5,-170,-412,-412,-223,28,150,49,-83,-133,-41,116,264,266,1,-338,-452,-344,-170,-6,42,-63,-228,-286,-158,59,165,96,-64,-252,-331,-207,-20,82,81,21,-103,-189,-92,-4}
        },
        {    // H20e050a.wav
            {1,2,2,-1,0,-3,-2,-3,3,-1,1,1,1,-2,1,1,4,9,-12,14,-16,23,-12,14,1,558,2348,1793,-166,-667,-1572,-819,1197,2187,3758,4462,2861,1216,1131,859,-814,-2472,-2842,-1907,-1449,-1807,-1345,-635,-287,212,611,1033,1397,1473,1250,755,446,372,388,74,-370,-515,-910,-1349,-1344,-1183,-1115,-931,-561,-237,-68,-38,-114,-208,-121,-2,-7,-57,-105,-88,-96,-177,-330,-539,-673,-679,-595,-460,-359,-293,-177,-82,-28,39,89,106,122,102,9,-73,-108,-151,-168,-160,-184,-222,-264,-269,-224,-170,-111,-85,-90,-92,-98,-83,-36,-1,16,-8,-61,-90,-113,-123,-123,-125,-140,-153,-133,-75,-18,-17,-56,-114,-127,-114,-89,-72,-85,-22},
            {-62,86,-121,121,-108,54,-31,1086,9917,12126,-876,-13850,-9948,4237,4375,7144,18590,11094,-200,2084,2192,-5678,-9583,-9043,-11234,-8461,-3313,-3699,-2435,-516,1241,3620,2936,3214,3361,2920,2633,799,280,612,1040,-499,-1826,-785,-1964,-3007,-2450,-1958,-1055,-407,105,332,-559,-2134,-2014,162,1293,900,347,-105,159,527,344,109,-250,-676,-1060,-1184,-754,-64,258,77,-36,-38,-57,3,19,165,238,-97,-402,-381,-200,7,247,245,-55,-312,-367,-257,-109,50,73,-93,-369,-481,-332,-141,31,49,-83,-293,-401,-269,-58,99,83,-63,-160,-127,6,211,293,96,-260,-471,-402,-244,-55,69,-4,-169,-277,-221,-12,141,120,-15,-200,-306,-239,-66,46,70,36,-70,-194,-165,-10,12}
        },
        {    // H20e055a.wav
            {0,0,0,1,-1,1,-3,-1,-2,1,-1,0,-1,-1,-1,-2,3,3,8,-13,12,-9,14,-6,-2,14,308,1871,1911,198,-452,-1403,-1066,814,1821,3326,4342,3000,1291,1215,1147,-253,-1689,-2325,-1939,-1618,-1899,-1395,-556,-292,257,1111,1322,975,928,957,527,114,8,74,-116,-376,-443,-812,-1108,-1030,-1001,-1011,-789,-449,-231,-111,-130,-249,-277,-142,7,58,-7,-137,-152,-139,-226,-370,-479,-528,-576,-533,-393,-306,-271,-196,-99,-62,-21,41,71,84,48,-26,-96,-152,-176,-176,-170,-184,-205,-210,-213,-192,-144,-90,-55,-72,-96,-120,-112,-51,-11,1,-30,-85,-105,-119,-135,-136,-125,-118,-128,-118,-73,-31,-11,-35,-78,-114,-117,-112,-107,-24},
            {-1,15,-60,120,-192,241,-259,4547,13528,7652,-9312,-15327,-1700,6720,3833,14331,16583,2437,536,4045,-1424,-8147,-8612,-9997,-11125,-5148,-3067,-4055,-1661,-285,1918,3158,3235,3470,2878,3848,2413,278,1224,1535,-981,-2805,-575,-930,-3241,-2569,-2063,-1517,-583,134,433,-944,-2706,-2153,262,1257,882,729,334,190,487,493,355,-86,-585,-870,-1248,-1211,-511,18,-75,-141,-73,-101,18,82,220,457,214,-220,-334,-232,-62,172,237,-1,-249,-389,-364,-226,-34,113,-24,-331,-509,-381,-166,0,87,27,-130,-317,-312,-137,30,107,24,-161,-232,-122,79,270,217,-101,-411,-452,-319,-147,49,89,-75,-266,-278,-101,105,159,56,-130,-294,-268,-107,28,72,51,-41,-170,-213,-76,70,23}
        },
        {    // H20e060a.wav
            {0,0,1,0,2,0,0,-2,0,-1,0,1,0,0,0,0,-1,7,0,7,-6,6,1,6,-1,-8,32,151,1407,1915,552,-213,-1211,-1296,444,1518,2967,4209,3064,1393,1403,1621,378,-1228,-2230,-2211,-1626,-1497,-1190,-355,214,537,682,559,604,672,425,52,-176,-132,64,-4,-273,-427,-608,-663,-687,-908,-941,-679,-440,-321,-251,-274,-342,-299,-90,73,24,-106,-151,-152,-228,-228,-225,-352,-450,-481,-426,-355,-325,-265,-211,-158,-91,-44,3,10,13,13,-70,-135,-148,-160,-169,-182,-160,-133,-164,-178,-159,-121,-68,-66,-73,-101,-128,-101,-69,-33,-23,-51,-87,-120,-138,-132,-120,-94,-97,-111,-104,-83,-17,7,-7,-60,-106,-128,-148,-36},
            {50,-74,64,-11,-69,125,424,8862,14163,483,-15457,-11100,5208,5504,6981,18346,9323,-976,3402,2784,-4498,-8522,-8259,-10665,-9099,-3807,-3924,-2990,-1504,-77,2480,2545,3440,3354,3182,3855,1983,1824,1806,-872,-2460,-1019,-623,-2722,-2730,-2378,-2317,-878,157,392,-1016,-2991,-2442,-55,1221,1039,880,818,516,375,444,557,282,-388,-748,-1131,-1423,-960,-352,-213,-217,-219,-287,-149,71,307,590,511,80,-163,-154,-102,60,205,93,-186,-390,-447,-337,-119,60,20,-238,-441,-438,-263,-62,88,139,32,-183,-303,-212,-48,101,116,-74,-282,-279,-85,149,262,90,-239,-436,-397,-235,-30,117,43,-183,-309,-211,7,156,137,-1,-208,-319,-209,-20,90,86,27,-117,-230,-169,12,118,31}
        },
        {    // H20e065a.wav
            {-1,0,-2,1,-1,1,0,0,-2,-1,-2,-2,1,-2,-1,-3,0,-2,6,-2,7,-5,-1,12,-10,0,-5,41,53,995,1820,857,58,-998,-1513,62,1276,2689,4044,3187,1785,1733,1813,406,-1254,-1897,-1793,-1380,-1024,-372,57,-352,-275,233,141,22,65,-17,-207,-163,179,216,-23,-145,-138,-231,-382,-534,-817,-929,-747,-528,-406,-394,-404,-343,-224,-102,-51,-76,-103,-146,-168,-131,-110,-166,-267,-335,-384,-408,-374,-328,-305,-259,-163,-110,-99,-73,-51,-42,-54,-80,-111,-137,-161,-169,-144,-113,-106,-127,-144,-140,-114,-83,-70,-80,-103,-121,-110,-87,-69,-53,-70,-104,-129,-118,-108,-102,-90,-95,-97,-103,-51,-3,17,-12,-65,-109,-157,-42},
            {64,-114,150,-146,116,-116,2164,12674,11790,-7199,-17565,-4138,8418,4224,11745,17047,2646,28,4728,556,-6250,-8443,-8220,-10175,-7003,-4033,-4305,-2258,-1377,526,2252,2617,3290,2879,4007,3346,2235,3232,231,-2723,-1210,115,-1633,-3241,-2732,-2612,-1975,-286,505,-765,-3182,-2960,-417,892,1047,1089,1162,1119,581,217,488,623,52,-553,-983,-1456,-1306,-697,-423,-344,-285,-445,-476,-212,227,667,734,427,80,-5,5,38,108,103,-56,-323,-482,-486,-275,-25,42,-126,-348,-439,-388,-174,28,171,184,-7,-238,-259,-109,33,149,55,-215,-374,-281,-27,183,205,-33,-325,-418,-317,-132,64,120,-54,-279,-302,-118,81,168,105,-74,-273,-313,-146,35,113,103,-9,-186,-237,-102,65,111,25}
        },
        {    // H20e070a.wav
            {0,-1,1,-1,1,1,2,2,1,0,1,0,-1,3,2,1,-1,4,-1,5,2,9,-3,3,22,-21,5,5,44,16,680,1646,1093,352,-774,-1738,-334,1165,2618,4150,3559,1950,1299,1367,723,-478,-1316,-1278,-428,-316,-839,-843,-751,-683,-606,-556,-372,-324,-202,45,237,314,264,306,169,-6,-15,-144,-498,-941,-1008,-768,-589,-516,-481,-389,-349,-337,-205,-92,-86,-74,-43,-29,-60,-62,-58,-172,-291,-368,-406,-395,-384,-323,-238,-192,-160,-149,-133,-108,-70,-36,-68,-105,-126,-133,-128,-118,-84,-70,-96,-130,-136,-112,-87,-83,-74,-86,-109,-122,-125,-97,-78,-61,-80,-102,-104,-102,-94,-90,-70,-68,-55,-35,-8,-7,-21,-57,-118,-33},
            {37,-93,156,-212,245,-265,4578,15065,7476,-13504,-16077,2577,8600,4458,15286,12554,-821,2297,4631,-1157,-7511,-8227,-7852,-9144,-5847,-4518,-4086,-2387,-1284,1280,1995,2694,3011,2883,4136,3224,3288,1999,-1711,-1303,34,-378,-1934,-3219,-3123,-2842,-1283,125,-539,-2742,-3615,-1233,519,779,1190,1323,1600,1321,415,163,543,583,-90,-758,-1320,-1510,-1047,-654,-471,-358,-524,-712,-595,-142,479,805,728,420,209,168,146,128,55,19,-160,-416,-551,-502,-208,16,-25,-212,-364,-459,-354,-76,143,241,158,-65,-239,-179,-33,118,151,-87,-344,-401,-212,28,175,144,-131,-370,-373,-217,-25,108,80,-139,-329,-263,-26,157,174,46,-159,-316,-265,-61,75,117,96,-36,-201,-198,-41,73,87,20}
        },
        {    // H20e075a.wav
            {0,1,-1,0,-2,2,1,1,1,-1,-1,-2,1,-1,4,1,-2,1,1,-3,5,4,5,0,6,17,-32,11,18,46,-5,441,1462,1276,619,-628,-1970,-620,1464,3135,4096,2828,1321,1337,1930,1343,227,-42,-454,-1011,-1075,-1118,-1352,-1561,-1439,-1163,-950,-563,-170,73,232,477,719,596,380,258,184,79,-209,-660,-1036,-1017,-803,-620,-550,-553,-513,-491,-363,-181,-90,-16,54,72,34,16,31,-30,-172,-300,-399,-442,-439,-398,-307,-260,-233,-213,-209,-159,-104,-61,-52,-75,-80,-96,-110,-103,-94,-71,-70,-96,-113,-141,-127,-85,-70,-67,-97,-135,-155,-145,-97,-54,-45,-77,-109,-106,-101,-81,-53,-43,-41,-63,-51,-33,-17,-28,-79,-24},
            {-10,-32,98,-193,264,-189,6935,15901,2848,-17553,-12630,7405,7414,5734,16506,7789,-1657,4180,4334,-2372,-8562,-7747,-7230,-8246,-5463,-4640,-3886,-2847,-1083,1430,2031,2910,2594,3175,4093,3451,3225,-143,-1746,336,534,-311,-2399,-3378,-2965,-2641,-997,-442,-2167,-3918,-2514,31,312,744,1498,1784,1902,1146,386,305,554,439,-244,-998,-1492,-1360,-938,-655,-462,-523,-784,-920,-658,35,603,768,700,483,372,307,219,123,34,-27,-248,-497,-629,-495,-155,-2,-106,-253,-402,-480,-302,-25,211,266,104,-114,-221,-108,28,136,85,-226,-444,-383,-152,52,138,68,-211,-412,-331,-141,33,111,13,-219,-359,-213,55,179,124,-39,-239,-334,-221,-12,85,96,53,-89,-205,-169,-31,53,48,8}
        },
        {    // H20e080a.wav
            {0,1,1,-1,1,-1,0,1,1,1,0,0,-1,1,-1,2,-1,-2,0,0,-3,5,1,5,6,2,5,-32,34,28,20,-24,320,1320,1417,842,-606,-1949,-228,1894,2595,2896,2548,2112,1923,2362,2587,1284,-588,-1408,-1136,-1398,-2170,-2164,-1870,-1855,-1534,-756,-170,-72,188,755,1028,843,585,513,296,91,5,-354,-828,-1073,-960,-769,-706,-707,-691,-593,-441,-266,-126,-6,90,149,149,118,89,19,-74,-231,-369,-431,-468,-444,-377,-314,-291,-285,-254,-198,-134,-96,-71,-54,-56,-61,-61,-67,-102,-125,-94,-57,-73,-130,-141,-102,-81,-92,-102,-118,-150,-148,-105,-77,-72,-68,-83,-97,-93,-66,-43,-52,-50,-58,-60,-61,-48,-39,-60,-17},
            {-47,31,29,-136,222,19,8676,15809,-915,-19630,-9012,10242,6197,6997,16048,4299,-1348,5481,4377,-3319,-9247,-7058,-6674,-7725,-5374,-4467,-3911,-3253,-823,1230,1916,3138,2624,3238,4253,3695,1698,-1293,-451,850,651,150,-2492,-3546,-2878,-1916,-1025,-1935,-3591,-3681,-1295,69,55,1035,1781,2163,1935,982,508,507,620,303,-481,-1122,-1383,-1265,-962,-576,-474,-761,-998,-1011,-603,111,593,757,703,564,512,413,263,141,79,-32,-304,-560,-649,-434,-131,-58,-138,-270,-437,-460,-232,30,229,269,104,-124,-193,-51,86,144,15,-292,-466,-351,-118,67,162,22,-284,-418,-284,-65,75,111,-18,-266,-330,-128,107,166,80,-61,-266,-331,-165,27,108,98,17,-130,-205,-119,17,60,24,1}
        },
        {    // H20e085a.wav
            {0,0,1,1,-1,0,-2,0,0,1,1,1,1,0,0,-2,2,-1,-2,2,0,-1,3,4,13,2,-12,5,3,38,8,2,-16,322,1253,1606,1215,-253,-1809,-1003,1063,2842,3415,2839,2792,3260,3098,1751,359,-684,-1869,-2205,-2169,-2558,-2463,-2024,-1729,-1197,-517,-15,354,739,1046,1126,916,544,342,201,49,-195,-580,-840,-992,-1017,-913,-813,-775,-669,-442,-296,-188,-32,109,179,204,225,172,35,-87,-173,-291,-406,-461,-440,-405,-391,-346,-311,-282,-224,-151,-106,-100,-76,-42,-17,-5,-42,-123,-166,-112,-45,-45,-78,-106,-122,-118,-115,-113,-107,-106,-108,-110,-111,-112,-82,-46,-46,-54,-63,-64,-68,-57,-43,-51,-70,-71,-65,-66,-16},
            {-58,51,-3,-104,190,127,9430,15520,-3011,-20323,-6574,11587,5505,7428,14972,2401,-882,6381,4809,-3813,-9573,-6349,-6241,-7608,-5407,-4237,-4014,-3619,-716,1073,1650,3081,2800,3420,4467,3356,291,-1342,508,866,741,383,-2258,-3308,-2732,-1526,-1315,-3211,-4392,-3100,-759,-272,-14,1292,1999,2315,1829,918,676,717,705,217,-623,-1126,-1249,-1267,-998,-498,-554,-964,-1158,-1049,-536,72,505,734,727,608,582,486,291,193,142,-23,-339,-588,-629,-395,-164,-134,-170,-305,-468,-447,-186,68,221,250,100,-117,-182,-28,120,151,-23,-329,-472,-345,-114,68,167,-10,-344,-429,-249,-29,92,101,-41,-278,-310,-88,126,156,67,-81,-290,-333,-140,55,105,63,-25,-164,-206,-92,56,66,-13,-10}
        },
        {    // H20e090a.wav
            {0,0,0,0,0,0,0,-1,-1,0,3,2,1,1,0,-2,0,3,-1,-1,2,-2,3,5,7,13,-16,-2,27,20,1,-2,-5,20,508,1544,2636,1537,-2263,-3454,-307,2902,3821,3483,3829,3690,2417,1915,1402,-244,-2091,-2772,-2376,-2443,-2683,-2149,-1604,-1470,-950,-5,511,625,913,1209,1070,650,375,261,72,-147,-341,-639,-978,-1161,-1088,-905,-779,-629,-438,-324,-234,-50,106,158,210,261,207,36,-109,-162,-235,-356,-418,-418,-434,-439,-399,-331,-271,-234,-175,-116,-114,-113,-44,24,3,-80,-145,-149,-113,-66,-36,-41,-77,-126,-153,-144,-117,-93,-72,-87,-132,-136,-123,-89,-38,0,-17,-79,-96,-84,-59,-47,-56,-69,-84,-101,-99,-22},
            {-49,39,17,-128,221,15,9095,15491,-3097,-20245,-5994,12020,5579,6793,13929,1915,-706,6968,5554,-3588,-9683,-5851,-5689,-7774,-5670,-4079,-4003,-3959,-881,1050,1432,2871,2775,3551,4712,2728,-422,-749,758,613,973,583,-2119,-2942,-2219,-1469,-1928,-3865,-4382,-2767,-988,-497,124,1300,2065,2383,1681,863,838,947,846,218,-621,-1036,-1187,-1302,-984,-494,-673,-1065,-1247,-1070,-503,-6,389,677,742,628,609,536,331,260,220,32,-327,-591,-598,-370,-208,-189,-205,-356,-479,-429,-169,71,215,255,85,-118,-163,-8,137,163,-19,-339,-481,-335,-101,57,139,-40,-350,-422,-238,-11,89,96,-44,-281,-302,-65,151,165,66,-93,-301,-321,-119,53,76,29,-47,-173,-198,-77,64,64,-32,-16}
        },
        {    // H20e095a.wav
            {0,0,0,0,0,-1,0,-1,0,2,2,0,1,-1,-1,-1,-2,2,1,-1,-2,-1,0,7,0,9,-1,-14,24,30,4,-36,15,-16,477,1814,2629,1419,-2261,-3763,-429,2691,3987,4510,3645,2594,2589,2612,1023,-937,-1675,-2216,-2721,-2572,-2131,-1934,-1832,-1359,-784,-239,282,605,859,954,920,794,515,220,31,-16,-211,-639,-1020,-1152,-1089,-939,-724,-531,-394,-334,-231,-54,76,148,181,197,131,9,-91,-161,-222,-300,-362,-401,-445,-462,-397,-319,-255,-209,-185,-138,-125,-104,-35,-3,-50,-126,-132,-103,-99,-72,-37,-38,-74,-129,-153,-142,-105,-62,-71,-107,-145,-135,-92,-67,-24,5,-23,-75,-106,-94,-66,-54,-55,-87,-111,-111,-100,-22},
            {-18,-16,81,-191,280,-234,7685,15633,-1194,-19535,-7196,11596,6409,5310,12917,2710,-949,7129,6616,-2538,-9602,-5801,-4872,-7918,-6254,-4143,-3872,-4204,-1354,1033,1354,2633,2613,3384,4698,2416,-423,-207,651,383,1059,813,-1840,-2744,-1835,-1406,-2304,-4100,-4152,-2627,-1411,-725,157,1225,1972,2290,1631,838,852,1125,1118,316,-576,-870,-1114,-1326,-1001,-554,-744,-1101,-1274,-1091,-541,-109,260,581,706,628,613,563,389,320,282,137,-262,-574,-568,-386,-246,-229,-250,-399,-514,-438,-170,62,195,244,91,-113,-168,13,163,164,-9,-320,-455,-342,-127,40,100,-60,-334,-405,-240,-19,82,82,-54,-280,-290,-51,170,177,61,-85,-277,-314,-137,24,38,-7,-51,-157,-204,-94,49,53,-21,-10}
        },
        {    // H20e100a.wav
            {1,0,-1,1,-1,-1,-1,0,0,0,2,0,1,-1,-2,0,1,0,2,0,-1,-2,1,6,0,5,-1,10,2,29,19,-31,0,178,1267,2130,1336,-94,-1968,-2472,246,3455,4513,3555,2472,2515,2793,2093,266,-1300,-1763,-1805,-2020,-2301,-2057,-1573,-1372,-1156,-702,-183,82,330,631,717,738,672,518,304,97,-27,-287,-685,-1023,-1121,-977,-786,-625,-471,-329,-234,-179,-88,67,152,107,45,-1,-47,-93,-150,-202,-268,-345,-389,-427,-426,-356,-279,-224,-197,-174,-149,-119,-80,-72,-83,-102,-123,-109,-87,-74,-64,-51,-55,-99,-141,-133,-98,-68,-67,-98,-130,-142,-107,-53,-23,-17,-30,-49,-70,-94,-97,-71,-62,-84,-128,-127,-86,-67,-15},
            {31,-86,154,-235,296,-375,5378,15342,2549,-17841,-9833,10003,7940,3578,11396,4743,-1269,6444,7917,-554,-9132,-6406,-3873,-7636,-7122,-4536,-3722,-4258,-2072,862,1432,2428,2432,3005,4368,2443,52,137,454,302,983,943,-1343,-2555,-1810,-1487,-2266,-3803,-3991,-2764,-1701,-822,12,1003,1802,2094,1634,868,778,1206,1383,555,-451,-727,-957,-1263,-1078,-664,-771,-1086,-1244,-1102,-616,-223,142,476,624,612,608,581,444,383,359,240,-154,-512,-550,-412,-270,-245,-278,-423,-531,-461,-203,45,161,229,128,-72,-156,7,177,175,21,-265,-411,-348,-169,8,74,-44,-296,-387,-233,-33,63,60,-52,-237,-269,-51,170,178,86,-34,-221,-307,-189,-13,29,-15,-51,-147,-202,-116,32,77,17,-2}
        },
        {    // H20e105a.wav
            {1,1,0,0,0,0,0,2,2,2,1,0,-1,0,0,1,2,3,2,0,0,2,4,3,6,2,0,11,19,5,16,20,150,1096,1869,1037,5,-853,-1913,-866,2398,4478,3644,1915,2011,2838,2084,580,-424,-1213,-1790,-1743,-1426,-1484,-1693,-1372,-729,-566,-596,-225,98,71,151,466,571,431,353,351,215,-155,-539,-748,-900,-989,-848,-608,-465,-384,-246,-102,-81,-63,46,100,-1,-113,-128,-139,-152,-145,-187,-271,-351,-389,-354,-313,-287,-232,-190,-185,-161,-113,-94,-124,-153,-123,-93,-111,-109,-82,-60,-58,-69,-89,-126,-127,-86,-56,-54,-89,-117,-121,-112,-71,-29,-4,-13,-52,-74,-78,-78,-81,-86,-105,-127,-132,-101,-61,-44,-10},
            {71,-127,170,-192,178,-229,2689,13675,7466,-14284,-13139,6735,9729,2449,8711,7501,-728,4587,8885,2389,-7762,-7698,-3136,-6513,-8101,-5331,-3629,-4172,-2940,390,1580,2273,2235,2519,3911,2613,631,456,306,254,848,1030,-712,-2360,-1964,-1690,-2199,-3164,-3639,-3055,-2092,-841,-40,640,1455,1837,1646,963,714,1136,1472,875,-182,-592,-790,-1118,-1137,-826,-774,-1027,-1197,-1114,-717,-339,10,350,527,551,558,600,501,415,412,332,-26,-418,-522,-452,-317,-271,-287,-415,-542,-495,-278,-13,106,193,158,-12,-117,-26,148,175,62,-184,-379,-371,-219,-45,47,-17,-232,-366,-268,-69,30,36,-30,-194,-256,-95,131,187,114,23,-167,-302,-232,-68,11,-30,-69,-156,-212,-124,26,97,34,-1}
        },
        {    // H20e110a.wav
            {0,0,0,0,0,1,1,1,1,1,0,-1,-1,-2,0,0,0,0,0,-2,0,4,1,3,-2,9,0,6,18,3,10,191,1142,1802,781,-231,-487,-1194,-1116,1525,4349,3796,1765,1878,2509,1587,527,-180,-1131,-1615,-1312,-1211,-1445,-1205,-677,-519,-559,-228,79,-167,-256,-12,23,7,146,273,279,167,-4,-282,-661,-848,-775,-692,-665,-543,-344,-214,-98,-4,16,33,7,-59,-126,-210,-254,-261,-240,-197,-235,-337,-359,-292,-254,-226,-185,-190,-190,-161,-118,-101,-152,-181,-154,-130,-117,-113,-109,-98,-84,-82,-107,-131,-117,-80,-50,-61,-87,-94,-105,-104,-72,-47,-37,-26,-29,-51,-91,-98,-72,-91,-128,-145,-135,-108,-74,-59,-61,-15},
            {64,-86,78,-31,-55,109,542,10070,11878,-8027,-15674,1429,10813,2909,4853,9575,1698,2077,8575,5803,-4816,-9073,-3542,-4486,-8560,-6697,-3694,-3849,-3845,-520,1697,2217,2047,2014,3417,2873,1095,798,387,102,663,1098,0,-2001,-2264,-1877,-2167,-2656,-3081,-3089,-2543,-1098,4,423,1008,1449,1588,1166,730,959,1371,1132,221,-386,-626,-940,-1129,-956,-792,-946,-1129,-1119,-806,-440,-117,218,429,486,473,590,581,442,414,388,133,-281,-474,-471,-379,-310,-287,-354,-510,-531,-362,-100,41,138,179,66,-62,-44,107,164,104,-91,-333,-396,-262,-81,18,12,-147,-311,-307,-142,9,25,-5,-125,-241,-156,64,205,157,51,-97,-255,-240,-112,-37,-65,-101,-132,-172,-118,20,89,34,-1}
        },
        {    // H20e115a.wav
            {0,0,0,0,1,2,2,1,0,1,-1,-1,0,-2,-1,1,-1,0,0,1,1,1,4,-4,9,-1,8,5,3,23,182,1226,1911,662,-500,-490,-839,-893,1429,4059,3465,1737,1956,2438,1475,209,-515,-1136,-1654,-1514,-1025,-1014,-1167,-745,-80,170,113,129,216,82,-211,-192,-94,-269,-265,48,118,-171,-400,-507,-661,-749,-636,-467,-438,-439,-277,-52,78,128,128,64,-60,-171,-242,-298,-342,-361,-324,-337,-405,-345,-242,-182,-147,-150,-130,-138,-148,-115,-119,-153,-170,-136,-128,-160,-146,-109,-99,-126,-145,-132,-133,-122,-66,-40,-49,-72,-97,-92,-78,-61,-46,-41,-54,-52,-49,-63,-81,-102,-111,-124,-135,-141,-110,-79,-66,-71,-95,-25},
            {-1,28,-77,132,-209,262,-294,5138,13334,717,-15058,-5529,9528,5325,973,8967,6122,603,6231,8457,-71,-8982,-5654,-2501,-7499,-8430,-4469,-3235,-4382,-2063,1425,2346,1884,1505,2850,3183,1460,1013,813,39,301,1044,675,-1301,-2480,-2184,-2108,-2383,-2678,-2777,-2698,-1648,-196,378,682,1013,1360,1319,862,772,1132,1235,610,-83,-447,-753,-1041,-1035,-823,-898,-1060,-1087,-887,-534,-264,68,322,417,421,494,603,488,371,382,265,-93,-402,-482,-416,-357,-317,-302,-432,-525,-462,-225,-30,48,151,126,0,-49,55,147,115,-29,-263,-393,-313,-122,-16,9,-70,-246,-314,-217,-48,15,-4,-61,-205,-221,-24,168,179,74,-35,-168,-240,-178,-110,-117,-113,-92,-111,-126,-41,51,10,-9}
        },
        {    // H20e120a.wav
            {-1,0,0,1,2,2,2,0,0,-1,-1,-2,-1,-2,0,-2,-1,-1,-1,1,-2,5,-7,5,5,9,-2,4,17,190,1348,2031,573,-706,-553,-696,-733,1565,4154,3392,1501,1731,2424,1408,-4,-516,-1253,-2104,-1713,-946,-1115,-1235,-461,125,92,369,855,667,127,74,222,-111,-480,-407,-281,-321,-438,-561,-687,-749,-659,-521,-416,-344,-301,-238,-133,26,218,286,171,2,-118,-207,-320,-399,-401,-421,-534,-548,-401,-277,-153,-80,-98,-96,-81,-77,-97,-143,-143,-103,-104,-133,-169,-177,-136,-108,-143,-195,-201,-168,-121,-72,-37,-45,-56,-74,-80,-65,-62,-38,-39,-52,-62,-73,-78,-85,-98,-122,-135,-142,-119,-108,-80,-79,-79,-92,-157,-44},
            {-59,90,-109,101,-82,21,-5,1129,10253,8790,-9187,-11493,4418,8256,-386,4657,10210,2487,2611,8654,5190,-5820,-8270,-2457,-4769,-9247,-6349,-2920,-4008,-3743,245,2522,1930,1057,2142,3384,1973,926,1317,492,-128,685,1113,-347,-2270,-2494,-2131,-2246,-2532,-2446,-2370,-2091,-768,257,529,730,1064,1289,1008,704,879,1191,894,206,-214,-520,-869,-1010,-886,-856,-982,-1026,-901,-619,-388,-119,220,385,398,411,528,509,353,326,334,98,-281,-449,-415,-367,-350,-292,-333,-460,-490,-344,-115,-30,69,149,68,-29,13,127,110,6,-165,-321,-331,-193,-47,3,-16,-150,-280,-244,-98,3,2,-46,-136,-215,-115,99,158,100,35,-71,-205,-250,-160,-102,-101,-64,-71,-131,-102,-18,-7,-7}
        },
        {    // H20e125a.wav
            {-1,-1,2,1,1,2,0,0,-1,-1,-2,0,-1,-1,-2,-2,0,0,2,0,4,-4,3,-3,16,6,-4,16,213,1474,2193,515,-933,-650,-601,-554,1808,4318,3314,1396,1784,2378,1052,-342,-555,-1227,-2231,-1973,-1158,-1110,-1263,-683,118,384,496,784,897,686,443,370,244,-84,-385,-404,-427,-757,-1000,-974,-912,-811,-586,-367,-275,-232,-142,-45,29,165,310,287,108,-48,-115,-230,-363,-405,-530,-664,-621,-511,-343,-201,-137,-77,-54,-35,-44,-82,-87,-79,-51,-56,-106,-168,-201,-147,-127,-169,-211,-240,-209,-148,-87,-49,-44,-56,-57,-52,-55,-41,-34,-35,-48,-63,-78,-91,-107,-125,-132,-132,-130,-124,-86,-75,-66,-88,-110,-145,-191,-47},
            {-22,1,21,-69,119,-190,229,-237,4550,11605,716,-12262,-3509,8232,2190,-860,9799,7901,753,5679,8547,53,-8445,-5033,-2282,-7711,-8547,-3907,-3023,-4542,-1838,2077,2224,810,1372,3127,2696,962,1225,1377,10,7,1036,545,-1503,-2576,-2241,-2164,-2528,-2424,-1929,-1974,-1460,-202,405,564,834,1138,1047,696,689,1027,1034,449,-42,-260,-596,-893,-933,-862,-882,-955,-894,-683,-480,-286,41,333,399,352,422,458,319,250,300,223,-126,-374,-380,-354,-346,-320,-290,-377,-451,-392,-229,-127,-46,101,108,2,-28,70,95,16,-89,-221,-294,-253,-126,-35,-11,-72,-190,-227,-129,-30,-28,-57,-101,-161,-157,-23,96,92,54,-16,-142,-233,-198,-104,-82,-92,-83,-125,-160,-116,-42,-3}
        },
        {    // H20e130a.wav
            {0,1,1,1,1,1,0,-1,0,-2,-1,-1,-1,-2,0,-1,2,3,-2,4,-7,5,-4,11,9,2,13,239,1626,2358,445,-1135,-752,-604,-412,2162,4597,3249,1273,1863,2405,890,-618,-899,-1443,-2326,-2119,-1253,-1113,-1318,-764,85,286,440,975,1048,606,488,776,702,168,-101,-51,-295,-854,-1209,-1311,-1266,-1054,-747,-478,-349,-240,-98,40,153,238,307,259,108,17,-28,-128,-234,-389,-592,-673,-659,-559,-383,-289,-242,-156,-65,-42,-77,-63,12,53,9,-31,-79,-168,-177,-144,-164,-216,-243,-234,-221,-184,-116,-54,-52,-79,-65,-41,-43,-41,-17,-6,-29,-65,-88,-111,-129,-134,-137,-156,-151,-111,-78,-51,-53,-76,-127,-167,-171,-136,-27},
            {35,-63,67,-67,42,-9,-57,97,499,7801,8948,-5537,-9638,2871,5889,-2468,3538,12196,4147,1470,7994,5967,-4270,-7698,-2720,-4328,-9023,-6348,-2726,-3917,-3846,424,2453,880,720,2452,3073,1670,820,1622,1005,-220,338,914,-343,-2148,-2396,-2099,-2411,-2618,-1994,-1481,-1585,-923,66,450,663,972,1052,746,550,785,1006,667,142,-87,-302,-668,-892,-853,-799,-863,-868,-715,-515,-385,-167,179,386,365,330,397,297,146,197,251,42,-261,-316,-299,-330,-322,-261,-286,-391,-389,-291,-199,-161,-27,98,53,-33,-8,66,21,-48,-116,-203,-248,-199,-110,-52,-14,-49,-128,-144,-81,-59,-76,-71,-99,-153,-134,-5,64,30,9,-36,-140,-189,-139,-108,-125,-119,-120,-173,-169,-61,0}
        },
        {    // H20e135a.wav
            {0,1,2,2,0,0,-2,0,-1,1,0,0,-2,0,1,1,2,0,5,-6,5,-6,12,5,9,16,265,1812,2531,356,-1333,-848,-592,-300,2487,4921,3250,1218,1962,2426,685,-898,-1019,-1548,-2680,-2501,-1361,-1064,-1285,-709,123,274,388,840,1034,746,475,632,743,552,341,207,-11,-524,-1090,-1436,-1503,-1304,-982,-690,-528,-369,-163,6,198,396,449,277,43,-30,-18,-29,-172,-417,-521,-586,-621,-511,-421,-362,-294,-221,-169,-182,-148,-10,121,118,74,53,-53,-153,-178,-159,-153,-230,-282,-251,-220,-195,-128,-57,-55,-81,-81,-78,-70,-30,13,13,-22,-50,-81,-122,-147,-144,-148,-164,-167,-138,-82,-40,-27,-62,-123,-168,-168,-121,-68,-12},
            {1,11,-40,60,-87,104,-119,103,-113,2016,9310,4775,-8056,-5051,4983,1221,-2727,8802,11141,1466,3547,8400,2491,-6263,-5784,-2468,-6479,-8442,-4365,-2847,-4347,-2158,1787,1386,211,1671,2858,2460,1159,1073,1629,568,-162,430,504,-1080,-2328,-2100,-2200,-2643,-2416,-1509,-1188,-1216,-493,197,502,796,1052,871,496,536,788,718,345,82,-100,-414,-745,-812,-722,-771,-816,-708,-524,-401,-313,-63,257,395,325,299,288,124,60,143,129,-97,-275,-255,-274,-317,-264,-206,-282,-367,-317,-226,-214,-172,-22,68,17,-59,-17,7,-33,-52,-113,-193,-230,-185,-105,-16,44,0,-96,-117,-82,-91,-90,-70,-109,-179,-133,-2,34,12,20,-30,-143,-190,-167,-163,-177,-140,-111,-123,-77,-10}
        },
        {    // H20e140a.wav
            {0,1,0,-1,-1,-3,-2,-4,-1,-2,-2,-4,-2,-4,-2,0,-3,3,-12,4,-12,7,3,7,19,302,2006,2733,247,-1575,-938,-590,-154,2869,5216,3202,1175,2169,2491,441,-1207,-1249,-1634,-2771,-2760,-1737,-1334,-1224,-573,187,453,479,729,953,716,395,543,675,478,409,515,342,-257,-847,-1197,-1389,-1383,-1133,-858,-753,-619,-341,-60,167,368,494,416,139,-72,-66,-96,-274,-370,-436,-536,-492,-420,-411,-367,-296,-257,-304,-344,-206,30,139,139,112,65,11,-101,-189,-173,-185,-243,-264,-266,-255,-207,-122,-64,-59,-67,-97,-115,-108,-64,11,34,-10,-68,-101,-120,-131,-139,-158,-185,-185,-154,-100,-42,-34,-64,-121,-149,-145,-121,-79,-64,-16},
            {-16,25,-24,-3,23,-59,94,-145,168,-130,3665,9142,1099,-7632,-1407,3657,-2197,244,12065,8302,619,5425,7182,-291,-6417,-4310,-3397,-7493,-6912,-3339,-3411,-3862,-460,1619,179,669,2356,2636,1963,1014,1285,1365,338,-76,406,75,-1604,-2090,-1881,-2456,-2705,-2072,-1137,-1023,-909,-197,288,556,903,1048,630,332,512,620,433,201,75,-113,-484,-769,-698,-600,-699,-714,-543,-392,-356,-285,-15,283,339,244,223,166,17,23,88,1,-161,-223,-203,-251,-289,-219,-170,-249,-307,-275,-243,-234,-156,-23,11,-48,-78,-44,-47,-53,-42,-98,-189,-217,-146,-50,50,81,4,-81,-105,-102,-123,-105,-77,-137,-185,-108,-2,31,22,8,-87,-204,-223,-216,-192,-135,-61,-44,-70,-18}
        },
        {    // H20e145a.wav
            {3,1,-1,0,-3,0,-1,1,-1,0,-3,-2,-1,1,2,-1,5,-9,8,-12,9,0,14,21,358,2268,2926,75,-1814,-1002,-591,7,3348,5565,3095,1094,2391,2605,202,-1521,-1460,-1812,-2894,-2874,-1924,-1536,-1410,-642,322,654,667,849,928,677,375,399,476,374,383,496,378,-64,-542,-925,-1167,-1133,-952,-853,-868,-832,-565,-190,102,321,430,365,197,89,-41,-281,-359,-341,-406,-436,-437,-384,-306,-266,-251,-322,-385,-308,-156,-31,77,142,116,70,3,-91,-128,-139,-182,-231,-266,-278,-259,-200,-112,-38,-33,-83,-110,-116,-103,-60,-6,16,-20,-71,-110,-127,-116,-110,-137,-169,-179,-147,-92,-41,-32,-86,-113,-124,-119,-112,-77,-33,-61,-20},
            {16,-22,34,-40,27,-14,-13,50,-105,146,84,4903,8012,-1038,-5966,-18,1188,-3041,3914,12837,5672,1036,6186,5497,-1793,-5896,-3755,-4407,-7339,-5531,-3145,-3626,-2791,285,650,-76,1419,2438,2357,1671,1021,1310,1078,218,-36,331,-368,-1700,-1744,-1949,-2587,-2579,-1796,-899,-863,-675,9,456,656,865,942,559,237,291,381,305,138,64,-121,-533,-713,-559,-496,-612,-569,-399,-346,-357,-270,20,251,247,184,167,87,-29,-11,19,-61,-156,-172,-196,-266,-254,-157,-130,-199,-243,-261,-263,-236,-140,-36,-45,-100,-106,-87,-78,-28,0,-81,-198,-200,-85,34,108,76,-27,-91,-95,-103,-134,-112,-78,-134,-158,-87,-7,8,-24,-51,-149,-238,-232,-177,-122,-63,-14,-32,-12}
        },
        {    // H20e150a.wav
            {1,0,-1,-3,0,-2,0,0,1,-4,-1,0,1,2,0,4,-10,11,-14,11,-3,15,23,418,2566,3145,-170,-2111,-1022,-573,173,3877,5926,2963,1000,2632,2700,-103,-1819,-1640,-1998,-3043,-2996,-2084,-1733,-1477,-634,235,666,900,1061,957,710,464,332,280,206,244,394,304,-154,-554,-754,-885,-858,-700,-595,-696,-852,-696,-321,-16,213,342,304,150,-29,-148,-176,-280,-438,-430,-394,-433,-388,-243,-169,-250,-340,-292,-196,-151,-36,90,76,34,19,-37,-110,-138,-110,-121,-200,-265,-285,-262,-210,-101,-9,-22,-79,-124,-124,-102,-45,13,0,-63,-119,-140,-136,-115,-100,-110,-154,-175,-140,-65,-14,-41,-95,-133,-128,-118,-95,-69,-42,-33,-68,-21},
            {-2,13,-14,28,-43,45,-42,29,-4,-42,77,421,5569,6733,-1768,-4608,-316,-592,-2166,6608,12196,4050,1655,6025,4202,-2415,-5450,-3726,-4916,-6666,-4707,-3217,-3302,-1933,51,36,322,1736,2341,2196,1464,1030,1240,805,106,72,111,-639,-1405,-1660,-2141,-2504,-2353,-1603,-862,-700,-374,182,555,675,787,884,593,107,-80,154,315,161,6,-201,-489,-557,-470,-472,-507,-439,-353,-343,-383,-283,36,232,179,113,136,73,-58,-80,-37,-57,-146,-190,-223,-259,-214,-111,-87,-153,-214,-266,-277,-238,-134,-45,-74,-151,-158,-101,-52,-2,-9,-102,-174,-140,-37,56,98,53,-34,-87,-91,-108,-140,-99,-65,-114,-148,-114,-75,-68,-54,-70,-159,-213,-183,-138,-96,-41,-13,-4}
        },
        {    // H20e155a.wav
            {0,0,-3,0,-2,1,0,1,-4,1,-1,1,3,-2,6,-13,12,-14,14,-10,18,22,477,2901,3394,-448,-2464,-1046,-517,359,4440,6299,2801,927,2890,2809,-429,-2209,-1812,-2171,-3203,-3051,-2224,-1964,-1572,-573,289,669,932,1203,1090,743,539,417,218,41,121,288,107,-366,-683,-791,-841,-708,-422,-319,-470,-593,-494,-306,-130,97,282,255,-36,-252,-203,-215,-285,-289,-378,-529,-522,-324,-193,-234,-273,-170,-101,-186,-153,39,138,76,-40,-87,-110,-171,-172,-96,-103,-190,-228,-252,-267,-201,-80,-3,-28,-87,-117,-121,-94,-38,13,-7,-78,-145,-195,-185,-126,-80,-94,-147,-169,-121,-43,8,-11,-85,-141,-147,-116,-85,-53,-45,-47,-54,-65,-16},
            {-1,2,4,-7,17,-38,44,-54,50,-43,10,9,738,5722,5831,-1714,-4122,-1147,-1214,-851,7975,11232,3269,1885,5519,3500,-2622,-5187,-3810,-4918,-5947,-4361,-3145,-2763,-1726,-401,15,614,1791,2313,2013,1330,1008,1088,584,107,107,-144,-608,-1115,-1726,-2282,-2407,-2036,-1406,-928,-569,-82,323,511,615,834,888,507,-66,-272,2,213,220,44,-285,-486,-446,-377,-455,-473,-379,-347,-369,-398,-243,49,189,150,96,134,53,-127,-143,-66,-62,-148,-219,-245,-240,-168,-72,-73,-142,-225,-272,-261,-230,-127,-49,-73,-142,-178,-143,-76,-3,-14,-102,-148,-106,-32,39,88,65,-18,-89,-108,-130,-124,-51,-39,-134,-208,-186,-115,-71,-45,-58,-131,-167,-165,-148,-110,-58,-7}
        },
        {    // H20e160a.wav
            {-2,-3,0,-3,0,-1,0,-5,0,-3,2,2,-3,4,-15,14,-20,16,-15,15,24,542,3253,3663,-754,-2849,-1066,-475,552,5070,6688,2600,860,3166,2896,-756,-2592,-2037,-2382,-3375,-3084,-2270,-2179,-1735,-532,379,726,962,1320,1203,707,604,543,175,-42,108,229,-89,-608,-918,-968,-884,-697,-400,-220,-203,-228,-223,-123,16,176,223,-3,-245,-244,-250,-375,-366,-290,-371,-513,-529,-421,-321,-218,-62,-37,-141,-155,-33,109,130,49,-33,-93,-199,-274,-193,-113,-155,-207,-214,-221,-224,-178,-74,-5,-24,-79,-124,-137,-100,-19,19,-28,-104,-166,-223,-223,-138,-74,-101,-173,-177,-100,-11,40,2,-91,-144,-127,-93,-80,-70,-48,-57,-72,-61,-50,-11},
            {1,-3,7,1,0,9,-29,37,-49,53,-55,41,-28,952,5606,5386,-1536,-4274,-1716,-1098,163,8470,10458,2864,1738,5062,3213,-2677,-5057,-3777,-4595,-5441,-4223,-2836,-2405,-1931,-582,147,709,1876,2243,1848,1236,887,941,553,106,-65,-126,-452,-1081,-1688,-2363,-2355,-1678,-1158,-932,-563,119,435,392,589,924,843,321,-120,-222,-113,84,218,61,-290,-508,-465,-381,-405,-436,-414,-347,-342,-349,-195,53,218,182,95,87,-25,-167,-171,-99,-72,-140,-208,-250,-251,-150,-51,-62,-146,-248,-265,-221,-176,-99,-42,-44,-121,-192,-178,-116,-42,-43,-95,-103,-70,-26,16,66,74,5,-79,-140,-146,-83,-14,-50,-177,-246,-194,-108,-58,-16,-25,-92,-166,-187,-173,-149,-32}
        },
        {    // H20e165a.wav
            {-4,1,-2,0,-2,1,-6,0,-1,2,3,-2,6,-18,17,-20,19,-16,16,22,602,3607,3969,-1036,-3267,-1087,-423,709,5709,7121,2404,795,3450,2980,-1073,-2962,-2256,-2610,-3588,-3136,-2276,-2312,-1885,-556,447,862,1003,1305,1391,818,538,605,225,-138,54,304,-112,-873,-1177,-1124,-1046,-822,-434,-219,-167,-19,117,136,263,424,215,-124,-246,-286,-351,-440,-437,-386,-460,-566,-576,-503,-329,-66,42,-65,-118,-64,31,134,140,59,-28,-105,-185,-269,-280,-184,-154,-223,-239,-229,-212,-135,-25,35,-16,-102,-133,-118,-88,-31,17,-31,-123,-189,-222,-205,-145,-90,-105,-167,-190,-123,-8,79,57,-57,-139,-131,-80,-55,-37,-49,-80,-99,-67,-22,-48,-18},
            {-10,4,-4,6,0,2,6,-23,28,-43,45,-53,45,-38,1041,5400,5209,-1516,-4600,-1848,-759,730,8544,9901,2513,1415,4788,3124,-2710,-4925,-3548,-4209,-5181,-4031,-2434,-2387,-2161,-539,184,807,1942,2086,1730,1100,717,923,640,-49,-243,64,-321,-1145,-1744,-2263,-2114,-1570,-1033,-692,-467,69,393,369,569,926,780,194,-109,-54,-36,-71,-14,7,-230,-570,-622,-465,-389,-392,-358,-319,-312,-269,-113,120,220,166,94,18,-116,-222,-176,-77,-81,-160,-223,-273,-273,-180,-51,-41,-147,-216,-218,-195,-161,-76,2,-25,-131,-201,-210,-174,-104,-62,-52,-85,-89,-48,11,75,64,-5,-91,-141,-141,-93,-34,-42,-156,-239,-194,-112,-21,6,-10,-113,-208,-231,-232,-54}
        },
        {    // H20e170a.wav
            {1,-3,1,-2,0,-6,1,-1,3,2,-3,7,-20,16,-23,23,-20,15,19,671,3967,4286,-1309,-3719,-1128,-376,848,6371,7592,2219,739,3740,3025,-1421,-3302,-2492,-2868,-3791,-3216,-2299,-2413,-1995,-577,462,1002,1181,1246,1367,1028,635,603,238,-245,-30,346,-87,-952,-1405,-1389,-1179,-931,-594,-287,-110,40,152,357,565,493,333,172,-134,-370,-404,-459,-532,-479,-525,-728,-785,-505,-101,10,-64,-59,-34,-38,12,131,181,85,-36,-84,-168,-291,-290,-193,-203,-268,-253,-244,-236,-145,10,84,2,-105,-135,-135,-104,-27,4,-42,-138,-203,-225,-200,-127,-90,-118,-185,-200,-127,-18,56,61,-7,-87,-117,-100,-54,-20,-21,-87,-139,-124,-54,-18,-67,-22},
            {1,-8,1,-2,5,0,1,5,-20,19,-36,39,-45,38,-25,1026,5177,5126,-1616,-4795,-1692,-488,975,8414,9424,2199,1135,4633,3070,-2679,-4663,-3226,-3944,-4996,-3691,-2211,-2563,-2193,-501,189,956,1889,1946,1628,887,645,1053,624,-255,-256,148,-240,-1097,-1840,-2055,-1819,-1593,-975,-373,-235,-85,185,400,600,825,712,292,-2,-16,66,-81,-278,-244,-320,-609,-732,-606,-395,-266,-239,-225,-212,-199,-69,161,247,125,28,-7,-147,-240,-170,-66,-91,-209,-269,-307,-306,-187,-34,14,-67,-165,-202,-201,-143,-35,32,-22,-153,-213,-214,-183,-118,-77,-84,-104,-100,-58,21,95,82,-34,-132,-166,-127,-62,-3,-21,-139,-197,-175,-87,-26,7,-51,-162,-236,-265,-62}
        },
        {    // H20e175a.wav
            {-5,2,-3,-1,-7,0,-1,3,2,-3,5,-19,16,-26,26,-26,20,10,758,4327,4562,-1552,-4133,-1173,-341,971,7023,8035,2057,719,4017,3053,-1819,-3628,-2660,-3178,-4023,-3231,-2318,-2510,-2061,-606,422,1089,1432,1337,1199,1047,868,684,251,-272,-184,295,3,-985,-1583,-1578,-1392,-1066,-619,-351,-206,27,286,365,410,653,694,344,-21,-182,-332,-525,-522,-493,-710,-951,-790,-343,-139,-111,-17,16,-31,-93,-32,148,187,98,25,-45,-187,-314,-266,-162,-188,-284,-320,-299,-240,-116,37,73,-25,-100,-116,-120,-111,-63,-23,-51,-118,-193,-232,-212,-128,-66,-103,-185,-208,-132,-14,75,60,-27,-107,-115,-64,-16,7,-29,-94,-171,-154,-84,-35,-43,-123,-39},
            {-2,2,-7,2,-1,5,1,0,5,-20,19,-31,35,-35,32,-9,957,4942,5000,-1719,-4746,-1458,-365,1067,8114,8940,2017,950,4453,3021,-2493,-4302,-2989,-3759,-4670,-3389,-2239,-2636,-2123,-545,245,1059,1782,1826,1422,717,790,1127,437,-334,-241,145,-121,-1020,-1801,-1922,-1670,-1423,-862,-307,-101,-42,35,309,617,775,709,434,98,-55,18,-91,-393,-549,-628,-720,-704,-559,-372,-225,-111,-50,-88,-152,-89,130,243,129,17,-25,-140,-254,-207,-87,-110,-258,-332,-336,-296,-148,21,49,-44,-127,-169,-170,-136,-37,32,-28,-130,-215,-232,-189,-121,-72,-99,-150,-132,-62,45,115,48,-67,-163,-149,-82,-14,38,-25,-112,-165,-143,-100,-57,-46,-66,-158,-254,-66}
        },
        {    // H20e180a.wav
            {2,-2,-1,-8,2,-3,3,1,-3,5,-21,18,-29,27,-31,23,2,859,4656,4805,-1701,-4499,-1282,-329,1052,7625,8479,1993,799,4231,3041,-2172,-3964,-2836,-3482,-4312,-3280,-2293,-2590,-2095,-594,335,1103,1651,1607,1190,813,984,939,248,-284,-224,167,-26,-961,-1703,-1791,-1555,-1206,-705,-363,-170,48,150,244,524,772,709,446,140,-82,-183,-302,-435,-621,-867,-860,-629,-452,-319,-173,-9,59,-38,-150,-82,120,216,148,44,-50,-176,-265,-247,-145,-145,-273,-344,-345,-271,-105,37,64,-21,-126,-139,-131,-114,-49,-15,-42,-127,-191,-232,-218,-123,-61,-93,-171,-190,-101,33,89,42,-66,-130,-125,-70,2,37,5,-108,-175,-179,-96,-48,-43,-82,-193,-56},
            {2,-2,-1,-8,2,-3,3,1,-3,5,-21,18,-29,27,-31,23,2,859,4656,4805,-1701,-4499,-1282,-329,1052,7625,8479,1993,799,4231,3041,-2172,-3964,-2836,-3482,-4312,-3280,-2293,-2590,-2095,-594,335,1103,1651,1607,1190,813,984,939,248,-284,-224,167,-26,-961,-1703,-1791,-1555,-1206,-705,-363,-170,48,150,244,524,772,709,446,140,-82,-183,-302,-435,-621,-867,-860,-629,-452,-319,-173,-9,59,-38,-150,-82,120,216,148,44,-50,-176,-265,-247,-145,-145,-273,-344,-345,-271,-105,37,64,-21,-126,-139,-131,-114,-49,-15,-42,-127,-191,-232,-218,-123,-61,-93,-171,-190,-101,33,89,42,-66,-130,-125,-70,2,37,5,-108,-175,-179,-96,-48,-43,-82,-193,-56}
        }
    },
    {    // elev30 
        {    // H30e000a.wav
            {-4,19,-24,41,-54,53,-48,20,39,-102,169,299,5288,5984,214,-2497,-7586,-3014,5566,4395,9015,11679,2991,-2400,1818,2064,-5549,-8074,-6851,-5569,-3651,-3042,-1654,-693,-505,1870,2768,1587,2003,2459,1790,1148,877,-197,-496,70,-496,-379,-325,-1030,-1552,-1716,-1342,-960,-414,-92,-107,219,898,1311,1201,1059,919,183,-914,-1527,-1645,-1345,-1148,-1364,-1416,-1092,-460,52,178,123,104,185,154,126,283,408,349,85,-186,-325,-406,-490,-501,-370,-298,-326,-345,-254,-85,103,225,157,-8,-145,-146,-95,-26,51,34,-118,-313,-321,-226,-138,-94,-138,-226,-265,-178,-29,110,151,55,-95,-176,-166,-118,-64,-63,-122,-196,-195,-137,-40,65,86,24,-68,-100,-62,1,34,-1,-8},
            {-4,19,-24,41,-54,53,-48,20,39,-102,169,299,5288,5984,214,-2497,-7586,-3014,5566,4395,9015,11679,2991,-2400,1818,2064,-5549,-8074,-6851,-5569,-3651,-3042,-1654,-693,-505,1870,2768,1587,2003,2459,1790,1148,877,-197,-496,70,-496,-379,-325,-1030,-1552,-1716,-1342,-960,-414,-92,-107,219,898,1311,1201,1059,919,183,-914,-1527,-1645,-1345,-1148,-1364,-1416,-1092,-460,52,178,123,104,185,154,126,283,408,349,85,-186,-325,-406,-490,-501,-370,-298,-326,-345,-254,-85,103,225,157,-8,-145,-146,-95,-26,51,34,-118,-313,-321,-226,-138,-94,-138,-226,-265,-178,-29,110,151,55,-95,-176,-166,-118,-64,-63,-122,-196,-195,-137,-40,65,86,24,-68,-100,-62,1,34,-1,-8}
        },
        {    // H30e006a.wav
            {3,6,10,-8,29,-43,59,-65,73,-36,16,47,854,5448,4343,-168,-2908,-6639,-778,4363,4240,9647,9260,1640,-932,2393,763,-5163,-6838,-6740,-4948,-2876,-2920,-1849,-717,30,1740,2080,1712,2075,2050,1623,1215,497,-466,-11,222,-444,-156,-341,-1076,-1572,-1622,-1227,-750,-235,-124,59,768,1122,745,704,886,486,-274,-1001,-1349,-1305,-1025,-959,-1113,-1137,-967,-423,-1,-38,-67,56,160,89,55,220,352,306,70,-170,-343,-438,-438,-392,-303,-247,-244,-222,-126,-27,96,154,69,-61,-148,-114,-72,-32,21,17,-102,-240,-262,-220,-128,-78,-116,-204,-227,-140,-29,93,121,37,-71,-141,-140,-93,-49,-64,-138,-204,-201,-128,-3,87,75,3,-59,-69,-38,17,51,14},
            {28,-34,49,-65,56,-45,2,67,-149,227,194,5771,7050,253,-3061,-8825,-3818,6410,5405,9997,12645,3252,-3328,1132,2428,-6103,-9396,-7478,-5272,-3515,-3653,-1616,-44,-654,1577,3234,1951,1854,2429,2047,1191,908,66,-537,-176,-598,-377,-427,-1288,-1710,-1644,-1148,-934,-497,50,-223,-575,482,1744,1585,1237,1171,382,-755,-1427,-1782,-1697,-1546,-1523,-1228,-944,-591,-25,398,326,123,203,168,132,303,446,424,98,-203,-329,-439,-500,-462,-337,-332,-416,-430,-303,-106,104,263,260,72,-183,-203,-105,-7,63,28,-136,-361,-367,-245,-150,-99,-127,-229,-281,-183,14,194,197,58,-123,-212,-200,-151,-46,-12,-99,-192,-215,-145,-26,74,99,13,-66,-104,-72,6,41,8,-69,-23}
        },
        {    // H30e012a.wav
            {-3,0,5,8,-7,22,-35,41,-48,47,-24,7,34,655,4488,4115,257,-2290,-5443,-1514,3221,4169,8297,8379,2616,-273,1964,1140,-3810,-6289,-6459,-4439,-2765,-3083,-2001,-626,-137,1162,1941,1687,1758,1863,1680,1185,292,-271,314,279,-434,-201,-287,-955,-1447,-1465,-1095,-537,-105,-266,-114,741,1092,485,175,498,428,-300,-959,-1096,-1044,-920,-830,-781,-799,-910,-659,-228,-79,-141,-113,36,5,-30,108,236,228,43,-148,-295,-396,-404,-331,-210,-163,-172,-150,-87,-47,25,91,31,-92,-168,-153,-122,-64,-7,-2,-83,-201,-240,-232,-166,-95,-92,-155,-200,-159,-48,75,98,21,-82,-149,-166,-118,-59,-67,-138,-196,-181,-125,-40,36,49,-15,-75,-86,-44,25,11},
            {-30,55,-72,51,-33,-18,96,-188,264,63,5849,8284,875,-3711,-9968,-4676,6758,5900,11251,14136,3160,-3750,786,1951,-6493,-9933,-8481,-5961,-2710,-3272,-2454,74,58,1475,2813,2156,2307,2261,1909,1400,1082,260,-452,-250,-776,-368,-407,-1551,-1947,-1788,-1078,-662,-329,-145,-620,-687,360,1493,1825,1538,1089,510,-400,-1247,-2016,-2168,-1773,-1359,-946,-967,-682,39,468,479,214,179,179,129,239,384,490,218,-232,-444,-484,-466,-422,-332,-344,-446,-463,-314,-117,119,336,326,97,-188,-230,-133,-27,46,13,-154,-400,-437,-336,-188,-92,-115,-214,-279,-139,62,225,235,80,-125,-265,-267,-155,-2,33,-62,-205,-256,-201,-37,116,106,8,-94,-108,-80,8,48,19,-41,-143,-45}
        },
        {    // H30e018a.wav
            {-1,-3,0,2,9,-8,17,-27,26,-30,20,2,-13,35,423,3538,3949,741,-1586,-4613,-2256,2542,3786,6881,7839,3348,185,1770,1604,-2804,-5590,-5670,-4121,-2909,-3028,-1994,-749,-428,752,1695,1494,1543,1745,1694,1178,354,25,362,146,-364,-70,-199,-824,-1114,-1119,-895,-532,-370,-529,-175,595,661,164,92,331,313,-162,-788,-941,-824,-685,-639,-663,-637,-747,-715,-451,-226,-150,-183,-176,-154,-71,39,59,82,69,-56,-217,-284,-285,-253,-136,-52,-82,-135,-124,-77,-12,28,-7,-89,-177,-210,-173,-79,-4,-16,-102,-189,-223,-207,-139,-81,-80,-129,-149,-118,-56,36,65,2,-109,-177,-164,-122,-80,-62,-86,-135,-160,-145,-92,-23,5,-23,-66,-72,-32,-1},
            {43,-62,41,-16,-39,130,-212,289,-98,5342,9462,2512,-4103,-11127,-5903,6401,6432,11608,15675,4803,-4261,78,2007,-6976,-10381,-8978,-7283,-3083,-2096,-2225,-737,99,2123,2897,1607,2285,2715,1836,1196,1310,613,-341,-258,-841,-365,-309,-1698,-2213,-1875,-1062,-616,-342,-518,-688,-280,108,1149,2020,1576,915,509,-54,-1004,-2398,-2704,-1536,-680,-856,-1224,-780,97,675,587,162,168,181,118,253,342,414,266,-156,-519,-550,-448,-426,-337,-325,-383,-423,-352,-137,181,411,367,145,-177,-277,-181,-40,67,4,-186,-433,-505,-418,-248,-99,-104,-184,-229,-145,48,275,339,138,-156,-312,-271,-122,39,73,-63,-226,-287,-227,-64,112,139,24,-100,-152,-91,1,86,56,-16,-103,-214,-59}
        },
        {    // H30e024a.wav
            {-2,0,-6,1,1,9,-8,15,-20,16,-12,1,25,-34,46,214,2643,3725,1281,-939,-4021,-2697,1946,3152,5719,7363,3807,654,1730,1900,-1968,-4614,-4776,-4024,-3039,-2790,-1990,-1005,-687,411,1374,1314,1418,1661,1778,1234,299,79,361,212,-170,-3,-17,-426,-751,-1010,-1031,-739,-582,-718,-357,280,289,42,168,293,229,9,-533,-809,-650,-509,-540,-601,-587,-638,-648,-554,-391,-241,-234,-302,-333,-198,-44,-19,32,80,25,-88,-151,-169,-163,-81,-31,-62,-109,-152,-148,-72,-2,-20,-102,-193,-231,-188,-99,-50,-52,-94,-166,-195,-164,-93,-54,-71,-101,-124,-114,-71,-15,7,-30,-97,-148,-158,-140,-90,-48,-63,-114,-152,-151,-118,-58,-24,-24,-45,-68,-18},
            {-38,14,4,-74,157,-235,303,-253,4325,10135,4897,-3486,-12380,-7517,5557,6387,12035,16394,6441,-2612,-758,1174,-6326,-10523,-9941,-8518,-3825,-1978,-1881,-274,-121,1528,3414,2220,1752,2177,2304,1437,946,870,55,-197,-948,-361,-54,-1776,-2412,-2033,-945,-567,-1201,-792,94,-143,-219,1065,1912,1491,917,572,-122,-1266,-2538,-2547,-1120,-379,-798,-1273,-860,96,662,612,225,128,167,165,246,288,387,275,-159,-543,-617,-519,-425,-322,-287,-298,-375,-338,-145,171,441,431,220,-178,-334,-221,-63,60,4,-181,-474,-586,-494,-302,-102,-58,-166,-283,-209,23,309,405,207,-113,-287,-246,-110,44,68,-62,-246,-321,-266,-92,105,139,36,-98,-171,-138,-6,98,101,11,-95,-189,-195,-38}
        },
        {    // H30e030a.wav
            {2,-3,1,-5,2,-1,7,-6,10,-13,7,-2,-14,37,-44,48,66,1824,3397,1780,-363,-3401,-2969,1235,2555,4733,6763,4148,1178,1661,2032,-1092,-3561,-3997,-3904,-3076,-2548,-2017,-1281,-865,82,1043,1247,1369,1603,1676,1005,324,359,396,268,137,264,170,-326,-730,-1091,-1150,-902,-898,-984,-464,176,120,-73,168,392,346,87,-389,-642,-541,-425,-483,-592,-576,-552,-574,-587,-523,-407,-342,-369,-387,-278,-124,-10,63,97,88,20,-72,-112,-87,-39,-48,-90,-124,-158,-179,-139,-61,-64,-106,-162,-216,-213,-169,-88,-40,-59,-118,-157,-126,-73,-43,-48,-99,-146,-147,-103,-32,-9,-33,-78,-125,-151,-152,-108,-61,-63,-100,-126,-135,-111,-74,-39,-38,-65,-17},
            {-30,56,-119,189,-245,282,-277,2899,10073,7502,-1412,-12971,-10123,4587,5812,11355,17713,8018,-1399,32,1308,-6757,-10128,-9592,-10741,-5377,-1493,-2227,-698,730,1765,2652,2400,2720,1946,1410,1733,1457,686,-3,277,-825,-633,243,-1528,-2516,-2114,-1102,-1102,-1709,-491,438,-74,-180,722,1668,1601,1012,537,-514,-1826,-2343,-1565,-808,-809,-666,-847,-825,-124,401,543,329,218,196,133,187,286,473,299,-191,-531,-705,-637,-475,-283,-154,-216,-332,-317,-133,172,462,465,212,-146,-317,-254,-107,40,33,-146,-492,-665,-539,-295,-65,-32,-175,-338,-282,-28,274,413,262,10,-169,-211,-133,25,97,-39,-253,-361,-308,-130,73,149,64,-83,-179,-155,-23,101,123,49,-80,-180,-177,-112,-22}
        },
        {    // H30e036a.wav
            {-5,2,-2,0,-4,2,-3,5,-4,5,-1,-2,7,-22,39,-39,38,-1,1144,2929,2138,208,-2709,-3134,512,2047,3820,6086,4428,1664,1524,2129,-192,-2621,-3263,-3633,-3076,-2391,-2023,-1442,-1023,-166,905,1122,1054,1370,1595,1040,486,539,601,608,328,118,65,-340,-785,-1155,-1276,-1154,-1135,-994,-365,100,-61,-67,251,467,437,94,-319,-493,-469,-415,-469,-564,-539,-508,-590,-661,-609,-511,-412,-342,-331,-259,-135,-36,87,133,72,55,7,-86,-80,-24,-26,-106,-182,-181,-180,-181,-136,-96,-85,-141,-216,-216,-173,-82,-13,-13,-62,-133,-131,-79,-58,-69,-101,-141,-149,-117,-62,-7,-24,-82,-123,-146,-145,-114,-66,-55,-81,-111,-117,-104,-72,-60,-71,-18},
            {74,-144,193,-190,159,-116,1391,9015,9827,1622,-11984,-13361,2835,5945,9085,18259,10615,-34,176,2040,-5110,-10662,-9560,-10794,-7956,-2638,-1933,-1124,174,1882,3513,2446,2288,2551,1860,1197,1028,1269,217,-50,-511,-530,283,-1279,-2359,-1861,-1759,-2393,-1417,461,95,-215,193,390,1186,1680,1347,311,-1322,-2141,-1503,-682,-858,-1133,-621,-401,-574,-440,-28,384,418,333,226,13,138,411,494,289,-112,-480,-761,-765,-588,-251,-37,-165,-294,-263,-73,165,415,432,202,-95,-300,-301,-181,32,85,-137,-502,-646,-515,-304,-93,-53,-166,-331,-318,-127,143,373,347,143,-95,-224,-164,17,120,9,-220,-370,-369,-217,21,151,101,-56,-192,-178,-29,100,127,51,-62,-169,-181,-111,-76,-15}
        },
        {    // H30e042a.wav
            {-1,-4,2,-2,-1,-3,1,-1,1,-2,4,5,-9,11,-23,33,-27,16,-3,611,2350,2345,733,-1928,-3133,-274,1573,3016,5386,4607,2067,1460,2168,598,-1744,-2584,-3246,-3061,-2293,-1902,-1483,-1004,-335,366,687,1011,1478,1495,996,846,996,676,379,189,-23,-136,-444,-837,-1219,-1326,-1200,-1142,-868,-312,9,-48,-5,228,443,442,104,-302,-433,-386,-412,-456,-528,-584,-579,-642,-665,-598,-482,-341,-293,-275,-205,-122,-67,6,102,96,54,17,-65,-94,-54,-50,-101,-173,-226,-226,-201,-162,-120,-102,-126,-164,-169,-127,-57,-12,-11,-67,-123,-130,-111,-84,-74,-87,-121,-149,-141,-96,-38,-20,-65,-107,-130,-137,-103,-67,-50,-75,-101,-110,-105,-85,-76,-17},
            {-93,105,-65,-25,119,188,6829,11331,5422,-9241,-16248,-638,6786,6820,16608,13490,2246,349,2580,-2993,-10058,-9476,-10799,-9705,-3926,-2966,-1995,210,1210,2981,3380,3307,2328,1493,2094,1314,619,183,379,-327,-968,501,-696,-2275,-1890,-2571,-3192,-1197,921,295,-258,47,228,990,1593,1286,4,-1731,-2000,-833,-340,-699,-989,-702,-300,-421,-561,-289,157,311,299,229,-3,131,434,453,371,61,-435,-750,-804,-649,-280,-51,-132,-242,-186,-18,151,349,355,210,-60,-310,-310,-243,-46,65,-89,-390,-584,-508,-336,-130,-45,-157,-323,-364,-226,59,332,387,201,-65,-212,-210,-32,127,64,-154,-344,-387,-300,-61,138,133,-15,-177,-207,-76,84,133,74,-46,-162,-201,-120,-54,-56,-15}
        },
        {    // H30e048a.wav
            {-2,-1,-2,1,0,-1,-2,0,0,-1,1,3,10,-10,13,-17,20,-8,-3,16,258,1741,2342,1190,-1095,-2971,-1075,1117,2406,4673,4625,2454,1467,2096,1264,-940,-1973,-2776,-2945,-2087,-1578,-1484,-1393,-826,157,739,1036,1426,1542,1307,987,751,455,187,-42,-289,-342,-477,-783,-1073,-1163,-1152,-1114,-682,-158,-45,-124,-10,205,357,344,51,-262,-360,-353,-391,-502,-619,-628,-590,-598,-561,-470,-365,-305,-253,-183,-178,-172,-140,-44,75,83,41,-36,-96,-97,-80,-45,-91,-195,-254,-256,-204,-164,-133,-89,-79,-83,-95,-109,-73,-42,-38,-58,-115,-134,-129,-109,-79,-88,-126,-152,-145,-117,-54,-15,-38,-89,-128,-117,-90,-61,-61,-85,-97,-104,-105,-83,-17},
            {-38,114,-204,290,-362,3790,11116,9550,-4022,-17749,-6465,7377,5730,13306,15338,5131,1284,2581,-172,-7967,-10261,-10158,-10339,-5941,-3743,-3052,-1009,457,2613,3100,3509,3695,1979,1814,1641,1369,431,-416,-51,-544,108,-374,-1740,-2157,-3660,-3384,-931,567,592,178,-98,-62,758,1526,1030,-368,-1659,-1495,-515,-416,-454,-515,-566,-404,-595,-622,-306,47,120,54,62,23,225,381,368,478,283,-288,-703,-751,-584,-381,-163,-52,-126,-174,-67,120,305,338,218,-23,-298,-368,-295,-124,23,-28,-217,-440,-508,-383,-156,-5,-92,-320,-431,-298,6,315,399,217,-46,-209,-222,-88,86,101,-75,-285,-391,-329,-97,116,150,34,-129,-204,-128,29,121,96,10,-123,-198,-147,-48,-20,-69,-24}
        },
        {    // H30e054a.wav
            {1,-1,-2,-2,0,-1,-2,0,-3,0,-4,2,3,9,-8,7,-5,2,9,-15,21,83,1163,2150,1550,-328,-2605,-1784,599,1958,3999,4528,2749,1555,1995,1721,-196,-1402,-2137,-2491,-1999,-1827,-1781,-1321,-708,-8,685,1285,1571,1261,927,811,541,131,-129,-277,-458,-335,-286,-571,-829,-1030,-1077,-880,-457,-179,-224,-206,-26,132,213,196,9,-221,-324,-370,-480,-573,-616,-589,-469,-430,-426,-367,-317,-247,-187,-182,-225,-232,-146,-63,-17,9,-18,-74,-89,-83,-83,-95,-133,-184,-239,-243,-208,-158,-95,-53,-28,-36,-79,-113,-103,-70,-49,-67,-108,-143,-155,-117,-96,-101,-123,-141,-124,-111,-80,-37,-37,-63,-94,-106,-88,-81,-69,-81,-86,-85,-99,-24},
            {123,-162,151,-116,904,8438,12384,3311,-15029,-14462,5222,7122,8781,15992,8162,2278,3034,1810,-4285,-9535,-10023,-11101,-7641,-3958,-4481,-2301,-497,1025,2782,3365,4167,2603,2257,2730,1410,795,194,-73,-738,-192,373,-1462,-2897,-4085,-3455,-1241,-35,816,699,-127,-178,569,1225,615,-571,-1156,-977,-467,-519,-322,-81,-332,-311,-648,-918,-437,25,58,-125,-225,-147,112,339,434,529,412,-59,-499,-657,-562,-392,-238,-65,-5,-120,-148,-5,169,326,284,62,-248,-470,-405,-213,-21,61,-73,-336,-486,-393,-152,5,-44,-263,-444,-357,-101,207,397,284,-4,-216,-274,-165,27,112,-10,-241,-361,-332,-149,82,173,88,-78,-198,-178,-27,92,105,26,-76,-175,-157,-68,-29,-35,-103,-33}
        },
        {    // H30e060a.wav
            {3,0,-1,-1,-1,-1,1,0,1,-3,0,-1,4,5,6,-3,4,2,-8,18,-18,21,23,713,1830,1758,334,-2106,-2320,19,1660,3484,4315,2910,1706,1930,2014,585,-602,-1620,-2725,-2248,-1418,-1420,-1298,-645,216,815,983,954,801,662,423,99,-77,-244,-316,-313,-150,-55,-339,-611,-806,-903,-706,-391,-356,-419,-230,-55,3,59,59,-66,-230,-340,-442,-520,-520,-475,-403,-306,-307,-351,-313,-239,-203,-222,-234,-244,-238,-185,-148,-110,-56,-44,-72,-88,-94,-128,-137,-126,-151,-190,-212,-192,-127,-49,-14,-19,-42,-82,-117,-124,-86,-66,-88,-115,-136,-146,-135,-106,-90,-101,-123,-127,-126,-89,-37,-26,-46,-78,-84,-97,-90,-71,-62,-60,-78,-21},
            {93,-192,283,-362,3755,11911,10468,-6185,-19785,-3966,9999,6012,12891,12717,3417,2949,3239,-154,-7036,-9709,-10024,-10058,-5825,-4428,-3436,-1782,-814,1914,2540,3702,3884,2082,2905,2807,1792,549,-233,103,-166,72,-820,-2979,-4532,-3925,-1764,-615,483,949,171,-73,377,826,362,-748,-823,-269,-316,-602,-383,125,35,-210,-460,-888,-801,-327,36,-20,-345,-429,-235,67,445,663,544,151,-285,-472,-467,-382,-259,-76,53,-33,-139,-138,-25,198,314,193,-138,-486,-528,-340,-97,88,73,-189,-451,-399,-176,8,40,-151,-374,-401,-233,48,298,342,127,-167,-304,-279,-102,75,81,-120,-338,-348,-203,27,174,155,-2,-174,-213,-92,69,113,73,-42,-150,-179,-100,-34,-30,-53,-111,-31}
        },
        {    // H30e066a.wav
            {1,1,0,0,-2,-1,-2,0,-1,0,-3,-3,-1,2,2,1,-1,0,2,-14,18,-13,11,11,418,1461,1809,860,-1580,-2658,-553,1445,3134,4064,2960,1904,2140,2485,961,-821,-1423,-1967,-1815,-1265,-1118,-842,-488,-177,199,452,436,270,144,-23,-15,154,-90,-299,-93,175,155,-147,-371,-659,-844,-675,-516,-514,-467,-274,-173,-162,-91,-74,-162,-282,-382,-400,-355,-346,-315,-237,-205,-266,-299,-227,-235,-287,-257,-242,-281,-303,-244,-184,-165,-115,-67,-78,-110,-132,-135,-119,-114,-119,-138,-159,-144,-98,-45,-34,-49,-63,-90,-120,-136,-119,-97,-93,-100,-129,-140,-120,-105,-99,-117,-132,-121,-108,-84,-54,-37,-37,-54,-88,-100,-83,-56,-58,-72,-17},
            {-36,-12,77,154,7006,13595,5527,-14895,-16803,5784,9437,6682,14284,8082,2353,3522,2598,-1980,-8757,-9363,-9356,-8387,-5680,-4872,-2407,-1717,-481,1895,2728,3946,2641,2433,3549,2538,1767,703,186,99,358,108,-2796,-4863,-4174,-2681,-1530,-188,876,397,-112,453,704,11,-857,-647,253,60,-528,-447,99,375,-46,-339,-548,-890,-787,-264,-46,-257,-466,-514,-353,94,607,717,406,-77,-302,-287,-309,-249,-95,84,90,-74,-217,-191,23,231,238,-17,-378,-582,-483,-232,13,140,-8,-304,-418,-254,-28,74,8,-203,-386,-357,-131,145,305,224,-46,-267,-351,-267,-46,95,22,-213,-342,-284,-88,134,190,93,-101,-229,-175,3,130,119,23,-110,-193,-178,-80,-30,-23,-54,-93,-22}
        },
        {    // H30e072a.wav
            {1,2,1,1,1,-1,0,0,1,0,3,-1,-1,0,3,2,2,5,1,3,-14,21,-2,3,17,279,1151,1744,1262,-1161,-2910,-1019,1373,3059,3913,3116,2396,2012,1724,1057,80,-659,-1506,-1413,-756,-883,-1153,-970,-652,-421,-165,-169,-346,-105,220,325,254,3,24,209,342,365,24,-394,-727,-834,-683,-589,-560,-517,-431,-371,-265,-159,-222,-280,-263,-213,-182,-213,-211,-154,-144,-183,-214,-247,-277,-299,-301,-281,-299,-333,-304,-255,-238,-195,-124,-92,-110,-120,-107,-108,-98,-80,-71,-67,-94,-122,-119,-86,-60,-66,-73,-94,-128,-142,-125,-101,-82,-74,-92,-123,-137,-123,-113,-106,-103,-101,-98,-90,-53,-36,-34,-43,-59,-75,-82,-72,-58,-13},
            {-127,156,-191,1216,9741,13551,-697,-19876,-9983,11262,7327,8048,13265,5135,2726,3520,2115,-3845,-9668,-8468,-8304,-7413,-6095,-4477,-2190,-2135,220,1912,2814,3643,2000,2822,3649,2565,1496,661,1059,738,265,-1174,-4001,-4761,-3783,-2406,-1067,-33,433,50,160,624,24,-873,-775,344,681,-128,-521,-129,619,429,-281,-447,-639,-864,-693,-317,-250,-399,-571,-605,-317,190,562,574,266,-120,-172,-170,-183,-70,87,205,57,-189,-295,-167,75,197,70,-235,-524,-577,-397,-164,90,137,-84,-333,-367,-135,67,117,-6,-257,-383,-295,-47,191,253,89,-201,-361,-359,-218,16,104,-50,-262,-315,-203,3,154,165,29,-169,-232,-116,76,153,107,-18,-173,-229,-174,-63,-10,-20,-63,-83,-19}
        },
        {    // H30e078a.wav
            {0,1,0,1,2,-1,-1,1,-1,1,2,1,-3,-1,-1,1,0,3,3,2,-2,-13,24,-3,8,0,238,992,1658,1503,-1042,-3196,-1185,1680,3548,4075,2451,1472,2111,2544,1562,365,-25,-750,-1305,-1200,-1228,-1481,-1586,-1213,-925,-941,-560,33,248,271,518,642,263,77,436,637,260,-232,-471,-725,-847,-663,-595,-698,-713,-580,-414,-322,-285,-263,-181,-86,-53,-42,-79,-99,-81,-123,-179,-257,-312,-297,-334,-355,-327,-323,-327,-332,-288,-226,-188,-163,-148,-102,-75,-82,-71,-71,-50,-16,-39,-103,-168,-156,-97,-81,-80,-96,-117,-124,-137,-122,-86,-64,-67,-103,-140,-148,-135,-93,-78,-99,-106,-103,-86,-58,-29,-19,-33,-61,-78,-85,-72,-14},
            {-154,235,-346,2307,11532,12385,-6106,-21069,-3286,13069,5481,8807,11498,3980,3227,3629,1864,-5559,-9872,-7276,-7385,-7217,-6265,-3891,-2537,-2434,419,1951,3145,2900,1799,3387,3447,2320,1283,1038,1541,1003,184,-2266,-4353,-4060,-3368,-2366,-1203,-122,107,-239,316,211,-867,-961,70,980,553,-231,-273,366,919,258,-432,-528,-716,-824,-648,-421,-394,-493,-659,-622,-270,190,432,387,153,-39,-47,-112,-36,129,270,264,-48,-294,-293,-113,69,85,-100,-372,-568,-549,-366,-124,124,132,-114,-345,-304,-45,132,136,-38,-289,-364,-209,13,175,177,-49,-319,-427,-350,-128,67,88,-98,-287,-283,-146,51,154,121,-24,-194,-206,-58,112,155,71,-68,-194,-232,-151,-41,-7,-37,-88,-76,-14}
        },
        {    // H30e084a.wav
            {0,1,1,1,2,3,0,1,1,0,3,1,1,-1,-2,-1,6,-1,5,5,5,-6,-2,33,-2,-4,-25,354,1020,1620,1451,-1469,-3289,-279,2746,3075,2476,2337,2577,2587,2679,2066,748,-300,-1055,-1401,-1726,-1966,-1811,-1867,-1956,-1387,-446,-4,27,357,854,903,492,356,463,378,278,97,-240,-615,-798,-715,-692,-810,-857,-731,-601,-483,-297,-181,-133,-68,24,102,79,-13,-56,-97,-189,-262,-303,-320,-348,-377,-359,-336,-333,-339,-299,-245,-245,-238,-179,-103,-51,-38,-41,-53,-49,-9,-22,-96,-148,-150,-121,-118,-109,-97,-103,-106,-109,-102,-104,-97,-73,-74,-104,-135,-132,-96,-80,-86,-100,-98,-81,-70,-37,-27,-32,-38,-48,-68,-90,-23},
            {-147,246,-386,2902,12337,11224,-9295,-20398,938,13224,4311,8612,10185,3851,3554,3974,1902,-6620,-9775,-6236,-6761,-7374,-6190,-3408,-2999,-2705,452,1807,3095,2565,1834,3649,3466,1947,976,1586,1773,638,41,-2087,-4069,-3907,-2936,-2062,-1586,-604,-119,-304,-43,-488,-1114,-556,562,1154,557,-142,35,806,1036,118,-507,-577,-745,-837,-644,-427,-459,-585,-699,-622,-303,125,300,237,120,7,9,12,131,280,385,292,-95,-326,-269,-98,22,-16,-200,-433,-587,-529,-343,-99,138,117,-124,-310,-220,17,156,140,-61,-281,-311,-154,38,149,108,-148,-392,-442,-321,-66,106,81,-122,-293,-256,-106,75,158,102,-52,-191,-163,-10,112,129,49,-87,-182,-197,-116,-30,-28,-55,-88,-73,-13}
        },
        {    // H30e090a.wav
            {-1,-1,0,0,2,2,2,0,0,-2,0,0,0,1,-2,-3,1,4,-1,6,1,2,-4,28,10,-19,-28,57,641,1215,1711,772,-2094,-2384,172,2365,3491,3033,2430,2848,3335,2834,1244,-58,-830,-1513,-1946,-2182,-2279,-2378,-2136,-1366,-666,-213,159,592,876,860,836,657,267,49,196,287,-48,-452,-713,-816,-815,-826,-840,-854,-749,-517,-287,-151,-86,-28,52,152,183,88,-61,-150,-189,-253,-327,-346,-346,-380,-393,-355,-312,-300,-288,-291,-298,-261,-189,-102,-42,-21,-35,-50,-44,-52,-71,-81,-89,-111,-145,-148,-130,-112,-89,-92,-97,-97,-117,-122,-96,-71,-74,-94,-118,-121,-99,-72,-68,-85,-81,-74,-62,-44,-25,-30,-43,-60,-80,-20},
            {-142,230,-368,2705,12194,10958,-9735,-19580,2078,13118,3572,7575,9651,4211,3811,4319,2436,-6648,-9737,-5555,-6327,-7623,-6206,-3116,-3245,-3146,302,1739,2705,2195,2056,3894,3392,1691,952,1785,1506,440,267,-1801,-3565,-3439,-2784,-2029,-1668,-977,-585,-581,-439,-904,-1109,-325,735,1189,608,134,374,956,1065,168,-494,-625,-802,-855,-584,-371,-515,-664,-733,-649,-359,-4,172,150,73,19,61,117,261,379,429,307,-52,-286,-276,-136,-40,-64,-236,-487,-604,-518,-327,-96,109,96,-127,-268,-148,55,153,120,-56,-251,-284,-132,40,118,53,-202,-419,-437,-290,-43,98,68,-124,-283,-236,-86,81,144,95,-45,-176,-147,-12,104,113,38,-81,-169,-171,-93,-31,-51,-83,-96,-69,-12}
        },
        {    // H30e096a.wav
            {0,-1,0,1,3,2,2,0,0,-1,-1,1,2,1,-1,-2,-2,3,3,6,-5,7,8,19,12,-28,7,-26,431,1152,1890,1792,-1651,-4048,-778,3167,3783,2876,2833,3123,2963,2767,1711,3,-1253,-1640,-1657,-2251,-2800,-2491,-1680,-1177,-924,-205,497,672,700,938,1048,512,-23,-43,131,237,44,-314,-664,-914,-893,-775,-799,-845,-727,-500,-292,-147,-33,38,91,171,176,70,-85,-177,-193,-271,-358,-359,-364,-384,-377,-332,-254,-259,-319,-316,-289,-255,-183,-79,-28,-58,-65,-58,-90,-112,-83,-22,-41,-123,-146,-132,-112,-105,-100,-87,-104,-123,-123,-120,-98,-66,-62,-85,-118,-118,-84,-49,-51,-81,-90,-80,-65,-46,-25,-36,-42,-53,-79,-20},
            {-125,171,-264,1786,11052,11723,-7585,-19077,334,13146,3384,5767,9775,4804,3967,4597,3400,-5487,-9857,-5282,-5813,-7884,-6540,-3078,-3103,-3706,-135,1669,2365,1890,1872,4105,3529,1421,1074,1856,1047,281,773,-1323,-3307,-2976,-2418,-2043,-1875,-1236,-855,-1022,-886,-962,-1049,-442,676,1231,695,359,617,1017,1056,250,-364,-564,-858,-885,-496,-300,-539,-719,-802,-681,-438,-173,79,86,7,-6,114,204,287,411,461,331,7,-220,-255,-182,-106,-86,-238,-505,-608,-524,-332,-124,52,74,-115,-252,-135,72,156,110,-55,-232,-271,-148,15,88,26,-209,-412,-418,-280,-58,64,33,-124,-263,-222,-87,61,122,91,-32,-170,-158,-28,98,109,28,-80,-162,-159,-89,-42,-73,-104,-107,-77,-14}
        },
        {    // H30e102a.wav
            {-1,0,0,1,2,2,2,-1,0,-2,0,1,2,0,0,-3,1,2,-3,7,-7,6,8,19,5,-15,-3,8,502,1600,2701,852,-3835,-3693,1440,3835,3226,2962,3075,2664,2479,2616,1217,-761,-1327,-1324,-1868,-2626,-2460,-1775,-1545,-1187,-436,265,460,493,896,1074,686,124,-113,-79,3,156,6,-440,-725,-801,-827,-831,-767,-641,-541,-470,-320,-120,45,126,159,156,60,-58,-123,-162,-237,-325,-374,-401,-407,-355,-300,-261,-233,-283,-308,-272,-250,-222,-150,-57,-54,-107,-120,-143,-167,-100,1,4,-87,-136,-114,-96,-80,-80,-98,-123,-137,-129,-129,-113,-72,-61,-88,-112,-117,-71,-38,-43,-65,-93,-85,-75,-54,-44,-31,-30,-40,-76,-129,-35},
            {-57,34,-32,582,8669,12870,-3042,-18037,-3950,12507,4350,3189,10046,5979,3756,4803,4603,-3138,-9849,-5585,-4970,-7982,-7233,-3541,-2607,-4115,-1006,1582,2064,1789,1563,3880,3761,1406,1109,1822,893,167,1002,-586,-2842,-2861,-2225,-1772,-1923,-1681,-1092,-1163,-1175,-1067,-1029,-565,398,1129,894,528,660,1001,1108,375,-248,-388,-755,-901,-496,-238,-471,-715,-863,-760,-515,-290,-26,29,-22,-31,132,263,284,374,439,381,88,-171,-224,-183,-125,-114,-225,-441,-573,-543,-362,-173,-15,47,-83,-214,-166,43,166,118,-33,-213,-260,-169,-33,61,33,-154,-348,-388,-293,-104,25,23,-108,-245,-210,-97,35,119,90,-27,-161,-147,-27,80,100,30,-69,-141,-139,-94,-59,-82,-99,-106,-101,-21}
        },
        {    // H30e108a.wav
            {-1,0,2,2,1,1,1,-1,-1,-1,0,2,2,-1,-1,-1,4,3,-2,-1,0,10,5,12,1,2,-12,178,1359,2706,1442,-2449,-3892,-527,2892,3716,3561,2858,2164,2422,2683,1360,-509,-1019,-1008,-1575,-2266,-2297,-1794,-1474,-1106,-521,32,439,579,685,896,812,281,-136,-220,-146,-6,-72,-349,-618,-718,-682,-721,-787,-679,-437,-340,-365,-285,-97,125,251,188,33,-89,-153,-169,-205,-309,-396,-426,-437,-398,-283,-204,-223,-281,-275,-214,-211,-197,-145,-112,-98,-111,-161,-246,-246,-123,-8,7,-56,-117,-110,-76,-67,-58,-70,-99,-144,-169,-141,-110,-87,-71,-86,-130,-125,-77,-32,-24,-54,-81,-95,-78,-60,-40,-30,-21,-39,-84,-137,-154,-35},
            {43,-118,181,-192,5192,12859,3152,-14833,-9409,9603,6646,579,9105,8305,3412,4486,5751,220,-8940,-6746,-3860,-7555,-8078,-4560,-2276,-3989,-2284,1261,1874,1725,1365,3344,3900,1485,1125,1787,953,191,962,205,-2123,-2752,-2243,-1697,-1759,-1967,-1416,-1200,-1266,-1097,-1051,-683,74,819,1038,724,617,853,1072,587,-75,-236,-534,-804,-568,-226,-334,-658,-872,-833,-598,-400,-154,-14,-7,-32,111,287,265,300,365,393,191,-104,-199,-184,-107,-99,-184,-339,-495,-537,-404,-225,-101,-5,-36,-145,-182,-30,133,122,7,-159,-244,-205,-91,20,47,-44,-229,-338,-311,-173,-17,29,-60,-213,-226,-110,18,103,86,-1,-112,-131,-38,58,75,29,-26,-88,-121,-111,-66,-72,-98,-107,-105,-23}
        },
        {    // H30e114a.wav
            {1,2,2,2,2,0,1,0,-1,2,2,3,-1,2,2,0,5,2,3,-5,7,6,12,6,-4,17,126,1323,2696,1271,-2027,-3199,-936,2044,3515,3745,2926,2132,2427,2532,1179,-535,-1061,-1142,-1582,-1884,-1928,-1750,-1476,-1065,-332,276,458,516,742,999,814,259,-93,-162,-189,-199,-237,-486,-762,-761,-654,-622,-633,-596,-455,-309,-229,-191,-135,4,215,267,95,-65,-170,-221,-239,-296,-399,-503,-496,-396,-295,-244,-224,-200,-215,-204,-144,-112,-90,-88,-114,-157,-228,-292,-281,-164,-45,-20,-64,-107,-91,-60,-52,-47,-57,-73,-95,-139,-158,-136,-87,-59,-90,-129,-134,-95,-43,-25,-42,-62,-82,-83,-59,-34,-6,-14,-48,-105,-137,-124,-101,-21},
            {80,-126,134,-172,1742,10204,9050,-8158,-13459,3294,8870,-214,5690,11054,4426,3163,6147,3940,-5975,-8454,-3500,-5970,-8788,-5990,-2547,-3392,-3525,310,1827,1636,1333,2619,3891,1757,945,1771,1178,302,680,875,-1044,-2569,-2300,-1717,-1771,-2136,-1627,-1153,-1357,-1191,-887,-692,-274,381,971,904,612,655,877,737,150,-90,-281,-628,-600,-286,-220,-554,-818,-827,-676,-530,-305,-49,24,-3,69,252,241,198,261,330,253,-17,-176,-189,-117,-64,-100,-213,-387,-487,-437,-303,-196,-87,-17,-80,-166,-95,40,68,26,-90,-219,-246,-153,-20,44,38,-86,-250,-302,-239,-88,6,-27,-150,-219,-139,-35,43,74,54,-33,-117,-88,2,55,37,10,-40,-99,-118,-80,-67,-102,-109,-89,-18}
        },
        {    // H30e120a.wav
            {3,2,2,1,0,1,1,0,2,2,2,1,0,1,3,3,0,3,-4,9,0,7,7,3,14,177,1519,2677,862,-2052,-2642,-789,1724,3563,3905,2647,1814,2530,2725,1009,-812,-1202,-1282,-1783,-2031,-1829,-1562,-1382,-981,-222,389,590,782,942,905,839,549,16,-297,-208,-49,-261,-759,-1009,-930,-829,-717,-592,-475,-330,-263,-213,-120,-28,91,192,198,98,-10,-94,-214,-304,-344,-422,-530,-574,-466,-324,-302,-270,-193,-143,-113,-116,-68,-5,-20,-85,-186,-291,-345,-285,-162,-93,-89,-105,-113,-111,-89,-37,-15,-52,-80,-83,-97,-125,-123,-102,-83,-85,-114,-134,-119,-73,-46,-49,-71,-85,-77,-56,-17,-1,-12,-70,-127,-141,-106,-67,-73,-20},
            {-1,36,-93,143,-72,5212,11319,1301,-12549,-5140,7856,2053,854,11232,8188,1998,4770,6664,-691,-8567,-5217,-3743,-8164,-7758,-3643,-2673,-4155,-1452,1579,1589,1363,1969,3482,2296,818,1585,1419,632,370,929,286,-1809,-2404,-1810,-1771,-2354,-1978,-1061,-1217,-1406,-915,-484,-337,-79,601,1001,693,481,627,706,382,28,-95,-340,-521,-407,-216,-382,-695,-758,-696,-614,-467,-164,53,55,31,155,228,115,108,213,257,84,-131,-175,-145,-82,-34,-58,-222,-411,-445,-370,-274,-171,-53,-36,-130,-146,-58,-7,-15,-64,-175,-249,-200,-73,27,68,18,-128,-226,-243,-176,-76,-31,-67,-160,-165,-110,-39,43,82,46,-80,-134,-66,14,47,33,-8,-66,-109,-92,-67,-87,-100,-80,-17}
        },
        {    // H30e126a.wav
            {3,0,-1,0,-3,0,-1,0,1,-1,-2,0,-2,1,2,-2,1,-9,7,-1,8,-2,-3,13,297,1835,2643,330,-2239,-2261,-477,1833,3754,3940,2407,1753,2598,2460,609,-891,-1120,-1477,-2143,-2040,-1736,-1874,-1577,-711,9,412,666,952,1080,1029,965,644,117,-163,-90,-55,-267,-660,-1064,-1195,-1117,-933,-702,-545,-354,-141,-81,-111,-7,203,305,230,77,-32,-88,-156,-260,-383,-498,-578,-571,-504,-464,-384,-280,-213,-131,-105,-59,26,45,26,-66,-194,-281,-316,-282,-195,-130,-144,-151,-142,-155,-123,-63,-25,-32,-65,-85,-100,-99,-96,-77,-75,-104,-122,-135,-119,-91,-70,-71,-100,-114,-89,-43,-2,3,-45,-103,-141,-119,-96,-71,-61,-102,-29},
            {-52,75,-84,58,-67,981,7982,8834,-4813,-10581,1441,4962,-1412,6496,12331,4163,2007,6579,4834,-4668,-7605,-3477,-5582,-8577,-5781,-2633,-3613,-3419,342,1653,1308,1653,2674,2695,1122,1219,1574,968,440,513,881,-394,-1881,-2047,-1850,-2291,-2477,-1365,-907,-1363,-1172,-517,-172,-148,135,750,852,447,363,532,500,169,-41,-125,-296,-422,-354,-272,-512,-664,-613,-574,-563,-380,-17,115,59,46,140,99,-29,41,187,161,-49,-148,-149,-128,-62,16,-25,-257,-414,-394,-315,-246,-133,-29,-83,-173,-154,-99,-91,-97,-121,-197,-240,-153,-17,63,68,-20,-120,-180,-208,-164,-88,-27,-68,-163,-173,-116,-12,56,59,-11,-124,-115,-40,10,22,4,-16,-67,-92,-81,-70,-81,-83,-19}
        },
        {    // H30e132a.wav
            {3,0,0,-1,1,0,0,1,1,-1,2,0,3,3,1,1,-5,4,-1,20,-6,9,9,487,2249,2539,-285,-2440,-1944,-158,2186,4163,3901,2089,1779,2777,2275,122,-1262,-1305,-1593,-2190,-2005,-1704,-2005,-1747,-815,-13,615,836,963,1180,1132,994,727,281,-19,-14,66,-139,-629,-1026,-1108,-1140,-1186,-994,-674,-432,-268,-111,30,121,223,336,332,182,24,-101,-210,-247,-297,-498,-653,-610,-548,-477,-407,-347,-211,-144,-132,-44,63,119,52,-73,-151,-195,-232,-245,-203,-180,-180,-173,-207,-200,-139,-67,-17,-43,-84,-87,-75,-80,-70,-45,-51,-85,-123,-128,-117,-99,-71,-73,-118,-138,-102,-31,13,0,-64,-137,-134,-103,-58,-46,-68,-93,-122,-31},
            {16,-43,73,-102,121,-158,2429,9045,5313,-7380,-6586,3124,678,221,11065,10031,1663,3336,7146,2139,-6315,-5941,-3561,-6825,-7692,-4266,-2721,-3969,-2079,1125,1339,1450,2046,2395,1805,1068,1397,1332,761,316,612,556,-623,-1619,-2100,-2253,-2529,-2049,-976,-1048,-1318,-755,-187,-54,27,394,769,597,267,293,429,281,19,-40,-144,-294,-399,-343,-336,-506,-505,-449,-484,-521,-266,69,138,61,1,30,-47,-101,32,152,67,-86,-120,-136,-133,-50,44,-36,-244,-356,-325,-278,-220,-70,-26,-133,-224,-223,-158,-118,-97,-136,-221,-216,-115,15,94,68,-19,-100,-154,-169,-121,-49,-39,-122,-173,-145,-82,-8,21,26,-39,-99,-80,-51,-15,9,40,6,-61,-91,-69,-58,-87,-23}
        },
        {    // H30e138a.wav
            {-1,-2,-2,-1,-2,-1,0,-2,-3,-1,-2,4,-1,2,-3,-7,3,-8,16,-8,16,13,781,2697,2282,-981,-2594,-1627,189,2687,4643,3766,1758,1946,2962,1920,-385,-1497,-1515,-1973,-2462,-1947,-1468,-1935,-1893,-871,24,549,825,1090,1287,1113,951,819,330,-71,100,266,-107,-641,-896,-940,-1047,-1148,-1029,-829,-663,-436,-226,-88,115,359,432,314,201,129,-4,-202,-324,-361,-442,-604,-759,-637,-399,-349,-323,-282,-217,-124,-41,53,51,-10,-23,-29,-101,-186,-187,-189,-202,-211,-249,-257,-245,-175,-61,-17,-43,-90,-112,-110,-84,-32,-16,-49,-89,-115,-120,-118,-98,-85,-117,-138,-133,-98,-37,3,-31,-115,-143,-126,-91,-67,-46,-57,-84,-107,-124,-30},
            {4,-4,-11,35,-73,102,-57,3561,8835,2642,-7358,-3917,1663,-1232,3837,12623,7133,908,4504,6672,141,-6486,-4996,-4167,-6999,-6571,-3543,-3017,-3682,-1012,1189,1232,1713,1832,1933,1573,1079,1380,1270,569,186,558,426,-553,-1610,-2379,-2552,-2304,-1510,-991,-1190,-986,-408,-106,46,284,541,622,452,247,210,222,92,-7,-53,-187,-368,-449,-303,-253,-346,-392,-386,-417,-446,-189,100,145,15,-75,-63,-128,-115,42,115,21,-72,-113,-167,-153,-31,56,-33,-203,-289,-272,-241,-167,-46,-52,-178,-275,-262,-183,-120,-87,-137,-210,-201,-106,27,105,95,20,-60,-118,-122,-82,-58,-76,-124,-133,-121,-87,-39,16,36,-21,-74,-83,-44,4,52,60,12,-59,-84,-78,-96,-26}
        },
        {    // H30e144a.wav
            {-1,-1,-1,0,2,0,-1,-3,0,0,5,-2,5,-4,-1,1,-6,18,-10,29,45,1188,3162,1862,-1737,-2660,-1269,593,3317,5103,3534,1489,2219,3137,1457,-938,-1689,-1750,-2337,-2648,-2016,-1479,-1851,-1766,-724,70,501,858,1108,1237,1132,964,753,333,5,52,184,-58,-554,-842,-870,-850,-927,-925,-738,-632,-581,-459,-262,32,306,452,405,249,121,12,-99,-233,-371,-567,-790,-713,-471,-388,-321,-286,-272,-198,-152,-65,-11,-41,-9,52,33,-49,-116,-136,-130,-182,-263,-295,-304,-269,-169,-57,-31,-54,-70,-103,-105,-73,-37,-14,-43,-83,-100,-111,-94,-82,-106,-126,-149,-142,-77,-7,-7,-73,-134,-142,-111,-72,-40,-46,-55,-76,-87,-103,-123,-29},
            {-23,18,-20,3,12,-47,65,110,4140,8156,1331,-6508,-3257,-164,-818,6683,12189,5109,925,5035,5993,-906,-6240,-4682,-4470,-6556,-5785,-3286,-3108,-3182,-478,1061,1318,1572,1430,1856,1432,1031,1494,1201,300,-9,663,525,-718,-1816,-2567,-2509,-1879,-1293,-1106,-1117,-695,-255,-80,180,446,543,529,474,239,-16,7,27,-3,-117,-356,-436,-390,-257,-160,-212,-334,-410,-420,-368,-128,105,110,-45,-120,-108,-157,-129,14,86,-21,-119,-150,-190,-158,-40,36,-40,-177,-249,-244,-225,-151,-46,-67,-190,-312,-318,-225,-124,-70,-128,-227,-241,-130,23,118,128,61,-50,-130,-142,-109,-71,-72,-107,-146,-157,-126,-58,17,42,-10,-81,-90,-52,9,57,57,-33,-123,-141,-118,-25}
        },
        {    // H30e150a.wav
            {-3,-3,-1,0,-1,-4,-3,-1,0,4,-4,5,-8,2,-3,-4,12,-10,30,116,1713,3581,1254,-2520,-2636,-866,1074,4051,5483,3168,1317,2596,3191,858,-1483,-1829,-1989,-2772,-2820,-2005,-1530,-1791,-1697,-678,293,657,867,1097,1218,1124,848,650,354,-13,10,118,-184,-698,-885,-707,-668,-814,-757,-521,-435,-496,-510,-407,-147,217,385,295,202,146,64,-81,-191,-380,-733,-839,-683,-455,-250,-248,-312,-254,-152,-128,-164,-132,-2,55,30,21,-49,-114,-82,-90,-199,-287,-311,-313,-278,-181,-73,-34,-69,-107,-98,-75,-48,-20,-27,-67,-115,-131,-114,-90,-85,-113,-147,-164,-139,-63,-3,-32,-113,-146,-126,-102,-76,-43,-26,-53,-78,-97,-124,-118,-76,-13},
            {13,-26,18,-17,9,5,-30,41,229,4225,7552,1068,-5902,-3743,-1094,444,7995,11189,4112,1010,5098,5512,-1310,-5982,-4575,-4315,-6010,-5358,-3106,-3013,-2783,-306,1023,1262,1120,1348,1905,1196,1136,1646,983,-54,59,982,379,-1053,-1952,-2496,-2206,-1622,-1249,-1080,-972,-544,-163,37,211,438,664,608,393,98,-103,-66,-48,-21,-161,-450,-497,-342,-181,-153,-180,-293,-431,-437,-312,-23,162,72,-75,-82,-84,-171,-152,-22,22,-51,-125,-192,-218,-164,-34,44,-52,-176,-222,-212,-187,-113,-14,-51,-209,-330,-318,-214,-121,-79,-134,-229,-224,-109,30,119,131,69,-32,-139,-184,-131,-46,-10,-67,-159,-210,-153,-24,81,77,-21,-92,-89,-23,22,40,-4,-87,-138,-143,-31}
        },
        {    // H30e156a.wav
            {-2,1,-1,1,-3,-1,1,1,6,-3,5,-9,9,-8,3,6,-4,29,244,2369,3917,439,-3286,-2493,-419,1660,4892,5724,2673,1284,3088,3125,88,-2041,-1926,-2222,-3174,-2978,-2007,-1618,-1697,-1461,-652,351,842,985,1194,1234,1053,823,573,219,-29,-6,-25,-338,-810,-1005,-845,-615,-505,-539,-466,-288,-240,-357,-365,-66,189,193,118,73,78,60,-34,-266,-560,-712,-731,-593,-395,-332,-260,-158,-142,-190,-232,-136,24,46,-14,5,2,-74,-111,-110,-117,-191,-272,-305,-303,-244,-155,-74,-60,-88,-99,-105,-80,-13,34,4,-73,-141,-159,-140,-120,-104,-118,-155,-170,-129,-46,-1,-38,-102,-136,-130,-93,-52,-28,-30,-49,-80,-107,-114,-79,-39,-33,-9},
            {-4,12,-24,14,-16,7,4,-28,35,248,3946,7174,1372,-5680,-4466,-1225,1473,8100,10346,3789,926,4897,5263,-1259,-5704,-4444,-3946,-5551,-5054,-2968,-2882,-2554,-293,983,888,775,1543,1738,1046,1415,1605,616,-139,399,989,65,-1208,-2029,-2246,-1864,-1575,-1216,-986,-852,-449,-110,132,198,384,786,698,224,-46,-68,-97,-76,11,-181,-519,-611,-409,-176,-176,-270,-354,-401,-351,-210,31,190,116,-38,-67,-85,-181,-182,-85,-39,-80,-156,-239,-258,-180,-51,23,-46,-157,-225,-213,-146,-53,9,-57,-207,-314,-294,-220,-145,-93,-123,-194,-201,-114,-8,79,106,52,-66,-179,-189,-97,9,15,-80,-188,-201,-117,16,98,63,-31,-98,-79,-61,-28,-3,-20,-77,-141,-38}
        },
        {    // H30e162a.wav
            {0,-1,-1,-6,-1,-1,3,3,-3,5,-13,11,-13,9,-6,7,18,449,3119,4106,-542,-3982,-2230,57,2313,5774,5799,2109,1421,3615,2897,-773,-2566,-2029,-2511,-3527,-3059,-2028,-1738,-1624,-1173,-548,367,1006,1079,1207,1298,1086,812,496,157,-19,-121,-258,-526,-904,-1099,-1006,-713,-451,-340,-281,-200,-195,-251,-55,229,267,119,-22,-49,-20,-61,-258,-433,-568,-687,-612,-471,-416,-348,-214,-136,-178,-246,-153,64,120,39,-12,-41,-73,-130,-167,-135,-152,-229,-273,-296,-281,-212,-108,-57,-81,-104,-117,-113,-77,-14,52,39,-57,-155,-196,-165,-128,-131,-166,-209,-201,-123,-27,-1,-45,-95,-114,-108,-76,-43,-29,-32,-67,-96,-122,-104,-51,5,4,-63,-22},
            {11,-6,12,-18,10,-8,-2,12,-31,40,202,3482,6899,1844,-5563,-4957,-1032,1965,7582,9767,3822,751,4528,5165,-892,-5351,-4261,-3535,-5101,-4795,-2916,-2743,-2422,-318,780,413,767,1606,1435,1197,1600,1316,418,136,544,696,-47,-1231,-2013,-1963,-1627,-1501,-1224,-909,-670,-332,-59,63,154,486,820,639,130,-108,0,20,-39,-50,-244,-524,-676,-629,-363,-219,-311,-379,-342,-228,-47,125,176,122,54,1,-119,-240,-218,-106,-60,-130,-224,-289,-273,-186,-72,5,-34,-145,-211,-188,-125,-21,39,-35,-176,-269,-268,-224,-144,-74,-101,-185,-203,-138,-44,34,64,3,-117,-179,-136,-33,31,5,-84,-151,-145,-65,30,71,44,-49,-103,-116,-86,-37,7,5,-67,-24}
        },
        {    // H30e168a.wav
            {-1,-1,-7,0,-2,5,0,-1,2,-14,13,-20,18,-19,19,6,753,3931,4116,-1633,-4562,-1898,531,3077,6666,5683,1541,1730,4133,2494,-1691,-3017,-2142,-2860,-3858,-3096,-2061,-1827,-1505,-900,-397,370,1136,1265,1178,1284,1129,781,501,171,12,-164,-516,-858,-1091,-1109,-1063,-839,-480,-273,-209,-218,-173,-53,195,439,419,227,44,-35,-150,-350,-438,-503,-649,-697,-611,-461,-335,-259,-200,-229,-244,-137,27,142,135,91,31,-47,-152,-242,-217,-161,-174,-243,-310,-328,-269,-162,-65,-25,-69,-128,-138,-108,-59,7,47,27,-59,-166,-190,-163,-127,-130,-210,-276,-244,-128,-25,-4,-50,-91,-93,-67,-45,-30,-17,-30,-61,-120,-150,-117,-29,30,21,-30,-82,-24},
            {1,11,-7,9,-15,6,0,-10,20,-37,49,119,2904,6596,2405,-5275,-5216,-897,2002,6772,9331,4081,578,4033,5155,-313,-4903,-4062,-3125,-4627,-4622,-2939,-2598,-2296,-435,405,128,814,1429,1336,1437,1492,1042,549,377,387,485,-59,-1209,-1821,-1786,-1556,-1397,-1183,-814,-458,-209,-129,-94,111,603,854,487,109,22,48,88,1,-183,-369,-565,-733,-802,-637,-365,-239,-271,-301,-149,58,200,247,151,52,-15,-133,-238,-252,-160,-91,-178,-283,-302,-284,-228,-117,-17,-29,-118,-178,-171,-119,-33,48,22,-116,-240,-262,-208,-125,-72,-108,-204,-242,-183,-83,2,19,-50,-147,-176,-107,-4,58,30,-64,-132,-112,-36,13,12,-23,-72,-105,-110,-86,-27,18,4,-3}
        },
        {    // H30e174a.wav
            {0,-7,3,-2,6,0,1,-1,-10,12,-22,27,-31,37,-1,1169,4758,3916,-2764,-4981,-1518,997,3937,7521,5381,1044,2218,4572,1905,-2605,-3373,-2303,-3244,-4123,-3093,-2143,-1933,-1278,-605,-241,425,1152,1464,1267,1181,1189,785,385,232,172,-156,-736,-1188,-1343,-1210,-1107,-870,-452,-263,-288,-291,-143,100,387,574,535,385,188,-60,-239,-320,-426,-594,-779,-804,-655,-457,-313,-278,-264,-190,-37,9,5,145,228,137,8,-87,-189,-254,-227,-169,-196,-287,-328,-323,-279,-158,-18,12,-59,-126,-139,-103,-45,34,82,13,-129,-197,-161,-108,-102,-164,-253,-286,-233,-122,-36,-31,-74,-90,-62,-46,-29,3,31,10,-64,-122,-148,-125,-53,35,43,-15,-67,-83,-19},
            {2,-2,12,-5,8,-10,-2,5,-15,28,-41,53,48,2285,6148,2994,-4697,-5302,-945,1779,5844,8871,4488,529,3451,5100,390,-4279,-3836,-2777,-4168,-4483,-2986,-2438,-2158,-676,-1,3,762,1232,1410,1524,1282,999,766,423,200,373,-57,-1049,-1605,-1739,-1493,-1273,-1058,-630,-318,-238,-235,-124,85,526,844,600,197,42,80,63,-50,-250,-532,-746,-816,-756,-639,-530,-334,-152,-116,-63,43,192,298,225,37,-78,-111,-220,-271,-191,-127,-180,-288,-329,-333,-273,-126,-3,-10,-107,-144,-132,-113,-31,62,56,-72,-203,-220,-177,-123,-86,-130,-222,-268,-216,-114,-26,6,-58,-153,-173,-90,26,86,62,-26,-105,-106,-61,-33,-34,-38,-56,-87,-82,-43,-10,4,2}
        },
        {    // H30e180a.wav
            {-7,3,-2,8,-4,4,-5,-8,10,-21,29,-39,49,8,1688,5521,3521,-3825,-5226,-1179,1423,4871,8268,4956,684,2819,4899,1165,-3478,-3626,-2521,-3695,-4319,-3056,-2273,-2033,-1014,-321,-74,569,1130,1503,1433,1145,1109,862,332,157,338,-100,-902,-1419,-1617,-1366,-1159,-943,-502,-249,-287,-346,-151,165,461,652,659,446,71,-79,-22,-148,-408,-619,-800,-860,-733,-529,-420,-393,-251,-20,63,-15,59,258,269,78,-82,-122,-188,-256,-211,-148,-212,-310,-338,-344,-287,-146,-7,1,-82,-123,-127,-103,-51,43,85,-25,-165,-217,-172,-106,-91,-149,-259,-303,-227,-114,-35,-32,-83,-119,-116,-66,3,59,64,-3,-81,-112,-115,-106,-57,-5,-16,-52,-50,-42,-45,-11},
            {-7,3,-2,8,-4,4,-5,-8,10,-21,29,-39,49,8,1688,5521,3521,-3825,-5226,-1179,1423,4871,8268,4956,684,2819,4899,1165,-3478,-3626,-2521,-3695,-4319,-3056,-2273,-2033,-1014,-321,-74,569,1130,1503,1433,1145,1109,862,332,157,338,-100,-902,-1419,-1617,-1366,-1159,-943,-502,-249,-287,-346,-151,165,461,652,659,446,71,-79,-22,-148,-408,-619,-800,-860,-733,-529,-420,-393,-251,-20,63,-15,59,258,269,78,-82,-122,-188,-256,-211,-148,-212,-310,-338,-344,-287,-146,-7,1,-82,-123,-127,-103,-51,43,85,-25,-165,-217,-172,-106,-91,-149,-259,-303,-227,-114,-35,-32,-83,-119,-116,-66,3,59,64,-3,-81,-112,-115,-106,-57,-5,-16,-52,-50,-42,-45,-11}
        }
    },
    {    // elev40 
        {    // H40e000a.wav
            {12,-14,6,-9,22,-18,27,-31,5,6,-60,109,-164,222,-147,2808,5784,2213,-3208,-12878,-9367,6634,11194,14540,13223,1896,-4048,-400,3108,-1486,-4882,-5794,-6415,-3791,-3264,-3317,-1864,-1837,-593,1501,1841,2286,2560,2322,2241,1672,696,420,-3,-1621,-1191,-441,-1848,-2081,-1196,-753,-535,-204,174,430,436,301,405,773,1191,1099,622,253,-107,-555,-908,-1226,-1512,-1494,-1385,-1311,-1205,-933,-290,252,303,210,322,406,207,113,126,1,-141,-211,-272,-409,-386,-240,-236,-361,-411,-350,-309,-188,-14,129,113,49,64,41,44,56,39,-74,-232,-276,-246,-210,-180,-172,-169,-160,-162,-108,-45,-46,-62,-58,-70,-97,-76,-59,-67,-76,-76,-65,-74,-108,-134,-122,-74,-44,-35,-6},
            {12,-14,6,-9,22,-18,27,-31,5,6,-60,109,-164,222,-147,2808,5784,2213,-3208,-12878,-9367,6634,11194,14540,13223,1896,-4048,-400,3108,-1486,-4882,-5794,-6415,-3791,-3264,-3317,-1864,-1837,-593,1501,1841,2286,2560,2322,2241,1672,696,420,-3,-1621,-1191,-441,-1848,-2081,-1196,-753,-535,-204,174,430,436,301,405,773,1191,1099,622,253,-107,-555,-908,-1226,-1512,-1494,-1385,-1311,-1205,-933,-290,252,303,210,322,406,207,113,126,1,-141,-211,-272,-409,-386,-240,-236,-361,-411,-350,-309,-188,-14,129,113,49,64,41,44,56,39,-74,-232,-276,-246,-210,-180,-172,-169,-160,-162,-108,-45,-46,-62,-58,-70,-97,-76,-59,-67,-76,-76,-65,-74,-108,-134,-122,-74,-44,-35,-6}
        },
        {    // H40e006a.wav
            {-6,9,-8,3,-7,15,-7,12,-4,-21,28,-73,100,-116,136,-100,1611,4878,2863,-1394,-9734,-11166,1804,8896,12467,14411,5929,-2392,-1445,2189,-311,-3114,-4096,-5835,-4614,-3249,-2995,-2161,-2220,-1262,867,1295,1591,2366,2290,2042,2043,1488,807,254,-1408,-1443,-479,-1572,-1955,-1193,-779,-483,-172,43,157,342,294,256,807,1401,1053,247,57,72,-423,-915,-1138,-1347,-1306,-1105,-968,-911,-949,-689,-49,294,169,105,211,152,-5,-5,27,-83,-195,-214,-321,-404,-339,-228,-195,-316,-381,-320,-196,-84,24,117,116,74,27,38,43,13,-49,-148,-216,-240,-197,-172,-191,-185,-159,-147,-128,-96,-84,-73,-55,-33,-29,-52,-90,-101,-73,-70,-60,-44,-76,-134,-150,-126,-94,-20},
            {-13,3,-10,20,-14,17,-12,-32,53,-111,152,-192,203,-155,2070,6546,3436,-2362,-13155,-13179,5641,12690,15412,16225,3320,-5348,-1908,3027,-661,-5044,-6164,-7328,-4269,-2656,-3761,-2505,-1613,-699,1238,1925,2599,2812,2328,2412,1963,820,164,91,-1274,-1644,-723,-1616,-2162,-1464,-833,-507,-257,50,450,556,242,427,614,776,1400,1334,371,-222,-377,-711,-1177,-1616,-1721,-1714,-1722,-1363,-828,-368,52,433,528,449,458,345,250,194,32,-125,-259,-362,-441,-359,-285,-309,-343,-423,-423,-346,-175,2,156,182,97,72,15,29,71,57,-67,-270,-348,-313,-241,-183,-173,-191,-169,-140,-92,-37,-31,-35,-41,-63,-90,-80,-90,-109,-86,-76,-91,-112,-124,-117,-89,-61,-37,-15,-6,-2}
        },
        {    // H40e013a.wav
            {5,-3,8,-8,1,-5,13,-9,15,-10,-8,12,-48,77,-94,117,-78,1678,4259,2477,-1393,-8951,-9301,1650,7225,11320,13183,5343,-1402,-359,1794,-563,-2519,-3694,-5479,-4320,-2865,-2699,-2312,-2125,-964,621,938,1487,2147,2068,1974,1968,1527,953,43,-1449,-1088,-485,-1501,-1620,-1039,-615,-321,-194,-113,11,232,143,195,845,1290,850,102,-148,-68,-279,-775,-1136,-1192,-1018,-922,-866,-753,-776,-645,-227,126,176,24,-11,-22,-48,-33,-71,-100,-139,-217,-307,-297,-255,-255,-229,-241,-314,-345,-216,-52,61,104,88,51,9,25,38,15,-62,-145,-193,-193,-173,-184,-195,-206,-189,-160,-124,-94,-99,-72,-17,-2,-12,-54,-108,-117,-82,-38,-53,-50,-75,-109,-127,-158,-39},
            {-4,-7,16,-1,0,18,-67,81,-127,150,-147,110,-49,1266,6747,5044,-1191,-12815,-16890,3251,14380,15972,18498,6310,-5953,-4095,2754,117,-5286,-6187,-8068,-5385,-2168,-3316,-3045,-2109,-744,1390,1809,2491,3204,2564,2376,2126,1091,159,17,-1036,-1682,-1037,-1704,-2158,-1597,-1012,-579,-150,120,355,699,337,213,227,446,1686,1802,522,-182,-356,-566,-946,-1491,-1892,-2214,-2137,-1315,-632,-554,-233,499,821,687,571,377,246,269,126,-92,-297,-429,-475,-414,-317,-275,-298,-465,-523,-399,-155,36,151,241,189,131,30,-14,58,81,-32,-270,-428,-413,-306,-202,-171,-215,-182,-120,-93,-41,-13,2,-2,-18,-59,-101,-119,-127,-103,-100,-130,-133,-109,-86,-77,-69,-34,-1,13,5,-1}
        },
        {    // H40e019a.wav
            {-8,5,-3,6,-4,0,-2,9,-6,7,-3,-16,16,-43,60,-69,77,-58,1130,3503,2613,-387,-6784,-8637,-499,5036,9487,12134,6261,274,-47,1385,2,-1754,-3029,-4858,-4041,-2587,-2656,-2395,-1941,-1129,50,612,1221,1823,1949,1928,1888,1578,966,64,-1049,-794,-359,-1118,-1284,-900,-625,-526,-404,-231,-193,-20,22,137,731,1088,668,126,-81,-64,-121,-599,-1027,-1016,-845,-786,-795,-704,-641,-582,-399,-133,69,40,-95,-211,-199,-49,-42,-171,-182,-158,-232,-230,-187,-220,-256,-263,-246,-251,-193,-67,23,67,72,52,7,-12,-5,-3,-38,-100,-156,-185,-186,-213,-216,-201,-192,-171,-135,-76,-71,-52,-6,-2,-23,-60,-101,-131,-101,-53,-19,-35,-76,-116,-148,-38},
            {-7,12,5,-8,26,-75,83,-129,146,-124,75,-10,961,6855,6329,-229,-13651,-19638,2047,16049,17665,19787,7390,-5436,-5120,1509,486,-5598,-6950,-8536,-6234,-2215,-2833,-2726,-2255,-1327,1477,2372,2544,2959,2801,2734,2079,1064,131,42,-854,-1700,-1268,-1946,-2190,-1631,-1163,-707,-162,391,554,824,445,-136,-158,442,1686,1847,697,-221,-424,-412,-714,-1376,-2157,-2633,-2160,-1061,-648,-777,-309,601,1056,902,626,372,272,298,146,-91,-327,-449,-522,-493,-313,-217,-294,-498,-558,-435,-178,51,213,305,235,174,82,30,51,66,-31,-277,-448,-477,-388,-278,-229,-222,-185,-152,-119,-24,39,47,42,27,-39,-93,-113,-128,-143,-175,-156,-97,-64,-75,-99,-77,-34,4,18,6,16,8}
        },
        {    // H40e026a.wav
            {-1,-6,3,-3,6,-3,0,-1,7,-6,8,-5,-9,10,-31,49,-56,64,-49,1027,3025,2435,-146,-5873,-7635,-1150,3994,8673,10897,6053,1073,277,1261,189,-1395,-2704,-4274,-3522,-2432,-2616,-2285,-1776,-1200,-244,460,1113,1709,1853,1671,1628,1579,1080,121,-743,-416,-208,-907,-1136,-965,-812,-680,-441,-419,-412,-28,-1,50,705,995,480,97,159,108,-204,-609,-892,-907,-777,-729,-722,-692,-660,-506,-342,-224,-76,-31,-106,-265,-276,-76,-50,-193,-217,-126,-149,-211,-181,-196,-253,-251,-207,-157,-124,-115,-16,77,73,38,-28,-45,-15,10,-19,-107,-178,-184,-182,-210,-225,-203,-162,-150,-98,-53,-55,-39,-29,-22,-22,-48,-99,-122,-104,-55,-40,-27,-70,-150,-40},
            {-4,23,-26,46,-86,78,-99,74,-11,-75,183,122,5675,7834,2616,-10726,-22831,-4341,15722,18446,21505,11182,-3769,-5667,163,759,-4869,-7024,-9229,-7845,-2732,-2515,-2719,-1906,-1518,533,2177,3119,3146,2390,2813,2583,1326,93,-113,-474,-1389,-1430,-2171,-2258,-1610,-1444,-929,-260,342,676,1152,566,-563,-19,638,980,1641,1133,-173,-648,-325,-326,-1334,-2383,-2574,-1912,-1019,-840,-996,-460,630,1210,934,570,418,339,359,231,-82,-373,-492,-519,-481,-333,-258,-285,-445,-545,-455,-239,-10,179,337,298,209,107,27,85,108,-12,-254,-442,-480,-439,-355,-277,-278,-264,-206,-136,-34,48,85,72,45,-19,-71,-83,-126,-177,-190,-160,-92,-58,-89,-102,-85,-51,-28,-2,8,3,29,9}
        },
        {    // H40e032a.wav
            {-3,0,-5,1,-2,4,-2,0,-2,2,-1,1,2,-10,13,-27,34,-37,32,-27,579,2355,2462,738,-3935,-7112,-2852,2365,6876,9759,6784,2222,567,1178,597,-858,-1974,-3447,-3239,-2328,-2508,-2232,-1686,-1406,-628,316,952,1264,1378,1507,1717,1804,1323,421,-262,-181,-203,-856,-1182,-1082,-976,-912,-660,-490,-382,-112,-177,-10,698,901,443,233,375,202,-247,-583,-772,-846,-792,-718,-716,-732,-620,-404,-318,-311,-239,-117,-96,-220,-228,-153,-143,-165,-165,-124,-160,-221,-228,-200,-163,-177,-199,-174,-102,-38,-13,16,18,-6,-18,-31,-31,-23,-58,-119,-166,-173,-169,-201,-218,-195,-143,-96,-73,-55,-67,-61,-39,-30,-20,-46,-85,-120,-107,-90,-75,-55,-84,-26},
            {35,-35,54,-82,62,-66,15,68,-171,295,-233,4619,8496,4874,-8141,-24577,-9306,14796,19019,22707,13884,-2172,-5659,-610,1486,-4587,-7613,-9308,-9474,-4026,-2326,-2602,-1820,-1393,698,1869,2815,3697,2719,2521,2451,1727,403,-357,-536,-1143,-1194,-2359,-2674,-1497,-1425,-1267,-369,464,789,1178,508,-470,342,655,608,1412,1059,-238,-843,-414,-236,-1461,-2517,-2151,-1309,-1083,-1099,-810,-319,482,1043,950,637,353,275,432,346,-71,-384,-497,-598,-538,-307,-223,-257,-444,-525,-385,-237,-44,156,349,328,203,109,28,84,133,53,-186,-419,-495,-451,-355,-296,-330,-355,-275,-163,-25,66,71,80,79,6,-63,-88,-130,-143,-120,-102,-107,-111,-98,-90,-82,-70,-55,-26,4,13,36,53,14}
        },
        {    // H40e039a.wav
            {4,-2,1,-4,2,0,4,0,1,0,3,1,1,5,-6,11,-19,23,-26,28,-21,484,2016,2291,933,-3217,-6480,-3198,1720,6095,8837,6528,2561,854,1177,681,-574,-1591,-2896,-2839,-2203,-2399,-2069,-1575,-1390,-668,75,532,1045,1441,1628,1811,1951,1433,427,-180,-203,-400,-898,-1119,-1265,-1288,-877,-483,-502,-427,-156,-178,47,771,932,415,247,372,191,-269,-637,-757,-847,-835,-735,-678,-628,-551,-386,-323,-338,-247,-128,-85,-170,-181,-128,-182,-189,-142,-175,-238,-243,-213,-174,-147,-143,-143,-129,-60,-8,-22,-31,-13,1,-15,-45,-69,-72,-73,-111,-154,-149,-161,-189,-190,-173,-106,-67,-60,-60,-70,-60,-47,-32,-35,-47,-86,-119,-116,-100,-92,-90,-21},
            {-16,36,-42,-13,34,-110,183,-248,296,-324,2278,8204,7475,-1927,-22141,-18943,9572,18848,21887,19057,2358,-5164,-2183,1632,-2091,-7183,-9249,-10726,-6260,-3180,-3069,-1524,-1582,-90,2057,2875,3589,2850,2817,2768,1674,713,-2,-429,-1183,-1076,-1922,-2990,-1898,-1405,-1450,-694,279,898,1017,462,131,531,364,417,1280,1179,-134,-1000,-730,-465,-1337,-2244,-1770,-1053,-1236,-1238,-537,-37,235,543,755,800,521,219,292,330,66,-163,-364,-662,-707,-401,-175,-181,-363,-464,-384,-294,-104,154,364,321,164,99,35,60,110,89,-74,-322,-449,-448,-379,-302,-342,-389,-320,-212,-73,24,58,69,82,35,-70,-110,-123,-104,-56,-52,-96,-129,-119,-87,-84,-106,-90,-46,4,28,32,44,48,11}
        },
        {    // H40e045a.wav
            {0,1,-1,0,-4,0,-1,2,-1,0,-2,1,-1,0,5,-7,8,-20,17,-17,18,-21,401,1723,2107,1127,-2569,-5978,-3473,1148,5391,8070,6244,2796,1109,1180,754,-329,-1226,-2393,-2489,-2069,-2246,-1831,-1457,-1598,-1033,-57,651,1133,1489,1745,1925,1897,1140,215,-166,-280,-453,-956,-1432,-1380,-1049,-725,-529,-493,-313,-204,-245,300,964,749,240,247,349,89,-333,-649,-831,-933,-816,-613,-580,-620,-543,-382,-313,-269,-212,-144,-68,-100,-130,-125,-214,-268,-223,-231,-273,-253,-214,-174,-142,-92,-54,-75,-79,-49,-16,-23,-35,-27,-53,-88,-105,-96,-78,-107,-139,-148,-158,-160,-162,-130,-92,-80,-63,-62,-65,-70,-76,-61,-48,-60,-83,-121,-130,-132,-127,-28},
            {1,13,-70,84,-143,165,-161,119,-65,671,6819,9073,2780,-17482,-24953,2636,18971,20164,20849,7278,-3371,-2762,1378,56,-6583,-9000,-10576,-8392,-4358,-4075,-2418,-1384,-575,1538,3005,4283,3298,2536,2971,2278,947,-206,-227,-866,-1223,-1689,-3026,-2317,-1523,-1623,-925,172,791,632,570,953,664,21,403,1184,1082,25,-920,-1237,-1205,-1367,-1621,-1322,-1115,-1186,-1003,-450,189,405,270,265,566,674,370,112,102,133,39,-220,-540,-711,-576,-266,-143,-237,-347,-392,-321,-114,138,341,337,149,13,-23,12,90,93,-43,-248,-388,-400,-359,-299,-319,-379,-325,-237,-145,-35,43,55,47,-6,-98,-128,-109,-60,-45,-56,-85,-106,-81,-79,-106,-138,-126,-77,-12,41,45,32,36,26,2}
        },
        {    // H40e051a.wav
            {2,1,2,-2,1,-2,-1,1,2,1,-1,-3,-1,-1,-3,9,-7,5,-15,10,-7,1,-5,208,1269,1894,1544,-1268,-5244,-4273,-49,4112,7178,6315,3365,1483,1170,923,58,-673,-1707,-2128,-1807,-1990,-2047,-1780,-1526,-865,9,675,1156,1525,1605,1550,1497,872,179,-31,-352,-815,-1032,-1086,-1203,-1073,-642,-354,-388,-438,-210,65,404,708,540,200,162,213,17,-362,-707,-875,-836,-675,-548,-579,-631,-487,-300,-247,-231,-178,-107,-46,-39,-110,-188,-269,-349,-328,-268,-267,-269,-247,-172,-61,-14,-27,-73,-83,-41,-12,-26,-64,-75,-97,-118,-115,-108,-106,-107,-108,-115,-120,-128,-122,-120,-106,-79,-60,-58,-81,-97,-95,-66,-64,-65,-95,-126,-148,-162,-38},
            {45,-83,62,-60,1,82,-185,301,-394,3681,9155,7746,-7367,-27270,-11259,16264,19357,20549,13533,487,-2685,-128,2506,-3202,-9138,-10519,-9456,-5576,-5148,-3974,-1913,-1678,571,2528,4257,4231,2944,3326,2620,1465,406,-140,-732,-1291,-1171,-2679,-2979,-1896,-1744,-1224,-239,475,359,666,1413,898,141,312,881,1058,365,-537,-1411,-1887,-1510,-1176,-1060,-1152,-1140,-789,-436,55,441,419,147,190,478,442,164,30,106,67,-122,-316,-520,-605,-440,-187,-111,-270,-387,-306,-137,74,261,346,213,1,-69,-61,10,89,40,-145,-350,-398,-330,-261,-244,-308,-316,-264,-209,-98,30,54,12,-29,-115,-142,-101,-53,-39,-72,-91,-94,-62,-49,-83,-115,-126,-107,-45,19,53,51,39,35,-10,-9}
        },
        {    // H40e058a.wav
            {1,1,0,2,0,0,-2,1,-1,2,-1,-1,-2,0,-1,1,12,-8,6,-14,10,-8,1,0,199,1123,1726,1583,-1037,-4938,-4203,-237,3835,6710,5860,3269,1627,1197,944,251,-383,-1238,-1795,-1943,-2177,-1865,-1309,-1094,-661,107,734,1036,1155,1193,1231,1103,649,177,-345,-621,-523,-698,-1090,-1193,-759,-372,-422,-417,-244,-80,74,380,530,271,101,123,53,-189,-470,-631,-735,-739,-626,-553,-549,-500,-359,-256,-220,-172,-122,-75,-44,-82,-165,-255,-343,-380,-330,-287,-313,-292,-176,-69,-36,-37,-34,-31,-33,-42,-38,-57,-95,-102,-118,-148,-148,-130,-93,-67,-68,-86,-114,-109,-109,-106,-95,-89,-76,-70,-71,-96,-105,-102,-82,-86,-98,-138,-177,-42},
            {12,-65,79,-140,169,-171,134,-89,558,6700,10012,3180,-19613,-25247,5491,20433,18639,17672,6083,-1215,-1100,2232,1697,-6527,-10600,-10784,-7433,-4883,-5300,-3255,-2550,-1265,1222,3426,5087,3482,3363,3813,2300,829,40,-3,-1173,-1488,-1812,-2973,-2598,-2189,-1591,-568,-11,-6,500,1674,1210,233,549,779,759,578,-55,-1103,-2231,-1967,-1092,-878,-1004,-1058,-754,-424,-21,276,423,379,138,153,188,144,115,126,30,-143,-196,-299,-459,-495,-293,-71,-146,-349,-359,-190,21,196,330,266,17,-103,-116,-80,20,66,-33,-265,-406,-363,-252,-158,-204,-267,-257,-243,-164,-30,63,10,-63,-117,-169,-129,-71,-42,-77,-108,-102,-77,-60,-69,-75,-82,-79,-72,-19,25,48,51,38,5,-55,-17}
        },
        {    // H40e064a.wav
            {1,1,1,0,2,-1,1,-3,-1,0,3,1,-1,-2,0,0,2,12,-8,7,-12,10,-4,-1,13,129,909,1525,1671,-408,-4427,-4422,-746,3211,6122,5585,3320,1867,1318,1099,596,-83,-1149,-1792,-1567,-1516,-1383,-987,-831,-653,-241,306,618,712,841,901,789,261,-71,4,-187,-392,-589,-882,-877,-638,-396,-264,-337,-355,-138,139,272,172,82,74,-30,-195,-265,-277,-459,-686,-703,-573,-440,-405,-395,-299,-230,-190,-100,-93,-141,-124,-125,-222,-323,-332,-335,-384,-372,-287,-183,-117,-94,-47,-6,11,9,-20,-52,-74,-93,-109,-125,-168,-183,-141,-83,-52,-51,-51,-75,-88,-82,-89,-109,-110,-85,-55,-49,-89,-115,-134,-111,-104,-97,-105,-150,-39},
            {-58,41,-37,-32,111,-215,311,-450,2753,9114,9291,-6203,-28168,-12429,17775,19180,17274,12072,1671,-988,682,4381,-1129,-9290,-10841,-9511,-6191,-5781,-4171,-2667,-3351,-804,1822,4370,4456,3213,4385,3635,1933,767,270,-553,-1514,-1395,-2528,-3045,-2604,-2232,-1108,-509,-418,198,1383,1571,526,483,994,783,531,129,-664,-1909,-2323,-1419,-949,-790,-808,-777,-388,-73,135,239,454,334,64,-22,-134,-32,176,149,-145,-265,-185,-255,-394,-341,-97,-24,-216,-353,-294,-122,126,308,304,97,-138,-206,-190,-74,62,17,-181,-381,-385,-268,-144,-94,-187,-223,-213,-190,-97,7,14,-66,-118,-176,-171,-127,-96,-81,-106,-124,-129,-100,-81,-68,-54,-30,-22,-33,-6,14,33,23,1,-47,-83,-19}
        },
        {    // H40e071a.wav
            {0,0,1,1,1,1,-1,1,-2,0,-1,3,0,-1,-2,0,-1,6,9,-8,8,-12,11,-9,12,1,184,945,1491,1592,-853,-4641,-3939,-133,3584,5867,4941,2951,1860,1469,1073,284,-267,-730,-1068,-1082,-1174,-1107,-941,-1006,-961,-518,97,357,458,612,462,274,406,461,88,-191,-144,-373,-870,-822,-347,-322,-511,-448,-278,-94,106,119,-59,-58,-36,-145,-198,-192,-234,-461,-646,-568,-422,-361,-359,-319,-259,-210,-129,-120,-183,-191,-173,-188,-259,-315,-326,-385,-392,-300,-229,-176,-127,-60,2,13,19,-1,-37,-75,-116,-129,-144,-163,-165,-153,-104,-65,-59,-42,-52,-64,-67,-84,-106,-105,-82,-69,-68,-80,-104,-143,-146,-140,-119,-95,-103,-26},
            {-75,87,-118,92,-41,-61,174,-261,4663,10370,6856,-14858,-28302,-109,21270,16814,15507,8183,630,-763,2401,4964,-4056,-10281,-9931,-8155,-6396,-6242,-3224,-2934,-3173,-466,2156,4712,3396,3371,4985,3378,1700,1007,715,-960,-1791,-1438,-2518,-3219,-2982,-1800,-903,-993,-441,801,1514,1023,416,868,1111,623,346,-195,-1220,-2143,-1868,-1105,-964,-744,-603,-447,-201,22,185,288,365,176,38,-179,-318,-71,203,115,-216,-250,-175,-254,-319,-172,30,-43,-236,-301,-232,-62,158,303,249,-16,-233,-258,-203,-46,51,-39,-270,-431,-305,-147,-73,-106,-170,-151,-175,-146,-47,15,-44,-119,-130,-162,-164,-155,-129,-104,-113,-143,-145,-109,-86,-51,-14,17,6,-4,21,21,15,-8,-32,-64,-69,-15}
        },
        {    // H40e077a.wav
            {0,2,0,1,2,1,2,1,0,-1,1,0,3,-1,2,-3,1,3,7,4,-4,7,-11,18,-2,18,-24,234,986,1508,1457,-1345,-4755,-3346,587,3788,5336,4386,2712,1687,1282,1075,775,372,-183,-561,-897,-1181,-1248,-1377,-1388,-1178,-710,-167,61,113,80,417,875,723,402,253,281,-16,-571,-618,-544,-659,-684,-506,-348,-332,-128,76,-95,-283,-117,32,-126,-238,-180,-192,-339,-465,-457,-388,-320,-284,-265,-231,-212,-179,-198,-244,-228,-205,-206,-263,-334,-340,-313,-310,-307,-245,-149,-66,-7,17,13,-10,-34,-59,-108,-154,-160,-138,-128,-138,-129,-96,-65,-49,-46,-38,-49,-68,-77,-87,-88,-84,-81,-77,-96,-135,-158,-156,-127,-96,-68,-13},
            {-55,77,-129,151,-148,100,-44,226,6128,11033,3222,-21416,-23854,9204,20743,14355,13544,6143,593,-417,4106,4260,-6473,-10124,-8440,-7141,-7124,-6197,-2770,-3628,-2931,101,2672,4139,2495,3819,4889,3040,1858,1492,852,-1138,-1437,-1480,-2737,-3260,-2958,-1693,-1156,-1183,-228,928,1225,644,449,1157,1059,432,204,-510,-1481,-1946,-1363,-935,-994,-658,-396,-210,-129,58,264,286,178,14,-22,-296,-440,-104,235,81,-250,-221,-145,-215,-224,-27,92,-71,-227,-219,-163,-48,164,264,128,-138,-266,-258,-211,-41,30,-120,-348,-382,-207,-86,-36,-100,-140,-113,-126,-95,-28,-10,-96,-131,-131,-152,-166,-181,-148,-145,-152,-152,-144,-110,-78,-33,15,38,16,17,45,42,0,-39,-54,-65,-53,-12}
        },
        {    // H40e084a.wav
            {0,0,0,-1,1,-1,3,-1,-1,-2,-2,-1,0,0,-2,-1,-4,1,-1,8,-3,1,-6,4,20,-1,-7,-15,527,1222,1661,646,-3152,-4670,-1389,2238,4311,4586,3354,2010,1608,1944,1616,846,272,-186,-637,-1285,-1512,-1472,-1648,-1543,-1221,-664,-225,-360,-50,753,987,763,683,681,408,87,-56,-417,-893,-993,-751,-531,-496,-407,-254,-118,-84,-205,-137,-2,-95,-232,-200,-83,-128,-300,-452,-454,-333,-253,-255,-277,-251,-229,-251,-273,-255,-209,-211,-260,-301,-301,-276,-298,-322,-285,-202,-92,-20,0,-18,-43,-49,-77,-108,-129,-143,-141,-132,-125,-119,-114,-98,-69,-52,-46,-48,-52,-65,-90,-103,-93,-87,-97,-110,-129,-145,-156,-134,-99,-70,-14},
            {-38,56,-111,150,-176,160,-150,531,6739,11171,705,-23880,-19769,12985,19050,12648,12445,5788,784,67,5094,3252,-7645,-9427,-7271,-6693,-7432,-5996,-2889,-4115,-2922,254,3104,3698,1862,4045,4697,2617,1950,1982,868,-1242,-861,-1112,-2965,-3462,-2618,-1566,-1670,-1291,1,750,767,380,613,1208,826,394,184,-639,-1507,-1625,-972,-922,-1001,-535,-264,-169,-156,112,276,229,72,-96,-114,-387,-463,-111,216,68,-272,-205,-92,-166,-148,42,96,-90,-200,-168,-147,-44,165,216,14,-230,-261,-239,-209,-34,4,-181,-376,-327,-151,-83,-29,-69,-118,-113,-105,-55,-27,-51,-116,-114,-130,-173,-173,-174,-164,-188,-190,-168,-142,-102,-65,-31,5,25,17,29,46,45,10,-41,-69,-68,-44,-9}
        },
        {    // H40e090a.wav
            {1,0,2,-1,2,1,1,0,0,1,1,2,0,3,-1,1,-1,2,-1,6,4,-1,1,0,35,-5,3,-55,243,995,1569,1418,-1663,-4771,-2719,1253,3509,4135,3491,2670,2274,2341,2101,1238,405,-203,-528,-1137,-1752,-1652,-1605,-1815,-1661,-881,-474,-623,102,944,993,893,974,880,355,297,333,-459,-1210,-1171,-726,-596,-625,-465,-350,-248,-94,25,9,-96,-152,-195,-142,-46,-55,-184,-404,-461,-350,-255,-253,-291,-245,-255,-312,-295,-247,-194,-195,-251,-274,-263,-260,-262,-272,-273,-231,-135,-48,-34,-49,-58,-75,-98,-93,-71,-94,-142,-143,-106,-86,-96,-107,-82,-54,-54,-53,-47,-58,-79,-100,-100,-87,-98,-103,-108,-120,-132,-115,-80,-62,-14},
            {-31,48,-96,133,-159,150,-145,501,6598,11164,-26,-23768,-17558,13461,17246,11125,11995,6318,1200,611,5640,2766,-8115,-8791,-6202,-6368,-7412,-5758,-3189,-4620,-3107,150,2957,3420,1681,3935,4456,2418,1926,2080,911,-1007,-300,-685,-2750,-3337,-2512,-1525,-1891,-1501,-88,436,259,138,687,1093,600,393,269,-553,-1336,-1320,-694,-823,-961,-440,-166,-162,-227,81,289,174,3,-154,-215,-447,-450,-117,144,33,-213,-156,-74,-111,-67,84,96,-76,-180,-167,-127,-25,135,156,-38,-267,-291,-216,-167,-40,-21,-188,-352,-313,-149,-65,-20,-52,-88,-102,-97,-39,-18,-56,-123,-104,-120,-183,-176,-159,-162,-202,-210,-187,-143,-85,-50,-34,-12,10,8,38,65,56,28,-14,-46,-61,-48,-10}
        },
        {    // H40e096a.wav
            {0,-1,0,0,0,0,1,1,-2,0,-2,-2,-3,1,-1,-2,-4,2,-2,0,0,-4,5,-5,32,-3,-9,-43,144,880,1564,1671,-985,-4736,-3594,685,3382,4183,3822,3145,2552,2413,2174,1163,333,-222,-763,-1219,-1692,-1783,-1768,-1907,-1602,-1146,-845,-141,522,671,971,1352,1182,636,465,570,108,-782,-1295,-1094,-774,-729,-663,-591,-490,-261,40,218,109,-82,-149,-128,-125,-102,-61,-161,-377,-463,-375,-292,-270,-264,-258,-295,-346,-311,-231,-190,-181,-203,-269,-305,-240,-185,-219,-250,-234,-177,-137,-110,-85,-112,-131,-88,-40,-49,-96,-132,-122,-92,-79,-81,-82,-81,-86,-80,-75,-71,-71,-85,-104,-115,-102,-90,-89,-102,-99,-97,-80,-69,-85,-21},
            {-41,53,-93,112,-115,80,-45,178,5687,11054,1553,-21625,-18353,11145,16250,10183,12168,7324,1681,863,5613,3384,-7655,-8722,-5658,-6033,-7229,-5744,-3246,-4876,-3630,-126,2533,3125,1592,3820,4418,2346,1988,1948,773,-748,123,-326,-2453,-2890,-2328,-1696,-1951,-1516,-346,-33,-121,35,642,864,455,425,359,-347,-1057,-1153,-642,-695,-858,-414,-142,-170,-264,39,242,120,-3,-165,-243,-451,-445,-159,47,26,-155,-123,-62,-92,-34,84,110,-45,-179,-185,-134,-23,97,114,-35,-242,-289,-227,-160,-42,-24,-161,-317,-318,-185,-83,-9,-50,-93,-85,-92,-41,-11,-45,-113,-115,-117,-166,-173,-164,-157,-193,-207,-188,-163,-105,-55,-33,-25,-12,-2,32,78,75,38,-3,-29,-40,-38,-10}
        },
        {    // H40e103a.wav
            {0,0,2,0,2,1,1,1,1,0,0,0,-1,3,-1,0,-3,3,1,3,-4,-5,8,5,27,-8,-1,-49,225,1007,1772,1677,-1701,-5338,-3353,1272,3920,4654,4271,3192,2184,2145,1926,801,25,-381,-895,-1497,-1801,-1678,-1835,-1799,-1439,-1312,-550,416,592,691,1158,1453,1061,652,687,316,-480,-1012,-1086,-960,-906,-763,-697,-703,-461,-137,146,246,158,43,-22,-45,-141,-200,-166,-170,-329,-508,-455,-290,-229,-262,-293,-321,-332,-268,-198,-179,-160,-195,-284,-273,-190,-151,-179,-226,-231,-214,-183,-156,-173,-174,-101,-16,-24,-87,-106,-93,-71,-70,-76,-67,-61,-63,-92,-104,-93,-91,-93,-103,-110,-103,-92,-81,-75,-84,-72,-66,-59,-68,-84,-20},
            {-45,48,-74,65,-40,-23,93,-177,4076,10460,4627,-17299,-20531,6171,15395,9490,12467,8997,2295,982,5097,4701,-6060,-8960,-5536,-5685,-6933,-5982,-3263,-4662,-4380,-765,1915,2939,1432,3273,4667,2571,1973,1863,723,-676,224,166,-1977,-2476,-2139,-1667,-1870,-1690,-578,-432,-578,-121,558,677,284,399,500,-76,-722,-1029,-680,-588,-770,-391,-164,-203,-269,-8,200,42,-19,-141,-210,-393,-473,-214,-30,16,-106,-123,-45,-74,-54,57,117,-13,-162,-191,-159,-73,53,103,-19,-194,-244,-220,-193,-66,-3,-122,-281,-323,-212,-124,-43,-47,-110,-92,-87,-39,-3,-43,-104,-118,-113,-151,-166,-162,-154,-174,-189,-185,-182,-136,-77,-43,-41,-34,-15,30,80,84,46,-2,-18,-12,-13,-5}
        },
        {    // H40e109a.wav
            {0,1,1,1,1,0,2,0,0,-2,1,0,0,1,1,0,1,1,0,6,-10,0,-3,20,16,-11,-6,-8,536,1553,2254,347,-4373,-5374,-871,3161,4708,4950,3999,2572,2017,1924,1012,94,-303,-848,-1373,-1717,-1780,-1758,-1624,-1377,-1573,-944,420,634,548,1128,1493,1097,788,973,569,-446,-1070,-1010,-826,-959,-968,-824,-791,-613,-269,28,118,162,277,257,127,-4,-115,-263,-334,-278,-352,-516,-528,-340,-219,-284,-334,-326,-260,-182,-152,-141,-205,-251,-204,-173,-148,-152,-191,-219,-254,-238,-224,-257,-245,-136,-22,-31,-89,-104,-74,-40,-47,-61,-60,-49,-50,-68,-88,-115,-120,-119,-129,-125,-122,-93,-63,-72,-65,-59,-50,-59,-65,-50,-56,-15},
            {-31,14,-20,-14,52,-111,157,-269,1830,8492,8380,-9438,-21815,-2708,13206,9127,12088,11945,3536,826,4079,6067,-2588,-8875,-5972,-5248,-6551,-6354,-3628,-3861,-5012,-1922,938,2568,1586,2170,4516,3297,2121,1739,874,-438,-145,521,-1162,-1996,-2017,-1650,-1371,-1761,-1124,-709,-934,-489,306,535,190,243,605,322,-318,-859,-787,-473,-685,-488,-184,-246,-233,-61,109,-8,-58,-96,-151,-265,-444,-303,-85,10,-77,-144,-82,-70,-73,-30,94,42,-140,-186,-173,-131,-35,72,41,-119,-198,-176,-190,-130,-21,-72,-211,-304,-250,-172,-117,-79,-124,-111,-91,-57,-1,-23,-87,-110,-105,-152,-163,-147,-139,-147,-164,-174,-197,-168,-119,-80,-68,-57,-23,21,76,83,40,-2,8,23,4,-2}
        },
        {    // H40e116a.wav
            {0,0,0,2,0,3,2,1,-1,-1,0,1,2,0,1,-1,4,-1,2,-1,-6,-3,1,18,1,6,-33,228,1230,2388,1421,-3060,-5921,-2654,2254,4675,5227,4296,2752,2149,2223,1463,167,-469,-885,-1401,-1838,-1910,-1636,-1590,-1402,-1336,-1159,25,735,631,1020,1470,1252,899,952,735,-115,-886,-1126,-946,-858,-935,-963,-974,-705,-309,-109,3,80,211,350,353,180,20,-54,-260,-437,-441,-449,-496,-500,-420,-337,-328,-321,-246,-170,-125,-121,-183,-211,-173,-135,-128,-149,-161,-208,-259,-260,-287,-308,-248,-144,-81,-94,-116,-100,-64,-31,-32,-53,-59,-40,-25,-48,-87,-108,-113,-126,-131,-139,-148,-130,-90,-45,-43,-54,-66,-66,-51,-40,-39,-56,-16},
            {0,-23,22,-50,65,-78,64,-65,349,5540,9892,-1160,-18951,-11337,8292,9154,10663,14501,6231,498,2864,6354,1258,-7397,-6820,-4953,-6127,-6551,-4425,-3184,-4902,-3137,-22,1856,1879,1431,3717,3839,2488,1818,987,46,-435,374,-391,-1586,-1846,-1727,-1080,-1404,-1513,-1050,-1057,-801,-43,377,171,142,554,616,71,-619,-837,-482,-555,-628,-303,-242,-192,-91,1,-51,-76,-41,-109,-154,-338,-346,-127,13,-38,-164,-143,-111,-101,-84,34,82,-103,-195,-163,-145,-112,6,72,-37,-147,-141,-138,-166,-94,-40,-119,-246,-274,-221,-176,-118,-130,-137,-115,-86,-14,5,-40,-100,-113,-147,-163,-120,-116,-123,-137,-157,-188,-184,-147,-119,-96,-72,-30,12,65,70,31,21,35,40,13,-1}
        },
        {    // H40e122a.wav
            {0,0,1,2,2,1,1,-1,-1,0,1,2,0,0,0,3,2,2,-1,-4,-2,-1,13,-1,3,-11,164,1231,2587,1448,-3088,-5912,-2883,2139,4976,5592,4300,2469,1940,2216,1650,390,-346,-969,-1774,-2203,-2117,-1803,-1666,-1278,-1097,-1161,-47,944,769,988,1483,1325,1011,987,764,-39,-859,-1074,-893,-861,-965,-995,-1032,-820,-370,-124,-77,-24,150,336,368,246,159,144,-19,-267,-473,-587,-557,-483,-481,-528,-513,-395,-213,-92,-95,-160,-153,-77,-73,-120,-133,-117,-158,-212,-221,-290,-364,-322,-206,-126,-124,-149,-161,-127,-73,-34,-10,-43,-63,-39,-18,-18,-64,-109,-128,-116,-101,-120,-156,-155,-108,-58,-35,-41,-59,-87,-60,-27,-16,-41,-97,-28},
            {15,-28,10,-16,-2,21,-61,96,-182,1880,7985,6875,-9479,-17318,-2075,7530,8389,15083,11790,1691,813,5182,5032,-3105,-7332,-5223,-5390,-6413,-5513,-3323,-3930,-4282,-1403,758,1801,1275,2268,3903,3029,2037,1254,663,-282,-150,276,-933,-1677,-1718,-1118,-973,-1455,-1387,-1283,-1037,-469,77,135,59,411,745,522,-160,-718,-607,-459,-668,-518,-312,-219,-113,-80,-105,-153,-7,11,-70,-188,-312,-166,-2,6,-138,-220,-197,-171,-120,-40,58,-40,-173,-157,-140,-147,-92,26,29,-50,-89,-116,-162,-141,-47,-40,-143,-256,-267,-230,-161,-137,-193,-167,-113,-41,13,-6,-69,-119,-131,-142,-115,-98,-91,-98,-135,-169,-186,-159,-150,-139,-101,-50,1,24,32,47,62,57,44,24,4}
        },
        {    // H40e129a.wav
            {-1,0,2,0,1,1,-1,-1,-1,0,1,0,-1,-2,1,3,0,1,-4,-2,-4,8,5,-1,-7,104,1155,2704,1654,-2908,-5945,-3275,1852,5121,5931,4483,2399,1822,2190,1654,359,-274,-727,-1632,-2315,-2426,-2116,-1875,-1496,-1017,-970,-328,867,1138,1128,1416,1256,1064,1106,813,99,-690,-1079,-1000,-783,-790,-1033,-1139,-868,-401,-196,-196,-80,99,261,345,239,149,207,127,-61,-241,-486,-626,-594,-528,-553,-625,-571,-353,-121,-87,-141,-86,-16,-5,-47,-95,-110,-161,-201,-246,-328,-332,-272,-211,-184,-176,-161,-151,-139,-122,-73,-31,-21,-39,-47,-26,-29,-50,-88,-121,-120,-109,-109,-136,-150,-105,-65,-50,-60,-89,-72,-61,-37,-29,-42,-71,-116,-31},
            {3,2,-21,11,-27,28,-35,17,-15,150,4074,8897,1006,-14399,-11529,1972,6320,12511,16019,6276,-310,2711,6059,1866,-5524,-6127,-4845,-5835,-6027,-4310,-3258,-4302,-2868,-297,1162,1476,1308,3052,3517,2292,1461,1136,320,-498,324,-138,-1428,-1665,-1321,-872,-1199,-1379,-1459,-1337,-672,-207,-27,1,251,691,768,303,-365,-650,-523,-586,-618,-462,-356,-189,-122,-125,-193,-96,71,17,-57,-211,-205,-46,34,-59,-257,-272,-221,-171,-101,-13,-11,-128,-151,-138,-161,-165,-63,31,10,-41,-99,-143,-157,-82,-16,-67,-190,-270,-252,-216,-173,-200,-216,-153,-86,-21,-18,-56,-97,-112,-118,-116,-95,-79,-74,-115,-151,-170,-163,-153,-167,-141,-86,-34,-17,-2,46,79,78,59,30,4}
        },
        {    // H40e135a.wav
            {1,1,1,1,0,-2,-2,-2,0,2,-1,-2,-2,0,3,-1,-1,-6,-3,-6,2,7,-4,0,84,1174,2874,1698,-3076,-6085,-3373,1895,5448,6308,4562,2265,1759,2203,1664,235,-492,-800,-1597,-2220,-2352,-2225,-2112,-1821,-1132,-840,-555,639,1425,1424,1519,1260,1021,1078,764,229,-475,-1107,-1147,-779,-622,-905,-1165,-940,-392,-170,-245,-166,7,202,295,194,133,184,159,26,-120,-291,-470,-563,-599,-636,-681,-653,-454,-288,-214,-91,-14,20,27,-1,-3,-60,-143,-221,-315,-332,-272,-205,-202,-242,-230,-184,-161,-152,-132,-95,-63,-48,-34,-32,-29,-29,-59,-98,-118,-106,-104,-132,-151,-131,-92,-47,-33,-73,-116,-117,-62,-28,-22,-54,-96,-109,-105,-24},
            {3,9,-6,-9,-3,-10,17,-27,33,-66,597,5186,8074,-2489,-14180,-8552,1314,7536,15703,13987,3104,-357,3732,5635,69,-5705,-5369,-4785,-5711,-5447,-3742,-3481,-3928,-1902,52,1164,1184,1537,3244,2914,1648,1430,1177,-96,-175,520,-633,-1469,-1469,-1150,-942,-1274,-1380,-1533,-1130,-351,-175,-218,44,553,829,655,222,-293,-586,-599,-589,-515,-530,-432,-206,-171,-139,-145,-68,26,63,20,-163,-141,-10,23,-119,-284,-270,-221,-159,-93,-36,-52,-110,-135,-165,-190,-166,-48,28,10,-45,-102,-136,-126,-39,-4,-64,-186,-259,-240,-198,-176,-215,-202,-154,-105,-51,-42,-63,-90,-77,-67,-75,-83,-75,-70,-105,-138,-144,-142,-158,-157,-122,-83,-66,-29,40,88,97,90,73,15}
        },
        {    // H40e141a.wav
            {1,1,1,-1,-2,-2,-1,0,1,-1,-1,-1,0,2,0,2,-7,-1,-7,3,5,-4,4,176,1648,3238,894,-4375,-6239,-2398,3048,6404,6613,4048,1799,1833,2307,1375,-165,-767,-1115,-1923,-2389,-2294,-2105,-2060,-1839,-1155,-755,-676,372,1521,1790,1784,1281,989,1051,622,111,-496,-1110,-1243,-893,-534,-715,-1046,-909,-353,-40,-160,-170,-24,121,182,109,98,155,147,48,-133,-306,-368,-368,-482,-678,-755,-698,-556,-352,-194,-132,-73,-3,57,98,49,-18,-114,-264,-316,-259,-198,-209,-249,-241,-199,-194,-228,-202,-131,-81,-52,-42,-49,-46,-22,-12,-39,-90,-127,-126,-122,-140,-147,-133,-82,-35,-20,-47,-95,-108,-93,-46,-31,-48,-92,-113,-101,-114,-30},
            {10,2,4,-9,-7,-2,-2,4,-15,25,-60,1299,6344,6396,-5876,-13466,-6670,2019,10822,16874,10404,857,215,4637,4734,-1707,-5706,-4778,-4693,-5516,-4842,-3390,-3647,-3253,-1160,266,1105,996,2021,3158,2041,1467,1615,727,-192,320,199,-926,-1380,-1434,-1039,-1089,-1424,-1416,-1331,-794,-274,-186,-200,212,781,794,488,185,-222,-594,-707,-546,-437,-567,-467,-248,-161,-137,-158,-91,-18,71,16,-130,-100,-20,-6,-138,-245,-241,-208,-153,-98,-34,-54,-129,-183,-212,-217,-153,-33,4,-32,-71,-89,-119,-103,-25,-11,-75,-176,-234,-231,-192,-176,-202,-201,-187,-139,-77,-57,-70,-66,-45,-57,-66,-72,-77,-87,-117,-133,-140,-143,-146,-139,-129,-117,-59,12,79,97,89,90,21}
        },
        {    // H40e148a.wav
            {3,0,-1,-1,-3,0,1,0,-2,-2,-2,1,3,-1,1,-7,0,-8,-1,5,-2,4,190,1838,3512,703,-4957,-6509,-2185,3525,7030,7025,3910,1540,1899,2462,1314,-411,-1024,-1337,-2117,-2530,-2384,-2163,-2039,-1761,-1104,-557,-597,-65,1184,1941,2013,1377,1026,1071,564,102,-356,-1118,-1499,-1081,-517,-621,-929,-792,-333,-51,-43,11,22,5,83,79,44,94,125,39,-148,-343,-382,-312,-407,-588,-711,-786,-593,-275,-170,-190,-186,-68,81,99,58,-7,-128,-213,-191,-182,-238,-264,-245,-214,-213,-236,-249,-220,-163,-100,-49,-40,-42,-38,-27,-21,-27,-65,-106,-136,-163,-169,-170,-134,-86,-46,-44,-60,-62,-68,-54,-64,-73,-88,-81,-84,-90,-124,-182,-47},
            {0,10,1,-1,-8,-9,0,-6,3,-12,14,-1,1974,6894,4544,-7818,-12708,-5713,3800,13427,15886,7467,-126,833,5141,3668,-2843,-5372,-4252,-4526,-5294,-4337,-3229,-3543,-2601,-823,325,925,1107,2395,2502,1514,1736,1421,411,135,383,-102,-959,-1420,-1344,-1054,-1314,-1505,-1324,-995,-618,-306,-142,-35,402,757,679,447,223,-193,-653,-724,-497,-387,-490,-474,-352,-219,-156,-180,-147,-87,8,-13,-74,-28,-1,-36,-122,-161,-170,-191,-172,-90,-32,-94,-186,-228,-242,-242,-161,-55,-42,-47,-47,-88,-133,-87,0,6,-70,-169,-226,-221,-168,-159,-204,-229,-220,-146,-80,-65,-71,-58,-37,-40,-39,-62,-102,-132,-128,-119,-133,-134,-130,-145,-147,-86,-22,45,79,77,85,21}
        },
        {    // H40e154a.wav
            {1,-2,-2,-2,1,3,1,-2,-1,0,3,1,-1,1,-8,3,-9,4,-1,6,4,395,2576,3726,-684,-6494,-6344,-709,5086,8111,7035,3048,1126,2213,2598,854,-913,-1342,-1779,-2503,-2681,-2417,-2255,-2102,-1594,-864,-269,-322,-22,1097,1883,2010,1419,1001,938,481,116,-361,-1164,-1619,-1334,-739,-630,-764,-625,-271,40,148,179,157,77,16,-9,68,138,45,-125,-281,-357,-343,-337,-463,-703,-825,-623,-277,-148,-213,-259,-174,-11,59,33,-42,-87,-53,-37,-113,-212,-248,-243,-227,-238,-262,-276,-264,-208,-154,-106,-58,-29,-26,-27,-4,11,-16,-66,-118,-137,-144,-181,-200,-168,-102,-67,-69,-68,-64,-45,-13,-20,-71,-95,-105,-91,-92,-113,-145,-154,-34},
            {-3,1,10,1,1,-7,-10,4,-12,10,-15,12,15,1849,6526,4425,-7227,-12622,-6220,4347,13621,14774,6925,-176,695,5032,3446,-2660,-4862,-3794,-4174,-5041,-4083,-3084,-3291,-2411,-921,104,802,1327,2110,1797,1533,1870,1255,608,329,258,-75,-910,-1387,-1330,-1204,-1405,-1564,-1212,-700,-500,-398,-131,222,443,519,632,574,262,-203,-550,-587,-453,-325,-372,-494,-538,-398,-255,-242,-223,-224,-132,-2,40,55,38,-17,-72,-45,-46,-145,-204,-147,-71,-114,-208,-262,-319,-344,-209,-55,-36,-65,-77,-87,-96,-32,33,2,-90,-163,-175,-172,-162,-176,-206,-218,-204,-149,-112,-115,-99,-39,-1,-13,-46,-82,-128,-160,-146,-118,-100,-97,-122,-145,-111,-51,4,32,37,50,14}
        },
        {    // H40e161a.wav
            {-3,-2,-1,0,1,2,-3,-1,-1,3,2,-1,2,-10,4,-10,5,-3,7,7,458,2925,4004,-1177,-7342,-6560,-163,5910,8857,7316,2738,862,2367,2765,681,-1241,-1573,-2060,-2807,-2806,-2490,-2364,-2170,-1574,-762,-70,-81,15,981,1873,2070,1427,910,840,409,68,-198,-985,-1696,-1527,-951,-801,-803,-548,-198,28,189,382,342,115,32,87,169,91,-46,-159,-349,-417,-370,-353,-571,-911,-851,-475,-157,-98,-192,-159,-59,6,2,-70,-111,-36,55,-25,-165,-192,-166,-201,-284,-314,-286,-267,-267,-221,-149,-102,-69,-32,-5,-2,9,26,8,-64,-110,-126,-152,-173,-184,-171,-157,-127,-86,-64,-70,-60,-22,1,-13,-62,-93,-114,-102,-114,-120,-103,-126,-34},
            {-5,-1,2,7,1,2,-9,-10,3,-14,11,-20,17,51,2108,6514,3505,-7885,-12313,-5240,5701,13684,13406,5836,-454,1086,5035,2695,-2819,-4306,-3382,-4042,-4778,-3714,-2948,-3111,-2215,-916,51,895,1430,1615,1411,1740,1823,1197,740,322,250,-156,-965,-1345,-1391,-1274,-1483,-1550,-998,-529,-423,-362,-33,315,383,481,650,561,142,-232,-284,-355,-419,-355,-388,-500,-629,-598,-449,-325,-261,-271,-169,-5,124,147,55,6,24,65,-4,-142,-195,-165,-123,-161,-253,-337,-390,-353,-213,-90,-55,-51,-57,-68,-63,-16,30,1,-85,-149,-158,-155,-156,-164,-174,-194,-199,-163,-141,-132,-102,-35,7,-18,-65,-117,-151,-153,-134,-101,-71,-74,-103,-108,-84,-37,0,12,17,4}
        },
        {    // H40e167a.wav
            {-4,-3,1,2,-1,-5,-1,-3,4,0,-2,-4,-12,3,-15,9,-15,15,6,858,3889,3800,-3217,-8799,-5801,1817,7759,9789,6737,1616,811,2934,2664,-82,-1813,-1867,-2534,-3227,-2883,-2514,-2518,-2197,-1383,-484,186,146,219,1073,1921,2061,1463,878,503,196,-14,-348,-956,-1563,-1571,-1188,-950,-826,-574,-207,71,274,408,427,257,140,291,285,38,-137,-247,-349,-398,-432,-613,-900,-927,-648,-373,-279,-233,-50,98,112,32,-103,-138,-15,101,8,-163,-202,-133,-127,-232,-332,-366,-344,-317,-259,-182,-124,-89,-86,-57,-13,21,46,35,-16,-76,-115,-127,-142,-170,-183,-183,-180,-173,-133,-105,-102,-80,-36,-14,-19,-35,-76,-95,-107,-113,-132,-117,-104,-139,-37},
            {1,-4,-1,0,8,0,1,-5,-14,5,-17,15,-20,16,21,1615,5869,4119,-6484,-12027,-5880,4795,12344,12794,6441,-66,713,4544,2909,-2011,-3753,-3014,-3617,-4463,-3600,-2836,-2948,-2277,-1119,-137,847,1192,1089,1292,1785,1807,1361,867,430,248,-193,-838,-1311,-1408,-1318,-1527,-1410,-906,-548,-398,-216,66,151,283,569,681,455,88,-33,21,-125,-394,-450,-441,-581,-737,-768,-676,-490,-296,-188,-154,-71,146,233,100,26,122,191,37,-156,-221,-178,-154,-242,-321,-379,-404,-360,-267,-141,-45,-7,-34,-80,-75,-1,53,15,-64,-131,-153,-144,-121,-121,-155,-188,-201,-171,-146,-142,-120,-75,-40,-39,-61,-102,-143,-153,-108,-51,-49,-81,-93,-85,-79,-53,-23,-8,-1}
        },
        {    // H40e174a.wav
            {-3,2,3,0,-4,0,-1,5,2,0,-2,-12,5,-16,13,-15,16,9,952,4300,4057,-3805,-9665,-5983,2441,8720,10530,6876,1242,645,3251,2812,-399,-2214,-2105,-2787,-3567,-3036,-2529,-2634,-2295,-1384,-384,409,358,350,1049,1842,2066,1508,1004,483,50,-104,-503,-940,-1399,-1528,-1285,-1138,-900,-590,-254,11,200,385,375,358,435,435,265,18,-55,-141,-316,-414,-578,-818,-943,-801,-612,-527,-380,-214,-5,167,159,41,-55,47,147,46,-95,-158,-156,-156,-184,-244,-310,-367,-392,-355,-272,-165,-90,-65,-62,-62,-39,20,60,44,-10,-69,-103,-131,-132,-138,-161,-177,-192,-174,-157,-155,-134,-78,-38,-32,-33,-41,-52,-71,-66,-88,-122,-130,-111,-102,-112,-27},
            {5,1,-4,1,2,10,1,3,-5,-9,8,-15,17,-21,23,28,1601,5604,3714,-6357,-11410,-5288,4817,11502,11909,6114,54,891,4236,2614,-1706,-3243,-2678,-3403,-4207,-3395,-2696,-2786,-2233,-1180,-166,818,929,797,1266,1774,1860,1433,913,506,104,-251,-768,-1284,-1373,-1409,-1440,-1223,-901,-585,-366,-35,168,83,209,598,760,422,81,37,99,0,-307,-535,-630,-689,-802,-833,-718,-557,-335,-152,-43,8,67,164,179,138,157,156,23,-145,-244,-218,-182,-264,-350,-401,-405,-357,-270,-142,-43,-18,-50,-78,-49,17,51,17,-58,-114,-129,-122,-110,-134,-160,-168,-178,-172,-167,-167,-148,-93,-56,-49,-60,-87,-114,-121,-71,-34,-72,-106,-93,-80,-82,-73,-50,-9}
        },
        {    // H40e180a.wav
            {0,3,0,-6,-1,-2,7,1,-1,-2,-14,5,-17,11,-16,13,6,1028,4668,4368,-4264,-10509,-6307,2920,9686,11315,7055,940,493,3547,2979,-715,-2669,-2357,-2978,-3904,-3280,-2564,-2696,-2372,-1395,-364,593,629,503,1083,1735,2014,1546,1013,549,38,-148,-617,-1120,-1320,-1453,-1349,-1193,-978,-650,-309,11,157,200,230,472,711,482,160,33,41,-4,-233,-488,-717,-842,-858,-795,-692,-594,-409,-205,-11,130,98,36,98,195,169,55,-37,-128,-221,-239,-200,-210,-319,-422,-420,-358,-268,-169,-95,-54,-50,-58,-44,6,42,18,-23,-64,-108,-130,-137,-139,-148,-164,-179,-187,-189,-184,-151,-93,-54,-58,-59,-54,-66,-79,-71,-64,-102,-113,-103,-108,-105,-85,-18},
            {0,3,0,-6,-1,-2,7,1,-1,-2,-14,5,-17,11,-16,13,6,1028,4668,4368,-4264,-10509,-6307,2920,9686,11315,7055,940,493,3547,2979,-715,-2669,-2357,-2978,-3904,-3280,-2564,-2696,-2372,-1395,-364,593,629,503,1083,1735,2014,1546,1013,549,38,-148,-617,-1120,-1320,-1453,-1349,-1193,-978,-650,-309,11,157,200,230,472,711,482,160,33,41,-4,-233,-488,-717,-842,-858,-795,-692,-594,-409,-205,-11,130,98,36,98,195,169,55,-37,-128,-221,-239,-200,-210,-319,-422,-420,-358,-268,-169,-95,-54,-50,-58,-44,6,42,18,-23,-64,-108,-130,-137,-139,-148,-164,-179,-187,-189,-184,-151,-93,-54,-58,-59,-54,-66,-79,-71,-64,-102,-113,-103,-108,-105,-85,-18}
        }
    },
    {    // elev50 
        {    // H50e000a.wav
            {-2,20,-53,65,-94,95,-78,31,39,474,4295,4538,2273,-7342,-16815,-2377,11395,13985,15446,5726,-2842,-1473,2553,1175,-3441,-4336,-6325,-5460,-2364,-3125,-3207,-2323,-1201,274,883,2183,2711,1923,2056,2231,1422,321,0,-267,-285,-498,-2138,-2347,-1518,-1426,-855,64,343,45,406,852,719,518,-11,-116,453,619,179,-162,41,3,-462,-651,-769,-1033,-1347,-1504,-1260,-832,-516,-341,-82,151,105,133,250,201,189,200,63,-207,-299,-211,-214,-264,-317,-331,-414,-441,-321,-224,-172,-190,-154,-81,15,150,219,190,50,-49,-73,-97,-110,-152,-246,-281,-235,-182,-137,-131,-131,-113,-115,-122,-87,-63,-88,-83,-65,-61,-35,-17,-45,-64,-66,-79,-85,-112,-130,-110,-64,-32,-45,-15},
            {-2,20,-53,65,-94,95,-78,31,39,474,4295,4538,2273,-7342,-16815,-2377,11395,13985,15446,5726,-2842,-1473,2553,1175,-3441,-4336,-6325,-5460,-2364,-3125,-3207,-2323,-1201,274,883,2183,2711,1923,2056,2231,1422,321,0,-267,-285,-498,-2138,-2347,-1518,-1426,-855,64,343,45,406,852,719,518,-11,-116,453,619,179,-162,41,3,-462,-651,-769,-1033,-1347,-1504,-1260,-832,-516,-341,-82,151,105,133,250,201,189,200,63,-207,-299,-211,-214,-264,-317,-331,-414,-441,-321,-224,-172,-190,-154,-81,15,150,219,190,50,-49,-73,-97,-110,-152,-246,-281,-235,-182,-137,-131,-131,-113,-115,-122,-87,-63,-88,-83,-65,-61,-35,-17,-45,-64,-66,-79,-85,-112,-130,-110,-64,-32,-45,-15}
        },
        {    // H50e008a.wav
            {20,-11,27,-26,10,-3,-39,76,-119,174,-126,1986,4332,3206,-905,-12422,-12154,2639,10470,15866,13579,2552,-2254,-543,1464,-441,-2036,-3603,-5543,-3711,-3083,-3528,-2433,-2144,-1328,179,1329,1939,1766,1862,1948,2255,1889,675,149,-441,-734,-1528,-2253,-1673,-1374,-909,-195,139,16,9,504,574,493,271,-189,110,789,806,207,-183,-119,-386,-688,-597,-779,-1183,-1395,-1217,-774,-520,-481,-287,125,217,-64,-160,-21,94,130,149,13,-235,-258,-182,-224,-330,-358,-336,-375,-395,-359,-242,-154,-116,-36,22,83,152,177,153,54,-49,-83,-132,-192,-223,-221,-197,-183,-137,-140,-202,-188,-114,-49,-9,-18,-86,-151,-148,-88,6,59,4,-85,-131,-109,-66,-44,-69,-133,-154,-110,-20},
            {31,-73,82,-105,95,-64,-9,94,333,4694,5323,2844,-7895,-19875,-3256,13974,15817,16793,6307,-3429,-2384,2235,1444,-4252,-5150,-6752,-6183,-2359,-2772,-3175,-2545,-1372,588,1125,2150,2959,2295,2157,2233,1520,232,-262,-437,-281,-297,-2155,-2741,-1820,-1482,-905,67,452,99,468,927,874,782,21,-295,314,489,258,111,10,-107,-296,-535,-827,-1130,-1411,-1679,-1678,-1083,-311,-148,-291,-21,346,437,387,345,326,228,99,-155,-366,-390,-333,-211,-286,-430,-453,-359,-275,-252,-172,-145,-108,-64,16,150,212,182,60,-65,-130,-130,-129,-182,-276,-295,-226,-185,-142,-106,-108,-98,-97,-118,-107,-103,-82,-37,-57,-86,-52,-18,-40,-75,-90,-99,-118,-123,-90,-47,-33,-29,-28,-35,-8}
        },
        {    // H50e016a.wav
            {-6,16,-9,20,-17,3,0,-36,60,-88,128,-94,1577,3656,2983,-233,-9881,-11054,640,8230,13437,12466,3807,-926,-108,1547,-75,-1690,-2904,-4681,-3752,-3090,-3149,-2290,-2152,-1495,6,1012,1452,1533,1695,1782,2168,1923,775,250,-132,-502,-1310,-1886,-1452,-1247,-916,-407,-142,-108,-13,304,326,301,194,-59,210,786,823,300,-156,-309,-382,-489,-656,-892,-1095,-1166,-1024,-684,-386,-364,-384,-128,106,26,-155,-219,-98,67,91,4,-143,-227,-243,-255,-276,-362,-428,-382,-298,-279,-237,-160,-75,-8,18,81,114,129,120,64,-11,-94,-120,-152,-220,-240,-219,-200,-165,-146,-155,-160,-116,-58,-39,-27,-76,-119,-120,-97,-16,27,-11,-74,-99,-114,-97,-77,-61,-91,-151,-40},
            {-72,83,-112,81,-24,-75,171,77,4698,6167,3805,-7285,-22726,-5918,15974,17777,18130,7212,-3621,-2642,1594,1586,-4435,-6233,-7460,-6792,-2556,-2669,-2893,-2340,-1657,445,1418,2478,2876,2292,2552,2332,1450,279,-320,-595,-391,-191,-2084,-2950,-2112,-1625,-934,-25,441,228,561,943,924,1044,305,-439,-199,275,624,355,-137,-171,-258,-442,-703,-1086,-1467,-2032,-2127,-1126,-54,-96,-460,-37,450,584,652,496,310,241,176,-119,-457,-468,-325,-265,-419,-456,-370,-357,-317,-252,-137,-90,-63,-26,31,138,226,238,75,-109,-183,-190,-173,-202,-293,-312,-270,-231,-134,-74,-86,-98,-97,-104,-105,-96,-66,-40,-72,-91,-49,-12,-36,-92,-145,-157,-132,-91,-42,-33,-40,-7,12,-16,-20,-4}
        },
        {    // H50e024a.wav
            {0,-5,11,-8,14,-12,-4,2,-35,51,-69,90,-74,1159,3041,2791,484,-7525,-10153,-1163,6057,11101,11576,4937,253,328,1539,192,-1268,-2204,-3953,-3648,-2903,-2828,-2233,-2130,-1568,-244,633,1097,1316,1550,1591,1846,1894,1082,545,176,-258,-1005,-1628,-1407,-1247,-1053,-652,-328,-138,-133,-69,151,368,239,34,299,764,774,351,-23,-306,-498,-551,-676,-894,-995,-950,-853,-668,-422,-299,-303,-234,-41,30,-92,-206,-213,-101,21,-26,-159,-224,-303,-352,-309,-297,-351,-366,-277,-177,-128,-114,-73,-18,11,48,77,103,104,59,-28,-103,-125,-164,-223,-255,-241,-189,-147,-116,-114,-132,-108,-78,-51,-34,-68,-117,-116,-74,-30,1,-34,-93,-116,-111,-108,-85,-65,-79,-20},
            {51,-82,47,45,-154,276,-207,4219,6941,5056,-5272,-24587,-10757,16583,19880,19420,9083,-3502,-3078,1353,2031,-4357,-7089,-8200,-8014,-2946,-2492,-2990,-1887,-1499,176,1267,2761,3332,2117,2416,2661,1647,179,-357,-584,-524,-38,-1929,-3221,-2438,-1734,-882,-84,279,201,766,1107,870,1234,683,-691,-751,428,885,122,-273,-58,-158,-429,-570,-960,-1677,-2227,-2116,-1114,-158,-183,-392,7,557,746,675,506,391,342,210,-140,-476,-494,-357,-290,-415,-472,-430,-384,-298,-222,-79,-52,-59,-5,43,161,282,282,100,-108,-204,-228,-234,-224,-278,-347,-320,-261,-144,-61,-75,-81,-103,-122,-81,-29,-14,-67,-115,-86,-42,-2,-19,-115,-190,-167,-93,-57,-54,-55,-30,36,36,-13,-22,-40,-13}
        },
        {    // H50e032a.wav
            {-3,0,-2,9,-5,10,-6,-8,8,-33,43,-51,58,-49,821,2492,2588,1064,-5521,-9239,-2591,4183,9097,10647,5664,1254,751,1471,436,-847,-1627,-3243,-3376,-2658,-2564,-2180,-2023,-1594,-499,334,816,1005,1221,1421,1772,1995,1388,812,450,1,-883,-1649,-1436,-1262,-1164,-767,-479,-383,-344,-77,222,340,336,200,256,680,845,395,-126,-361,-461,-573,-764,-904,-820,-744,-811,-725,-433,-235,-227,-232,-117,4,-28,-131,-232,-282,-152,-62,-201,-314,-344,-354,-305,-263,-261,-265,-209,-130,-77,-56,-67,-49,-6,36,80,87,52,1,-74,-119,-134,-187,-234,-236,-197,-146,-108,-81,-95,-109,-92,-89,-72,-45,-59,-95,-115,-84,-43,-30,-48,-117,-138,-110,-91,-77,-63,-14},
            {-13,-54,149,-251,348,-379,3102,7369,6336,-1730,-23969,-17846,14236,21815,20541,12150,-2065,-3592,332,2838,-2879,-7932,-8766,-9175,-4426,-2639,-2987,-1787,-1401,325,1178,2552,3701,2438,2387,2516,1844,501,-468,-614,-641,2,-1484,-3312,-2965,-2066,-845,-49,198,103,677,1344,1022,1311,930,-833,-1001,505,953,-3,-544,-261,-77,-199,-403,-1007,-1987,-2255,-1643,-967,-494,-369,-335,113,664,773,591,486,447,369,267,-59,-493,-604,-447,-235,-287,-488,-545,-457,-284,-153,-28,-23,-68,-36,52,179,265,293,148,-67,-195,-265,-263,-231,-287,-363,-362,-289,-169,-86,-76,-123,-118,-92,-69,-14,-16,-55,-90,-85,-67,-48,-40,-125,-179,-117,-76,-76,-64,-51,-16,13,4,-19,-14,-5,-2,2}
        },
        {    // H50e040a.wav
            {3,-3,-1,-2,5,-3,7,-2,-10,11,-31,34,-41,39,-31,560,2029,2361,1468,-3903,-8331,-3620,2679,7437,9638,6026,2062,1112,1426,674,-484,-1176,-2603,-2986,-2405,-2368,-2054,-1858,-1565,-709,-88,409,829,1194,1429,1716,2028,1604,966,505,20,-890,-1675,-1444,-1207,-1229,-1071,-674,-296,-303,-122,279,509,443,133,236,712,711,179,-181,-243,-432,-698,-805,-767,-705,-743,-775,-654,-432,-256,-179,-149,-81,1,-34,-163,-268,-311,-294,-265,-280,-300,-315,-347,-330,-236,-153,-137,-138,-137,-97,-34,-19,-22,-13,9,40,32,-25,-79,-125,-157,-167,-167,-177,-194,-171,-114,-62,-51,-90,-116,-107,-92,-62,-42,-68,-125,-152,-112,-66,-47,-71,-120,-148,-130,-82,-48,-9},
            {-122,217,-268,275,-262,1550,7041,7490,2319,-19616,-25099,7716,23132,20856,15508,1076,-3538,-665,2767,-488,-7584,-9141,-9924,-6249,-3443,-3759,-1752,-1383,-75,1494,2521,3899,2701,2462,2831,1839,623,-299,-557,-821,-79,-909,-3156,-3336,-2517,-1169,-105,152,142,574,1336,1300,1384,838,-671,-633,274,600,255,-656,-731,-212,-36,-263,-1074,-2019,-2196,-1285,-632,-710,-593,-194,282,534,502,558,620,459,325,311,32,-484,-643,-432,-266,-270,-410,-529,-511,-334,-104,35,-13,-84,0,66,109,202,268,204,-11,-191,-253,-251,-209,-270,-365,-369,-313,-195,-104,-107,-158,-117,-57,-76,-54,-30,-56,-66,-46,-75,-99,-96,-119,-116,-85,-65,-75,-59,-24,-10,-15,-47,-45,-9,11,17,2,-4}
        },
        {    // H50e048a.wav
            {-3,3,0,-1,-2,5,-1,5,2,-7,13,-25,28,-32,31,-18,395,1679,2146,1687,-2753,-7499,-4217,1646,6197,8638,6065,2610,1416,1420,838,-201,-853,-2025,-2507,-2154,-2156,-1839,-1681,-1697,-1067,-252,435,846,1159,1384,1621,1900,1527,890,456,8,-889,-1613,-1403,-1343,-1400,-946,-468,-380,-365,134,494,459,424,183,83,438,600,197,-248,-312,-370,-649,-776,-705,-679,-697,-692,-599,-416,-251,-110,-36,-37,-53,-91,-176,-306,-376,-378,-356,-310,-308,-324,-302,-247,-164,-116,-111,-91,-89,-74,-19,19,22,-20,-49,-37,-44,-91,-144,-163,-154,-127,-108,-129,-162,-131,-64,-28,-33,-82,-114,-93,-68,-62,-70,-102,-147,-163,-133,-84,-55,-63,-103,-119,-111,-85,-16},
            {111,-98,33,95,114,5439,8287,6020,-11501,-29325,-4120,22499,21443,17590,6069,-2267,-1554,1979,2393,-5945,-9789,-9753,-7760,-4506,-4845,-2887,-1500,-778,1223,2434,4344,3389,2351,3194,2354,883,-237,-463,-848,-433,-378,-2525,-3681,-3114,-1509,-323,-152,100,581,1265,1611,1483,655,-421,-221,275,248,297,-439,-1047,-602,-123,-214,-1125,-1983,-1915,-1031,-521,-688,-543,-138,326,506,261,248,559,651,436,224,-13,-336,-539,-508,-308,-228,-368,-475,-490,-355,-127,19,48,-32,-17,55,67,142,216,194,22,-192,-245,-233,-181,-195,-323,-350,-318,-231,-125,-115,-153,-113,-62,-86,-81,-70,-76,-69,-49,-79,-125,-111,-93,-88,-81,-68,-57,-34,-11,8,-18,-62,-66,-44,-6,8,18,1,-5}
        },
        {    // H50e056a.wav
            {-1,-2,3,-1,2,-2,3,0,2,1,-5,12,-24,22,-26,24,-12,320,1448,1968,1734,-2162,-6869,-4362,1165,5439,7714,5775,2873,1624,1393,944,52,-620,-1569,-2012,-1856,-2005,-1813,-1615,-1577,-996,-196,477,782,986,1197,1319,1544,1365,839,381,-60,-822,-1624,-1544,-1136,-1059,-851,-566,-395,-42,333,448,446,249,-95,-35,426,497,21,-298,-236,-304,-624,-726,-630,-665,-700,-610,-484,-359,-227,-81,1,-29,-115,-158,-225,-369,-396,-360,-386,-403,-342,-233,-191,-205,-173,-116,-83,-49,-28,-18,-14,1,-4,-59,-103,-126,-130,-143,-156,-138,-106,-86,-90,-104,-116,-95,-41,-1,-14,-70,-114,-100,-86,-92,-100,-128,-158,-178,-148,-109,-58,-40,-58,-89,-127,-32},
            {130,-254,367,-443,2609,7869,8437,-1416,-25988,-19397,15706,23353,18291,11113,818,-1378,233,4145,-1236,-9789,-10466,-8761,-5312,-5244,-4584,-2303,-2012,238,1867,3985,4616,2722,3235,3224,1623,49,-398,-661,-855,-296,-1642,-3407,-3733,-2382,-581,-310,-228,340,1105,1778,1734,755,-167,-85,251,317,300,-300,-1057,-883,-418,-413,-1062,-1811,-1774,-1049,-498,-429,-317,-178,200,538,292,10,198,615,591,253,-6,-226,-430,-531,-383,-211,-282,-424,-464,-375,-179,-5,92,51,-40,1,53,89,176,188,43,-195,-303,-256,-174,-119,-215,-308,-297,-236,-170,-127,-105,-101,-70,-92,-99,-103,-123,-86,-82,-121,-152,-109,-58,-62,-87,-77,-44,-30,-15,10,20,-28,-60,-77,-52,-9,13,10,-48,-17}
        },
        {    // H50e064a.wav
            {-5,0,-1,0,-1,1,-4,2,-1,2,-2,-3,10,-24,18,-24,33,-19,336,1350,1869,1640,-2265,-6561,-3967,1338,5222,6936,5212,2807,1651,1388,1028,263,-457,-1264,-1635,-1766,-1885,-1473,-1267,-1325,-946,-217,435,534,602,871,1071,1302,1168,764,355,-296,-966,-1214,-1106,-1037,-1023,-757,-461,-279,154,449,244,11,16,26,9,216,285,-18,-208,-183,-293,-561,-665,-641,-676,-627,-471,-369,-324,-226,-83,-19,-73,-174,-237,-283,-354,-396,-401,-395,-364,-287,-201,-170,-174,-158,-107,-47,1,17,-12,-49,-61,-69,-111,-161,-188,-169,-131,-118,-99,-80,-71,-77,-90,-85,-57,-11,10,-17,-81,-133,-136,-113,-105,-113,-143,-184,-180,-154,-97,-51,-25,-41,-100,-29},
            {-77,34,60,30,5178,9011,6579,-12986,-29405,-2160,23342,19963,14811,5826,-233,-740,2702,4191,-5591,-11091,-9953,-7158,-5161,-5649,-3206,-2755,-2146,686,2675,4838,3713,3161,4093,2823,966,-55,-306,-1019,-597,-825,-2768,-3851,-3340,-1365,-561,-617,65,772,1450,1855,1252,242,-23,164,407,441,-89,-913,-990,-609,-695,-1111,-1623,-1627,-1204,-703,-300,-97,5,77,358,405,75,-38,294,562,338,58,-116,-352,-507,-423,-202,-188,-372,-462,-391,-240,-71,88,128,16,-61,-7,45,117,184,91,-142,-347,-354,-254,-123,-119,-225,-241,-228,-195,-139,-75,-82,-78,-65,-112,-137,-166,-124,-111,-174,-195,-148,-67,-54,-83,-83,-37,-29,-35,-6,25,8,-33,-55,-72,-44,-21,-10,-46,-83,-20}
        },
        {    // H50e072a.wav
            {-3,-3,0,-2,2,-1,0,-3,3,-5,4,-4,4,0,-19,14,-16,38,-33,470,1377,1891,1280,-3188,-6429,-2873,2234,5437,6165,4401,2467,1573,1469,1076,357,-472,-1234,-1282,-1392,-1531,-1185,-1099,-1204,-1023,-368,242,203,278,702,962,1060,1082,628,-61,-188,-326,-849,-1177,-1071,-762,-616,-456,-70,145,-8,-91,40,71,-6,1,93,113,5,-43,-99,-388,-622,-631,-600,-597,-520,-357,-304,-309,-250,-138,-59,-128,-225,-271,-330,-393,-390,-308,-296,-356,-306,-190,-137,-134,-117,-64,-24,3,-1,-52,-111,-139,-143,-154,-170,-173,-148,-107,-83,-70,-61,-68,-76,-74,-52,-21,-4,-9,-56,-114,-153,-146,-121,-122,-130,-152,-172,-174,-142,-97,-41,-18,-44,-14},
            {-186,268,-316,1090,6743,9545,2408,-21712,-24146,9679,23265,17373,12141,3496,-533,-319,4989,2570,-8297,-10668,-8833,-6441,-6115,-5136,-2478,-3299,-1827,716,3219,4617,3022,3847,4444,2691,705,177,-106,-1078,-752,-1593,-3285,-4044,-2777,-798,-935,-723,391,1113,1558,1480,843,257,101,401,643,247,-532,-1081,-709,-662,-1275,-1551,-1569,-1298,-936,-455,-77,76,159,268,428,256,-64,-37,333,451,156,-66,-226,-475,-496,-231,-86,-229,-438,-438,-301,-161,7,133,129,2,-61,-13,34,150,151,-44,-280,-415,-353,-244,-142,-141,-176,-163,-179,-155,-86,-42,-45,-40,-84,-135,-179,-182,-132,-188,-235,-204,-115,-63,-91,-102,-56,-3,-22,-23,15,18,-22,-34,-32,-34,-32,-42,-46,-89,-81,-13}
        },
        {    // H50e080a.wav
            {1,-2,0,-1,1,1,1,-1,1,3,-3,7,-6,13,-15,1,10,9,6,25,787,1546,1974,89,-4980,-5675,-674,3666,5645,5222,3477,2004,1521,1578,897,188,-393,-904,-991,-1317,-1339,-1063,-1178,-1293,-1146,-443,108,19,144,643,1064,892,580,666,504,26,-399,-807,-1091,-1032,-639,-376,-491,-491,-194,51,33,-23,36,56,53,7,46,169,55,-282,-569,-600,-534,-518,-502,-412,-295,-307,-326,-281,-178,-87,-152,-271,-368,-371,-286,-245,-254,-330,-365,-259,-148,-87,-74,-71,-55,-52,-35,-54,-134,-184,-182,-144,-129,-145,-130,-105,-72,-54,-62,-53,-52,-58,-52,-37,-21,-22,-42,-79,-130,-160,-150,-127,-107,-109,-143,-168,-155,-121,-73,-28,-12,-2},
            {-175,306,-439,1872,7545,9585,-1731,-25298,-17597,14756,21040,15716,10743,2727,-823,459,6138,886,-9334,-9683,-7639,-6370,-6816,-4652,-2523,-3598,-1536,935,3372,3731,2702,4297,4297,2595,1021,604,-53,-801,-788,-2255,-3572,-3786,-2253,-994,-1289,-468,506,1047,1418,1203,615,147,298,753,663,11,-686,-891,-583,-922,-1540,-1644,-1405,-1147,-783,-204,-6,103,227,372,452,145,-106,-52,294,392,97,-144,-337,-481,-407,-126,-35,-254,-427,-397,-275,-122,46,143,112,-11,-47,-3,56,142,74,-123,-336,-427,-352,-240,-150,-153,-137,-125,-135,-105,-50,-4,-11,-25,-98,-152,-186,-173,-157,-242,-251,-192,-115,-94,-122,-98,-36,-1,-16,9,34,3,-38,-33,-16,-10,-14,-29,-58,-109,-77,-10}
        },
        {    // H50e088a.wav
            {0,-1,-2,0,-2,2,-1,-1,-3,4,-4,3,-5,1,3,-13,21,-3,23,-56,390,1280,1880,1346,-2962,-6275,-2774,2307,4875,5330,4120,2576,1590,1553,1412,653,129,-370,-882,-1258,-1420,-1202,-1181,-1458,-1448,-863,-202,-85,-63,454,793,556,847,1294,856,219,-126,-441,-977,-1119,-641,-546,-933,-920,-305,70,-2,2,56,60,117,167,98,31,33,-102,-412,-641,-584,-415,-402,-438,-371,-296,-342,-377,-250,-143,-170,-260,-325,-302,-253,-206,-223,-317,-348,-267,-152,-90,-72,-67,-88,-105,-103,-117,-163,-197,-175,-131,-121,-125,-100,-69,-61,-74,-66,-35,-34,-50,-68,-67,-39,-35,-48,-73,-125,-157,-157,-125,-88,-94,-108,-138,-155,-139,-104,-41,-15,-5},
            {-144,267,-416,1981,7647,9509,-3475,-25172,-14319,14894,19022,14998,10712,2753,-909,1142,6238,135,-9152,-8749,-6752,-6333,-7003,-4675,-2924,-3780,-1587,962,3369,3138,2270,4304,4183,2399,1316,1211,236,-710,-732,-2176,-3671,-3646,-1892,-1318,-1568,-350,445,857,1113,963,468,65,458,918,645,-58,-592,-651,-569,-1060,-1565,-1605,-1332,-1097,-717,-114,-10,68,254,409,427,108,-117,-88,233,358,116,-171,-390,-436,-345,-118,-59,-231,-371,-388,-280,-132,51,132,71,-8,-22,14,63,112,24,-160,-342,-418,-374,-257,-140,-150,-149,-132,-105,-67,-30,15,8,-27,-94,-137,-179,-181,-190,-253,-244,-198,-144,-133,-135,-100,-43,-8,-16,16,39,1,-42,-40,-14,6,8,-4,-52,-106,-67,-8}
        },
        {    // H50e096a.wav
            {0,-1,-2,1,-1,2,0,1,-2,5,-2,4,-3,-3,5,-10,29,-7,23,-54,264,1181,1872,1609,-2269,-6185,-3482,1741,4500,5226,4464,2966,1789,1647,1477,762,247,-263,-733,-1265,-1604,-1390,-1344,-1494,-1504,-983,-202,-159,-74,350,338,692,1423,1354,828,502,79,-574,-874,-716,-805,-1118,-1181,-814,-350,-159,-25,55,114,172,188,284,245,-15,-180,-87,-218,-611,-639,-431,-338,-358,-390,-369,-379,-356,-264,-218,-239,-261,-221,-205,-233,-224,-240,-279,-271,-204,-116,-96,-120,-117,-117,-142,-166,-186,-188,-158,-133,-127,-121,-99,-61,-43,-46,-65,-64,-31,-30,-53,-72,-73,-54,-52,-61,-76,-115,-146,-139,-107,-76,-65,-68,-107,-152,-150,-105,-50,-26,-6},
            {-127,229,-347,1486,7013,9664,-2284,-23111,-14868,11918,17619,15072,11617,3373,-805,1415,6014,505,-8415,-8181,-6090,-6112,-6813,-4910,-3415,-4008,-1922,609,3021,3022,2069,3882,4008,2438,1422,1454,721,-462,-686,-1841,-3210,-3409,-2072,-1483,-1531,-582,87,737,952,585,249,141,505,867,678,104,-397,-527,-460,-964,-1475,-1552,-1337,-1054,-774,-200,-13,50,234,370,457,150,-153,-133,174,354,178,-117,-384,-432,-303,-115,-81,-225,-343,-356,-277,-170,9,115,66,-3,0,31,55,89,22,-133,-329,-411,-367,-276,-150,-140,-151,-152,-112,-42,-14,15,14,-8,-65,-106,-150,-179,-200,-243,-235,-211,-160,-147,-146,-103,-55,-22,-21,14,39,3,-31,-26,-6,20,30,15,-23,-70,-53,-8}
        },
        {    // H50e104a.wav
            {0,-1,-1,-1,-1,1,-1,1,-1,4,-2,6,-7,-3,-4,-5,31,-9,16,-55,367,1320,2054,1354,-3158,-6383,-2730,2381,4731,5167,4366,3059,2005,1806,1394,347,-163,-382,-864,-1415,-1639,-1568,-1620,-1621,-1290,-628,-168,0,68,-124,450,1472,1474,1028,845,577,-161,-654,-549,-739,-1233,-1415,-1015,-556,-475,-300,-103,36,272,346,273,219,226,95,-125,-224,-359,-508,-577,-500,-342,-317,-382,-436,-400,-321,-285,-259,-241,-226,-210,-175,-180,-271,-278,-199,-158,-121,-106,-130,-174,-201,-189,-203,-225,-197,-143,-127,-145,-135,-105,-64,-38,-47,-51,-47,-39,-49,-60,-61,-79,-86,-82,-70,-64,-82,-113,-141,-135,-94,-47,-29,-55,-112,-151,-151,-98,-44,-43,-12},
            {-105,155,-193,600,5406,9717,1680,-18774,-18240,5718,16050,15629,13353,4928,-531,1093,5633,2141,-6901,-8207,-5754,-5602,-6535,-5217,-3656,-4295,-2642,-93,2277,3010,1970,3417,3917,2498,1594,1518,958,-259,-368,-1289,-2707,-2926,-2172,-1680,-1558,-869,-329,407,835,346,-18,148,413,715,803,345,-172,-440,-315,-649,-1301,-1464,-1356,-1131,-886,-376,-90,-9,192,331,465,233,-129,-192,60,327,276,4,-334,-453,-310,-112,-75,-223,-355,-353,-265,-206,-66,66,71,22,-7,31,37,63,51,-77,-266,-389,-363,-289,-193,-154,-147,-156,-144,-75,-27,5,6,10,-28,-78,-121,-156,-184,-244,-241,-219,-176,-149,-155,-127,-77,-41,-42,-12,18,3,-24,-16,12,26,34,26,6,-41,-56,-12}
        },
        {    // H50e112a.wav
            {1,-4,-2,-1,2,-1,0,-1,2,3,-2,5,-8,5,-15,13,12,5,-2,7,753,1783,2274,-211,-5498,-5769,-222,4018,5268,4971,3878,2558,2046,2022,947,-153,-571,-965,-1305,-1682,-1722,-1599,-1776,-1652,-907,-101,188,103,-225,154,1345,1585,1177,959,645,89,-349,-354,-636,-1224,-1519,-1211,-595,-463,-504,-375,-175,214,451,370,222,151,179,179,1,-309,-482,-538,-556,-422,-345,-408,-445,-418,-360,-319,-281,-220,-173,-205,-229,-212,-221,-203,-172,-126,-76,-96,-133,-174,-220,-260,-288,-262,-198,-122,-111,-146,-147,-113,-56,-36,-43,-53,-53,-38,-33,-48,-68,-76,-96,-111,-88,-56,-53,-71,-108,-125,-109,-64,-14,-29,-69,-127,-141,-117,-61,-24,-79,-27},
            {-37,18,27,-73,3057,8567,6380,-11218,-20656,-3566,12324,15839,15535,7799,206,339,4748,4285,-4015,-8192,-6072,-5027,-5976,-5605,-3802,-4183,-3577,-1129,1172,2816,1985,2655,3916,2803,1736,1569,1188,-193,-328,-475,-1960,-2522,-2084,-1629,-1607,-1295,-706,34,591,179,-204,84,241,448,881,673,68,-339,-189,-240,-975,-1358,-1329,-1194,-1031,-628,-249,-96,134,262,407,312,-42,-187,-44,246,318,146,-181,-437,-361,-128,-49,-206,-348,-350,-301,-247,-123,0,34,37,10,8,4,36,77,0,-166,-317,-343,-306,-232,-180,-162,-160,-166,-109,-64,-31,-13,16,3,-52,-69,-114,-157,-217,-253,-232,-188,-141,-139,-146,-116,-66,-55,-39,-6,1,-16,-14,23,39,36,39,23,-36,-45,-7}
        },
        {    // H50e120a.wav
            {-3,0,-1,-1,2,-1,-2,-2,4,-3,5,-6,2,-6,-6,19,-8,23,-42,403,1545,2505,1110,-4217,-6910,-2207,3390,5461,5455,4356,2714,1961,2223,1516,206,-435,-991,-1602,-2072,-2020,-1702,-1791,-1722,-1114,-297,263,431,-2,-58,1261,1798,1173,981,712,62,-267,-216,-545,-1184,-1524,-1307,-698,-430,-425,-444,-403,69,492,406,186,117,125,173,155,-68,-299,-475,-588,-478,-396,-472,-495,-467,-432,-362,-253,-175,-167,-179,-214,-280,-261,-155,-80,-53,-87,-113,-130,-182,-221,-298,-351,-282,-180,-144,-159,-162,-130,-88,-60,-47,-45,-48,-58,-58,-56,-57,-55,-71,-115,-130,-100,-72,-50,-58,-67,-89,-92,-58,-42,-42,-75,-114,-143,-103,-59,-37,-59,-137,-40},
            {32,-66,101,-155,872,5610,8982,-1260,-17692,-13613,4233,14134,17191,12197,2439,-491,3024,5511,362,-6749,-6959,-4910,-5219,-5718,-4331,-3737,-4058,-2402,-229,2011,2279,1839,3310,3284,2159,1701,1378,117,-578,-91,-1021,-1907,-1842,-1674,-1467,-1473,-1202,-427,298,93,-391,-125,196,246,646,880,444,-139,-194,76,-434,-1202,-1322,-1137,-1043,-909,-571,-249,43,201,327,352,59,-162,-105,118,271,234,5,-276,-352,-212,-63,-151,-316,-343,-322,-290,-203,-80,-12,9,4,1,-17,-14,70,78,-44,-220,-300,-289,-262,-200,-190,-191,-168,-131,-90,-81,-66,-12,16,-24,-35,-63,-126,-179,-228,-233,-199,-139,-123,-151,-150,-98,-62,-60,-33,-7,-14,-23,11,47,54,39,8,-5,-8,-2}
        },
        {    // H50e128a.wav
            {-3,-2,-2,1,-3,-1,-3,3,0,3,-4,-3,-2,-13,14,-10,20,-34,258,1451,2717,1571,-3803,-7355,-3138,3191,5868,5933,4638,2678,1818,2175,1615,290,-319,-794,-1588,-2258,-2380,-2157,-2077,-1832,-1160,-277,296,533,233,30,1318,1999,1226,983,689,-36,-286,-203,-514,-1199,-1572,-1353,-706,-331,-407,-449,-389,-3,482,430,172,71,39,100,82,-47,-124,-285,-456,-409,-401,-564,-612,-520,-476,-454,-324,-134,-45,-142,-319,-296,-169,-138,-69,-18,-52,-125,-180,-172,-250,-360,-335,-221,-167,-200,-206,-186,-153,-77,-45,-43,-43,-63,-49,-57,-89,-93,-82,-91,-123,-133,-107,-70,-62,-65,-72,-67,-43,-20,-29,-65,-98,-144,-150,-119,-56,-37,-57,-112,-171,-44},
            {17,-15,0,27,-61,2048,7350,6722,-7633,-17833,-7821,7696,16407,16603,7550,-32,800,4594,4253,-2499,-7121,-5641,-4577,-5324,-4998,-3732,-3769,-3421,-1653,481,2148,1719,2120,3196,2693,2156,1678,566,-593,-248,-325,-1244,-1244,-1540,-1619,-1364,-1411,-940,-159,-69,-464,-339,21,211,466,716,675,232,-72,125,0,-752,-1237,-1108,-930,-970,-869,-582,-177,128,208,295,140,-118,-138,-13,188,262,146,-80,-239,-216,-133,-120,-248,-335,-309,-295,-274,-201,-110,-50,-22,-30,-31,-31,17,96,58,-80,-221,-265,-257,-233,-210,-209,-179,-140,-104,-115,-134,-90,-13,5,-22,-30,-91,-150,-172,-198,-201,-169,-130,-131,-146,-130,-95,-84,-59,-24,-18,-29,-20,30,51,22,3,30,45,10}
        },
        {    // H50e136a.wav
            {-1,-1,1,-2,0,-3,3,0,3,-1,-3,-2,-11,10,-9,19,-26,244,1551,3015,1573,-4254,-7760,-3133,3614,6463,6420,4717,2435,1699,2200,1535,89,-464,-853,-1655,-2271,-2381,-2293,-2356,-2198,-1394,-225,364,589,564,200,1199,2237,1549,948,544,-79,-281,-377,-666,-1113,-1530,-1512,-854,-197,-180,-416,-425,49,566,443,169,91,11,-23,-27,-90,-211,-262,-252,-255,-359,-545,-600,-599,-610,-515,-334,-146,-64,-148,-237,-217,-167,-95,-6,-9,-98,-148,-163,-233,-323,-323,-238,-197,-224,-222,-188,-173,-156,-121,-72,-43,-24,-9,-47,-84,-93,-89,-98,-135,-162,-149,-108,-68,-49,-60,-77,-74,-21,14,4,-32,-103,-153,-167,-126,-93,-63,-63,-83,-125,-175,-44},
            {-12,15,-15,9,-13,131,3033,7941,3891,-10813,-16380,-4652,10310,17772,14259,4303,-410,1916,4935,2893,-3928,-6594,-4732,-4504,-5126,-4427,-3442,-3541,-2913,-1144,896,1852,1422,2188,2816,2588,2309,1183,-204,-533,-156,-594,-694,-896,-1726,-1518,-1296,-1216,-617,-407,-687,-485,-27,50,321,653,621,393,195,233,166,-369,-852,-912,-870,-889,-907,-805,-583,-202,108,161,122,-52,-154,-115,30,262,270,85,-97,-131,-101,-134,-189,-270,-296,-294,-303,-293,-254,-178,-91,-39,-45,-46,-31,41,99,46,-72,-197,-263,-258,-197,-181,-194,-175,-143,-119,-145,-146,-98,-30,-9,-29,-55,-110,-133,-149,-183,-181,-136,-106,-118,-144,-141,-118,-95,-47,-22,-32,-32,-3,18,7,13,57,72,15}
        },
        {    // H50e144a.wav
            {0,4,-2,-2,-1,4,1,5,-3,-2,-2,-11,9,-8,18,-23,337,1939,3425,979,-5599,-8083,-2057,4924,7312,6666,4316,1959,1724,2298,1275,-306,-790,-1108,-1913,-2478,-2354,-2229,-2434,-2224,-1387,-309,237,599,858,459,1192,2331,1722,924,514,-59,-346,-552,-834,-1181,-1512,-1495,-975,-256,-57,-277,-307,110,597,510,237,107,-32,-84,-67,-123,-301,-338,-250,-236,-309,-476,-532,-547,-651,-612,-364,-119,-117,-211,-175,-107,-62,-24,-5,-33,-113,-162,-216,-304,-299,-222,-193,-236,-273,-224,-151,-139,-156,-127,-97,-76,-25,7,-21,-76,-93,-91,-100,-128,-168,-180,-148,-81,-38,-55,-80,-48,-2,14,10,-17,-71,-130,-149,-140,-112,-88,-78,-101,-118,-123,-116,-26},
            {-7,-8,10,-9,5,-16,281,3602,7769,1988,-11886,-15271,-2782,12081,17607,11930,2876,-170,2344,4887,2009,-4413,-5822,-4130,-4372,-4857,-4042,-3147,-3303,-2611,-804,952,1465,1230,2040,2613,2745,2128,529,-363,-367,-296,-186,-166,-1220,-1819,-1308,-1199,-956,-702,-948,-861,-223,133,219,461,574,460,293,316,328,-44,-562,-645,-509,-648,-873,-934,-758,-552,-324,-84,13,-30,-141,-138,-81,96,287,261,121,-16,-42,-72,-127,-169,-241,-296,-338,-353,-344,-292,-205,-122,-83,-52,-26,-21,46,100,63,-58,-191,-236,-209,-159,-168,-195,-186,-152,-121,-131,-143,-112,-51,-29,-38,-57,-105,-138,-151,-141,-109,-91,-103,-130,-153,-160,-125,-73,-37,-25,-22,-7,-15,-15,18,57,68,15}
        },
        {    // H50e152a.wav
            {1,-3,-3,-2,3,0,3,-4,-2,-5,-8,4,-12,18,-21,477,2440,3778,77,-7101,-8223,-766,6327,8190,6797,3782,1556,1900,2435,909,-790,-1140,-1441,-2214,-2652,-2374,-2269,-2500,-2125,-1201,-166,231,428,937,778,1047,2077,1987,1104,394,-53,-250,-711,-1145,-1207,-1437,-1621,-1157,-276,47,-223,-210,217,624,590,387,200,-114,-203,-55,-76,-291,-387,-359,-392,-453,-453,-429,-545,-684,-579,-329,-179,-110,-105,-172,-142,11,118,61,-93,-192,-231,-269,-261,-222,-247,-291,-283,-231,-180,-183,-181,-137,-102,-91,-70,-27,-32,-69,-71,-58,-67,-110,-156,-181,-191,-165,-114,-90,-86,-73,-51,-17,12,16,-24,-81,-118,-128,-123,-113,-98,-110,-131,-144,-128,-83,-50,-10},
            {-16,3,-12,8,-8,1,-9,333,3690,7353,1275,-11874,-14632,-1884,12582,16633,10551,2634,-20,2331,4777,1594,-4290,-5063,-3681,-4171,-4608,-3726,-2885,-3168,-2429,-661,759,1135,1059,1871,2603,2742,1684,258,-221,-432,-53,471,-277,-1585,-1639,-1163,-1091,-924,-1069,-1201,-702,-110,279,551,457,269,341,428,402,145,-220,-424,-334,-213,-433,-861,-1047,-788,-536,-480,-376,-215,-125,-96,-78,-22,121,220,271,246,115,-4,-80,-84,-131,-253,-354,-400,-391,-376,-321,-240,-168,-100,-52,-25,-15,40,109,90,-38,-164,-200,-179,-157,-180,-194,-184,-153,-111,-114,-135,-125,-64,-37,-58,-77,-106,-138,-132,-82,-64,-87,-122,-141,-156,-155,-110,-66,-36,-17,8,-11,-41,-19,24,55,15}
        },
        {    // H50e160a.wav
            {-1,-3,-1,5,1,4,-6,-2,-4,-5,4,-11,18,-11,736,3141,3984,-1386,-8841,-7905,1124,7987,8993,6637,3021,1215,2227,2547,399,-1343,-1509,-1867,-2606,-2821,-2374,-2297,-2545,-2052,-972,98,405,534,1054,1001,930,1612,1920,1240,472,73,-324,-896,-1232,-1230,-1441,-1644,-1279,-476,49,-26,-81,240,580,664,579,284,-98,-208,-71,-35,-223,-361,-446,-555,-570,-518,-524,-657,-697,-542,-264,21,7,-190,-185,5,151,135,30,-82,-212,-272,-215,-191,-271,-345,-322,-272,-236,-198,-186,-160,-128,-96,-49,-18,-17,-45,-79,-85,-60,-55,-84,-142,-196,-196,-154,-111,-101,-105,-101,-79,-32,18,19,-26,-81,-115,-117,-96,-69,-77,-107,-141,-140,-131,-88,-37,-63,-21},
            {-1,-15,3,-12,9,-9,2,-7,305,3423,6884,1347,-11151,-14103,-1877,11920,15408,9977,2948,64,2136,4571,1498,-3775,-4351,-3288,-3896,-4343,-3463,-2712,-3061,-2319,-745,462,886,896,1750,2534,2471,1386,302,-227,-313,585,668,-655,-1593,-1468,-1105,-1020,-1104,-1384,-1171,-535,-48,452,689,380,57,232,556,441,8,-239,-202,-80,-84,-313,-770,-1102,-969,-702,-552,-527,-461,-223,-28,26,46,119,157,233,350,272,52,-118,-144,-151,-249,-360,-436,-470,-444,-324,-224,-195,-157,-103,-28,36,81,94,51,-36,-121,-160,-175,-188,-203,-194,-159,-131,-126,-123,-119,-111,-74,-68,-97,-92,-87,-120,-131,-96,-75,-83,-102,-130,-149,-145,-111,-65,-30,3,-11,-64,-57,-5,21,6}
        },
        {    // H50e168a.wav
            {-4,0,6,-1,3,-8,-2,-7,-2,2,-11,18,9,1119,3968,3912,-3305,-10513,-7070,3402,9709,9595,6139,2129,1069,2701,2536,-290,-1934,-1863,-2306,-3013,-2978,-2405,-2395,-2521,-1844,-765,238,598,807,1279,1350,953,946,1536,1348,488,135,-240,-1049,-1393,-1189,-1358,-1685,-1365,-591,-81,9,80,325,520,645,650,289,-63,-45,112,-13,-306,-400,-449,-532,-625,-694,-743,-838,-798,-488,-53,107,-48,-128,-14,135,181,144,47,-122,-207,-147,-156,-304,-383,-330,-313,-337,-296,-219,-179,-171,-108,-25,-32,-36,6,-5,-58,-98,-87,-74,-107,-150,-180,-179,-155,-110,-84,-107,-133,-115,-53,-3,-14,-60,-83,-109,-112,-77,-51,-53,-89,-110,-143,-148,-100,-51,-66,-107,-27},
            {3,0,-14,3,-11,9,-9,-1,-1,223,2914,6335,1933,-9753,-13575,-2715,10404,14141,9872,3598,257,1817,4240,1691,-2986,-3703,-2919,-3578,-4069,-3257,-2598,-2939,-2310,-966,152,673,783,1629,2302,2142,1308,331,-178,256,1009,382,-774,-1393,-1399,-1065,-1052,-1352,-1539,-1034,-376,59,476,568,329,130,258,499,420,52,-119,-62,-6,-59,-343,-676,-972,-1133,-987,-646,-490,-514,-352,-81,122,179,138,125,196,334,335,105,-147,-194,-175,-266,-382,-446,-455,-438,-364,-274,-210,-154,-83,-7,29,61,83,51,-33,-111,-146,-166,-176,-189,-182,-167,-149,-121,-95,-83,-112,-113,-91,-90,-79,-80,-121,-154,-130,-84,-48,-54,-101,-141,-145,-97,-56,-35,-31,-68,-87,-42,3,3}
        },
        {    // H50e176a.wav
            {1,7,1,2,-9,0,-8,1,0,-8,16,53,1641,4845,3512,-5511,-11921,-5783,5862,11378,9932,5377,1279,1131,3255,2389,-1121,-2555,-2235,-2740,-3377,-3086,-2477,-2550,-2455,-1581,-469,364,676,1139,1575,1641,1156,498,862,1267,673,87,-343,-1105,-1397,-1135,-1299,-1681,-1443,-686,-137,43,135,330,486,612,629,230,-58,154,317,29,-309,-434,-458,-449,-652,-888,-992,-1020,-741,-279,-76,-99,-46,80,183,206,179,139,44,-16,-34,-123,-285,-366,-340,-344,-372,-384,-344,-262,-207,-140,-51,-21,-30,-1,29,20,-27,-90,-114,-104,-119,-172,-196,-175,-125,-80,-81,-109,-143,-123,-55,-38,-65,-80,-99,-128,-113,-63,-37,-38,-52,-91,-143,-149,-90,-43,-75,-115,-80,-12},
            {7,-1,1,-11,0,-10,4,-5,-7,7,127,2270,5654,2771,-7771,-12910,-4189,8274,12830,9967,4473,648,1425,3777,2052,-2041,-3107,-2589,-3202,-3722,-3139,-2549,-2759,-2362,-1268,-174,505,734,1421,1939,1870,1276,343,219,896,922,120,-567,-1218,-1398,-1066,-1151,-1584,-1558,-838,-222,109,314,374,354,401,519,312,124,185,168,25,-136,-258,-409,-568,-770,-1029,-1166,-908,-495,-359,-328,-153,100,216,189,157,181,231,208,102,-74,-208,-251,-297,-365,-411,-425,-418,-373,-297,-202,-120,-64,-25,-2,47,70,30,-46,-102,-116,-130,-148,-184,-205,-183,-128,-79,-79,-96,-126,-123,-88,-72,-69,-82,-123,-160,-131,-66,-28,-32,-65,-112,-144,-121,-63,-37,-76,-111,-79,-27,-3}
        }
    },
    {    // elev60 
        {    // H60e000a.wav
            {15,-13,-20,72,-140,192,-168,2048,4291,4559,1860,-11770,-10843,7090,11493,9293,5204,1180,2378,3033,1959,-2864,-5803,-5495,-5309,-2995,-2561,-2953,-1594,-917,-48,692,1512,2036,1601,1685,1370,1224,686,-182,140,175,144,-435,-1470,-1987,-1989,-1367,-944,-408,188,543,608,306,379,691,673,453,156,-300,-530,-371,-200,-207,-173,-160,-343,-486,-624,-627,-534,-783,-1221,-1302,-749,-67,183,213,163,8,-76,-66,-8,33,58,79,-32,-242,-413,-436,-259,-95,-102,-191,-344,-435,-385,-299,-128,73,100,-9,-113,-141,-41,99,102,-39,-125,-134,-114,-55,-33,-58,-123,-209,-260,-245,-167,-70,-63,-132,-155,-146,-103,-42,-6,-1,-23,-69,-93,-34,23,21,-20,-89,-173,-198,-110,-14},
            {15,-13,-20,72,-140,192,-168,2048,4291,4559,1860,-11770,-10843,7090,11493,9293,5204,1180,2378,3033,1959,-2864,-5803,-5495,-5309,-2995,-2561,-2953,-1594,-917,-48,692,1512,2036,1601,1685,1370,1224,686,-182,140,175,144,-435,-1470,-1987,-1989,-1367,-944,-408,188,543,608,306,379,691,673,453,156,-300,-530,-371,-200,-207,-173,-160,-343,-486,-624,-627,-534,-783,-1221,-1302,-749,-67,183,213,163,8,-76,-66,-8,33,58,79,-32,-242,-413,-436,-259,-95,-102,-191,-344,-435,-385,-299,-128,73,100,-9,-113,-141,-41,99,102,-39,-125,-134,-114,-55,-33,-58,-123,-209,-260,-245,-167,-70,-63,-132,-155,-146,-103,-42,-6,-1,-23,-69,-93,-34,23,21,-20,-89,-173,-198,-110,-14}
        },
        {    // H60e010a.wav
            {-33,30,-30,-2,40,-99,147,-91,2045,3808,4088,954,-10981,-8948,6304,10371,8989,4882,1168,2024,2886,1934,-2411,-4702,-4803,-4743,-2730,-2510,-2849,-1842,-1086,-207,389,1317,1904,1610,1678,1373,1222,667,-127,98,222,213,-424,-1315,-1751,-1791,-1264,-850,-463,-31,401,505,195,230,519,641,502,161,-230,-420,-298,-115,-191,-189,-103,-435,-697,-568,-445,-558,-869,-1070,-957,-604,-196,88,231,138,-135,-245,-146,-38,-20,-5,22,-43,-195,-336,-376,-302,-168,-92,-161,-311,-382,-351,-263,-132,43,107,-3,-86,-115,-71,28,54,-39,-118,-105,-91,-51,-10,-39,-115,-183,-237,-231,-161,-98,-81,-134,-172,-165,-89,-17,-13,-32,-39,-40,-57,-27,-4,3,-38,-72,-117,-179,-45},
            {16,-65,129,-190,231,-231,1846,4811,5085,3259,-11962,-13981,7091,13187,9694,5772,1216,2510,3295,2185,-2945,-6792,-6317,-5949,-3382,-2635,-3098,-1406,-675,88,886,1744,2315,1532,1536,1390,1251,669,-345,223,317,130,-347,-1520,-2238,-2253,-1511,-1012,-460,302,715,659,370,486,797,789,558,213,-405,-706,-552,-291,-51,-88,-244,-341,-426,-544,-538,-514,-886,-1473,-1551,-822,37,225,106,191,190,115,105,68,18,72,163,8,-338,-545,-458,-205,-69,-102,-170,-341,-460,-418,-304,-72,92,97,-19,-183,-194,-4,168,128,-29,-157,-201,-128,-18,18,-29,-153,-264,-287,-254,-162,-49,-52,-124,-131,-147,-130,-32,32,20,-21,-81,-111,-45,29,47,-14,-118,-186,-165,-79,-26,-3}
        },
        {    // H60e020a.wav
            {17,-33,28,-27,7,20,-63,110,-23,1902,3342,3654,469,-9860,-7726,5282,9417,8565,4655,1238,1874,2783,1894,-1773,-3812,-4302,-4222,-2525,-2445,-2790,-1970,-1163,-382,179,1187,1789,1557,1624,1375,1144,637,15,140,250,210,-388,-1152,-1630,-1688,-1163,-840,-603,-172,330,369,-2,225,712,675,395,114,-190,-334,-261,-68,-115,-339,-374,-443,-523,-452,-465,-640,-803,-831,-689,-461,-282,-107,111,140,-80,-281,-291,-179,-98,-44,-4,-73,-222,-315,-317,-260,-184,-126,-138,-222,-286,-287,-225,-123,11,77,-9,-99,-107,-71,-22,-13,-63,-106,-85,-44,-8,9,-47,-124,-172,-205,-209,-172,-108,-95,-128,-169,-163,-88,-16,-6,-35,-37,-43,-48,-39,-12,-23,-38,-57,-118,-35},
            {-95,176,-227,229,-220,1359,5145,5550,4900,-10597,-17531,5448,14993,10041,6383,1695,2605,3336,2661,-2449,-7697,-7088,-6673,-4056,-2826,-3389,-1240,-435,289,1161,1788,2644,1716,1316,1250,1290,772,-525,118,443,231,-227,-1438,-2335,-2604,-1779,-1127,-536,300,765,767,442,579,943,919,663,318,-329,-864,-884,-400,-21,-139,-209,-278,-431,-556,-491,-375,-840,-1664,-1822,-892,132,188,19,289,342,219,186,136,84,107,178,-22,-393,-568,-475,-248,-112,-77,-111,-333,-511,-462,-233,12,75,74,-38,-219,-192,19,153,136,8,-213,-278,-157,-31,52,28,-141,-297,-349,-310,-162,-23,-11,-100,-170,-201,-125,19,64,37,-34,-112,-121,-58,16,34,-43,-137,-155,-122,-65,-34,-23,-5}
        },
        {    // H60e030a.wav
            {-3,14,-29,26,-27,12,5,-36,78,35,1766,2960,3303,50,-9034,-6753,4616,8692,8053,4311,1317,1846,2645,1856,-1230,-3150,-3842,-3652,-2293,-2442,-2696,-1940,-1196,-525,40,1111,1642,1393,1511,1373,1124,643,149,191,242,179,-404,-1112,-1531,-1524,-1115,-931,-643,-240,37,236,294,450,624,535,302,65,-112,-199,-251,-249,-311,-345,-269,-366,-516,-464,-443,-581,-662,-635,-549,-477,-387,-168,72,118,-76,-289,-389,-321,-160,-99,-91,-118,-208,-281,-290,-203,-133,-131,-116,-133,-177,-221,-223,-133,-26,13,-46,-120,-125,-87,-54,-48,-75,-84,-51,-8,15,-4,-52,-112,-160,-191,-193,-164,-131,-113,-128,-152,-161,-98,-16,-1,-22,-59,-63,-56,-33,-24,-34,-50,-80,-22},
            {138,-167,134,-45,550,5019,6022,6478,-6721,-20828,566,16709,10859,7003,2580,2781,3373,2796,-758,-7939,-8229,-6993,-5059,-3271,-3874,-1463,-223,229,1574,1904,2765,2070,1351,1222,1083,927,-474,-132,436,279,97,-1198,-2345,-2794,-2127,-1347,-686,254,723,738,541,652,1036,1078,798,491,-197,-986,-1110,-428,-83,-383,-218,-132,-394,-518,-442,-378,-811,-1558,-1821,-1114,-93,259,136,241,436,395,179,94,167,200,196,-26,-371,-538,-510,-328,-138,-61,-104,-298,-501,-473,-194,33,105,106,-85,-238,-142,25,129,166,8,-256,-292,-185,-60,61,56,-116,-281,-353,-347,-209,-20,61,-64,-219,-245,-120,36,104,95,-21,-124,-142,-74,12,19,-58,-115,-110,-106,-75,-18,10,-16,-9}
        },
        {    // H60e040a.wav
            {11,-4,10,-22,23,-27,17,-4,-13,52,92,1669,2678,3027,-401,-8524,-5911,4328,8205,7464,3878,1438,1890,2499,1780,-858,-2646,-3396,-3122,-2116,-2427,-2513,-1831,-1207,-607,-34,1005,1430,1234,1448,1399,1091,610,264,209,148,58,-460,-1014,-1386,-1443,-1111,-939,-853,-429,318,523,274,405,519,395,281,155,-43,-392,-575,-305,-44,-187,-431,-455,-384,-335,-408,-532,-530,-561,-575,-457,-333,-194,-9,44,-121,-282,-374,-416,-328,-186,-77,-91,-209,-259,-226,-139,-71,-65,-81,-113,-128,-163,-206,-173,-81,-38,-84,-143,-158,-114,-48,-22,-44,-58,-36,-7,11,5,-35,-89,-141,-182,-186,-165,-136,-127,-131,-138,-129,-75,-29,-17,-33,-52,-64,-56,-42,-32,-36,-56,-15},
            {37,-143,266,-245,3842,6475,7333,-356,-20801,-8958,16240,13230,7334,4086,2935,3697,2712,1245,-6428,-9498,-7499,-5917,-3855,-4652,-2399,-97,-196,1599,2270,2902,2498,1479,1471,1073,942,-352,-417,389,168,260,-662,-2036,-2985,-2586,-1533,-959,35,699,653,520,679,1077,1241,954,651,23,-964,-1208,-569,-194,-500,-407,-161,-278,-417,-460,-406,-733,-1380,-1642,-1224,-455,117,261,346,456,364,191,131,189,163,184,110,-262,-551,-573,-398,-184,-70,-102,-272,-471,-448,-180,-25,77,162,-55,-233,-157,-22,122,168,11,-241,-307,-228,-100,49,54,-93,-258,-363,-365,-239,-49,73,-58,-234,-241,-157,-10,103,124,17,-95,-143,-129,-46,-6,-29,-68,-89,-135,-109,-20,31,8,-58,-18}
        },
        {    // H60e050a.wav
            {2,6,1,7,-18,22,-31,27,-18,14,18,198,1684,2497,2771,-1308,-8414,-4587,4690,7840,6666,3298,1592,1947,2373,1620,-729,-2310,-3036,-2625,-1933,-2378,-2273,-1671,-1160,-662,-51,990,1250,1080,1391,1400,991,506,266,106,28,-25,-451,-959,-1290,-1289,-1315,-1191,-497,79,322,354,290,312,371,468,366,-73,-478,-541,-302,-39,-95,-394,-471,-269,-187,-324,-472,-493,-466,-502,-513,-444,-337,-230,-104,-34,-138,-302,-441,-494,-375,-181,-58,-86,-179,-201,-154,-73,-23,-36,-72,-114,-133,-162,-208,-195,-127,-88,-126,-175,-166,-106,-21,17,-17,-48,-37,-10,11,6,-30,-72,-132,-183,-191,-171,-141,-133,-129,-116,-105,-76,-53,-42,-36,-48,-59,-71,-55,-36,-47,-13},
            {-215,317,-368,1719,6273,7460,5466,-14237,-19352,9372,17225,8100,5236,3529,4151,2692,2685,-2843,-10191,-8537,-6398,-4633,-4858,-4170,-620,-433,739,2406,3013,3214,1796,1607,1467,1144,16,-863,166,169,173,-208,-1507,-2729,-3083,-1999,-1130,-295,536,626,475,603,964,1353,1199,806,220,-861,-1051,-622,-473,-542,-532,-317,-267,-357,-449,-446,-668,-1164,-1425,-1152,-644,-192,188,474,520,297,162,128,175,174,153,169,-91,-453,-617,-510,-260,-90,-83,-204,-415,-453,-222,-61,52,133,4,-159,-181,-91,69,137,40,-161,-304,-277,-139,1,33,-32,-213,-364,-376,-277,-86,37,-38,-204,-245,-196,-73,81,123,49,-64,-133,-157,-106,-37,3,-12,-79,-143,-153,-47,33,31,-38,-102,-28}
        },
        {    // H60e060a.wav
            {-6,8,1,3,-2,-10,16,-28,35,-37,49,-29,421,1808,2452,2341,-2987,-8356,-2424,5625,7474,5597,2663,1753,1977,2316,1307,-924,-2165,-2688,-2132,-1812,-2296,-2003,-1529,-1059,-604,46,987,1060,960,1332,1333,743,278,218,43,5,-88,-466,-876,-1396,-1494,-1075,-589,-231,25,225,259,237,303,441,321,-128,-354,-283,-252,-229,-185,-229,-323,-284,-147,-216,-427,-470,-347,-357,-505,-535,-448,-361,-281,-149,-97,-240,-394,-441,-425,-336,-156,-23,-54,-136,-139,-92,-44,-21,-35,-89,-158,-172,-173,-212,-219,-164,-121,-140,-173,-148,-78,-1,29,-6,-29,-21,-9,1,-11,-42,-77,-126,-177,-190,-169,-140,-129,-121,-114,-98,-68,-55,-45,-49,-55,-63,-66,-55,-55,-14},
            {-72,201,-156,4306,7359,8172,-2666,-22312,-6032,18036,12137,5632,4289,4425,3554,2590,1572,-7421,-10660,-7203,-5208,-4773,-5544,-2182,-633,-613,1860,2738,3502,2744,1838,1839,1458,960,-743,-526,169,13,86,-951,-2204,-3195,-2725,-1427,-664,240,596,404,557,826,1194,1398,1058,489,-627,-1037,-473,-506,-705,-619,-420,-337,-419,-455,-459,-615,-980,-1224,-1062,-675,-318,47,344,515,391,151,96,107,163,173,181,59,-302,-556,-577,-406,-164,-48,-99,-313,-450,-286,-105,-2,103,55,-69,-156,-165,-15,83,60,-55,-253,-306,-187,-55,-6,11,-93,-304,-387,-313,-146,-21,-16,-123,-229,-244,-153,27,124,83,-20,-121,-185,-154,-43,41,25,-63,-135,-157,-89,19,36,-10,-73,-103,-25}
        },
        {    // H60e070a.wav
            {-1,-3,11,-3,10,-13,8,-4,-5,21,-28,60,-30,875,2002,2558,1081,-5662,-7235,1002,6751,6715,4155,2176,1921,2075,2258,606,-1384,-2090,-2246,-1752,-1876,-2127,-1737,-1335,-866,-511,241,962,891,903,1213,1108,435,146,204,51,31,-120,-703,-1262,-1177,-849,-737,-489,-233,-23,176,259,280,170,15,-18,-27,-88,-187,-323,-333,-165,-101,-251,-297,-215,-276,-349,-289,-266,-418,-563,-519,-443,-426,-332,-195,-215,-328,-352,-353,-358,-250,-64,27,-32,-104,-101,-59,-40,-52,-90,-155,-192,-189,-203,-243,-219,-136,-97,-133,-163,-118,-38,26,26,-7,-14,-3,-1,-21,-42,-56,-77,-128,-172,-174,-149,-136,-137,-122,-99,-73,-54,-48,-71,-72,-56,-52,-56,-68,-17},
            {155,-192,949,5897,8227,6577,-11327,-20889,5463,18120,8430,4867,4284,4548,2840,3212,-858,-9959,-9548,-6153,-4891,-5503,-4779,-1143,-1201,-248,2213,3111,3375,2259,2299,2087,1487,461,-702,-134,-146,18,-212,-1600,-2835,-3302,-2203,-1008,-260,382,451,415,662,980,1390,1280,787,-62,-946,-624,-356,-609,-692,-553,-365,-488,-564,-506,-534,-853,-1089,-970,-775,-418,63,259,273,384,331,134,8,72,189,186,127,-98,-408,-587,-529,-279,-91,-39,-154,-376,-361,-188,-53,60,52,7,-44,-172,-160,-11,64,42,-145,-299,-255,-126,-44,0,11,-178,-327,-327,-241,-99,-16,-34,-168,-258,-234,-86,72,112,49,-74,-189,-218,-103,42,75,-22,-114,-143,-105,-25,27,13,-42,-77,-98,-24}
        },
        {    // H60e080a.wav
            {0,-4,7,2,6,-2,-9,14,-24,32,-27,43,-24,287,1544,2298,2300,-2410,-7892,-3037,5003,6956,5059,2741,2127,2080,2309,1689,-583,-1857,-1950,-1714,-1787,-2011,-1716,-1549,-1165,-670,-206,493,787,819,886,1054,823,239,119,191,189,-207,-660,-755,-874,-777,-625,-636,-540,-230,121,206,89,-127,-135,140,188,25,-116,-249,-299,-233,-111,-185,-386,-316,-142,-154,-239,-265,-346,-492,-528,-515,-553,-529,-374,-212,-207,-285,-322,-324,-240,-65,48,19,-54,-79,-66,-69,-101,-135,-174,-206,-214,-220,-248,-225,-135,-80,-100,-144,-138,-67,7,18,-8,-13,-3,-5,-14,-27,-55,-84,-112,-132,-143,-145,-150,-145,-123,-100,-73,-60,-58,-82,-87,-70,-48,-44,-80,-23},
            {216,-345,1842,6632,8735,3859,-15773,-16470,10572,16119,7015,4733,4268,4106,2875,3461,-2813,-10541,-8363,-5469,-5156,-5977,-3820,-1024,-1602,143,2111,3108,3137,2060,2508,2350,1652,171,-501,170,-156,-77,-593,-1992,-3255,-3291,-1737,-681,-187,261,453,526,613,1026,1477,1158,434,-401,-684,-422,-554,-538,-500,-486,-475,-596,-623,-586,-618,-981,-1040,-806,-610,-120,307,262,171,314,344,131,-84,24,206,191,65,-201,-479,-585,-439,-188,-49,-64,-219,-348,-286,-171,-29,70,24,15,-44,-185,-162,-43,54,29,-193,-310,-234,-122,-35,39,-15,-217,-300,-278,-195,-93,-10,-36,-199,-275,-219,-55,64,88,28,-118,-225,-205,-65,64,62,-51,-116,-111,-59,-3,17,-12,-61,-80,-97,-24}
        },
        {    // H60e090a.wav
            {-1,-5,2,4,1,6,-16,15,-22,23,-8,17,9,88,1241,2174,2509,-983,-7294,-4751,3686,6836,5292,3015,2298,2277,2402,2059,-28,-1684,-1994,-1620,-1624,-2142,-1746,-1427,-1406,-905,-280,335,477,609,967,1033,813,410,293,219,-91,-236,-276,-580,-827,-600,-522,-703,-622,-304,-50,-56,-177,-187,-19,166,198,88,-18,-61,-157,-275,-300,-322,-383,-278,-74,-64,-209,-276,-279,-373,-498,-576,-663,-715,-531,-195,-86,-234,-360,-305,-140,0,49,25,-13,-55,-81,-105,-154,-199,-228,-233,-231,-236,-236,-203,-128,-69,-74,-120,-130,-85,-23,-6,-18,-29,-27,-10,-1,-10,-59,-103,-104,-99,-113,-137,-155,-144,-120,-98,-80,-78,-69,-88,-96,-86,-60,-57,-100,-29},
            {193,-329,1982,6766,8831,2480,-16252,-14272,10974,15073,6938,4780,4016,3821,3213,3405,-3273,-10195,-7711,-5035,-5345,-6179,-3644,-1130,-1709,-15,1965,2932,2759,2063,2576,2387,1827,403,-291,183,86,86,-926,-2338,-3353,-3193,-1552,-574,-305,112,463,553,567,935,1364,1068,301,-376,-413,-407,-728,-447,-241,-447,-607,-642,-640,-621,-694,-995,-1003,-810,-481,78,373,224,143,311,342,140,-109,-38,157,183,73,-232,-515,-559,-368,-156,-58,-69,-224,-330,-271,-173,-31,49,37,47,-57,-193,-163,-62,34,7,-188,-307,-257,-139,-27,59,-23,-202,-264,-263,-171,-76,-13,-39,-195,-273,-227,-73,47,73,6,-136,-226,-194,-62,44,35,-45,-77,-78,-41,11,15,-28,-82,-96,-85,-18}
        },
        {    // H60e100a.wav
            {-3,-4,4,2,1,7,-14,12,-25,21,-9,21,3,87,1242,2238,2525,-1184,-7373,-4508,3915,6768,5018,2905,2425,2438,2559,2173,-52,-1718,-1992,-1771,-1743,-2127,-1869,-1472,-1295,-981,-362,409,464,429,931,1287,866,328,456,103,-373,-24,-92,-678,-786,-549,-520,-612,-518,-314,-279,-418,-317,28,131,82,119,141,154,64,-104,-256,-449,-529,-396,-161,-32,-86,-210,-257,-203,-271,-466,-632,-790,-819,-543,-157,-63,-256,-368,-246,-40,56,64,55,3,-64,-106,-142,-206,-271,-277,-254,-238,-232,-221,-172,-106,-54,-62,-105,-112,-93,-45,-19,-36,-56,-53,-17,0,-29,-67,-78,-69,-77,-110,-133,-141,-130,-109,-97,-89,-89,-80,-91,-97,-91,-84,-92,-111,-27},
            {154,-250,1415,6223,8781,3214,-14091,-15038,8185,15178,7690,4854,3764,3743,3563,3460,-2357,-9371,-7628,-4746,-5162,-6208,-4148,-1434,-1673,-464,1481,2767,2657,1792,2524,2506,1824,734,100,277,144,339,-702,-2495,-3487,-3020,-1432,-788,-569,82,415,400,505,830,1104,929,417,-90,-201,-438,-815,-404,-69,-341,-664,-682,-605,-608,-691,-981,-1015,-860,-497,94,355,260,185,274,315,183,-62,-104,69,174,107,-176,-472,-534,-373,-183,-62,-61,-204,-322,-293,-191,-59,26,42,70,-17,-182,-174,-72,10,-2,-170,-298,-281,-161,-35,51,1,-158,-232,-252,-173,-61,-4,-30,-177,-271,-236,-100,25,66,2,-134,-220,-189,-74,19,28,-19,-40,-52,-31,17,13,-39,-92,-105,-77,-13}
        },
        {    // H60e110a.wav
            {-3,-6,8,-1,4,-1,-7,8,-26,30,-24,46,-39,285,1585,2536,2173,-3127,-7901,-2149,5629,6577,4188,2535,2519,2578,2707,1840,-578,-1959,-2016,-1817,-2167,-2380,-1736,-1506,-1339,-717,-79,404,474,641,1088,1241,886,536,130,-278,79,100,-532,-716,-707,-672,-527,-435,-419,-419,-461,-478,-203,120,165,64,82,264,240,-2,-109,-261,-560,-594,-309,-134,-161,-137,-119,-181,-209,-253,-430,-734,-889,-709,-394,-185,-189,-289,-294,-140,31,87,104,73,-11,-86,-145,-198,-271,-306,-274,-247,-242,-234,-205,-129,-58,-41,-75,-109,-99,-71,-34,-32,-71,-83,-63,-42,-37,-38,-31,-19,-40,-81,-113,-121,-107,-98,-97,-103,-103,-94,-83,-87,-90,-115,-113,-98,-105,-25},
            {64,-78,502,4805,8441,5335,-9535,-16788,2092,15143,9527,5049,3585,3635,3936,3714,-450,-7882,-8018,-4649,-4691,-5967,-4937,-2074,-1660,-1072,808,2270,2739,1778,2053,2541,2001,971,310,521,384,378,-331,-2037,-3398,-3108,-1449,-918,-939,-166,386,293,298,629,839,770,568,269,70,-355,-888,-476,66,-175,-642,-733,-558,-532,-633,-914,-1049,-934,-629,-83,265,296,245,237,266,229,25,-131,-21,141,146,-57,-367,-505,-410,-258,-99,-51,-187,-318,-319,-238,-117,0,44,64,36,-129,-191,-88,-14,1,-138,-300,-309,-200,-57,32,20,-105,-201,-236,-190,-72,3,-19,-153,-265,-254,-132,-9,41,3,-108,-203,-208,-119,-13,28,1,-16,-34,-33,-2,2,-35,-92,-108,-81,-16}
        },
        {    // H60e120a.wav
            {-3,0,9,-3,11,-13,12,-12,-1,13,-11,47,-34,885,2248,2903,202,-6694,-6420,2622,7277,5526,3000,2359,2597,2736,2683,668,-1589,-2052,-1928,-2123,-2645,-2397,-1745,-1514,-1102,-386,430,587,481,1013,1371,1134,768,346,-186,-18,279,-269,-716,-893,-830,-555,-498,-454,-434,-463,-420,-218,23,82,75,121,281,330,53,-130,-141,-351,-574,-464,-220,-233,-308,-170,-31,-72,-225,-347,-554,-785,-720,-455,-279,-296,-339,-260,-146,-42,59,135,125,30,-56,-120,-200,-283,-294,-244,-233,-257,-260,-216,-144,-77,-39,-55,-103,-111,-69,-23,-23,-71,-97,-94,-86,-81,-50,-5,11,0,-48,-87,-92,-71,-66,-87,-105,-108,-102,-96,-80,-97,-114,-115,-106,-98,-97,-22},
            {-54,110,-135,2607,7196,7437,-2866,-16065,-6937,12108,12607,6071,3533,3253,4178,4081,1780,-5043,-8432,-5197,-3978,-5379,-5552,-3151,-1702,-1661,-179,1552,2581,2029,1671,2275,2118,1362,512,495,669,604,5,-1458,-2816,-3041,-1795,-1065,-1125,-582,109,283,183,294,473,594,685,605,353,-130,-772,-672,36,65,-491,-793,-588,-402,-507,-775,-1035,-1017,-805,-388,46,232,269,237,230,244,129,-70,-94,58,179,93,-213,-454,-450,-324,-182,-94,-158,-299,-344,-296,-207,-65,60,76,40,-63,-179,-117,-20,-8,-97,-274,-343,-254,-99,12,27,-58,-166,-211,-203,-110,-15,-23,-113,-224,-261,-184,-66,6,2,-64,-159,-219,-177,-59,19,15,-7,-23,-37,-34,-14,-29,-71,-104,-98,-21}
        },
        {    // H60e130a.wav
            {-6,10,-2,7,-6,-1,6,-19,26,-34,57,-52,431,1953,3092,1822,-4839,-8222,-274,7182,6661,3638,2330,2519,2680,2941,1544,-1252,-2234,-1952,-2035,-2744,-2834,-2040,-1824,-1508,-606,297,726,685,1007,1348,1282,1030,477,-192,-15,472,-114,-745,-915,-987,-763,-587,-556,-546,-467,-372,-147,134,119,27,89,336,407,78,-166,-197,-322,-447,-377,-335,-388,-320,-236,-202,-81,-54,-262,-571,-726,-577,-356,-279,-362,-414,-302,-166,-68,7,92,138,70,-50,-158,-235,-272,-248,-208,-229,-272,-270,-220,-166,-108,-57,-68,-111,-114,-77,-43,-29,-55,-103,-119,-116,-105,-76,-37,-9,-8,-35,-71,-64,-27,-27,-81,-120,-119,-105,-90,-97,-120,-142,-121,-96,-93,-99,-90,-19},
            {-58,66,-74,511,4492,7851,3964,-9579,-14608,2402,14339,9373,4112,2780,3788,4485,3528,-881,-7124,-6789,-3736,-4258,-5555,-4539,-2196,-1807,-1372,415,2012,2344,1531,1880,2176,1595,970,512,633,767,510,-702,-2185,-2652,-1983,-1344,-1305,-960,-318,142,184,77,54,281,635,805,753,186,-524,-706,-175,192,-224,-698,-676,-382,-349,-554,-845,-1054,-974,-682,-308,-8,187,243,232,234,210,93,-71,-53,138,232,12,-335,-457,-385,-276,-186,-156,-235,-349,-360,-284,-162,11,123,67,-34,-130,-154,-39,-1,-67,-189,-315,-306,-177,-38,21,-6,-102,-176,-197,-163,-70,-23,-63,-156,-230,-232,-140,-30,-5,-40,-105,-174,-193,-119,-23,19,7,-16,-33,-54,-32,-21,-43,-80,-94,-22}
        },
        {    // H60e140a.wav
            {6,1,4,0,-10,11,-25,29,-28,33,-22,220,1762,3281,2619,-3752,-8956,-2054,7084,7501,4079,2402,2486,2668,3038,1902,-1114,-2432,-2092,-2088,-2782,-3046,-2256,-1921,-1774,-966,113,817,798,1077,1568,1443,1036,617,-60,-163,485,154,-642,-1035,-1140,-794,-712,-773,-655,-526,-389,-163,219,307,129,130,366,470,127,-226,-261,-346,-444,-317,-300,-444,-434,-293,-203,-165,-156,-271,-521,-661,-478,-219,-189,-328,-395,-308,-186,-98,-49,41,118,57,-55,-200,-307,-269,-171,-143,-222,-286,-259,-206,-179,-137,-85,-72,-105,-128,-91,-59,-55,-68,-92,-110,-122,-110,-83,-65,-54,-43,-57,-73,-46,1,-2,-56,-106,-131,-120,-85,-85,-136,-164,-144,-110,-90,-73,-69,-73,-17},
            {44,-87,116,-147,1398,5663,7209,-41,-13061,-10113,8230,13564,6860,2867,2798,4236,4375,2618,-2968,-7303,-5078,-3255,-4495,-5283,-3589,-1808,-1946,-1057,812,2165,1894,1350,2042,1833,1241,850,584,712,699,152,-1305,-2223,-1861,-1474,-1444,-1282,-808,-136,157,-15,-200,-115,369,680,963,789,-167,-663,-321,180,-15,-504,-624,-467,-314,-398,-538,-816,-1057,-949,-649,-356,-80,133,221,256,234,218,102,-51,21,223,221,-98,-373,-440,-381,-273,-209,-198,-279,-366,-344,-251,-117,69,155,34,-97,-156,-124,-19,-3,-95,-223,-302,-262,-120,-17,10,-22,-114,-174,-187,-130,-49,-28,-86,-174,-219,-194,-98,-34,-42,-69,-101,-149,-147,-74,-13,10,-9,-25,-54,-60,-27,-16,-43,-68,-16}
        },
        {    // H60e150a.wav
            {4,1,1,-14,14,-26,26,-26,20,-4,136,1726,3558,3085,-3463,-9503,-2771,7357,8095,4289,2428,2547,2766,3150,1980,-1361,-2778,-2210,-2165,-2954,-3300,-2327,-1887,-1899,-1077,58,763,783,1150,1685,1577,1223,774,-29,-348,450,383,-654,-1132,-1104,-853,-865,-882,-697,-640,-522,-205,220,409,302,290,474,528,219,-206,-407,-444,-357,-271,-390,-468,-424,-363,-291,-192,-177,-412,-673,-622,-280,-73,-137,-230,-266,-226,-163,-124,-74,5,66,17,-139,-297,-308,-206,-155,-170,-196,-207,-225,-237,-200,-136,-75,-67,-103,-117,-109,-96,-71,-66,-92,-117,-105,-81,-90,-87,-67,-63,-86,-92,-42,-2,-2,-42,-84,-117,-114,-80,-91,-127,-138,-134,-135,-100,-60,-28,-31,-66,-18},
            {6,14,-48,82,-91,2098,6035,6078,-3054,-13906,-5936,10799,12040,5220,2312,3083,4287,4146,1819,-4041,-6617,-3970,-3121,-4496,-4875,-2932,-1754,-2010,-848,1005,2105,1486,1373,1994,1493,1159,818,655,685,476,-248,-1467,-1646,-1442,-1541,-1373,-1191,-679,-14,11,-263,-400,-79,407,759,1110,596,-328,-495,9,216,-277,-559,-483,-345,-362,-441,-482,-748,-1006,-1007,-719,-386,-143,60,207,282,252,218,133,30,77,209,155,-139,-399,-476,-403,-292,-217,-203,-270,-352,-342,-219,-83,71,147,17,-143,-182,-115,-17,7,-92,-227,-284,-226,-96,-24,-9,-41,-111,-161,-167,-109,-50,-30,-87,-179,-209,-166,-98,-61,-51,-63,-100,-127,-102,-48,-11,-4,-18,-45,-73,-60,-22,-14,-28,-8}
        },
        {    // H60e160a.wav
            {-1,1,-18,17,-30,25,-28,10,2,109,1822,3955,3413,-3753,-10166,-2766,8085,8529,4274,2415,2632,2927,3302,1888,-1840,-3239,-2352,-2300,-3196,-3491,-2411,-1925,-1903,-1026,151,851,739,1081,1717,1630,1248,950,291,-457,117,525,-518,-1336,-1202,-802,-890,-1006,-734,-603,-644,-440,104,501,440,391,581,622,339,-129,-471,-533,-345,-250,-410,-497,-511,-421,-282,-244,-331,-602,-770,-591,-236,-20,-3,-82,-153,-120,-68,-84,-118,-46,43,-61,-284,-379,-288,-197,-184,-182,-174,-198,-229,-231,-222,-149,-55,-43,-104,-148,-137,-121,-89,-71,-107,-132,-122,-103,-89,-82,-80,-89,-104,-102,-80,-48,-32,-50,-101,-133,-114,-86,-104,-128,-126,-136,-130,-116,-66,-32,-32,-50,-98,-29},
            {-31,31,-18,-16,44,6,2411,5875,5072,-4651,-13419,-3349,11341,10746,4359,2190,3208,4085,3967,1367,-4222,-5761,-3339,-2983,-4329,-4499,-2595,-1814,-2025,-778,1044,1886,1209,1381,1791,1379,1203,801,713,558,185,-446,-1087,-1190,-1583,-1476,-1152,-1169,-573,-42,-159,-462,-505,-34,495,891,975,442,-126,-255,54,55,-360,-470,-406,-365,-441,-456,-436,-620,-924,-1094,-799,-401,-176,2,162,287,288,235,153,87,110,139,64,-181,-416,-489,-435,-291,-191,-188,-229,-314,-336,-228,-99,32,123,40,-147,-218,-126,-20,12,-77,-213,-257,-202,-97,-39,-33,-50,-87,-135,-152,-104,-50,-33,-87,-174,-205,-155,-95,-73,-58,-73,-102,-103,-69,-28,-8,-13,-35,-65,-90,-64,-26,-13,-3}
        },
        {    // H60e170a.wav
            {5,-20,19,-30,30,-26,10,7,106,2018,4447,3691,-4312,-10946,-2444,9101,8937,4141,2371,2799,3188,3472,1658,-2492,-3753,-2499,-2456,-3515,-3717,-2379,-1914,-1997,-898,447,1022,809,1092,1653,1627,1231,960,583,-262,-131,369,-402,-1433,-1355,-827,-942,-996,-645,-505,-663,-602,-123,419,635,564,600,620,442,-12,-445,-457,-312,-327,-425,-460,-531,-485,-302,-253,-482,-824,-849,-532,-179,-9,57,82,41,34,31,-29,-71,-2,-2,-200,-364,-353,-277,-249,-212,-137,-135,-209,-253,-246,-202,-85,12,-13,-95,-158,-161,-113,-51,-59,-109,-132,-139,-120,-82,-47,-51,-73,-98,-101,-75,-60,-46,-68,-100,-124,-115,-90,-84,-90,-104,-101,-101,-78,-44,-10,-19,-47,-77,-113,-29},
            {18,-38,38,-27,2,22,66,2387,5466,4448,-5021,-12618,-2400,10911,9949,4055,2223,3139,3800,3827,1293,-3850,-5023,-2960,-2790,-4080,-4223,-2476,-1846,-2025,-806,953,1601,1013,1304,1654,1431,1216,823,751,335,-80,-313,-600,-1193,-1721,-1193,-1047,-1125,-522,-154,-339,-641,-495,70,637,857,754,524,169,-117,-117,-127,-277,-399,-452,-442,-490,-451,-375,-496,-831,-1070,-851,-459,-177,-31,119,273,266,223,169,102,61,45,-8,-205,-409,-479,-421,-298,-172,-116,-187,-301,-348,-256,-109,6,84,37,-120,-224,-148,-24,-15,-92,-172,-204,-174,-115,-73,-42,-54,-67,-95,-138,-110,-63,-39,-78,-157,-193,-152,-89,-73,-79,-85,-91,-88,-58,-23,-1,-15,-52,-86,-98,-69,-42,-9}
        },
        {    // H60e180a.wav
            {-22,23,-36,30,-28,7,9,96,2222,4956,4004,-4807,-11738,-2217,10054,9360,4037,2304,2973,3490,3657,1416,-3207,-4343,-2691,-2612,-3817,-3978,-2407,-1869,-2031,-849,737,1279,894,1194,1596,1528,1230,888,720,44,-222,50,-354,-1401,-1600,-931,-1001,-1049,-557,-321,-538,-707,-360,259,684,712,679,586,338,-11,-293,-301,-268,-371,-479,-471,-501,-474,-337,-375,-682,-946,-870,-547,-171,11,97,152,174,222,122,-7,-23,47,-9,-260,-414,-420,-343,-265,-175,-112,-189,-269,-276,-250,-171,-42,45,21,-88,-193,-175,-78,-42,-81,-121,-148,-168,-143,-84,-38,-42,-64,-95,-123,-101,-57,-43,-85,-141,-158,-129,-87,-83,-92,-89,-89,-87,-64,-24,-9,-19,-54,-83,-102,-96,-20},
            {-22,23,-36,30,-28,7,9,96,2222,4956,4004,-4807,-11738,-2217,10054,9360,4037,2304,2973,3490,3657,1416,-3207,-4343,-2691,-2612,-3817,-3978,-2407,-1869,-2031,-849,737,1279,894,1194,1596,1528,1230,888,720,44,-222,50,-354,-1401,-1600,-931,-1001,-1049,-557,-321,-538,-707,-360,259,684,712,679,586,338,-11,-293,-301,-268,-371,-479,-471,-501,-474,-337,-375,-682,-946,-870,-547,-171,11,97,152,174,222,122,-7,-23,47,-9,-260,-414,-420,-343,-265,-175,-112,-189,-269,-276,-250,-171,-42,45,21,-88,-193,-175,-78,-42,-81,-121,-148,-168,-143,-84,-38,-42,-64,-95,-123,-101,-57,-43,-85,-141,-158,-129,-87,-83,-92,-89,-89,-87,-64,-24,-9,-19,-54,-83,-102,-96,-20}
        }
    },
    {    // elev70 
        {    // H70e000a.wav
            {-1,-10,-1,5,16,-14,26,-45,51,-54,39,-6,-54,113,26,2656,4057,4906,-110,-13248,-6841,9547,10644,6541,3359,3195,3463,2323,531,-4378,-6562,-5947,-4526,-2804,-3197,-2197,-461,58,777,1376,2291,2071,1245,1293,1191,976,-151,-681,-189,-107,-193,-782,-1398,-1961,-1930,-1274,-733,-103,447,870,896,659,695,876,634,151,-221,-519,-635,-614,-506,-635,-668,-390,-215,-38,-16,-177,-267,-365,-626,-976,-1054,-676,-137,133,43,-105,-62,86,97,-49,-121,-75,-110,-268,-368,-330,-200,-69,0,-66,-234,-325,-310,-229,-140,-39,-39,-171,-250,-180,-10,87,60,-64,-140,-111,-57,34,86,36,-84,-182,-231,-205,-125,-72,-114,-199,-231,-209,-91,18,33,-19,-41,-29,-50,-14},
            {-1,-10,-1,5,16,-14,26,-45,51,-54,39,-6,-54,113,26,2656,4057,4906,-110,-13248,-6841,9547,10644,6541,3359,3195,3463,2323,531,-4378,-6562,-5947,-4526,-2804,-3197,-2197,-461,58,777,1376,2291,2071,1245,1293,1191,976,-151,-681,-189,-107,-193,-782,-1398,-1961,-1930,-1274,-733,-103,447,870,896,659,695,876,634,151,-221,-519,-635,-614,-506,-635,-668,-390,-215,-38,-16,-177,-267,-365,-626,-976,-1054,-676,-137,133,43,-105,-62,86,97,-49,-121,-75,-110,-268,-368,-330,-200,-69,0,-66,-234,-325,-310,-229,-140,-39,-39,-171,-250,-180,-10,87,60,-64,-140,-111,-57,34,86,36,-84,-182,-231,-205,-125,-72,-114,-199,-231,-209,-91,18,33,-19,-41,-29,-50,-14}
        },
        {    // H70e015a.wav
            {-1,-1,-7,-1,1,14,-8,21,-37,37,-40,22,6,-54,99,14,2161,3507,4184,276,-11170,-7277,7366,10221,6929,3402,2684,3212,2406,1022,-3036,-5481,-5274,-4162,-2643,-2841,-2346,-972,-400,256,964,1897,1909,1373,1464,1292,1075,161,-549,-262,-112,-156,-686,-1266,-1712,-1752,-1265,-784,-211,240,584,734,592,593,793,664,277,-82,-438,-622,-657,-445,-417,-678,-545,-230,-109,-120,-165,-189,-275,-501,-758,-837,-617,-230,38,-6,-191,-236,-158,-69,-76,-111,-85,-120,-216,-292,-267,-155,-120,-91,-67,-152,-238,-282,-260,-158,-51,-33,-138,-240,-208,-71,48,55,-55,-123,-92,-30,46,92,75,-31,-149,-205,-206,-151,-115,-149,-195,-222,-205,-117,-8,46,20,-39,-61,-14},
            {-8,-1,4,19,-15,38,-59,62,-66,48,2,-66,143,-25,3052,4682,5745,31,-15211,-7281,11373,11141,6171,3550,3918,3657,2028,396,-5404,-7733,-6416,-4919,-3196,-3623,-2099,20,425,1356,1870,2596,2291,1214,1060,1052,875,-508,-836,-101,-46,-106,-825,-1553,-2210,-2145,-1354,-732,75,609,957,1093,761,762,1083,717,23,-399,-555,-589,-709,-702,-699,-609,-433,-166,105,-13,-156,-207,-381,-794,-1262,-1222,-606,9,72,-72,86,277,301,167,-46,-96,-42,-120,-354,-497,-412,-167,23,22,-80,-227,-328,-328,-238,-85,37,-41,-226,-274,-159,14,110,67,-98,-181,-136,-52,66,112,29,-127,-239,-268,-205,-93,-28,-82,-195,-235,-201,-80,21,36,31,-3,-50,-74,-56,-10}
        },
        {    // H70e030a.wav
            {1,-1,1,-6,-2,1,15,-6,17,-27,26,-23,7,20,-58,95,-17,1653,3011,3598,860,-9136,-7922,5106,9655,7171,3610,2440,2931,2387,1546,-1765,-4459,-4618,-3831,-2529,-2565,-2394,-1364,-738,-42,574,1489,1797,1384,1478,1368,1139,396,-357,-261,-158,-168,-629,-1145,-1476,-1613,-1253,-833,-327,34,253,655,777,575,602,655,431,-11,-464,-600,-596,-490,-470,-626,-512,-251,-187,-231,-107,-4,-173,-445,-590,-559,-497,-397,-212,-101,-165,-267,-291,-281,-228,-115,-37,-106,-226,-257,-224,-146,-87,-62,-64,-123,-166,-196,-212,-178,-109,-76,-136,-218,-229,-136,-23,11,-38,-78,-49,10,65,94,69,-8,-97,-189,-218,-174,-137,-157,-199,-200,-190,-131,-33,34,40,-6,-6},
            {1,0,29,-24,44,-64,66,-64,33,33,-110,207,-164,3114,5276,6511,1122,-16264,-9103,12297,11758,5715,3927,4724,3962,1659,508,-5649,-8828,-6921,-5018,-3738,-4340,-2117,247,561,1874,2349,2918,2474,1298,1114,875,701,-725,-1034,-124,-63,-14,-662,-1565,-2470,-2389,-1453,-819,120,762,1004,1084,824,912,1245,788,64,-401,-613,-556,-837,-939,-715,-714,-535,-15,171,-90,-168,-77,-310,-918,-1406,-1285,-588,-52,34,115,254,356,374,216,18,-46,-20,-159,-477,-586,-400,-127,9,0,-64,-221,-336,-332,-196,-8,70,-46,-244,-272,-140,11,96,48,-120,-226,-187,-69,60,125,57,-135,-280,-322,-238,-67,19,-54,-188,-244,-218,-117,37,124,68,-35,-100,-125,-70,5,8}
        },
        {    // H70e045a.wav
            {-3,0,-1,-1,-4,-3,-2,10,-5,14,-23,18,-21,5,14,-47,79,-10,1407,2654,3216,771,-8141,-7625,4047,9017,6956,3562,2394,2731,2320,1767,-1035,-3660,-4019,-3365,-2374,-2444,-2269,-1478,-916,-232,325,1204,1577,1293,1424,1389,1158,492,-181,-293,-277,-224,-605,-1040,-1346,-1483,-1160,-855,-562,-68,504,714,555,480,572,597,355,-62,-426,-599,-660,-536,-393,-490,-532,-352,-161,-123,-96,-3,-46,-290,-485,-474,-473,-513,-391,-196,-181,-323,-379,-337,-299,-203,-55,-52,-193,-247,-183,-105,-56,-16,-26,-105,-150,-150,-170,-219,-195,-126,-145,-215,-244,-181,-75,-7,-4,-17,-8,21,62,83,51,-18,-85,-164,-212,-191,-156,-163,-195,-194,-161,-104,-31,7,-1,-3},
            {-11,38,-29,44,-50,31,-4,-52,129,-203,282,-316,2262,5622,6892,4220,-14147,-14393,10070,13778,5819,4144,5321,4755,1534,1164,-4419,-9716,-7592,-5391,-4118,-4856,-3155,166,399,1737,2783,3230,2980,1484,1311,1153,709,-799,-1395,-283,-175,-78,-442,-1356,-2398,-2711,-1757,-903,11,734,1055,1065,796,948,1343,1002,210,-337,-543,-582,-941,-976,-772,-943,-719,-68,204,-17,-164,-65,-247,-859,-1323,-1174,-699,-359,47,430,413,293,272,218,96,14,5,-176,-516,-605,-400,-157,-49,-9,-28,-221,-345,-299,-140,16,69,-1,-195,-280,-182,-20,77,49,-117,-264,-235,-113,29,128,87,-124,-305,-337,-244,-86,24,-7,-152,-252,-279,-143,76,151,84,-59,-155,-159,-69,35,23,-4}
        },
        {    // H70e060a.wav
            {-8,1,-1,1,-1,-4,-3,1,7,-4,11,-21,20,-26,20,-8,-15,46,73,1487,2505,2995,-346,-8470,-6058,4814,8528,6141,3128,2473,2605,2269,1710,-997,-3273,-3553,-2819,-2165,-2433,-2018,-1335,-945,-324,293,1140,1296,1106,1390,1401,1071,374,-191,-390,-312,-185,-629,-1066,-1225,-1342,-1338,-764,73,170,182,550,569,373,453,507,157,-299,-524,-484,-368,-412,-583,-598,-369,-158,-168,-205,-36,118,-4,-258,-396,-445,-551,-628,-487,-268,-275,-383,-369,-329,-317,-204,-18,-22,-160,-191,-125,-50,-24,-2,-25,-132,-188,-166,-179,-248,-239,-162,-147,-211,-244,-164,-57,5,15,9,10,24,54,57,18,-28,-83,-154,-198,-190,-166,-172,-172,-147,-126,-90,-43,-9,0},
            {22,-1,6,14,-54,84,-124,151,-143,115,-54,548,4879,6803,7386,-6122,-19597,506,16049,8215,3915,5109,5963,2463,1341,-1015,-8908,-9420,-5907,-4389,-5056,-4645,-782,46,845,2671,3122,3635,2279,1484,1511,1179,8,-1691,-953,-247,-251,-270,-1048,-2124,-2876,-2192,-1192,-301,623,1027,1015,832,921,1235,1223,547,-146,-449,-656,-880,-812,-804,-1177,-944,-238,22,-56,-47,5,-192,-696,-1135,-1064,-730,-481,-128,399,633,361,112,123,146,78,-11,-113,-392,-593,-473,-259,-85,-6,-26,-161,-311,-310,-144,28,90,39,-115,-241,-246,-106,38,60,-75,-259,-273,-169,-27,103,117,-53,-280,-349,-259,-115,19,38,-110,-271,-293,-146,45,134,89,-46,-167,-172,-98,27,46,-93,-39}
        },
        {    // H70e075a.wav
            {-3,-6,2,-2,2,-6,-2,-4,7,-2,6,-4,-9,12,-28,41,-46,53,-37,447,1899,2637,2388,-3623,-9027,-1737,7096,7588,4502,2582,2673,2430,2344,1105,-1818,-3238,-3090,-2237,-2141,-2426,-1636,-1072,-770,-277,537,1239,936,970,1477,1340,637,16,-159,-309,-304,-300,-623,-1231,-1663,-1109,-379,-222,-129,84,301,410,352,344,377,75,-305,-285,-110,-204,-474,-588,-487,-401,-369,-227,-115,-70,38,112,-21,-245,-351,-490,-696,-747,-534,-299,-343,-416,-334,-263,-217,-84,46,-19,-135,-117,-42,-14,-37,-59,-121,-203,-211,-180,-228,-286,-212,-121,-134,-204,-201,-106,-16,11,6,13,18,25,33,25,-5,-46,-100,-162,-183,-166,-141,-138,-138,-131,-113,-64,-20,-2},
            {38,-28,38,-42,21,10,-62,130,-198,264,-302,1933,6052,7810,4566,-13764,-15351,9369,14408,5433,4054,5817,4936,1599,1572,-3761,-10230,-7973,-5038,-4588,-5557,-3447,-161,-185,1218,2740,3495,3275,1894,1983,1770,1008,-604,-1456,-645,-554,-288,-483,-1676,-2794,-2815,-1751,-748,186,878,1025,818,856,1090,1277,971,163,-249,-517,-839,-785,-576,-990,-1333,-652,-48,-164,-245,10,26,-425,-903,-1016,-812,-514,-166,190,479,483,237,60,45,90,27,-46,-210,-498,-543,-393,-193,-44,2,-48,-234,-335,-232,-41,86,117,9,-175,-277,-205,-42,31,-5,-182,-308,-246,-108,33,106,46,-151,-313,-320,-182,-17,81,-21,-239,-315,-219,-30,100,110,-4,-127,-184,-154,-45,35,-29,-148,-43}
        },
        {    // H70e090a.wav
            {1,-4,0,-2,3,-3,-2,-3,6,5,1,8,-14,18,-29,29,-14,17,14,128,1471,2455,2759,-1414,-8468,-4593,5374,7878,5044,2735,2770,2643,2423,1962,-847,-2947,-3011,-2386,-2158,-2477,-1923,-1215,-801,-407,111,1032,1121,805,1083,1363,979,109,-118,-119,-262,-228,-721,-1421,-1284,-710,-484,-331,-165,27,274,239,159,187,156,13,-112,-72,-47,-203,-347,-297,-358,-620,-635,-284,-16,-20,-4,87,56,-98,-217,-359,-668,-915,-780,-437,-303,-358,-359,-283,-168,11,129,33,-84,-67,-21,-19,-80,-134,-177,-221,-220,-218,-249,-258,-187,-108,-104,-152,-163,-113,-40,2,-13,-10,6,13,16,12,-3,-45,-81,-116,-140,-135,-109,-103,-123,-131,-97,-54,-43,-10},
            {35,-27,41,-49,36,-19,-25,92,-158,232,-281,2304,6345,8017,2632,-15162,-12468,10869,13185,5030,4177,5631,4405,1791,1551,-4513,-9986,-7143,-4643,-4957,-5699,-2924,-311,-456,1171,2493,3376,3069,1792,2163,2095,1150,-652,-1217,-409,-512,-399,-724,-2006,-3099,-2821,-1532,-508,322,887,894,770,896,1041,1234,817,-7,-262,-479,-754,-675,-589,-1011,-1172,-549,-137,-292,-306,8,-43,-538,-887,-894,-715,-349,93,316,372,325,218,108,11,-5,2,-28,-246,-515,-538,-386,-149,-6,10,-70,-243,-321,-219,-27,103,130,12,-177,-278,-189,-27,17,-51,-224,-315,-246,-89,51,88,16,-163,-293,-275,-139,21,95,-58,-271,-299,-188,-19,100,89,-41,-142,-182,-135,-49,-10,-55,-144,-41}
        },
        {    // H70e105a.wav
            {0,-4,2,-1,3,-3,-1,-5,7,3,2,5,-13,19,-30,32,-22,32,-2,178,1585,2603,2677,-2227,-8765,-3536,6234,7671,4437,2524,2896,2810,2557,1849,-981,-2954,-2947,-2323,-2399,-2771,-1937,-1204,-902,-348,385,1088,999,890,1170,1161,802,326,-10,-235,-117,-431,-1213,-1156,-826,-756,-614,-385,-62,180,222,155,21,-96,-14,205,203,-88,-297,-232,-27,-85,-513,-784,-639,-323,-108,-4,46,55,58,-20,-150,-331,-653,-933,-873,-519,-301,-352,-409,-307,-42,146,129,46,-11,-18,-38,-77,-138,-216,-241,-231,-248,-293,-280,-178,-103,-103,-126,-148,-125,-87,-41,-19,-48,-45,-28,-6,-6,-22,-37,-63,-79,-92,-97,-106,-92,-88,-95,-105,-97,-69,-79,-22},
            {32,-19,29,-28,6,16,-58,109,-151,193,-226,1460,5700,7774,3914,-12129,-14226,7353,13895,6020,3896,5067,4697,2371,1791,-2984,-9097,-7329,-4423,-4724,-5822,-3703,-603,-614,360,2078,3134,2930,1798,2151,2201,1495,-25,-995,-461,-320,-125,-724,-2179,-3072,-2877,-1658,-607,173,751,756,745,864,889,1067,746,83,-146,-309,-530,-669,-629,-822,-1012,-641,-290,-310,-338,-81,-36,-470,-858,-894,-683,-323,86,307,333,251,213,191,36,-62,-35,-1,-171,-469,-563,-445,-190,11,26,-85,-222,-285,-247,-101,66,144,50,-130,-245,-206,-63,3,-48,-205,-319,-275,-128,22,86,35,-123,-260,-264,-137,5,80,-20,-223,-297,-213,-56,65,82,-23,-129,-174,-146,-84,-41,-54,-120,-35}
        },
        {    // H70e120a.wav
            {-4,-4,2,-1,1,-4,-3,-5,10,-5,8,-14,4,-3,-17,27,-40,70,-68,721,2244,3068,1318,-6161,-8156,1778,8359,6243,2970,2538,3116,2772,2620,669,-2339,-3109,-2604,-2414,-2933,-2784,-1770,-1227,-773,-58,1016,1455,904,970,1383,1181,450,3,113,-35,-599,-969,-844,-965,-1089,-739,-545,-335,28,290,268,-6,-130,26,247,255,86,-141,-287,-159,-36,-293,-679,-719,-462,-299,-237,-76,71,119,78,-25,-202,-489,-726,-776,-614,-453,-461,-483,-363,-87,78,92,130,95,12,-43,-90,-160,-242,-233,-214,-268,-320,-300,-205,-107,-67,-96,-152,-167,-117,-52,-12,-43,-93,-72,-38,-32,-42,-49,-63,-71,-83,-93,-74,-64,-57,-64,-59,-83,-105,-94,-98,-25},
            {16,9,-4,16,-40,55,-72,76,-57,28,24,179,3762,6947,6331,-4989,-16019,-1785,13666,9124,3790,4142,5024,3494,2237,-221,-6755,-8063,-4762,-4023,-5379,-5046,-1785,-608,-509,1020,2497,3124,1922,1737,2336,1816,704,-500,-407,-246,-51,-173,-1708,-2980,-3030,-1860,-882,-352,462,688,612,756,745,811,691,254,47,-27,-211,-574,-649,-589,-791,-786,-544,-312,-304,-203,-20,-275,-694,-916,-800,-446,-100,159,290,263,211,220,153,21,-47,-16,-70,-315,-515,-519,-330,-89,10,-48,-175,-253,-256,-179,-24,105,102,-29,-183,-229,-128,-29,-30,-140,-273,-290,-191,-46,54,59,-43,-186,-248,-182,-62,38,45,-97,-248,-266,-137,12,64,27,-85,-173,-163,-120,-46,-34,-96,-29}
        },
        {    // H70e135a.wav
            {-6,1,-2,2,-7,-2,-6,7,-1,3,-4,-9,12,-33,35,-45,50,-41,359,2039,3249,2456,-4426,-9379,-783,8349,7332,3395,2369,3169,2953,2763,1373,-2031,-3442,-2800,-2410,-3020,-3268,-2113,-1437,-1220,-390,925,1682,1235,1185,1480,1243,709,154,7,-136,-515,-779,-831,-1031,-1146,-929,-771,-451,-87,151,238,86,-36,83,451,497,92,-215,-182,-40,-167,-465,-683,-664,-432,-320,-353,-261,-29,137,75,-53,-143,-388,-661,-634,-379,-340,-544,-572,-357,-133,-22,83,151,72,-5,-40,-101,-201,-247,-188,-184,-267,-319,-280,-184,-108,-81,-84,-134,-178,-159,-89,-17,-35,-84,-76,-67,-71,-63,-50,-51,-78,-98,-106,-89,-42,-16,-14,-52,-83,-94,-87,-89,-114,-30},
            {-9,27,-11,16,-14,-4,22,-54,86,-110,133,-151,971,4736,6869,3321,-10032,-12820,5285,13228,6426,3097,4211,4747,3104,2004,-2109,-7431,-6290,-3709,-4134,-5419,-4019,-1188,-911,-374,1252,2614,2634,1529,1857,2127,1436,300,-331,-106,-40,91,-741,-2225,-2999,-2371,-1158,-810,-208,460,520,604,595,538,532,408,228,135,165,-154,-632,-521,-406,-699,-875,-587,-237,-219,-152,-113,-360,-735,-908,-707,-368,-94,74,191,230,216,230,185,67,-18,-39,-127,-356,-522,-471,-297,-130,-55,-94,-185,-234,-211,-133,-20,82,69,-73,-208,-221,-116,-40,-60,-157,-256,-246,-145,-25,39,14,-83,-185,-225,-156,-29,38,8,-115,-224,-227,-110,11,20,-24,-115,-172,-152,-79,-26,-50,-17}
        },
        {    // H70e150a.wav
            {1,-3,3,-6,-2,-7,10,-1,3,-2,-13,16,-36,38,-48,47,-38,318,2181,3659,2783,-4632,-9980,-713,9097,7609,3268,2444,3341,3054,2798,1238,-2450,-3864,-2936,-2532,-3331,-3497,-2120,-1458,-1355,-489,953,1761,1335,1400,1741,1467,751,57,51,-87,-610,-936,-856,-937,-1268,-1111,-766,-468,-236,31,248,51,-112,219,679,668,262,-92,-180,-127,-162,-471,-857,-765,-433,-348,-330,-213,-83,2,1,-93,-300,-513,-519,-351,-219,-316,-449,-357,-230,-163,-92,6,90,31,-70,-137,-204,-215,-166,-129,-187,-273,-290,-224,-143,-101,-70,-90,-156,-206,-167,-77,-44,-74,-94,-72,-61,-79,-84,-55,-52,-75,-113,-130,-93,-39,6,-12,-55,-100,-102,-74,-66,-92,-122,-30},
            {0,-4,25,-13,21,-25,11,1,-28,61,-96,134,-166,1274,4698,6263,1526,-11047,-10228,7163,12238,5464,2699,4083,4533,3061,1884,-2527,-6838,-5260,-3275,-4007,-5142,-3548,-1169,-1136,-488,1164,2471,2275,1384,1830,1916,1238,342,-120,-7,109,-37,-1124,-2306,-2552,-1690,-1077,-859,-106,296,431,508,365,247,309,420,328,293,220,-128,-437,-363,-333,-747,-970,-599,-212,-167,-184,-151,-310,-683,-841,-654,-395,-202,-47,86,152,241,311,189,45,37,37,-161,-434,-498,-434,-335,-212,-102,-62,-131,-199,-199,-138,-35,66,40,-113,-246,-230,-98,-33,-47,-134,-217,-215,-142,-25,22,-17,-101,-178,-189,-113,-15,27,-21,-106,-153,-170,-121,-66,-51,-54,-79,-115,-131,-80,-18,0}
        },
        {    // H70e165a.wav
            {-2,3,-8,0,-6,13,-4,6,-5,-9,14,-37,47,-61,66,-68,469,2665,4272,2597,-6220,-10290,1292,10295,7134,2822,2735,3683,3089,2711,506,-3503,-4250,-2958,-2781,-3787,-3676,-1894,-1334,-1327,-239,1335,1828,1227,1534,1835,1500,863,94,-49,-145,-467,-1010,-1291,-1144,-1205,-1147,-749,-406,-242,49,203,-16,-118,229,703,778,430,6,-93,-24,-220,-670,-866,-679,-573,-503,-282,-101,-73,-71,-119,-311,-509,-571,-411,-188,-149,-217,-220,-145,-52,-25,-67,-55,-25,-100,-233,-300,-257,-168,-116,-121,-172,-233,-234,-183,-143,-93,-40,-70,-181,-241,-169,-68,-42,-79,-113,-108,-98,-78,-44,-37,-66,-106,-126,-121,-69,-8,3,-44,-103,-118,-102,-62,-73,-89,-93,-115,-30},
            {-12,0,-4,19,-14,15,-23,8,-3,-28,50,-86,115,-146,1111,4136,5611,1330,-10162,-9622,6352,11700,5516,2457,3726,4323,3101,2103,-1849,-5911,-4788,-3029,-3639,-4781,-3513,-1353,-1273,-763,803,2167,2067,1275,1741,1809,1238,562,24,31,72,-239,-1240,-2096,-1932,-1343,-1231,-816,-91,117,295,314,140,35,236,497,506,423,142,-15,-139,-334,-478,-752,-907,-683,-311,-155,-166,-175,-232,-468,-735,-702,-439,-280,-175,-15,64,184,265,159,54,51,68,-143,-442,-524,-441,-307,-217,-130,-66,-88,-159,-216,-178,-74,10,-10,-126,-250,-232,-102,-33,-40,-117,-183,-197,-144,-47,-16,-38,-94,-152,-161,-107,-25,7,-26,-84,-133,-152,-134,-116,-101,-73,-72,-92,-98,-73,-14}
        },
        {    // H70e180a.wav
            {3,-9,1,-6,17,-7,12,-13,0,7,-31,51,-74,94,-110,774,3385,4961,1954,-8362,-10018,4095,11224,6232,2474,3217,4044,3120,2455,-665,-4768,-4525,-2929,-3181,-4316,-3637,-1617,-1287,-1073,243,1780,1970,1190,1629,1826,1359,778,128,6,-92,-395,-1130,-1688,-1449,-1273,-1261,-682,-177,-149,117,251,15,-95,223,615,704,477,95,-9,-9,-243,-652,-833,-764,-659,-428,-234,-127,-115,-125,-237,-560,-699,-518,-290,-183,-121,-62,6,114,117,24,0,23,-85,-310,-441,-408,-270,-161,-114,-87,-124,-175,-200,-197,-125,-34,-25,-100,-211,-230,-131,-55,-33,-89,-147,-154,-122,-63,-39,-33,-63,-113,-148,-122,-35,20,-1,-71,-128,-154,-113,-73,-77,-99,-98,-82,-86,-21},
            {3,-9,1,-6,17,-7,12,-13,0,7,-31,51,-74,94,-110,774,3385,4961,1954,-8362,-10018,4095,11224,6232,2474,3217,4044,3120,2455,-665,-4768,-4525,-2929,-3181,-4316,-3637,-1617,-1287,-1073,243,1780,1970,1190,1629,1826,1359,778,128,6,-92,-395,-1130,-1688,-1449,-1273,-1261,-682,-177,-149,117,251,15,-95,223,615,704,477,95,-9,-9,-243,-652,-833,-764,-659,-428,-234,-127,-115,-125,-237,-560,-699,-518,-290,-183,-121,-62,6,114,117,24,0,23,-85,-310,-441,-408,-270,-161,-114,-87,-124,-175,-200,-197,-125,-34,-25,-100,-211,-230,-131,-55,-33,-89,-147,-154,-122,-63,-39,-33,-63,-113,-148,-122,-35,20,-1,-71,-128,-154,-113,-73,-77,-99,-98,-82,-86,-21}
        }
    },
    {    // elev80 
        {    // H80e000a.wav
            {16,-1,6,3,-26,47,-72,96,-92,88,-56,546,3248,4493,5312,-3519,-13198,-1093,10744,7336,3177,3528,4984,3106,1828,-313,-5231,-6352,-4795,-3443,-3812,-3868,-1315,-213,304,1396,1982,2317,1538,1162,1129,957,396,-645,-391,-17,2,-260,-919,-1473,-2021,-1745,-1137,-709,-224,211,726,987,885,1001,1056,523,-166,-670,-731,-451,-167,-268,-802,-957,-570,-249,-248,-179,25,77,29,-76,-320,-665,-854,-666,-253,-160,-460,-574,-271,71,126,72,62,-28,-126,-112,-67,-107,-139,-74,-99,-219,-349,-390,-282,-146,-82,-182,-333,-357,-185,26,90,23,-91,-119,-65,32,121,145,35,-135,-201,-197,-141,-72,-65,-159,-244,-256,-199,-64,28,33,-44,-162,-232,-158,6,135,140,27},
            {16,-1,6,3,-26,47,-72,96,-92,88,-56,546,3248,4493,5312,-3519,-13198,-1093,10744,7336,3177,3528,4984,3106,1828,-313,-5231,-6352,-4795,-3443,-3812,-3868,-1315,-213,304,1396,1982,2317,1538,1162,1129,957,396,-645,-391,-17,2,-260,-919,-1473,-2021,-1745,-1137,-709,-224,211,726,987,885,1001,1056,523,-166,-670,-731,-451,-167,-268,-802,-957,-570,-249,-248,-179,25,77,29,-76,-320,-665,-854,-666,-253,-160,-460,-574,-271,71,126,72,62,-28,-126,-112,-67,-107,-139,-74,-99,-219,-349,-390,-282,-146,-82,-182,-333,-357,-185,26,90,23,-91,-119,-65,32,121,145,35,-135,-201,-197,-141,-72,-65,-159,-244,-256,-199,-64,28,33,-44,-162,-232,-158,6,135,140,27}
        },
        {    // H80e030a.wav
            {-6,16,2,3,7,-21,40,-59,81,-73,70,-37,472,2824,3842,4295,-3678,-12573,-1525,10613,8333,3533,2737,4244,3182,2222,494,-4130,-5720,-4505,-3170,-3345,-3688,-1703,-457,-69,737,1619,2187,1493,1234,1254,1030,638,-342,-406,-93,-11,-261,-923,-1487,-1896,-1621,-1091,-582,-88,249,585,741,712,866,1035,581,-96,-538,-714,-563,-356,-396,-668,-788,-529,-180,-153,-127,86,132,16,-79,-150,-409,-762,-839,-497,-197,-386,-644,-543,-192,109,179,84,-68,-132,-64,26,26,-77,-136,-163,-230,-275,-323,-330,-207,-95,-130,-253,-330,-235,-60,52,35,-67,-94,-29,64,121,136,71,-61,-152,-194,-172,-118,-114,-170,-212,-207,-156,-57,10,12,-9,-24,-56,-78,-36,15,7},
            {12,-4,15,-39,60,-81,89,-67,41,15,289,3377,5202,6741,-1214,-14256,-4069,10461,7654,3329,4127,5596,3201,1447,-249,-5654,-7023,-5028,-3916,-4111,-4063,-1478,-89,534,1703,2086,2590,1845,991,1173,1149,222,-963,-484,1,-120,-133,-613,-1462,-2159,-1913,-1418,-911,-213,402,963,1071,816,871,1029,530,-179,-516,-552,-321,12,-233,-1004,-1068,-586,-478,-423,-99,41,-15,9,-81,-377,-722,-847,-579,-158,-104,-435,-480,-89,167,173,151,98,-80,-243,-170,-77,-68,-32,-87,-256,-357,-353,-280,-139,-79,-88,-145,-305,-347,-180,-17,31,-21,-107,-120,-61,38,147,171,35,-139,-212,-199,-131,-65,-86,-187,-256,-256,-206,-173,-115,-45,-23,34,89,130,69,-42,-69,-70,-16}
        },
        {    // H80e060a.wav
            {-5,-8,16,-10,12,-11,-3,16,-42,68,-87,103,-94,818,2838,3653,2958,-6413,-11547,1525,10882,7634,3177,2691,3833,2775,2385,263,-3963,-4981,-3858,-2790,-3282,-3321,-1548,-674,-200,486,1511,1996,1256,1297,1389,1043,474,-254,-295,-213,-62,-383,-1073,-1527,-1811,-1511,-998,-343,204,380,600,630,496,685,807,404,-173,-577,-623,-431,-308,-527,-833,-748,-417,-111,-58,-29,147,139,31,10,-66,-364,-790,-915,-574,-310,-486,-719,-635,-291,67,241,130,-75,-96,4,74,33,-81,-156,-218,-244,-246,-317,-374,-278,-119,-100,-216,-279,-208,-87,7,1,-53,-56,-16,48,85,94,37,-60,-138,-193,-175,-124,-119,-161,-183,-174,-140,-67,-19,-24,-32,-23,-24,-62,-70,-14},
            {-17,34,-52,43,-33,-4,59,-116,185,-187,2257,5237,7314,4273,-11487,-11539,6842,9900,4198,3895,5711,4309,1448,705,-3941,-7649,-5834,-4216,-4231,-4511,-2384,-319,242,1435,1796,2537,2596,1234,1159,1434,776,-796,-1001,-163,-245,-99,-189,-1193,-2262,-2285,-1716,-1136,-239,479,937,994,685,673,962,751,117,-335,-505,-261,66,-91,-869,-1257,-844,-607,-575,-285,36,73,18,-39,-310,-666,-754,-521,-274,-236,-315,-263,-86,67,177,148,48,9,-83,-188,-207,-175,-91,-58,-218,-395,-386,-254,-49,33,-33,-162,-363,-405,-242,-29,76,15,-141,-229,-116,60,169,165,70,-119,-275,-294,-207,-67,-4,-83,-327,-479,-423,-162,206,371,226,-115,-270,-192,20,149,130,-78,-343,-101}
        },
        {    // H80e090a.wav
            {-5,-7,7,5,-4,10,-24,32,-48,45,-33,16,21,179,2125,3293,3609,-2419,-11684,-4246,9118,9509,4420,2338,3521,3258,2522,1705,-2219,-4586,-4018,-2899,-2877,-3601,-2341,-1011,-634,8,1019,2003,1457,1085,1589,1333,619,-111,-238,-224,-222,-195,-779,-1447,-1841,-1627,-895,-317,-83,224,631,582,407,560,646,317,-82,-340,-412,-352,-392,-485,-665,-778,-616,-266,-48,-11,125,201,137,51,-27,-170,-540,-904,-847,-498,-420,-650,-743,-496,-72,210,204,39,-21,46,103,78,-57,-190,-250,-264,-275,-320,-361,-274,-126,-102,-187,-263,-221,-112,-27,-11,-51,-38,-5,10,34,59,39,-45,-129,-176,-179,-143,-106,-101,-112,-122,-120,-75,-27,-46,-60,-55,-45,-70,-106,-27},
            {-13,29,-56,59,-65,45,-9,-51,120,-48,2942,5817,7808,1728,-13776,-8345,8977,8747,3735,4306,5682,3569,1350,205,-4987,-7427,-5238,-4087,-4368,-4415,-1976,-144,214,1166,1809,2697,2284,1268,1551,1571,543,-855,-714,-314,-433,18,-340,-1682,-2546,-2236,-1555,-807,35,718,1000,674,508,754,903,534,-22,-345,-385,-72,154,-203,-976,-1194,-839,-709,-637,-270,71,113,66,-89,-421,-684,-596,-320,-297,-398,-277,-39,-4,-31,61,149,202,37,-211,-298,-287,-84,53,-147,-398,-418,-252,-94,-31,-31,-84,-226,-352,-325,-156,-4,22,-56,-196,-211,-69,80,170,139,-13,-200,-316,-299,-129,39,-4,-261,-475,-418,-182,164,351,170,-168,-318,-163,38,175,74,-118,-268,-358,-87}
        },
        {    // H80e120a.wav
            {-3,-6,15,-2,5,1,-13,27,-48,60,-66,68,-45,434,2506,3592,3228,-4792,-11779,-834,10498,8274,3260,2430,3859,3221,2614,1046,-3081,-4637,-3570,-2720,-3316,-3625,-2056,-1105,-744,76,1369,2200,1447,1218,1594,1324,487,-334,-277,-241,-199,-229,-997,-1771,-1881,-1172,-538,-455,-157,464,584,327,396,659,580,100,-149,-120,-237,-479,-472,-345,-611,-894,-648,-207,-71,-5,105,122,153,129,0,-284,-656,-833,-684,-461,-515,-711,-683,-318,72,143,72,83,104,86,77,23,-113,-217,-242,-265,-358,-413,-314,-160,-93,-134,-206,-218,-156,-80,-31,-51,-76,-46,-16,6,21,30,-16,-93,-137,-159,-144,-104,-77,-80,-95,-101,-79,-47,-39,-51,-57,-71,-97,-107,-83,-16},
            {-13,29,-40,26,-12,-25,72,-122,173,-199,1675,4877,6903,4324,-9823,-11748,5422,10342,4555,3397,5217,4579,2001,1037,-3002,-6968,-5604,-3864,-4111,-4724,-2873,-637,-314,490,1409,2464,2480,1406,1621,1817,1075,-382,-802,-237,-425,-243,-239,-1397,-2459,-2282,-1506,-905,-316,469,966,662,534,737,772,473,-14,-242,-303,-83,176,-20,-658,-1053,-872,-784,-759,-410,-7,138,88,-42,-283,-563,-599,-360,-248,-386,-404,-147,4,-30,31,140,170,70,-137,-280,-259,-109,-6,-99,-308,-389,-304,-180,-40,-5,-56,-146,-295,-339,-227,-55,15,-29,-139,-216,-131,12,115,136,61,-99,-246,-276,-177,-36,23,-48,-247,-371,-314,-122,76,172,89,-126,-207,-136,38,130,99,-63,-244,-69}
        },
        {    // H80e150a.wav
            {-7,7,11,-9,18,-32,39,-41,36,-16,-12,63,34,2031,3697,4190,-1488,-11518,-5024,9197,9499,3762,2205,3963,3852,2665,1635,-2394,-5033,-4053,-2843,-3274,-4136,-2554,-1078,-1127,-346,1194,2331,1862,1416,1738,1415,688,-109,-338,-397,-278,-75,-840,-1773,-1969,-1283,-647,-629,-283,384,454,224,414,702,664,330,52,-106,-262,-411,-377,-204,-493,-941,-809,-368,-201,-169,4,162,135,23,12,-147,-585,-811,-540,-319,-530,-723,-542,-161,11,18,108,102,17,22,30,-44,-135,-110,-110,-275,-427,-403,-250,-131,-97,-119,-199,-252,-201,-103,-22,-17,-73,-88,-78,-25,49,51,-16,-98,-143,-161,-147,-97,-58,-69,-94,-104,-91,-41,-14,-18,-36,-71,-123,-145,-88,-17,2},
            {18,-15,25,-40,44,-49,34,-3,-41,100,-52,2351,4823,6072,327,-12065,-6501,8949,8961,3390,3168,5085,4068,2107,739,-3791,-6387,-4625,-3325,-4141,-4595,-2226,-718,-716,311,1548,2539,2014,1423,1851,1704,820,-477,-570,-217,-301,-208,-780,-1817,-2319,-1755,-948,-709,-371,431,716,521,668,774,622,226,-108,-207,-187,-75,41,-46,-654,-987,-763,-722,-669,-338,22,179,76,-89,-258,-501,-606,-419,-214,-361,-519,-269,-24,-29,-18,155,245,10,-242,-266,-204,-85,9,-82,-296,-383,-264,-136,-123,-139,-104,-129,-255,-318,-197,-54,-17,-37,-117,-172,-126,3,96,71,-17,-112,-196,-220,-125,-17,4,-95,-200,-201,-126,-44,-32,-66,-169,-234,-140,10,71,59,17,-41,-15}
        },
        {    // H80e180a.wav
            {5,12,-8,21,-36,43,-45,37,-10,-24,79,-8,2167,4202,4982,-810,-11702,-5367,9298,9171,3371,2556,4540,4061,2464,1193,-3067,-5704,-4294,-3013,-3738,-4418,-2424,-908,-1007,-179,1377,2479,1912,1499,1885,1571,728,-294,-408,-326,-296,-130,-912,-1881,-2096,-1389,-704,-669,-354,314,449,344,594,779,629,278,40,-107,-252,-344,-177,6,-539,-1010,-764,-532,-485,-291,9,178,117,-32,-147,-361,-591,-554,-331,-367,-587,-492,-187,-46,-51,44,162,72,-89,-115,-113,-151,-125,-84,-143,-268,-305,-234,-204,-183,-139,-147,-210,-294,-231,-69,-4,-6,-67,-120,-109,-48,46,62,-17,-103,-176,-205,-144,-53,-9,-61,-130,-147,-108,-27,-4,-24,-53,-115,-167,-172,-130,-82,-46,-9},
            {5,12,-8,21,-36,43,-45,37,-10,-24,79,-8,2167,4202,4982,-810,-11702,-5367,9298,9171,3371,2556,4540,4061,2464,1193,-3067,-5704,-4294,-3013,-3738,-4418,-2424,-908,-1007,-179,1377,2479,1912,1499,1885,1571,728,-294,-408,-326,-296,-130,-912,-1881,-2096,-1389,-704,-669,-354,314,449,344,594,779,629,278,40,-107,-252,-344,-177,6,-539,-1010,-764,-532,-485,-291,9,178,117,-32,-147,-361,-591,-554,-331,-367,-587,-492,-187,-46,-51,44,162,72,-89,-115,-113,-151,-125,-84,-143,-268,-305,-234,-204,-183,-139,-147,-210,-294,-231,-69,-4,-6,-67,-120,-109,-48,46,62,-17,-103,-176,-205,-144,-53,-9,-61,-130,-147,-108,-27,-4,-24,-53,-115,-167,-172,-130,-82,-46,-9}
        }
    },
    {    // elev90 
        {    // H90e000a.wav
            {9,-26,41,-56,65,-56,47,-11,323,2804,4716,5780,-1242,-11324,-3481,8404,6580,2586,3719,5177,3406,1794,-122,-4173,-5554,-4005,-3156,-3940,-3805,-1742,-694,-62,866,1534,2292,1795,1128,1259,1050,14,-832,-187,437,394,28,-859,-1842,-2290,-1825,-1088,-466,-52,271,539,460,484,825,899,534,36,-313,-373,-352,-133,-66,-615,-1111,-941,-461,-350,-164,152,36,-129,-121,-93,-224,-524,-649,-465,-305,-484,-683,-456,3,189,92,41,14,-92,-203,-208,-109,-3,82,5,-260,-464,-380,-129,17,-54,-344,-585,-544,-262,40,137,12,-78,-3,90,166,179,114,-42,-219,-277,-255,-197,-130,-99,-145,-197,-202,-135,-21,60,58,-19,-90,-141,-100,0,75,33,-64,-124,-155,-38},
            {9,-26,41,-56,65,-56,47,-11,323,2804,4716,5780,-1242,-11324,-3481,8404,6580,2586,3719,5177,3406,1794,-122,-4173,-5554,-4005,-3156,-3940,-3805,-1742,-694,-62,866,1534,2292,1795,1128,1259,1050,14,-832,-187,437,394,28,-859,-1842,-2290,-1825,-1088,-466,-52,271,539,460,484,825,899,534,36,-313,-373,-352,-133,-66,-615,-1111,-941,-461,-350,-164,152,36,-129,-121,-93,-224,-524,-649,-465,-305,-484,-683,-456,3,189,92,41,14,-92,-203,-208,-109,-3,82,5,-260,-464,-380,-129,17,-54,-344,-585,-544,-262,40,137,12,-78,-3,90,166,179,114,-42,-219,-277,-255,-197,-130,-99,-145,-197,-202,-135,-21,60,58,-19,-90,-141,-100,0,75,33,-64,-124,-155,-38}
        }
    }
};